/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.psiView.formattingblocks;

import com.intellij.formatting.Block;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PlatformColors;
import java.awt.Color;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class BlockTreeNode
extends SimpleNode {
    private final Block myBlock;

    public BlockTreeNode(Block block, BlockTreeNode parent) {
        super((SimpleNode)parent);
        this.myBlock = block;
    }

    public Block getBlock() {
        return this.myBlock;
    }

    public BlockTreeNode[] getChildren() {
        return (BlockTreeNode[])ContainerUtil.map2Array((Collection)this.myBlock.getSubBlocks(), BlockTreeNode.class, block -> new BlockTreeNode((Block)block, this));
    }

    protected void update(PresentationData presentation) {
        String name = this.myBlock.getClass().getSimpleName();
        if (this.myBlock instanceof DataLanguageBlockWrapper) {
            name = name + " (" + ((DataLanguageBlockWrapper)this.myBlock).getOriginal().getClass().getSimpleName() + ")";
        }
        presentation.addText(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myBlock.getIndent() != null) {
            presentation.addText(" " + String.valueOf(this.myBlock.getIndent()).replaceAll("[<>]", " "), SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            presentation.addText(" Indent: null", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (this.myBlock.getAlignment() != null) {
            float d = 1.0f * (float)System.identityHashCode(this.myBlock.getAlignment()) / 2.1474836E9f;
            JBColor color = new JBColor(Color.HSBtoRGB(1.0f * d, 0.3f, 0.7f), Color.HSBtoRGB(1.0f * d, 0.3f, 0.8f));
            presentation.addText(" " + String.valueOf(this.myBlock.getAlignment()), new SimpleTextAttributes(1, (Color)color));
        }
        if (this.myBlock.getWrap() != null) {
            presentation.addText(" " + String.valueOf(this.myBlock.getWrap()), new SimpleTextAttributes(2, PlatformColors.BLUE));
        }
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myBlock};
        if (objectArray == null) {
            BlockTreeNode.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    public boolean isAlwaysLeaf() {
        return this.myBlock.isLeaf() && this.myBlock.getSubBlocks().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/psiView/formattingblocks/BlockTreeNode", "getEqualityObjects"));
    }
}

