/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.registry.Registry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\f\u0010\u0018\u001a\u00020\u0004*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/eventLog/FeatureUsageEventLogger;", "", "()V", "bucket", "", "count", "", "eventLogger", "Lorg/apache/log4j/Logger;", "lastEvent", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "lastEventTime", "", "recorderVersion", "sessionId", "createLogger", "dispose", "", "logger", "log", "recorderId", "action", "event", "logLastEvent", "shortedUUID", "intellij.platform.ide.impl"})
public final class FeatureUsageEventLogger {
    private static final String sessionId;
    private static final String bucket = "-1";
    private static final String recorderVersion = "1";
    private static final Logger eventLogger;
    private static LogEvent lastEvent;
    private static long lastEventTime;
    private static int count;
    public static final FeatureUsageEventLogger INSTANCE;

    private final String shortedUUID(@NotNull String $receiver) {
        int start = StringsKt.lastIndexOf$default((CharSequence)$receiver, (char)'-', (int)0, (boolean)false, (int)6, null);
        if (start > 0 && start + 1 < $receiver.length()) {
            String string = $receiver;
            int n = start + 1;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            return string3;
        }
        return $receiver;
    }

    public final void log(@NotNull String recorderId, @NotNull String action) {
        Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
        Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
        if (eventLogger != null) {
            this.log(eventLogger, new LogEvent(sessionId, bucket, recorderId, recorderVersion, action));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void log(Logger logger, LogEvent event) {
        if (lastEvent != null && event.getTime() - lastEventTime <= (long)10000) {
            LogEvent logEvent = lastEvent;
            if (logEvent == null) {
                Intrinsics.throwNpe();
            }
            if (logEvent.shouldMerge(event)) {
                lastEventTime = event.getTime();
                int n = count;
                count = n + 1;
                return;
            }
        }
        this.logLastEvent(logger);
        lastEvent = event;
        lastEventTime = event.getTime();
    }

    private final void dispose(Logger logger) {
        this.log(logger, new LogEvent(sessionId, bucket, "feature-usage-stats", recorderVersion, "ideaapp.closed"));
        this.logLastEvent(logger);
    }

    private final void logLastEvent(Logger logger) {
        if (lastEvent != null) {
            if (count > 1) {
                LogEvent logEvent = lastEvent;
                if (logEvent == null) {
                    Intrinsics.throwNpe();
                }
                logEvent.getAction().addData("count", count);
            }
            LogEvent logEvent = lastEvent;
            if (logEvent == null) {
                Intrinsics.throwNpe();
            }
            logger.info((Object)LogEventSerializer.INSTANCE.toString(logEvent));
        }
        lastEvent = null;
        count = 1;
    }

    private final Logger createLogger() {
        Logger logger;
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("event-log").resolve("feature-usage-event.log");
        File file2 = new File(path.toUri());
        Logger logger2 = logger = Logger.getLogger((String)"feature-usage-event-logger");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
        logger2.setLevel(Level.INFO);
        logger.setAdditivity(false);
        PatternLayout pattern = new PatternLayout("%m\n");
        try {
            RollingFileAppender fileAppender = new RollingFileAppender((Layout)pattern, file2.getAbsolutePath());
            fileAppender.setMaxFileSize("200KB");
            fileAppender.setMaxBackupIndex(10);
            logger.addAppender((Appender)fileAppender);
        }
        catch (IOException e) {
            System.err.println("Unable to initialize logging for feature usage: " + e.getLocalizedMessage());
        }
        return logger;
    }

    private FeatureUsageEventLogger() {
    }

    static {
        FeatureUsageEventLogger featureUsageEventLogger;
        INSTANCE = featureUsageEventLogger = new FeatureUsageEventLogger();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        sessionId = featureUsageEventLogger.shortedUUID(string);
        bucket = bucket;
        recorderVersion = recorderVersion;
        eventLogger = Registry.is((String)"feature.usage.event.log.collect.and.upload") ? featureUsageEventLogger.createLogger() : null;
        count = 1;
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void applicationExiting() {
                if (FeatureUsageEventLogger.access$getEventLogger$p(INSTANCE) != null) {
                    INSTANCE.dispose(FeatureUsageEventLogger.access$getEventLogger$p(INSTANCE));
                }
            }
        });
    }

    @Nullable
    public static final /* synthetic */ Logger access$getEventLogger$p(FeatureUsageEventLogger $this) {
        FeatureUsageEventLogger featureUsageEventLogger = $this;
        return eventLogger;
    }
}

