/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.LogEventAction;
import com.intellij.internal.statistic.eventLog.LogEventRecorder;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEvent;", "", "session", "", "bucket", "recorderId", "recorderVersion", "type", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "action", "Lcom/intellij/internal/statistic/eventLog/LogEventAction;", "getAction", "()Lcom/intellij/internal/statistic/eventLog/LogEventAction;", "getBucket", "()Ljava/lang/String;", "recorder", "Lcom/intellij/internal/statistic/eventLog/LogEventRecorder;", "getRecorder", "()Lcom/intellij/internal/statistic/eventLog/LogEventRecorder;", "getSession", "time", "", "getTime", "()J", "equals", "", "other", "hashCode", "", "removeTabsOrSpaces", "str", "shouldMerge", "next", "intellij.platform.ide.impl"})
public class LogEvent {
    private final long time;
    @NotNull
    private final LogEventRecorder recorder;
    @NotNull
    private final LogEventAction action;
    @NotNull
    private final String session;
    @NotNull
    private final String bucket;

    public final long getTime() {
        return this.time;
    }

    @NotNull
    public final LogEventRecorder getRecorder() {
        return this.recorder;
    }

    @NotNull
    public final LogEventAction getAction() {
        return this.action;
    }

    public final boolean shouldMerge(@NotNull LogEvent next) {
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
        if (Intrinsics.areEqual((Object)this.session, (Object)next.session) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.bucket, (Object)next.bucket) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.recorder.getId(), (Object)next.recorder.getId()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.recorder.getVersion(), (Object)next.recorder.getVersion()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.action.getId(), (Object)next.action.getId()) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual(this.action.getData(), next.action.getData()) ^ true);
    }

    private final String removeTabsOrSpaces(String str) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)str, (String)" ", (String)"_", (boolean)false, (int)4, null), (String)"\t", (String)"_", (boolean)false, (int)4, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.LogEvent");
        }
        LogEvent cfr_ignored_0 = (LogEvent)object2;
        if (Intrinsics.areEqual((Object)this.session, (Object)((LogEvent)other).session) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.bucket, (Object)((LogEvent)other).bucket) ^ true) {
            return false;
        }
        if (this.time != ((LogEvent)other).time) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.recorder, (Object)((LogEvent)other).recorder) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.action, (Object)((LogEvent)other).action) ^ true);
    }

    public int hashCode() {
        int result2 = this.session.hashCode();
        result2 = 31 * result2 + this.bucket.hashCode();
        result2 = 31 * result2 + Long.hashCode(this.time);
        result2 = 31 * result2 + this.recorder.hashCode();
        result2 = 31 * result2 + this.action.hashCode();
        return result2;
    }

    @NotNull
    public final String getSession() {
        return this.session;
    }

    @NotNull
    public final String getBucket() {
        return this.bucket;
    }

    public LogEvent(@NotNull String session2, @NotNull String bucket, @NotNull String recorderId, @NotNull String recorderVersion, @NotNull String type) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)bucket, (String)"bucket");
        Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
        Intrinsics.checkParameterIsNotNull((Object)recorderVersion, (String)"recorderVersion");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        this.session = session2;
        this.bucket = bucket;
        this.time = System.currentTimeMillis();
        this.recorder = new LogEventRecorder(this.removeTabsOrSpaces(recorderId), recorderVersion);
        this.action = new LogEventAction(this.removeTabsOrSpaces(type));
    }
}

