/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.beans.FSContent;
import com.intellij.internal.statistic.service.fus.beans.FSGroup;
import com.intellij.internal.statistic.service.fus.beans.FSSession;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.FUSession;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsPersistence;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUStatisticsAggregator
implements UsagesCollectorConsumer {
    public static FUStatisticsAggregator create() {
        return new FUStatisticsAggregator();
    }

    @Nullable
    public FSContent getUsageCollectorsData(@NotNull Set<String> approvedGroups) {
        if (approvedGroups == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(0);
        }
        if (approvedGroups.isEmpty() && !ApplicationManagerEx.getApplicationEx().isInternal()) {
            return null;
        }
        FSContent content = FSContent.create();
        this.collectApplicationUsages(content, approvedGroups);
        this.collectOpenProjectUsages(content, approvedGroups);
        FUStatisticsAggregator.collectPersistedProjectUsages(content);
        return content;
    }

    public void collectApplicationUsages(FSContent content, @NotNull Set<String> approvedGroups) {
        if (approvedGroups == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(1);
        }
        FUStatisticsAggregator.writeContent(content, FUSession.APPLICATION_SESSION, this.getApplicationUsages(approvedGroups));
    }

    private void collectOpenProjectUsages(@NotNull FSContent content, @NotNull Set<String> approvedGroups) {
        if (content == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(2);
        }
        if (approvedGroups == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(3);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            Map<String, Set<UsageDescriptor>> usages;
            if (project.isDisposed() || (usages = this.getProjectUsages(project, approvedGroups)).isEmpty()) continue;
            FUStatisticsAggregator.writeContent(content, FUSession.create(project), usages);
        }
    }

    private static void collectPersistedProjectUsages(@NotNull FSContent content) {
        if (content == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(4);
        }
        for (FSSession session2 : FUStatisticsPersistence.getPersistedSessions()) {
            content.addSession(session2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Map<String, Set<UsageDescriptor>> getApplicationUsages(@NotNull Set<String> approvedGroups) {
        if (approvedGroups == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(5);
        }
        Object object = StatisticsUploadAssistant.LOCK;
        // MONITORENTER : object
        LinkedHashMap<String, Set<UsageDescriptor>> usageDescriptors = new LinkedHashMap<String, Set<UsageDescriptor>>();
        Iterator<ApplicationUsagesCollector> iterator = ApplicationUsagesCollector.getExtensions(this).iterator();
        while (true) {
            if (!iterator.hasNext()) {
                LinkedHashMap<String, Set<UsageDescriptor>> linkedHashMap = usageDescriptors;
                // MONITOREXIT : object
                if (linkedHashMap != null) return linkedHashMap;
                FUStatisticsAggregator.$$$reportNull$$$0(6);
                return linkedHashMap;
            }
            ApplicationUsagesCollector usagesCollector = iterator.next();
            FUStatisticsAggregator.collectUsages(usageDescriptors, usagesCollector, (Factory<Set<UsageDescriptor>>)((Factory)usagesCollector::getUsages), approvedGroups);
        }
    }

    private static void collectUsages(@NotNull Map<String, Set<UsageDescriptor>> usageDescriptors, @NotNull FeatureUsagesCollector usagesCollector, @NotNull Factory<Set<UsageDescriptor>> usagesProducer, @NotNull Set<String> approvedGroups) {
        if (usageDescriptors == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(7);
        }
        if (usagesCollector == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(8);
        }
        if (usagesProducer == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(9);
        }
        if (approvedGroups == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(10);
        }
        if (!usagesCollector.isValid()) {
            return;
        }
        if (approvedGroups.contains(usagesCollector.getGroupId())) {
            FUStatisticsAggregator.addUsageDescriptors(usagesCollector.getGroupId(), usageDescriptors, usagesProducer);
        } else if (ApplicationManagerEx.getApplicationEx().isInternal()) {
            FUStatisticsAggregator.addUsageDescriptors(FUStatisticsAggregator.createDebugModeId(usagesCollector), usageDescriptors, usagesProducer);
        }
    }

    @NotNull
    private static String createDebugModeId(@NotNull FeatureUsagesCollector usagesCollector) {
        if (usagesCollector == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(11);
        }
        String string = "internal." + usagesCollector.getGroupId();
        if (string == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static void addUsageDescriptors(@NotNull String groupDescriptor, @NotNull Map<String, Set<UsageDescriptor>> allUsageDescriptors, @NotNull Factory<Set<UsageDescriptor>> usagesProducer) {
        Set usages;
        if (groupDescriptor == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(13);
        }
        if (allUsageDescriptors == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(14);
        }
        if (usagesProducer == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(15);
        }
        if (!(usages = (Set)usagesProducer.create()).isEmpty()) {
            allUsageDescriptors.merge(groupDescriptor, usages, ContainerUtil::union);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    Map<String, Set<UsageDescriptor>> getProjectUsages(@NotNull Project project, @NotNull Set<String> approvedGroups) {
        if (project == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(16);
        }
        if (approvedGroups == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(17);
        }
        Object object = StatisticsUploadAssistant.LOCK;
        // MONITORENTER : object
        LinkedHashMap<String, Set<UsageDescriptor>> usageDescriptors = new LinkedHashMap<String, Set<UsageDescriptor>>();
        Iterator<ProjectUsagesCollector> iterator = ProjectUsagesCollector.getExtensions(this).iterator();
        while (true) {
            if (!iterator.hasNext()) {
                LinkedHashMap<String, Set<UsageDescriptor>> linkedHashMap = usageDescriptors;
                // MONITOREXIT : object
                if (linkedHashMap != null) return linkedHashMap;
                FUStatisticsAggregator.$$$reportNull$$$0(18);
                return linkedHashMap;
            }
            ProjectUsagesCollector usagesCollector = iterator.next();
            FUStatisticsAggregator.collectUsages(usageDescriptors, usagesCollector, (Factory<Set<UsageDescriptor>>)((Factory)() -> {
                if (project == null) {
                    FUStatisticsAggregator.$$$reportNull$$$0(22);
                }
                return usagesCollector.getUsages(project);
            }), approvedGroups);
        }
    }

    static void writeContent(@NotNull FSContent content, @NotNull FUSession fuSession, @NotNull Map<String, Set<UsageDescriptor>> usages) {
        if (content == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(19);
        }
        if (fuSession == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(20);
        }
        if (usages == null) {
            FUStatisticsAggregator.$$$reportNull$$$0(21);
        }
        FSSession session2 = FSSession.create(fuSession);
        if (content.getSessions() != null && content.getSessions().contains(session2)) {
            return;
        }
        for (Map.Entry<String, Set<UsageDescriptor>> group : usages.entrySet()) {
            Set<UsageDescriptor> value = group.getValue();
            if (value.isEmpty()) continue;
            session2.addGroup(FSGroup.create(group.getKey(), value));
        }
        if (session2.hasGroups()) {
            content.addSession(session2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 12: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 12: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "approvedGroups";
                break;
            }
            case 2: 
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FUStatisticsAggregator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageDescriptors";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesCollector";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usagesProducer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupDescriptor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allUsageDescriptors";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fuSession";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUStatisticsAggregator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationUsages";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugModeId";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUsageCollectorsData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectApplicationUsages";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectOpenProjectUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectPersistedProjectUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationUsages";
                break;
            }
            case 6: 
            case 12: 
            case 18: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectUsages";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDebugModeId";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addUsageDescriptors";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProjectUsages";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writeContent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getProjectUsages$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 12: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

