/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.service.fus.beans.FSContent;
import com.intellij.internal.statistic.service.fus.beans.FSGroup;
import com.intellij.internal.statistic.service.fus.beans.FSSession;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsDifferenceSender;
import com.intellij.internal.statistic.service.fus.collectors.FUStatisticsPersistence;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUStatisticsStateService
implements UsagesCollectorConsumer {
    public static FUStatisticsStateService create() {
        return new FUStatisticsStateService();
    }

    @Nullable
    public String getMergedDataToSend(@NotNull String actualDataFromCollectors) {
        Set<FSSession> allDataFromCollectorsSessions;
        FSContent previousStateContent;
        if (actualDataFromCollectors == null) {
            FUStatisticsStateService.$$$reportNull$$$0(0);
        }
        FSContent allDataFromCollectors = FSContent.fromJson(actualDataFromCollectors);
        Set<String> differenceSenders = this.getFUStatisticsDifferenceSenders();
        if (!differenceSenders.isEmpty() && (previousStateContent = FUStatisticsStateService.loadContent()) != null && (allDataFromCollectorsSessions = allDataFromCollectors.getSessions()) != null) {
            for (FSSession actualSession : allDataFromCollectorsSessions) {
                for (FSGroup actualGroup : this.getActualGroupsToMerge(differenceSenders, actualSession.getGroups())) {
                    Map<String, Integer> persistedMetrics = FUStatisticsStateService.getPersistedMetrics(FUStatisticsStateService.getPreviousSession(previousStateContent, actualSession), actualGroup.id);
                    if (persistedMetrics.isEmpty()) continue;
                    FUStatisticsStateService.updateDifferenceSenderMetricsData(actualGroup.getMetrics(), persistedMetrics);
                }
            }
        }
        allDataFromCollectors.removeEmptyData();
        if (allDataFromCollectors.sessions == null || allDataFromCollectors.sessions.isEmpty()) {
            return null;
        }
        return allDataFromCollectors.asJsonString();
    }

    @NotNull
    public Set<FSGroup> getActualGroupsToMerge(@NotNull Set<String> differenceSenders, @Nullable List<FSGroup> groups) {
        if (differenceSenders == null) {
            FUStatisticsStateService.$$$reportNull$$$0(1);
        }
        if (groups != null) {
            Set<FSGroup> set2 = groups.stream().filter(actualGroup -> {
                if (differenceSenders == null) {
                    FUStatisticsStateService.$$$reportNull$$$0(10);
                }
                return differenceSenders.contains(actualGroup.id);
            }).collect(Collectors.toSet());
            if (set2 == null) {
                FUStatisticsStateService.$$$reportNull$$$0(2);
            }
            return set2;
        }
        Set<FSGroup> set3 = Collections.emptySet();
        if (set3 == null) {
            FUStatisticsStateService.$$$reportNull$$$0(3);
        }
        return set3;
    }

    private static void updateDifferenceSenderMetricsData(@NotNull Map<String, Integer> actualMetrics, @NotNull Map<String, Integer> persistedMetrics) {
        if (actualMetrics == null) {
            FUStatisticsStateService.$$$reportNull$$$0(4);
        }
        if (persistedMetrics == null) {
            FUStatisticsStateService.$$$reportNull$$$0(5);
        }
        HashSet keysToRemove = ContainerUtil.newHashSet();
        for (Map.Entry<String, Integer> entry : actualMetrics.entrySet()) {
            Integer persistedValue = persistedMetrics.get(entry.getKey());
            if (persistedValue == null) continue;
            Integer actualValue = entry.getValue();
            if (actualValue > persistedValue) {
                entry.setValue(actualValue - persistedValue);
                continue;
            }
            if (actualValue.intValue() != persistedValue.intValue()) continue;
            keysToRemove.add(entry.getKey());
        }
        if (!keysToRemove.isEmpty()) {
            actualMetrics.keySet().removeAll(keysToRemove);
        }
    }

    public Set<String> getFUStatisticsDifferenceSenders() {
        HashSet senders = ContainerUtil.newHashSet();
        for (ProjectUsagesCollector projectUsagesCollector : ProjectUsagesCollector.getExtensions(this)) {
            if (!(projectUsagesCollector instanceof FUStatisticsDifferenceSender)) continue;
            senders.add(projectUsagesCollector.getGroupId());
        }
        for (ApplicationUsagesCollector applicationUsagesCollector : ApplicationUsagesCollector.getExtensions(this)) {
            if (!(applicationUsagesCollector instanceof FUStatisticsDifferenceSender)) continue;
            senders.add(applicationUsagesCollector.getGroupId());
        }
        return senders;
    }

    @Nullable
    public static FSContent loadContent() {
        String content = FUStatisticsPersistence.getPreviousStateContent();
        if (content == null) {
            return null;
        }
        return FSContent.fromJson(content);
    }

    @Nullable
    public static FSSession getPreviousSession(@Nullable FSContent persistedContent, @NotNull FSSession actualSession) {
        if (actualSession == null) {
            FUStatisticsStateService.$$$reportNull$$$0(6);
        }
        if (persistedContent == null) {
            return null;
        }
        Set<FSSession> sessions = persistedContent.getSessions();
        if (sessions == null) {
            return null;
        }
        for (FSSession previousSession : sessions) {
            if (!previousSession.equals(actualSession)) continue;
            return previousSession;
        }
        return null;
    }

    @NotNull
    public static Map<String, Integer> getPersistedMetrics(@Nullable FSSession persistedSession, @NotNull String groupId) {
        List<FSGroup> persistedGroups;
        if (groupId == null) {
            FUStatisticsStateService.$$$reportNull$$$0(7);
        }
        if (persistedSession != null && (persistedGroups = persistedSession.getGroups()) != null) {
            for (FSGroup group : persistedGroups) {
                if (!groupId.equals(group.id)) continue;
                Map<String, Integer> map = group.getMetrics();
                if (map == null) {
                    FUStatisticsStateService.$$$reportNull$$$0(8);
                }
                return map;
            }
        }
        Map<String, Integer> map = Collections.emptyMap();
        if (map == null) {
            FUStatisticsStateService.$$$reportNull$$$0(9);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualDataFromCollectors";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "differenceSenders";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FUStatisticsStateService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualMetrics";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistedMetrics";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualSession";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUStatisticsStateService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualGroupsToMerge";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistedMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMergedDataToSend";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getActualGroupsToMerge";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateDifferenceSenderMetricsData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousSession";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPersistedMetrics";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getActualGroupsToMerge$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

