/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationInfoImpl
extends ApplicationInfoEx {
    private String myCodeName;
    private String myMajorVersion;
    private String myMinorVersion;
    private String myMicroVersion;
    private String myPatchVersion;
    private String myFullVersionFormat;
    private String myBuildNumber;
    private String myApiVersion;
    private String myCompanyName = "JetBrains s.r.o.";
    private String myCopyrightStart = "2000";
    private String myShortCompanyName;
    private String myCompanyUrl = "https://www.jetbrains.com/";
    private Color myProgressColor;
    private Color myCopyrightForeground = JBColor.BLACK;
    private Color myAboutForeground = JBColor.BLACK;
    private Color myAboutLinkColor;
    private String myProgressTailIconName;
    private Icon myProgressTailIcon;
    private int myProgressHeight = 2;
    private int myProgressX = 1;
    private int myProgressY = 350;
    private int myLicenseOffsetY = Registry.is((String)"ide.new.about") ? 85 : 30;
    private String mySplashImageUrl;
    private String myAboutImageUrl;
    private Color mySplashTextColor = new Color(0, 35, 135);
    private String myIconUrl = "/icon.png";
    private String mySmallIconUrl = "/icon_small.png";
    private String myBigIconUrl;
    private String myToolWindowIconUrl = "/toolwindows/toolWindowProject.png";
    private String myWelcomeScreenLogoUrl;
    private String myEditorBackgroundImageUrl;
    private Calendar myBuildDate;
    private Calendar myMajorReleaseBuildDate;
    private String myPackageCode;
    private boolean myShowLicensee = true;
    private String myCustomizeIDEWizardStepsProvider;
    private ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myEAPFeedbackUrl;
    private String myReleaseFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String myChannelsListUrl;
    private String myPluginsDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp = true;
    private boolean myHasContextHelp = true;
    @Nullable
    private String myHelpFileName = "ideahelp.jar";
    @Nullable
    private String myHelpRootName = "idea";
    private String myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
    private List<ApplicationInfoEx.PluginChooserPage> myPluginChooserPages = new ArrayList<ApplicationInfoEx.PluginChooserPage>();
    private String[] myEssentialPluginsIds;
    private String myStatisticsSettingsUrl;
    private String myFUStatisticsSettingsUrl;
    private String myStatisticsServiceUrl;
    private String myStatisticsServiceKey;
    private String myThirdPartySoftwareUrl;
    private String myJetbrainsTvUrl;
    private String myEvalLicenseUrl = "https://www.jetbrains.com/store/license.html";
    private String myKeyConversionUrl = "https://www.jetbrains.com/shop/eform/keys-exchange";
    private String mySubscriptionFormId;
    private String mySubscriptionNewsKey;
    private String mySubscriptionNewsValue;
    private String mySubscriptionTipsKey;
    private boolean mySubscriptionTipsAvailable;
    private String mySubscriptionAdditionalFormData;
    private Rectangle myAboutLogoRect;
    private static final String IDEA_PATH = "/idea/";
    private static final String ELEMENT_VERSION = "version";
    private static final String ATTRIBUTE_MAJOR = "major";
    private static final String ATTRIBUTE_MINOR = "minor";
    private static final String ATTRIBUTE_MICRO = "micro";
    private static final String ATTRIBUTE_PATCH = "patch";
    private static final String ATTRIBUTE_FULL = "full";
    private static final String ATTRIBUTE_CODENAME = "codename";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ELEMENT_BUILD = "build";
    private static final String ELEMENT_COMPANY = "company";
    private static final String ATTRIBUTE_NUMBER = "number";
    private static final String ATTRIBUTE_API_VERSION = "apiVersion";
    private static final String ATTRIBUTE_DATE = "date";
    private static final String ATTRIBUTE_MAJOR_RELEASE_DATE = "majorReleaseDate";
    private static final String ELEMENT_LOGO = "logo";
    private static final String ATTRIBUTE_URL = "url";
    private static final String COPYRIGHT_START = "copyrightStart";
    private static final String ATTRIBUTE_TEXT_COLOR = "textcolor";
    private static final String ATTRIBUTE_PROGRESS_COLOR = "progressColor";
    private static final String ATTRIBUTE_ABOUT_FOREGROUND_COLOR = "foreground";
    private static final String ATTRIBUTE_ABOUT_COPYRIGHT_FOREGROUND_COLOR = "copyrightForeground";
    private static final String ATTRIBUTE_ABOUT_LINK_COLOR = "linkColor";
    private static final String ATTRIBUTE_PROGRESS_HEIGHT = "progressHeight";
    private static final String ATTRIBUTE_PROGRESS_X = "progressX";
    private static final String ATTRIBUTE_PROGRESS_Y = "progressY";
    private static final String ATTRIBUTE_LICENSE_TEXT_OFFSET_Y = "licenseOffsetY";
    private static final String ATTRIBUTE_PROGRESS_TAIL_ICON = "progressTailIcon";
    private static final String ELEMENT_ABOUT = "about";
    private static final String ELEMENT_ICON = "icon";
    private static final String ATTRIBUTE_SIZE32 = "size32";
    private static final String ATTRIBUTE_SIZE128 = "size128";
    private static final String ATTRIBUTE_SIZE16 = "size16";
    private static final String ATTRIBUTE_SIZE12 = "size12";
    private static final String ELEMENT_PACKAGE = "package";
    private static final String ATTRIBUTE_CODE = "code";
    private static final String ELEMENT_LICENSEE = "licensee";
    private static final String ATTRIBUTE_SHOW = "show";
    private static final String WELCOME_SCREEN_ELEMENT_NAME = "welcome-screen";
    private static final String LOGO_URL_ATTR = "logo-url";
    private static final String ELEMENT_EDITOR = "editor";
    private static final String BACKGROUND_URL_ATTR = "background-url";
    private static final String UPDATE_URLS_ELEMENT_NAME = "update-urls";
    private static final String XML_EXTENSION = ".xml";
    private static final String ATTRIBUTE_EAP = "eap";
    private static final String HELP_ELEMENT_NAME = "help";
    private static final String ATTRIBUTE_HELP_FILE = "file";
    private static final String ATTRIBUTE_HELP_ROOT = "root";
    private static final String PLUGINS_PAGE_ELEMENT_NAME = "plugins-page";
    private static final String ELEMENT_DOCUMENTATION = "documentation";
    private static final String ELEMENT_SUPPORT = "support";
    private static final String ELEMENT_FEEDBACK = "feedback";
    private static final String ATTRIBUTE_RELEASE_URL = "release-url";
    private static final String ATTRIBUTE_EAP_URL = "eap-url";
    private static final String ELEMENT_PLUGINS = "plugins";
    private static final String ATTRIBUTE_LIST_URL = "list-url";
    private static final String ATTRIBUTE_CHANNEL_LIST_URL = "channel-list-url";
    private static final String ATTRIBUTE_DOWNLOAD_URL = "download-url";
    private static final String ATTRIBUTE_BUILTIN_URL = "builtin-url";
    private static final String ATTRIBUTE_WEBHELP_URL = "webhelp-url";
    private static final String ATTRIBUTE_HAS_HELP = "has-help";
    private static final String ATTRIBUTE_HAS_CONTEXT_HELP = "has-context-help";
    private static final String ELEMENT_WHATSNEW = "whatsnew";
    private static final String ELEMENT_KEYMAP = "keymap";
    private static final String ATTRIBUTE_WINDOWS_URL = "win";
    private static final String ATTRIBUTE_MAC_URL = "mac";
    private static final String ELEMENT_STATISTICS = "statistics";
    private static final String ATTRIBUTE_STATISTICS_SETTINGS = "settings";
    private static final String ATTRIBUTE_FU_STATISTICS_SETTINGS = "fus-settings";
    private static final String ATTRIBUTE_STATISTICS_SERVICE = "service";
    private static final String ATTRIBUTE_STATISTICS_SERVICE_KEY = "service-key";
    private static final String ELEMENT_THIRD_PARTY = "third-party";
    private static final String ELEMENT_JB_TV = "jetbrains-tv";
    private static final String CUSTOMIZE_IDE_WIZARD_STEPS = "customize-ide-wizard";
    private static final String STEPS_PROVIDER = "provider";
    private static final String ELEMENT_EVALUATION = "evaluation";
    private static final String ATTRIBUTE_EVAL_LICENSE_URL = "license-url";
    private static final String ELEMENT_LICENSING = "licensing";
    private static final String ATTRIBUTE_KEY_CONVERSION_URL = "key-conversion-url";
    private static final String ESSENTIAL_PLUGIN = "essential-plugin";
    private static final String ELEMENT_SUBSCRIPTIONS = "subscriptions";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_FORM_ID = "formid";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_NEWS_KEY = "news-key";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_NEWS_VALUE = "news-value";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_TIPS_KEY = "tips-key";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_TIPS_AVAILABLE = "tips-available";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_ADDITIONAL_FORM_DATA = "additional-form-data";
    private static final String DEFAULT_PLUGINS_HOST = "http://plugins.jetbrains.com";
    private static ApplicationInfoImpl ourShadowInstance;
    private static volatile boolean myInStressTest;

    ApplicationInfoImpl() {
        String resource = IDEA_PATH + ApplicationNamesInfo.getComponentName() + XML_EXTENSION;
        try {
            Document doc = JDOMUtil.loadDocument(ApplicationInfoImpl.class, (String)resource);
            this.loadState(doc.getRootElement());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
    }

    public Calendar getBuildDate() {
        return this.myBuildDate;
    }

    @Override
    public Calendar getMajorReleaseBuildDate() {
        return this.myMajorReleaseBuildDate != null ? this.myMajorReleaseBuildDate : this.myBuildDate;
    }

    public BuildNumber getBuild() {
        return BuildNumber.fromStringWithProductCode((String)this.myBuildNumber, (String)ApplicationInfoImpl.getProductPrefix());
    }

    private static String getProductPrefix() {
        String prefix = null;
        if (PlatformUtils.isIdeaCommunity()) {
            prefix = "IC";
        } else if (PlatformUtils.isIdeaUltimate()) {
            prefix = "IU";
        }
        return prefix;
    }

    public String getApiVersion() {
        BuildNumber api;
        BuildNumber build = this.getBuild();
        if (this.myApiVersion != null && (api = BuildNumber.fromStringWithProductCode((String)this.myApiVersion, (String)build.getProductCode())) != null) {
            return api.asString();
        }
        return build.asString();
    }

    public String getMajorVersion() {
        return this.myMajorVersion;
    }

    public String getMinorVersion() {
        return this.myMinorVersion;
    }

    public String getMicroVersion() {
        return this.myMicroVersion;
    }

    public String getPatchVersion() {
        return this.myPatchVersion;
    }

    public String getFullVersion() {
        String result2 = this.myFullVersionFormat != null ? MessageFormat.format(this.myFullVersionFormat, this.myMajorVersion, this.myMinorVersion, this.myMicroVersion, this.myPatchVersion) : StringUtil.notNullize((String)this.myMajorVersion, (String)"0") + '.' + StringUtil.notNullize((String)this.myMinorVersion, (String)"0");
        if (this.isEAP()) {
            result2 = result2 + " EAP";
        }
        return result2;
    }

    public String getStrictVersion() {
        return this.myMajorVersion + "." + this.myMinorVersion + "." + StringUtil.notNullize((String)this.myMicroVersion, (String)"0") + "." + StringUtil.notNullize((String)this.myPatchVersion, (String)"0");
    }

    public String getVersionName() {
        String fullName = ApplicationNamesInfo.getInstance().getFullProductName();
        if (this.myEAP && !StringUtil.isEmptyOrSpaces((String)this.myCodeName)) {
            fullName = fullName + " (" + this.myCodeName + ")";
        }
        return fullName;
    }

    @Nullable
    public String getHelpURL() {
        String jarPath = this.getHelpJarPath();
        return jarPath == null || this.myHelpRootName == null ? null : "jar:file:///" + jarPath + "!/" + this.myHelpRootName;
    }

    public String getShortCompanyName() {
        return this.myShortCompanyName;
    }

    public String getCompanyName() {
        return this.myCompanyName;
    }

    public String getCompanyURL() {
        return IdeUrlTrackingParametersProvider.getInstance().augmentUrl(this.myCompanyUrl);
    }

    @Nullable
    private String getHelpJarPath() {
        return this.myHelpFileName == null ? null : PathManager.getHomePath() + File.separator + HELP_ELEMENT_NAME + File.separator + this.myHelpFileName;
    }

    @Override
    public String getSplashImageUrl() {
        return this.mySplashImageUrl;
    }

    @Override
    public Color getSplashTextColor() {
        return this.mySplashTextColor;
    }

    @Override
    public String getAboutImageUrl() {
        return this.myAboutImageUrl;
    }

    public Color getProgressColor() {
        return this.myProgressColor;
    }

    public Color getCopyrightForeground() {
        return this.myCopyrightForeground;
    }

    public int getProgressHeight() {
        return this.myProgressHeight;
    }

    public int getProgressY() {
        return this.myProgressY;
    }

    public int getLicenseOffsetY() {
        return this.myLicenseOffsetY;
    }

    public int getProgressX() {
        return this.myProgressX;
    }

    @Nullable
    public Icon getProgressTailIcon() {
        if (this.myProgressTailIcon == null && this.myProgressTailIconName != null) {
            try {
                URL url = ((Object)((Object)this)).getClass().getResource(this.myProgressTailIconName);
                Image image = ImageLoader.loadFromUrl((URL)url, (boolean)false);
                if (image != null) {
                    this.myProgressTailIcon = new ImageIcon(image);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.myProgressTailIcon;
    }

    @Override
    public String getIconUrl() {
        return this.myIconUrl;
    }

    @Override
    public String getSmallIconUrl() {
        return this.mySmallIconUrl;
    }

    @Override
    @Nullable
    public String getBigIconUrl() {
        return this.myBigIconUrl;
    }

    @Override
    public String getToolWindowIconUrl() {
        return this.myToolWindowIconUrl;
    }

    @Override
    public String getWelcomeScreenLogoUrl() {
        return this.myWelcomeScreenLogoUrl;
    }

    @Override
    @Nullable
    public String getCustomizeIDEWizardStepsProvider() {
        return this.myCustomizeIDEWizardStepsProvider;
    }

    @Override
    public String getEditorBackgroundImageUrl() {
        return this.myEditorBackgroundImageUrl;
    }

    @Override
    public String getPackageCode() {
        return this.myPackageCode;
    }

    @Override
    public boolean isEAP() {
        return this.myEAP;
    }

    @Override
    public ApplicationInfoEx.UpdateUrls getUpdateUrls() {
        return this.myUpdateUrls;
    }

    @Override
    public String getDocumentationUrl() {
        return this.myDocumentationUrl;
    }

    @Override
    public String getSupportUrl() {
        return this.mySupportUrl;
    }

    @Override
    public String getEAPFeedbackUrl() {
        return this.myEAPFeedbackUrl;
    }

    @Override
    public String getReleaseFeedbackUrl() {
        return this.myReleaseFeedbackUrl;
    }

    @Override
    public String getPluginManagerUrl() {
        return this.myPluginManagerUrl;
    }

    @Override
    public String getPluginsListUrl() {
        return this.myPluginsListUrl;
    }

    @Override
    public String getChannelsListUrl() {
        return this.myChannelsListUrl;
    }

    @Override
    public String getPluginsDownloadUrl() {
        return this.myPluginsDownloadUrl;
    }

    @Override
    public String getBuiltinPluginsUrl() {
        return this.myBuiltinPluginsUrl;
    }

    @Override
    public String getWebHelpUrl() {
        return this.myWebHelpUrl;
    }

    public boolean hasHelp() {
        return this.myHasHelp;
    }

    public boolean hasContextHelp() {
        return this.myHasContextHelp;
    }

    @Override
    public String getWhatsNewUrl() {
        return this.myWhatsNewUrl;
    }

    @Override
    public String getWinKeymapUrl() {
        return this.myWinKeymapUrl;
    }

    @Override
    public String getMacKeymapUrl() {
        return this.myMacKeymapUrl;
    }

    @Override
    public Color getAboutForeground() {
        return this.myAboutForeground;
    }

    @Nullable
    public Color getAboutLinkColor() {
        return this.myAboutLinkColor;
    }

    @Override
    public String getFullApplicationName() {
        return this.getVersionName() + " " + this.getFullVersion();
    }

    @Override
    public boolean showLicenseeInfo() {
        return this.myShowLicensee;
    }

    public String getCopyrightStart() {
        return this.myCopyrightStart;
    }

    public String getStatisticsSettingsUrl() {
        return this.myStatisticsSettingsUrl;
    }

    public String getFUStatisticsSettingsUrl() {
        return this.myFUStatisticsSettingsUrl;
    }

    public String getStatisticsServiceUrl() {
        return this.myStatisticsServiceUrl;
    }

    public String getStatisticsServiceKey() {
        return this.myStatisticsServiceKey;
    }

    public String getThirdPartySoftwareURL() {
        return this.myThirdPartySoftwareUrl;
    }

    public String getJetbrainsTvUrl() {
        return this.myJetbrainsTvUrl;
    }

    public String getEvalLicenseUrl() {
        return this.myEvalLicenseUrl;
    }

    public String getKeyConversionUrl() {
        return this.myKeyConversionUrl;
    }

    public Rectangle getAboutLogoRect() {
        return this.myAboutLogoRect;
    }

    @Override
    public String getSubscriptionFormId() {
        return this.mySubscriptionFormId;
    }

    @Override
    public String getSubscriptionNewsKey() {
        return this.mySubscriptionNewsKey;
    }

    @Override
    public String getSubscriptionNewsValue() {
        return this.mySubscriptionNewsValue;
    }

    @Override
    public String getSubscriptionTipsKey() {
        return this.mySubscriptionTipsKey;
    }

    @Override
    public boolean areSubscriptionTipsAvailable() {
        return this.mySubscriptionTipsAvailable;
    }

    @Override
    @Nullable
    public String getSubscriptionAdditionalFormData() {
        return this.mySubscriptionAdditionalFormData;
    }

    public boolean isBetaOrRC() {
        String minor = this.getMinorVersion();
        return minor != null && (minor.contains("RC") || minor.contains("Beta") || minor.contains("beta"));
    }

    @NotNull
    public static ApplicationInfoEx getShadowInstance() {
        if (ourShadowInstance == null) {
            ourShadowInstance = new ApplicationInfoImpl();
        }
        ApplicationInfoImpl applicationInfoImpl = ourShadowInstance;
        if (applicationInfoImpl == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(0);
        }
        return applicationInfoImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadState(Element parentNode) {
        Element subscriptionsElement;
        String url;
        Element licensingElement;
        String url2;
        Element evaluationElement;
        Element tvElement;
        Element keymapElement;
        Element pluginsElement;
        Element whatsnewElement;
        Element feedbackElement;
        Element supportElement;
        Element helpElement;
        Element editor;
        Element wizardSteps;
        Element welcomeScreen;
        Element showLicensee;
        Element packageElement;
        Element iconElement;
        Element aboutLogoElement;
        Element buildElement;
        Element companyElement;
        Element versionElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_VERSION);
        if (versionElement != null) {
            this.myMajorVersion = versionElement.getAttributeValue(ATTRIBUTE_MAJOR);
            this.myMinorVersion = versionElement.getAttributeValue(ATTRIBUTE_MINOR);
            this.myMicroVersion = versionElement.getAttributeValue(ATTRIBUTE_MICRO);
            this.myPatchVersion = versionElement.getAttributeValue(ATTRIBUTE_PATCH);
            this.myFullVersionFormat = versionElement.getAttributeValue(ATTRIBUTE_FULL);
            this.myCodeName = versionElement.getAttributeValue(ATTRIBUTE_CODENAME);
            this.myEAP = Boolean.parseBoolean(versionElement.getAttributeValue(ATTRIBUTE_EAP));
        }
        if ((companyElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_COMPANY)) != null) {
            this.myCompanyName = companyElement.getAttributeValue(ATTRIBUTE_NAME, this.myCompanyName);
            this.myShortCompanyName = companyElement.getAttributeValue("shortName", ApplicationInfoImpl.shortenCompanyName(this.myCompanyName));
            this.myCompanyUrl = companyElement.getAttributeValue(ATTRIBUTE_URL, this.myCompanyUrl);
            this.myCopyrightStart = companyElement.getAttributeValue(COPYRIGHT_START, this.myCopyrightStart);
        }
        if ((buildElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_BUILD)) != null) {
            String majorReleaseDateString;
            this.myBuildNumber = buildElement.getAttributeValue(ATTRIBUTE_NUMBER);
            this.myApiVersion = buildElement.getAttributeValue(ATTRIBUTE_API_VERSION);
            ApplicationInfoImpl.setBuildNumber(this.myApiVersion, this.myBuildNumber);
            String dateString = buildElement.getAttributeValue(ATTRIBUTE_DATE);
            if (dateString.equals("__BUILD_DATE__")) {
                this.myBuildDate = new GregorianCalendar();
                try (JarFile bootstrapJar2 = new JarFile(PathManager.getHomePath() + File.separator + "lib" + File.separator + "bootstrap.jar");){
                    JarEntry jarEntry = bootstrapJar2.entries().nextElement();
                    this.myBuildDate.setTime(new Date(jarEntry.getTime()));
                }
                catch (Exception bootstrapJar2) {}
            } else {
                this.myBuildDate = ApplicationInfoImpl.parseDate(dateString);
            }
            if ((majorReleaseDateString = buildElement.getAttributeValue(ATTRIBUTE_MAJOR_RELEASE_DATE)) != null) {
                this.myMajorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
            }
        }
        Thread currentThread = Thread.currentThread();
        currentThread.setName(currentThread.getName() + " " + this.myMajorVersion + "." + this.myMinorVersion + "#" + this.myBuildNumber + " " + ApplicationNamesInfo.getInstance().getProductName() + ", eap:" + this.myEAP + ", os:" + SystemInfoRt.OS_NAME + " " + SystemInfoRt.OS_VERSION + ", java-version:" + SystemInfo.JAVA_VENDOR + " " + SystemInfo.JAVA_RUNTIME_VERSION);
        Element logoElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_LOGO);
        if (logoElement != null) {
            this.mySplashImageUrl = logoElement.getAttributeValue(ATTRIBUTE_URL);
            this.mySplashTextColor = ApplicationInfoImpl.parseColor(logoElement.getAttributeValue(ATTRIBUTE_TEXT_COLOR));
            String v = logoElement.getAttributeValue(ATTRIBUTE_PROGRESS_COLOR);
            if (v != null) {
                this.myProgressColor = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = logoElement.getAttributeValue(ATTRIBUTE_PROGRESS_TAIL_ICON)) != null) {
                this.myProgressTailIconName = v;
            }
            if ((v = logoElement.getAttributeValue(ATTRIBUTE_PROGRESS_HEIGHT)) != null) {
                this.myProgressHeight = Integer.parseInt(v);
            }
            if ((v = logoElement.getAttributeValue(ATTRIBUTE_PROGRESS_X)) != null) {
                this.myProgressX = Integer.parseInt(v);
            }
            if ((v = logoElement.getAttributeValue(ATTRIBUTE_PROGRESS_Y)) != null) {
                this.myProgressY = Integer.parseInt(v);
            }
            if ((v = logoElement.getAttributeValue(ATTRIBUTE_LICENSE_TEXT_OFFSET_Y)) != null) {
                this.myLicenseOffsetY = Integer.parseInt(v);
            }
        }
        if ((aboutLogoElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_ABOUT)) != null) {
            String c;
            this.myAboutImageUrl = aboutLogoElement.getAttributeValue(ATTRIBUTE_URL);
            String v = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_FOREGROUND_COLOR);
            if (v != null) {
                this.myAboutForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_COPYRIGHT_FOREGROUND_COLOR)) != null) {
                this.myCopyrightForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((c = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_LINK_COLOR)) != null) {
                this.myAboutLinkColor = ApplicationInfoImpl.parseColor(c);
            }
            String logoX = aboutLogoElement.getAttributeValue("logoX");
            String logoY = aboutLogoElement.getAttributeValue("logoY");
            String logoW = aboutLogoElement.getAttributeValue("logoW");
            String logoH = aboutLogoElement.getAttributeValue("logoH");
            if (logoX != null && logoY != null && logoW != null && logoH != null) {
                try {
                    this.myAboutLogoRect = new Rectangle(Integer.parseInt(logoX), Integer.parseInt(logoY), Integer.parseInt(logoW), Integer.parseInt(logoH));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((iconElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_ICON)) != null) {
            this.myIconUrl = iconElement.getAttributeValue(ATTRIBUTE_SIZE32);
            this.mySmallIconUrl = iconElement.getAttributeValue(ATTRIBUTE_SIZE16);
            this.myBigIconUrl = iconElement.getAttributeValue(ATTRIBUTE_SIZE128, (String)null);
            String toolWindowIcon = iconElement.getAttributeValue(ATTRIBUTE_SIZE12);
            if (toolWindowIcon != null) {
                this.myToolWindowIconUrl = toolWindowIcon;
            }
        }
        if ((packageElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_PACKAGE)) != null) {
            this.myPackageCode = packageElement.getAttributeValue(ATTRIBUTE_CODE);
        }
        if ((showLicensee = ApplicationInfoImpl.getChild(parentNode, ELEMENT_LICENSEE)) != null) {
            this.myShowLicensee = Boolean.valueOf(showLicensee.getAttributeValue(ATTRIBUTE_SHOW));
        }
        if ((welcomeScreen = ApplicationInfoImpl.getChild(parentNode, WELCOME_SCREEN_ELEMENT_NAME)) != null) {
            this.myWelcomeScreenLogoUrl = welcomeScreen.getAttributeValue(LOGO_URL_ATTR);
        }
        if ((wizardSteps = ApplicationInfoImpl.getChild(parentNode, CUSTOMIZE_IDE_WIZARD_STEPS)) != null) {
            this.myCustomizeIDEWizardStepsProvider = wizardSteps.getAttributeValue(STEPS_PROVIDER);
        }
        if ((editor = ApplicationInfoImpl.getChild(parentNode, ELEMENT_EDITOR)) != null) {
            this.myEditorBackgroundImageUrl = editor.getAttributeValue(BACKGROUND_URL_ATTR);
        }
        if ((helpElement = ApplicationInfoImpl.getChild(parentNode, HELP_ELEMENT_NAME)) != null) {
            String attValue;
            this.myHelpFileName = helpElement.getAttributeValue(ATTRIBUTE_HELP_FILE);
            this.myHelpRootName = helpElement.getAttributeValue(ATTRIBUTE_HELP_ROOT);
            String webHelpUrl = helpElement.getAttributeValue(ATTRIBUTE_WEBHELP_URL);
            if (webHelpUrl != null) {
                this.myWebHelpUrl = webHelpUrl;
            }
            this.myHasHelp = (attValue = helpElement.getAttributeValue(ATTRIBUTE_HAS_HELP)) == null || Boolean.parseBoolean(attValue);
            attValue = helpElement.getAttributeValue(ATTRIBUTE_HAS_CONTEXT_HELP);
            this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
        }
        Element updateUrls = ApplicationInfoImpl.getChild(parentNode, UPDATE_URLS_ELEMENT_NAME);
        this.myUpdateUrls = new UpdateUrlsImpl(updateUrls);
        Element documentationElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_DOCUMENTATION);
        if (documentationElement != null) {
            this.myDocumentationUrl = documentationElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((supportElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_SUPPORT)) != null) {
            this.mySupportUrl = supportElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((feedbackElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_FEEDBACK)) != null) {
            this.myEAPFeedbackUrl = feedbackElement.getAttributeValue(ATTRIBUTE_EAP_URL);
            this.myReleaseFeedbackUrl = feedbackElement.getAttributeValue(ATTRIBUTE_RELEASE_URL);
        }
        if ((whatsnewElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_WHATSNEW)) != null) {
            this.myWhatsNewUrl = whatsnewElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((pluginsElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_PLUGINS)) != null) {
            String url3 = pluginsElement.getAttributeValue(ATTRIBUTE_URL);
            this.myPluginManagerUrl = url3 != null ? url3 : DEFAULT_PLUGINS_HOST;
            boolean closed = StringUtil.endsWith((CharSequence)this.myPluginManagerUrl, (CharSequence)"/");
            String listUrl = pluginsElement.getAttributeValue(ATTRIBUTE_LIST_URL);
            this.myPluginsListUrl = listUrl != null ? listUrl : this.myPluginManagerUrl + (closed ? "" : "/") + "plugins/list/";
            String channelListUrl = pluginsElement.getAttributeValue(ATTRIBUTE_CHANNEL_LIST_URL);
            this.myChannelsListUrl = channelListUrl != null ? channelListUrl : this.myPluginManagerUrl + (closed ? "" : "/") + "channels/list/";
            String downloadUrl = pluginsElement.getAttributeValue(ATTRIBUTE_DOWNLOAD_URL);
            String string = downloadUrl != null ? downloadUrl : (this.myPluginsDownloadUrl = this.myPluginManagerUrl + (closed ? "" : "/") + "pluginManager/");
            if (!this.getBuild().isSnapshot()) {
                this.myBuiltinPluginsUrl = StringUtil.nullize((String)pluginsElement.getAttributeValue(ATTRIBUTE_BUILTIN_URL));
            }
        } else {
            this.myPluginManagerUrl = DEFAULT_PLUGINS_HOST;
            this.myPluginsListUrl = "http://plugins.jetbrains.com/plugins/list/";
            this.myChannelsListUrl = "http://plugins.jetbrains.com/channels/list/";
            this.myPluginsDownloadUrl = "http://plugins.jetbrains.com/pluginManager/";
        }
        String pluginsHost = System.getProperty("idea.plugins.host");
        if (pluginsHost != null) {
            this.myPluginsListUrl = this.myPluginsListUrl.replace(DEFAULT_PLUGINS_HOST, pluginsHost);
            this.myChannelsListUrl = this.myChannelsListUrl.replace(DEFAULT_PLUGINS_HOST, pluginsHost);
            this.myPluginsDownloadUrl = this.myPluginsDownloadUrl.replace(DEFAULT_PLUGINS_HOST, pluginsHost);
        }
        if ((keymapElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_KEYMAP)) != null) {
            this.myWinKeymapUrl = keymapElement.getAttributeValue(ATTRIBUTE_WINDOWS_URL);
            this.myMacKeymapUrl = keymapElement.getAttributeValue(ATTRIBUTE_MAC_URL);
        }
        this.myPluginChooserPages = new ArrayList<ApplicationInfoEx.PluginChooserPage>();
        for (Element child : ApplicationInfoImpl.getChildren(parentNode, PLUGINS_PAGE_ELEMENT_NAME)) {
            this.myPluginChooserPages.add(new PluginChooserPageImpl(child));
        }
        List<Element> essentialPluginsElements = ApplicationInfoImpl.getChildren(parentNode, ESSENTIAL_PLUGIN);
        List essentialPluginsIds = ContainerUtil.mapNotNull(essentialPluginsElements, element -> {
            String id = element.getTextTrim();
            return StringUtil.isNotEmpty((String)id) ? id : null;
        });
        this.myEssentialPluginsIds = ArrayUtil.toStringArray((Collection)essentialPluginsIds);
        Element statisticsElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_STATISTICS);
        if (statisticsElement != null) {
            this.myStatisticsSettingsUrl = statisticsElement.getAttributeValue(ATTRIBUTE_STATISTICS_SETTINGS);
            this.myFUStatisticsSettingsUrl = statisticsElement.getAttributeValue(ATTRIBUTE_FU_STATISTICS_SETTINGS);
            this.myStatisticsServiceUrl = statisticsElement.getAttributeValue(ATTRIBUTE_STATISTICS_SERVICE);
            this.myStatisticsServiceKey = statisticsElement.getAttributeValue(ATTRIBUTE_STATISTICS_SERVICE_KEY);
        } else {
            this.myStatisticsSettingsUrl = "https://www.jetbrains.com/idea/statistics/stat-assistant.xml";
            this.myFUStatisticsSettingsUrl = "https://www.jetbrains.com/idea/statistics/fus-assistant.xml";
            this.myStatisticsServiceUrl = "https://www.jetbrains.com/idea/statistics/index.jsp";
            this.myStatisticsServiceKey = null;
        }
        Element thirdPartyElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_THIRD_PARTY);
        if (thirdPartyElement != null) {
            this.myThirdPartySoftwareUrl = thirdPartyElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((tvElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_JB_TV)) != null) {
            this.myJetbrainsTvUrl = tvElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((evaluationElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_EVALUATION)) != null && (url2 = evaluationElement.getAttributeValue(ATTRIBUTE_EVAL_LICENSE_URL)) != null && !url2.isEmpty()) {
            this.myEvalLicenseUrl = url2.trim();
        }
        if ((licensingElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_LICENSING)) != null && (url = licensingElement.getAttributeValue(ATTRIBUTE_KEY_CONVERSION_URL)) != null && !url.isEmpty()) {
            this.myKeyConversionUrl = url.trim();
        }
        if ((subscriptionsElement = ApplicationInfoImpl.getChild(parentNode, ELEMENT_SUBSCRIPTIONS)) != null) {
            this.mySubscriptionFormId = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_FORM_ID);
            this.mySubscriptionNewsKey = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_NEWS_KEY);
            this.mySubscriptionNewsValue = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_NEWS_VALUE, "yes");
            this.mySubscriptionTipsKey = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_TIPS_KEY);
            this.mySubscriptionTipsAvailable = Boolean.parseBoolean(subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_TIPS_AVAILABLE));
            this.mySubscriptionAdditionalFormData = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_ADDITIONAL_FORM_DATA);
        }
    }

    @NotNull
    private static List<Element> getChildren(Element parentNode, String name) {
        List list2 = parentNode.getChildren(name, parentNode.getNamespace());
        if (list2 == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(1);
        }
        return list2;
    }

    private static Element getChild(Element parentNode, String version) {
        return parentNode.getChild(version, parentNode.getNamespace());
    }

    @VisibleForTesting
    static String shortenCompanyName(String name) {
        return StringUtil.trimEnd((String)StringUtil.trimEnd((String)name, (String)" s.r.o."), (String)" Inc.");
    }

    private static void setBuildNumber(String apiVersion, String buildNumber) {
        PluginManagerCore.BUILD_NUMBER = apiVersion != null ? apiVersion : buildNumber;
    }

    private static GregorianCalendar parseDate(String dateString) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        try {
            calendar.set(1, Integer.parseInt(dateString.substring(0, 4)));
            calendar.set(2, Integer.parseInt(dateString.substring(4, 6)) - 1);
            calendar.set(5, Integer.parseInt(dateString.substring(6, 8)));
            if (dateString.length() > 8) {
                calendar.set(11, Integer.parseInt(dateString.substring(8, 10)));
                calendar.set(12, Integer.parseInt(dateString.substring(10, 12)));
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return calendar;
    }

    private static Color parseColor(String colorString) {
        long rgb = Long.parseLong(colorString, 16);
        return new Color((int)rgb, rgb > 0xFFFFFFL);
    }

    @Override
    public List<ApplicationInfoEx.PluginChooserPage> getPluginChooserPages() {
        return this.myPluginChooserPages;
    }

    @Override
    public boolean isEssentialPlugin(@NotNull String pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(2);
        }
        return "com.intellij".equals(pluginId) || ArrayUtil.contains((String)pluginId, (String[])this.myEssentialPluginsIds);
    }

    public List<String> getEssentialPluginsIds() {
        return Collections.unmodifiableList(Arrays.asList(this.myEssentialPluginsIds));
    }

    public static boolean isInStressTest() {
        return myInStressTest;
    }

    public static void setInStressTest(boolean inStressTest) {
        myInStressTest = inStressTest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadowInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEssentialPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PluginChooserPageImpl
    implements ApplicationInfoEx.PluginChooserPage {
        private final String myTitle;
        private final String myCategory;
        private final String myDependentPlugin;

        private PluginChooserPageImpl(Element e) {
            this.myTitle = e.getAttributeValue("title");
            this.myCategory = e.getAttributeValue("category");
            this.myDependentPlugin = e.getAttributeValue("depends");
        }

        @Override
        @NotNull
        public String getTitle() {
            String string = this.myTitle;
            if (string == null) {
                PluginChooserPageImpl.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public String getCategory() {
            return this.myCategory;
        }

        @Override
        public String getDependentPlugin() {
            return this.myDependentPlugin;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/impl/ApplicationInfoImpl$PluginChooserPageImpl", "getTitle"));
        }
    }

    private static class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private String myCheckingUrl;
        private String myPatchesUrl;

        private UpdateUrlsImpl(Element element) {
            if (element != null) {
                this.myCheckingUrl = element.getAttributeValue("check");
                this.myPatchesUrl = element.getAttributeValue("patches");
            }
        }

        @Override
        public String getCheckingUrl() {
            return this.myCheckingUrl;
        }

        @Override
        public String getPatchesUrl() {
            return this.myPatchesUrl;
        }
    }
}

