/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.keymap.impl.ui.Hyperlink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.Gray;
import com.intellij.ui.HeldDownKeyListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionsTree {
    private static final Logger LOG = Logger.getInstance(ActionsTree.class);
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    private static final Icon CLOSE_ICON = AllIcons.Nodes.Folder;
    private final JTree myTree;
    private DefaultMutableTreeNode myRoot;
    private final JScrollPane myComponent;
    private Keymap myKeymap;
    private Group myMainGroup = new Group("", null, null);
    private final boolean myShowBoundActions = Registry.is((String)"keymap.show.alias.actions");
    @NonNls
    private static final String ROOT = "ROOT";
    private String myFilter = null;
    private boolean myPaintInternalInfo;
    private final Map<String, String> myPluginNames = ActionsTreeUtil.createPluginActionsMap();
    private static Method ourGetRowXMethod = null;

    public ActionsTree() {
        this.myRoot = new DefaultMutableTreeNode(ROOT);
        this.myTree = new Tree(new MyModel(this.myRoot)){

            public void paint(Graphics g) {
                super.paint(g);
                Rectangle visibleRect = this.getVisibleRect();
                Insets insets = this.getInsets();
                if (insets != null && insets.right > 0) {
                    visibleRect.width -= JBUI.scale((int)9);
                }
                Rectangle clip = g.getClipBounds();
                for (int row = 0; row < this.getRowCount(); ++row) {
                    Object data;
                    Object node;
                    Rectangle rowBounds = this.getRowBounds(row);
                    rowBounds.x = 0;
                    rowBounds.width = Integer.MAX_VALUE;
                    if (!rowBounds.intersects(clip) || !((node = this.getPathForRow(row).getLastPathComponent()) instanceof DefaultMutableTreeNode) || (data = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Hyperlink) continue;
                    Rectangle fullRowRect = new Rectangle(visibleRect.x, rowBounds.y, visibleRect.width, rowBounds.height);
                    ActionsTree.this.paintRowData(this, data, fullRowRect, (Graphics2D)g);
                }
            }

            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof DefaultMutableTreeNode) {
                    String path = ActionsTree.this.getPath((DefaultMutableTreeNode)value);
                    return StringUtil.notNullize((String)path);
                }
                return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            }
        };
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.putClientProperty("mac.ui.striped", Boolean.TRUE);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new KeymapsRenderer()));
        new TreeLinkMouseListener(new KeymapsRenderer()){

            @Override
            protected boolean doCacheLastNode() {
                return false;
            }

            protected void handleTagClick(@Nullable Object tag, @NotNull MouseEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (tag instanceof Hyperlink) {
                    ((Hyperlink)tag).onClick(event);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/keymap/impl/ui/ActionsTree$2", "handleTagClick"));
            }
        }.installOn(this.myTree);
        this.myTree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                String description = this.getDescription(e);
                ActionMenu.showDescriptionInStatusBar(description != null, ActionsTree.this.myTree, description);
            }

            @Nullable
            private String getDescription(@NotNull MouseEvent e) {
                Object userObject;
                TreePath path;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                DefaultMutableTreeNode node = (path = ActionsTree.this.myTree.getPathForLocation(e.getX(), e.getY())) == null ? null : (DefaultMutableTreeNode)path.getLastPathComponent();
                Object object = userObject = node == null ? null : node.getUserObject();
                if (!(userObject instanceof String)) {
                    return null;
                }
                AnAction action = ActionManager.getInstance().getActionOrStub((String)userObject);
                return action == null ? null : action.getTemplatePresentation().getDescription();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/ActionsTree$3", "getDescription"));
            }
        });
        this.myTree.getSelectionModel().setSelectionMode(1);
        if (Registry.is((String)"show.configurables.ids.in.settings")) {
            new HeldDownKeyListener(){

                protected void heldKeyTriggered(JComponent component, boolean pressed) {
                    ActionsTree.this.myPaintInternalInfo = pressed;
                    ((Tree)component).setCellRenderer((TreeCellRenderer)((Object)new KeymapsRenderer()));
                }
            }.installOn((JComponent)this.myTree);
        }
        this.myComponent = ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)22, (int)31);
    }

    void setKeymap(@NotNull Keymap keymap) {
        if (keymap == null) {
            ActionsTree.$$$reportNull$$$0(0);
        }
        this.myKeymap = keymap;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        this.myTree.getSelectionModel().addTreeSelectionListener(l);
    }

    @Nullable
    private Object getSelectedObject() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        return ((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
    }

    @Nullable
    public String getSelectedActionId() {
        Object userObject = this.getSelectedObject();
        if (userObject instanceof String) {
            return (String)userObject;
        }
        if (userObject instanceof QuickList) {
            return ((QuickList)userObject).getActionId();
        }
        if (userObject instanceof Group) {
            return ((Group)userObject).getId();
        }
        return null;
    }

    public void reset(@NotNull Keymap keymap, @NotNull QuickList[] allQuickLists) {
        if (keymap == null) {
            ActionsTree.$$$reportNull$$$0(1);
        }
        if (allQuickLists == null) {
            ActionsTree.$$$reportNull$$$0(2);
        }
        this.reset(keymap, allQuickLists, this.myFilter, null);
    }

    public Group getMainGroup() {
        return this.myMainGroup;
    }

    public JTree getTree() {
        return this.myTree;
    }

    public void filter(String filter2, QuickList[] currentQuickListIds) {
        this.myFilter = filter2;
        this.reset(this.myKeymap, currentQuickListIds, filter2, null);
    }

    private void reset(@NotNull Keymap keymap, @NotNull QuickList[] allQuickLists, String filter2, @Nullable Shortcut shortcut) {
        if (keymap == null) {
            ActionsTree.$$$reportNull$$$0(3);
        }
        if (allQuickLists == null) {
            ActionsTree.$$$reportNull$$$0(4);
        }
        this.myKeymap = keymap;
        PathsKeeper pathsKeeper = new PathsKeeper();
        pathsKeeper.storePaths();
        this.myRoot.removeAllChildren();
        ActionManager actionManager = ActionManager.getInstance();
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myComponent));
        Group mainGroup = ActionsTreeUtil.createMainGroup(project, keymap, allQuickLists, filter2, true, ActionsTreeUtil.isActionFiltered(actionManager, keymap, shortcut, filter2, true));
        if ((filter2 != null && filter2.length() > 0 || shortcut != null) && mainGroup.initIds().isEmpty()) {
            mainGroup = ActionsTreeUtil.createMainGroup(project, keymap, allQuickLists, filter2, false, ActionsTreeUtil.isActionFiltered(actionManager, keymap, shortcut, filter2, false));
        }
        this.myRoot = ActionsTreeUtil.createNode(mainGroup);
        this.myMainGroup = mainGroup;
        MyModel model = (MyModel)this.myTree.getModel();
        model.setRoot(this.myRoot);
        model.nodeStructureChanged(this.myRoot);
        pathsKeeper.restorePaths();
        this.getComponent().repaint();
    }

    public void filterTree(Shortcut shortcut, QuickList[] currentQuickListIds) {
        this.reset(this.myKeymap, currentQuickListIds, this.myFilter, shortcut);
    }

    private static boolean isActionChanged(String actionId, Keymap oldKeymap, Keymap newKeymap) {
        Object[] newShortcuts;
        if (!newKeymap.canModify()) {
            return false;
        }
        Object[] oldShortcuts = oldKeymap.getShortcuts(actionId);
        return !Comparing.equal((Object[])oldShortcuts, (Object[])(newShortcuts = newKeymap.getShortcuts(actionId)));
    }

    private static boolean isGroupChanged(Group group, Keymap oldKeymap, Keymap newKeymap) {
        if (!newKeymap.canModify()) {
            return false;
        }
        ArrayList<Object> children2 = group.getChildren();
        for (Object child : children2) {
            String actionId;
            if (!(child instanceof Group ? ActionsTree.isGroupChanged((Group)child, oldKeymap, newKeymap) : (child instanceof String ? ActionsTree.isActionChanged(actionId = (String)child, oldKeymap, newKeymap) : child instanceof QuickList && ActionsTree.isActionChanged(actionId = ((QuickList)child).getActionId(), oldKeymap, newKeymap)))) continue;
            return true;
        }
        return ActionsTree.isActionChanged(group.getId(), oldKeymap, newKeymap);
    }

    public void selectAction(String actionId) {
        String boundId;
        String path = this.myMainGroup.getActionQualifiedPath(actionId);
        String string = boundId = path == null ? KeymapManagerEx.getInstanceEx().getActionBinding(actionId) : null;
        if (path == null && boundId != null && (path = this.myMainGroup.getActionQualifiedPath(boundId)) == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getNodeForPath(path);
        if (node == null) {
            return;
        }
        TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)true, (JTree)this.myTree);
    }

    @Nullable
    private DefaultMutableTreeNode getNodeForPath(String path) {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.myTree.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!Comparing.equal((String)this.getPath(node), (String)path)) continue;
            return node;
        }
        return null;
    }

    private List<DefaultMutableTreeNode> getNodesByPaths(List<String> paths) {
        SmartList result2 = new SmartList();
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.myTree.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            String path = this.getPath(node);
            if (!paths.contains(path)) continue;
            result2.add(node);
        }
        return result2;
    }

    @Nullable
    private String getPath(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof String) {
            Object object;
            String actionId = (String)userObject;
            TreeNode parent = node.getParent();
            if (parent instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)parent).getUserObject()) instanceof Group) {
                return ((Group)object).getActionQualifiedPath(actionId);
            }
            return this.myMainGroup.getActionQualifiedPath(actionId);
        }
        if (userObject instanceof Group) {
            return ((Group)userObject).getQualifiedPath();
        }
        if (userObject instanceof QuickList) {
            return ((QuickList)userObject).getName();
        }
        return null;
    }

    public static Icon getEvenIcon(Icon icon) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        if (icon != null && icon.getIconHeight() <= EMPTY_ICON.getIconHeight() && icon.getIconWidth() <= EMPTY_ICON.getIconWidth()) {
            layeredIcon.setIcon(icon, 1, (-icon.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon.getIconHeight()) / 2);
        }
        return layeredIcon;
    }

    @NotNull
    private Pair<Shortcut[], Set<String>> extractRowData(Object data) {
        if (data instanceof String) {
            String actionId = (String)data;
            Pair pair = Pair.create((Object)this.myKeymap.getShortcuts(actionId), (Object)AbbreviationManager.getInstance().getAbbreviations(actionId));
            if (pair == null) {
                ActionsTree.$$$reportNull$$$0(5);
            }
            return pair;
        }
        Shortcut[] shortcuts = null;
        if (data instanceof QuickList) {
            shortcuts = this.myKeymap.getShortcuts(((QuickList)data).getActionId());
        } else if (data instanceof Group) {
            shortcuts = this.myKeymap.getShortcuts(((Group)data).getId());
        }
        Pair pair = Pair.create(shortcuts, null);
        if (pair == null) {
            ActionsTree.$$$reportNull$$$0(6);
        }
        return pair;
    }

    private void paintRowData(Tree tree, Object data, Rectangle bounds, Graphics2D g) {
        Color c2;
        Color c1;
        int fontHeight;
        Pair<Shortcut[], Set<String>> rowData = this.extractRowData(data);
        Shortcut[] shortcuts = (Shortcut[])rowData.first;
        Set abbreviations = (Set)rowData.second;
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        int totalWidth = 0;
        FontMetrics metrics = tree.getFontMetrics(tree.getFont());
        if (shortcuts != null && shortcuts.length > 0) {
            for (Shortcut shortcut : shortcuts) {
                totalWidth += metrics.stringWidth(KeymapUtil.getShortcutText((Shortcut)shortcut));
                totalWidth += 10;
            }
            int x = bounds.x + bounds.width - (totalWidth -= 5);
            fontHeight = (int)metrics.getMaxCharBounds(g).getHeight();
            c1 = new Color(234, 200, 162);
            c2 = new Color(208, 200, 66);
            g.translate(0, bounds.y - 1);
            for (Shortcut shortcut : shortcuts) {
                int width = metrics.stringWidth(KeymapUtil.getShortcutText((Shortcut)shortcut));
                UIUtil.drawSearchMatch((Graphics2D)g, (float)x, (float)(x + width), (int)bounds.height, (Color)c1, (Color)c2);
                g.setColor((Color)Gray._50);
                g.drawString(KeymapUtil.getShortcutText((Shortcut)shortcut), x, fontHeight);
                x += width;
                x += 10;
            }
            g.translate(0, -bounds.y + 1);
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations") && abbreviations != null && abbreviations.size() > 0) {
            for (String abbreviation : abbreviations) {
                totalWidth += metrics.stringWidth(abbreviation);
                totalWidth += 10;
            }
            int x = bounds.x + bounds.width - (totalWidth -= 5);
            fontHeight = (int)metrics.getMaxCharBounds(g).getHeight();
            c1 = new Color(206, 234, 176);
            c2 = new Color(126, 208, 82);
            g.translate(0, bounds.y - 1);
            for (String abbreviation : abbreviations) {
                int width = metrics.stringWidth(abbreviation);
                UIUtil.drawSearchMatch((Graphics2D)g, (float)x, (float)(x + width), (int)bounds.height, (Color)c1, (Color)c2);
                g.setColor((Color)Gray._50);
                g.drawString(abbreviation, x, fontHeight);
                x += width;
                x += 10;
            }
            g.translate(0, -bounds.y + 1);
        }
        config.restore();
    }

    private static int getRowX(BasicTreeUI ui, int row, int depth) {
        if (ourGetRowXMethod == null) {
            try {
                ourGetRowXMethod = BasicTreeUI.class.getDeclaredMethod("getRowX", Integer.TYPE, Integer.TYPE);
                ourGetRowXMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                LOG.error((Throwable)e);
            }
        }
        if (ourGetRowXMethod != null) {
            try {
                return (Integer)ourGetRowXMethod.invoke((Object)ui, row, depth);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allQuickLists";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/ActionsTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/ActionsTree";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRowData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setKeymap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyColoredTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private int myHeight;

        private MyColoredTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyColoredTreeCellRenderer.$$$reportNull$$$0(0);
            }
        }

        protected void doPaint(Graphics2D g) {
            super.doPaint(g);
        }

        public void setHeight(int height) {
            this.myHeight = height;
        }

        public int getHeight() {
            return this.myHeight;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/keymap/impl/ui/ActionsTree$MyColoredTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private class KeymapsRenderer
    extends ColoredTreeCellRenderer {
        private final MyColoredTreeCellRenderer myLink = new MyColoredTreeCellRenderer();
        private boolean myHaveLink;
        private int myLinkOffset;
        private int myLinkWidth;
        private int myRow;

        private KeymapsRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                KeymapsRenderer.$$$reportNull$$$0(0);
            }
            this.myRow = row;
            this.myHaveLink = false;
            this.myLink.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            boolean showIcons = UISettings.getInstance().getShowIconsInMenus();
            Keymap originalKeymap = ActionsTree.this.myKeymap == null ? null : ActionsTree.this.myKeymap.getParent();
            Icon icon = null;
            String actionId = null;
            boolean bound = false;
            this.setToolTipText(null);
            if (value instanceof DefaultMutableTreeNode) {
                Color foreground;
                boolean changed;
                String text;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object userObject = node.getUserObject();
                if (userObject instanceof Group) {
                    Group group = (Group)userObject;
                    actionId = group.getId();
                    text = group.getName();
                    changed = originalKeymap != null && ActionsTree.isGroupChanged(group, originalKeymap, ActionsTree.this.myKeymap);
                    icon = group.getIcon();
                    if (icon == null) {
                        icon = CLOSE_ICON;
                    }
                } else if (userObject instanceof String) {
                    actionId = (String)userObject;
                    bound = ActionsTree.this.myShowBoundActions && ((KeymapImpl)ActionsTree.this.myKeymap).isActionBound(actionId);
                    AnAction action = ActionManager.getInstance().getAction(actionId);
                    if (action != null) {
                        Icon actionIcon;
                        text = action.getTemplatePresentation().getText();
                        if (text == null || text.length() == 0) {
                            text = actionId;
                        }
                        if ((actionIcon = action.getTemplatePresentation().getIcon()) != null) {
                            icon = actionIcon;
                        }
                        this.setToolTipText(action.getTemplatePresentation().getDescription());
                    } else {
                        text = actionId;
                    }
                    changed = originalKeymap != null && ActionsTree.isActionChanged(actionId, originalKeymap, ActionsTree.this.myKeymap);
                } else if (userObject instanceof QuickList) {
                    QuickList list2 = (QuickList)userObject;
                    icon = AllIcons.Actions.QuickList;
                    text = list2.getName();
                    changed = originalKeymap != null && ActionsTree.isActionChanged(list2.getActionId(), originalKeymap, ActionsTree.this.myKeymap);
                } else if (userObject instanceof Separator) {
                    changed = false;
                    text = "-------------";
                } else if (userObject instanceof Hyperlink) {
                    this.getIpad().right = 0;
                    this.myLink.getIpad().left = 0;
                    this.myHaveLink = true;
                    Hyperlink link = (Hyperlink)userObject;
                    changed = false;
                    text = "";
                    this.append(link.getLinkText(), link.getTextAttributes(), link);
                    icon = link.getIcon();
                    this.setIcon(ActionsTree.getEvenIcon(link.getIcon()));
                    Rectangle treeVisibleRect = tree.getVisibleRect();
                    TreePath path = tree.getPathForRow(row);
                    int rowX = path != null ? ActionsTree.getRowX((BasicTreeUI)tree.getUI(), row, path.getPathCount() - 1) : 0;
                    this.setupLinkDimensions(treeVisibleRect, rowX);
                } else {
                    throw new IllegalArgumentException("unknown userObject: " + userObject);
                }
                if (showIcons) {
                    this.setIcon(ActionsTree.getEvenIcon(icon));
                }
                if (selected) {
                    foreground = UIUtil.getTreeForeground((boolean)true, (boolean)hasFocus);
                } else {
                    foreground = changed ? PlatformColors.BLUE : UIUtil.getTreeForeground();
                    if (bound) {
                        foreground = JBColor.MAGENTA;
                    }
                }
                if (!this.myHaveLink) {
                    Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                    SearchUtil.appendFragments(ActionsTree.this.myFilter, text, 0, foreground, background, (SimpleColoredComponent)this);
                    if (actionId != null && ActionsTree.this.myPaintInternalInfo) {
                        Group parentGroup;
                        String pluginName = (String)ActionsTree.this.myPluginNames.get(actionId);
                        if (pluginName != null && pluginName.equals((parentGroup = (Group)((DefaultMutableTreeNode)node.getParent()).getUserObject()).getName())) {
                            pluginName = null;
                        }
                        this.append("   ");
                        this.append(pluginName != null ? actionId + " (" + pluginName + ")" : actionId, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
                    }
                }
            }
            this.putClientProperty(ExpandableItemsHandler.RENDERER_DISABLED, this.myHaveLink);
        }

        private void setupLinkDimensions(Rectangle treeVisibleRect, int rowX) {
            Dimension linkSize = this.myLink.getPreferredSize();
            this.myLinkWidth = linkSize.width;
            this.myLinkOffset = Math.min(super.getPreferredSize().width - 1, treeVisibleRect.x + treeVisibleRect.width - this.myLinkWidth - rowX);
        }

        public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag) {
            if (fragment == null) {
                KeymapsRenderer.$$$reportNull$$$0(1);
            }
            if (attributes == null) {
                KeymapsRenderer.$$$reportNull$$$0(2);
            }
            if (tag instanceof Hyperlink) {
                this.myHaveLink = true;
                this.myLink.append(fragment, attributes, tag);
            } else {
                super.append(fragment, attributes, tag);
            }
        }

        protected void doPaint(Graphics2D g) {
            if (!this.myHaveLink) {
                super.doPaint(g);
            }
            Graphics2D textGraphics = (Graphics2D)g.create(0, 0, this.myLinkOffset, g.getClipBounds().height);
            try {
                super.doPaint(textGraphics);
            }
            finally {
                textGraphics.dispose();
            }
            g.translate(this.myLinkOffset, 0);
            this.myLink.setHeight(this.getHeight());
            this.myLink.doPaint(g);
            g.translate(-this.myLinkOffset, 0);
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (this.myHaveLink) {
                size.width += this.myLinkWidth;
            }
            Dimension dimension = size;
            if (dimension == null) {
                KeymapsRenderer.$$$reportNull$$$0(3);
            }
            return dimension;
        }

        @Nullable
        public Object getFragmentTagAt(int x) {
            if (this.myHaveLink) {
                return this.myLink.getFragmentTagAt(x - this.myLinkOffset);
            }
            return super.getFragmentTagAt(x);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleKeymapsRenderer();
            }
            return this.accessibleContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/ActionsTree$KeymapsRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/ActionsTree$KeymapsRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        protected class AccessibleKeymapsRenderer
        extends ColoredTreeCellRenderer.AccessibleColoredTreeCellRenderer {
            protected AccessibleKeymapsRenderer() {
                super((ColoredTreeCellRenderer)KeymapsRenderer.this);
            }

            public String getAccessibleName() {
                Object data;
                String name = super.getAccessibleName();
                String shortcutName = null;
                TreePath path = KeymapsRenderer.this.myTree.getPathForRow(KeymapsRenderer.this.myRow);
                if (path == null) {
                    return "unknown";
                }
                Object node = path.getLastPathComponent();
                if (node instanceof DefaultMutableTreeNode && !((data = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Hyperlink)) {
                    Pair rowData = ActionsTree.this.extractRowData(data);
                    Shortcut[] shortcuts = (Shortcut[])rowData.first;
                    if (shortcuts != null && shortcuts.length > 0) {
                        StringBuilder sb = new StringBuilder();
                        for (Shortcut shortcut : shortcuts) {
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append("shortcut: ");
                            sb.append(KeymapUtil.getShortcutText((Shortcut)shortcut));
                        }
                        if (sb.length() > 0) {
                            shortcutName = sb.toString();
                        }
                    }
                }
                return AccessibleContextUtil.combineAccessibleStrings((String)name, (String)", ", shortcutName);
            }
        }
    }

    private class PathsKeeper {
        private ArrayList<String> myPathsToExpand;
        private ArrayList<String> mySelectionPaths;

        private PathsKeeper() {
        }

        public void storePaths() {
            this.myPathsToExpand = new ArrayList();
            this.mySelectionPaths = new ArrayList();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)ActionsTree.this.myTree.getModel().getRoot();
            TreePath path = new TreePath(root.getPath());
            if (ActionsTree.this.myTree.isPathSelected(path)) {
                this.addPathToList(root, this.mySelectionPaths);
            }
            if (ActionsTree.this.myTree.isExpanded(path) || root.getChildCount() == 0) {
                this.addPathToList(root, this.myPathsToExpand);
                this._storePaths(root);
            }
        }

        private void addPathToList(DefaultMutableTreeNode root, ArrayList<String> list2) {
            String path = ActionsTree.this.getPath(root);
            if (!StringUtil.isEmpty((String)path)) {
                list2.add(path);
            }
        }

        private void _storePaths(DefaultMutableTreeNode root) {
            ArrayList<TreeNode> childNodes = this.childrenToArray(root);
            for (TreeNode childNode1 : childNodes) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)childNode1;
                TreePath path = new TreePath(childNode.getPath());
                if (ActionsTree.this.myTree.isPathSelected(path)) {
                    this.addPathToList(childNode, this.mySelectionPaths);
                }
                if (!ActionsTree.this.myTree.isExpanded(path) && childNode.getChildCount() != 0 || childNode.isLeaf()) continue;
                this.addPathToList(childNode, this.myPathsToExpand);
                this._storePaths(childNode);
            }
        }

        public void restorePaths() {
            for (DefaultMutableTreeNode node : ActionsTree.this.getNodesByPaths(this.myPathsToExpand)) {
                ActionsTree.this.myTree.expandPath(new TreePath(node.getPath()));
            }
            if (ActionsTree.this.myTree.getSelectionModel().getSelectionCount() == 0) {
                List nodesToSelect = ActionsTree.this.getNodesByPaths(this.mySelectionPaths);
                if (!nodesToSelect.isEmpty()) {
                    for (DefaultMutableTreeNode node : nodesToSelect) {
                        TreeUtil.selectNode((JTree)ActionsTree.this.myTree, (TreeNode)node);
                    }
                } else {
                    ActionsTree.this.myTree.setSelectionRow(0);
                }
            }
        }

        private ArrayList<TreeNode> childrenToArray(DefaultMutableTreeNode node) {
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            for (int i = 0; i < node.getChildCount(); ++i) {
                arrayList.add(node.getChildAt(i));
            }
            return arrayList;
        }
    }

    private class MyModel
    extends DefaultTreeModel
    implements TreeTableModel {
        protected MyModel(DefaultMutableTreeNode root) {
            super(root);
        }

        public void setTree(JTree tree) {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return KeyMapBundle.message((String)"action.column.name", (Object[])new Object[0]);
                }
                case 1: {
                    return KeyMapBundle.message((String)"shortcuts.column.name", (Object[])new Object[0]);
                }
            }
            return "";
        }

        public Object getValueAt(Object value, int column) {
            if (!(value instanceof DefaultMutableTreeNode)) {
                return "???";
            }
            if (column == 0) {
                return value;
            }
            if (column == 1) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject instanceof QuickList) {
                    userObject = ((QuickList)userObject).getActionId();
                }
                return userObject instanceof String ? KeymapUtil.getShortcutsText((Shortcut[])ActionsTree.this.myKeymap.getShortcuts((String)userObject)) : "";
            }
            return "???";
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((TreeNode)parent).getChildAt(index);
        }

        @Override
        public int getChildCount(Object parent) {
            return ((TreeNode)parent).getChildCount();
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return Object.class;
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0;
        }

        public void setValueAt(Object aValue, Object node, int column) {
        }
    }
}

