/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LibraryOrderEntryBaseImpl
extends OrderEntryBaseImpl
implements LibraryOrSdkOrderEntry {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl");
    final ProjectRootManagerImpl myProjectRootManagerImpl;
    @NotNull
    protected DependencyScope myScope;
    @Nullable
    private RootProvider myCurrentlySubscribedRootProvider;

    LibraryOrderEntryBaseImpl(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (rootModel == null) {
            LibraryOrderEntryBaseImpl.$$$reportNull$$$0(0);
        }
        if (projectRootManager == null) {
            LibraryOrderEntryBaseImpl.$$$reportNull$$$0(1);
        }
        super(rootModel);
        this.myScope = DependencyScope.COMPILE;
        this.myProjectRootManagerImpl = projectRootManager;
    }

    protected final void init() {
        this.updateFromRootProviderAndSubscribe();
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType type) {
        if (type == null) {
            LibraryOrderEntryBaseImpl.$$$reportNull$$$0(2);
        }
        VirtualFile[] virtualFileArray = this.getRootFiles(type);
        if (virtualFileArray == null) {
            LibraryOrderEntryBaseImpl.$$$reportNull$$$0(3);
        }
        return virtualFileArray;
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType type) {
        if (type == null) {
            LibraryOrderEntryBaseImpl.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!this.getRootModel().getModule().isDisposed());
        String[] stringArray = this.getRootUrls(type);
        if (stringArray == null) {
            LibraryOrderEntryBaseImpl.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getRootFiles(@NotNull OrderRootType type) {
        RootProvider rootProvider;
        if (type == null) {
            LibraryOrderEntryBaseImpl.$$$reportNull$$$0(6);
        }
        VirtualFile[] virtualFileArray = (rootProvider = this.getRootProvider()) == null ? VirtualFile.EMPTY_ARRAY : rootProvider.getFiles(type);
        if (virtualFileArray == null) {
            LibraryOrderEntryBaseImpl.$$$reportNull$$$0(7);
        }
        return virtualFileArray;
    }

    @Nullable
    protected abstract RootProvider getRootProvider();

    @NotNull
    public String[] getRootUrls(@NotNull OrderRootType type) {
        RootProvider rootProvider;
        if (type == null) {
            LibraryOrderEntryBaseImpl.$$$reportNull$$$0(8);
        }
        String[] stringArray = (rootProvider = this.getRootProvider()) == null ? ArrayUtil.EMPTY_STRING_ARRAY : rootProvider.getUrls(type);
        if (stringArray == null) {
            LibraryOrderEntryBaseImpl.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    @NotNull
    public final Module getOwnerModule() {
        Module module = this.getRootModel().getModule();
        if (module == null) {
            LibraryOrderEntryBaseImpl.$$$reportNull$$$0(10);
        }
        return module;
    }

    void updateFromRootProviderAndSubscribe() {
        this.getRootModel().makeExternalChange(() -> this.resubscribe(this.getRootProvider()));
    }

    private void resubscribe(RootProvider wrapper) {
        this.unsubscribe();
        this.subscribe(wrapper);
    }

    private void subscribe(@Nullable RootProvider wrapper) {
        if (wrapper != null) {
            this.myProjectRootManagerImpl.subscribeToRootProvider(this, wrapper);
        }
        this.myCurrentlySubscribedRootProvider = wrapper;
    }

    private void unsubscribe() {
        if (this.myCurrentlySubscribedRootProvider != null) {
            this.myProjectRootManagerImpl.unsubscribeFromRootProvider(this, this.myCurrentlySubscribedRootProvider);
        }
        this.myCurrentlySubscribedRootProvider = null;
    }

    @Override
    public void dispose() {
        this.unsubscribe();
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/LibraryOrderEntryBaseImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootUrls";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnerModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRootFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRootUrls";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

