/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class ContentEntryEditingAction
extends ToggleAction
implements DumbAware {
    protected final JTree myTree;

    protected ContentEntryEditingAction(JTree tree) {
        this.myTree = tree;
        this.getTemplatePresentation().setEnabled(true);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(true);
        VirtualFile[] files = this.getSelectedFiles();
        if (files.length == 0) {
            presentation.setEnabled(false);
            return;
        }
        for (VirtualFile file2 : files) {
            if (file2 != null && file2.isDirectory()) continue;
            presentation.setEnabled(false);
            break;
        }
    }

    @NotNull
    protected final VirtualFile[] getSelectedFiles() {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                ContentEntryEditingAction.$$$reportNull$$$0(0);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList<VirtualFile> selected = new ArrayList<VirtualFile>();
        for (TreePath treePath : selectionPaths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object nodeDescriptor = node.getUserObject();
            if (!(nodeDescriptor instanceof FileNodeDescriptor)) {
                if (VirtualFile.EMPTY_ARRAY == null) {
                    ContentEntryEditingAction.$$$reportNull$$$0(1);
                }
                return VirtualFile.EMPTY_ARRAY;
            }
            FileElement fileElement = ((FileNodeDescriptor)((Object)nodeDescriptor)).getElement();
            VirtualFile file2 = fileElement.getFile();
            if (file2 == null) continue;
            selected.add(file2);
        }
        VirtualFile[] virtualFileArray = selected.toArray(VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            ContentEntryEditingAction.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/actions/ContentEntryEditingAction", "getSelectedFiles"));
    }
}

