/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.externalComponents.ExternalComponentManager;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.CheckForUpdateResult;
import com.intellij.openapi.updateSettings.impl.ExternalUpdate;
import com.intellij.openapi.updateSettings.impl.NoUpdatesDialog;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateStrategy;
import com.intellij.openapi.updateSettings.impl.UpdatesInfo;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.HyperlinkEvent;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0004H\u0007JF\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020 0-2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u0001002\b\u00102\u001a\u0004\u0018\u000103H\u0007J\u0010\u00104\u001a\u00020%2\u0006\u00105\u001a\u000206H\u0007J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J<\u0010;\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010<2\u0006\u0010=\u001a\u00020:2\b\u00102\u001a\u0004\u0018\u0001032\u000e\u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u0001002\b\u0010>\u001a\u0004\u0018\u00010?H\u0003J\u0014\u0010@\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u0002010-H\u0002J>\u0010A\u001a\u00020%2\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u00020\u001a2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020:2\b\u00102\u001a\u0004\u0018\u0001032\b\u0010F\u001a\u0004\u0018\u00010GH\u0002J\u0010\u0010H\u001a\u00020\u00042\u0006\u0010I\u001a\u00020JH\u0007J\u0010\u0010K\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010<H\u0007J\u0010\u0010L\u001a\u00020%2\u0006\u0010M\u001a\u00020NH\u0002J\b\u0010O\u001a\u00020%H\u0007J\u0018\u0010P\u001a\u00020%2\u0006\u0010Q\u001a\u00020\u001a2\u0006\u0010R\u001a\u00020\u0004H\u0002J0\u0010S\u001a\u00020%2\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010R\u001a\u00020\u00042\f\u0010T\u001a\b\u0012\u0004\u0012\u00020%0U2\u0006\u0010V\u001a\u00020\u001dH\u0002Jb\u0010W\u001a\u00020%2\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010X\u001a\u0002082\u0006\u0010=\u001a\u00020:2\u000e\u0010Y\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010<2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u00010<2\u000e\u0010Z\u001a\n\u0012\u0004\u0012\u00020[\u0018\u00010<2\u0006\u0010\\\u001a\u00020\u001a2\u0006\u0010]\u001a\u00020\u001aH\u0002J\u0018\u0010^\u001a\u00020%2\u0006\u0010_\u001a\u00020\u00042\b\u0010`\u001a\u0004\u0018\u00010\u0004J\b\u0010a\u001a\u00020GH\u0007J\u001c\u0010a\u001a\u00020%2\b\u0010B\u001a\u0004\u0018\u00010C2\b\u0010b\u001a\u0004\u0018\u00010:H\u0007J(\u0010c\u001a\b\u0012\u0004\u0012\u00020[0<2\u0006\u0010E\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020:2\b\u00102\u001a\u0004\u0018\u000103H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rR,\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000fj\b\u0012\u0004\u0012\u00020\u0004`\u00108\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0013R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0015j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020 0\u0015j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020 `\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006e"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker;", "", "()V", "DISABLED_UPDATE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NOTIFICATIONS", "Lcom/intellij/notification/NotificationGroup;", "disabledToUpdatePlugins", "", "disabledToUpdatePlugins$annotations", "getDisabledToUpdatePlugins", "()Ljava/util/Set;", "excludedFromUpdateCheckPlugins", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "excludedFromUpdateCheckPlugins$annotations", "getExcludedFromUpdateCheckPlugins", "()Ljava/util/HashSet;", "ourAdditionalRequestOptions", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "ourDisabledToUpdatePlugins", "", "ourHasFailedPlugins", "", "ourShownNotifications", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$NotificationUniqueType;", "Lcom/intellij/notification/Notification;", "ourUpdatedPlugins", "Lcom/intellij/openapi/updateSettings/impl/PluginDownloader;", "updateUrl", "getUpdateUrl", "()Ljava/lang/String;", "addUpdateRequestParameter", "", "name", "value", "checkAndPrepareToInstall", "downloader", "state", "Lcom/intellij/ide/plugins/InstalledPluginsState;", "toUpdate", "", "Lcom/intellij/openapi/extensions/PluginId;", "incompatiblePlugins", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "checkForUpdate", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "checkPlatformUpdate", "Lcom/intellij/openapi/updateSettings/impl/CheckForUpdateResult;", "settings", "Lcom/intellij/openapi/updateSettings/impl/UpdateSettings;", "checkPluginsUpdate", "", "updateSettings", "buildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "collectUpdateablePlugins", "doUpdateAndShowResult", "project", "Lcom/intellij/openapi/project/Project;", "fromSettings", "manualCheck", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "getInstallationUID", "c", "Lcom/intellij/ide/util/PropertiesComponent;", "getPluginUpdates", "prepareUpdateCheckArgs", "uriBuilder", "Lorg/apache/http/client/utils/URIBuilder;", "saveDisabledToUpdatePlugins", "showErrorMessage", "showDialog", "message", "showNotification", "action", "Lkotlin/Function0;", "notificationType", "showUpdateResult", "checkForUpdateResult", "updatedPlugins", "externalUpdates", "Lcom/intellij/openapi/updateSettings/impl/ExternalUpdate;", "enableLink", "alwaysShowResults", "testPlatformUpdate", "updateInfoText", "patchFilePath", "updateAndShowResult", "customSettings", "updateExternal", "NotificationUniqueType", "intellij.platform.ide.impl"})
public final class UpdateChecker {
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final NotificationGroup NOTIFICATIONS;
    private static final String DISABLED_UPDATE = "disabled_update.txt";
    private static Set<String> ourDisabledToUpdatePlugins;
    private static final HashMap<String, String> ourAdditionalRequestOptions;
    private static final HashMap<String, PluginDownloader> ourUpdatedPlugins;
    private static final MultiMap<NotificationUniqueType, Notification> ourShownNotifications;
    @NotNull
    private static final HashSet<String> excludedFromUpdateCheckPlugins;
    private static boolean ourHasFailedPlugins;
    public static final UpdateChecker INSTANCE;

    public static /* synthetic */ void excludedFromUpdateCheckPlugins$annotations() {
    }

    @NotNull
    public final HashSet<String> getExcludedFromUpdateCheckPlugins() {
        return excludedFromUpdateCheckPlugins;
    }

    private final String getUpdateUrl() {
        String string = System.getProperty("idea.updates.url");
        if (string == null) {
            ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
            ApplicationInfoEx.UpdateUrls updateUrls = applicationInfoEx.getUpdateUrls();
            Intrinsics.checkExpressionValueIsNotNull((Object)updateUrls, (String)"ApplicationInfoEx.getInstanceEx().updateUrls");
            String string2 = updateUrls.getCheckingUrl();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ApplicationInfoEx.getIns\u2026().updateUrls.checkingUrl");
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final ActionCallback updateAndShowResult() {
        ActionCallback callback = new ActionCallback();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(callback){
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                UpdateSettings updateSettings = UpdateSettings.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"UpdateSettings.getInstance()");
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, null, true, false, updateSettings, null, this.$callback);
            }
            {
                this.$callback = actionCallback;
            }
        });
        return callback;
    }

    @JvmStatic
    public static final void updateAndShowResult(@Nullable Project project, @Nullable UpdateSettings customSettings) {
        UpdateSettings updateSettings = customSettings;
        if (updateSettings == null) {
            updateSettings = UpdateSettings.getInstance();
        }
        UpdateSettings settings = updateSettings;
        boolean fromSettings = customSettings != null;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(fromSettings, settings, project, project, IdeBundle.message((String)"updates.checking.progress", (Object[])new Object[0]), true){
            final /* synthetic */ boolean $fromSettings;
            final /* synthetic */ UpdateSettings $settings;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                Project project = this.getProject();
                UpdateSettings updateSettings = this.$settings;
                Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"settings");
                UpdateChecker.access$doUpdateAndShowResult(UpdateChecker.INSTANCE, project, this.$fromSettings, true, updateSettings, indicator, null);
            }

            public boolean isConditionalModal() {
                return this.$fromSettings;
            }

            public boolean shouldStartInBackground() {
                return !this.$fromSettings;
            }
            {
                this.$fromSettings = $captured_local_variable$0;
                this.$settings = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    @JvmStatic
    @Nullable
    public static final Collection<PluginDownloader> getPluginUpdates() {
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"UpdateSettings.getInstance()");
        return UpdateChecker.checkPluginsUpdate(updateSettings, (ProgressIndicator)new EmptyProgressIndicator(), null, BuildNumber.currentVersion());
    }

    private final void doUpdateAndShowResult(Project project, boolean fromSettings, boolean manualCheck, UpdateSettings updateSettings, ProgressIndicator indicator, ActionCallback callback) {
        Collection<ExternalUpdate> externalUpdates;
        Collection<PluginDownloader> updatedPlugins;
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText(IdeBundle.message((String)"updates.checking.platform", (Object[])new Object[0]));
        }
        CheckForUpdateResult result2 = this.checkPlatformUpdate(updateSettings);
        if (Intrinsics.areEqual((Object)((Object)result2.getState()), (Object)((Object)UpdateStrategy.State.CONNECTION_ERROR))) {
            Exception e = result2.getError();
            if (e != null) {
                LOG.debug((Throwable)e);
            }
            Object[] objectArray = new Object[1];
            Object object = e;
            if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                object = "internal error";
            }
            objectArray[0] = object;
            String string = IdeBundle.message((String)"updates.error.connection.failed", (Object[])objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IdeBundle.message(\"updat\u2026sage ?: \"internal error\")");
            this.showErrorMessage(manualCheck, string);
            ActionCallback actionCallback = callback;
            if (actionCallback != null) {
                actionCallback.setRejected();
            }
            return;
        }
        ProgressIndicator progressIndicator2 = indicator;
        if (progressIndicator2 != null) {
            progressIndicator2.setText(IdeBundle.message((String)"updates.checking.plugins", (Object[])new Object[0]));
        }
        BuildInfo buildInfo = result2.getNewBuild();
        BuildNumber buildNumber = buildInfo != null ? buildInfo.getApiVersion() : null;
        Collection incompatiblePlugins = buildNumber != null ? (Collection)new HashSet() : null;
        try {
            updatedPlugins = UpdateChecker.checkPluginsUpdate(updateSettings, indicator, incompatiblePlugins, buildNumber);
            externalUpdates = this.updateExternal(manualCheck, updateSettings, indicator);
        }
        catch (IOException e) {
            String string = IdeBundle.message((String)"updates.error.connection.failed", (Object[])new Object[]{e.getMessage()});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IdeBundle.message(\"updat\u2026ction.failed\", e.message)");
            this.showErrorMessage(manualCheck, string);
            ActionCallback actionCallback = callback;
            if (actionCallback != null) {
                actionCallback.setRejected();
            }
            return;
        }
        UpdateSettings.getInstance().saveLastCheckedInfo();
        ApplicationManager.getApplication().invokeLater(new Runnable(project, result2, updateSettings, updatedPlugins, incompatiblePlugins, externalUpdates, fromSettings, manualCheck, callback){
            final /* synthetic */ Project $project;
            final /* synthetic */ CheckForUpdateResult $result;
            final /* synthetic */ UpdateSettings $updateSettings;
            final /* synthetic */ Collection $updatedPlugins;
            final /* synthetic */ Collection $incompatiblePlugins;
            final /* synthetic */ Collection $externalUpdates;
            final /* synthetic */ boolean $fromSettings;
            final /* synthetic */ boolean $manualCheck;
            final /* synthetic */ ActionCallback $callback;

            public final void run() {
                block0: {
                    UpdateChecker.access$showUpdateResult(UpdateChecker.INSTANCE, this.$project, this.$result, this.$updateSettings, this.$updatedPlugins, this.$incompatiblePlugins, this.$externalUpdates, !this.$fromSettings, this.$manualCheck);
                    ActionCallback actionCallback = this.$callback;
                    if (actionCallback == null) break block0;
                    actionCallback.setDone();
                }
            }
            {
                this.$project = project;
                this.$result = checkForUpdateResult;
                this.$updateSettings = updateSettings;
                this.$updatedPlugins = collection;
                this.$incompatiblePlugins = collection2;
                this.$externalUpdates = collection3;
                this.$fromSettings = bl;
                this.$manualCheck = bl2;
                this.$callback = actionCallback;
            }
        }, fromSettings ? ModalityState.any() : ModalityState.NON_MODAL);
    }

    private final CheckForUpdateResult checkPlatformUpdate(UpdateSettings settings) {
        UpdatesInfo updateInfo;
        if (!settings.isPlatformUpdateEnabled()) {
            return new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED, null);
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(this.getUpdateUrl());
            if (Intrinsics.areEqual((Object)"file", (Object)uriBuilder.getScheme()) ^ true) {
                this.prepareUpdateCheckArgs(uriBuilder);
            }
            String updateUrl = uriBuilder.build().toString();
            LogUtil.debug((Logger)LOG, (String)"load update xml (UPDATE_URL='%s')", (Object[])new Object[]{updateUrl});
            updateInfo = (UpdatesInfo)HttpRequests.request((String)updateUrl).forceHttps(settings.canUseSecureConnection()).connect((HttpRequests.RequestProcessor)checkPlatformUpdate.1.INSTANCE);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return new CheckForUpdateResult(UpdateStrategy.State.CONNECTION_ERROR, e);
        }
        if (updateInfo == null) {
            return new CheckForUpdateResult(UpdateStrategy.State.NOTHING_LOADED, null);
        }
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        UpdateStrategy strategy = new UpdateStrategy(buildNumber, updateInfo, settings);
        return strategy.checkForUpdates();
    }

    @JvmStatic
    private static final Collection<PluginDownloader> checkPluginsUpdate(UpdateSettings updateSettings, ProgressIndicator indicator, Collection<IdeaPluginDescriptor> incompatiblePlugins, BuildNumber buildNumber) {
        Map<PluginId, IdeaPluginDescriptor> updateable = INSTANCE.collectUpdateablePlugins();
        if (updateable.isEmpty()) {
            return null;
        }
        THashMap toUpdate = ContainerUtil.newTroveMap();
        List<String> hosts = RepositoryHelper.getPluginHosts();
        InstalledPluginsState state = InstalledPluginsState.getInstance();
        block2: for (String host : hosts) {
            try {
                boolean forceHttps = host == null && updateSettings.canUseSecureConnection();
                List<IdeaPluginDescriptor> list2 = RepositoryHelper.loadPlugins(host, buildNumber, forceHttps, indicator);
                Iterator<IdeaPluginDescriptor> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    PluginDownloader downloader;
                    IdeaPluginDescriptor descriptor;
                    IdeaPluginDescriptor ideaPluginDescriptor = descriptor = iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptor, (String)"descriptor");
                    PluginId id = ideaPluginDescriptor.getPluginId();
                    if (!updateable.containsKey(id)) continue;
                    updateable.remove(id);
                    state.onDescriptorDownload(descriptor);
                    PluginDownloader pluginDownloader = downloader = PluginDownloader.createDownloader(descriptor, host, buildNumber, forceHttps);
                    Intrinsics.checkExpressionValueIsNotNull((Object)pluginDownloader, (String)"downloader");
                    InstalledPluginsState installedPluginsState = state;
                    Intrinsics.checkExpressionValueIsNotNull((Object)installedPluginsState, (String)"state");
                    THashMap tHashMap = toUpdate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)tHashMap, (String)"toUpdate");
                    UpdateChecker.checkAndPrepareToInstall(pluginDownloader, installedPluginsState, (Map)tHashMap, incompatiblePlugins, indicator);
                    if (!updateable.isEmpty()) continue;
                    break block2;
                }
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                if (host != null) {
                    LOG.info("failed to load plugin descriptions from " + host + ": " + e.getMessage());
                    continue;
                }
                throw (Throwable)e;
            }
        }
        THashMap tHashMap = toUpdate;
        Intrinsics.checkExpressionValueIsNotNull((Object)tHashMap, (String)"toUpdate");
        return tHashMap.isEmpty() ? null : toUpdate.values();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<PluginId, IdeaPluginDescriptor> collectUpdateablePlugins() {
        Object element$iv;
        Object object;
        Object object2;
        Iterable $receiver$iv$iv;
        Object it;
        void $receiver$iv$iv2;
        THashMap updateable = ContainerUtil.newTroveMap();
        Map map = (Map)updateable;
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptorArray, (String)"PluginManagerCore.getPlugins()");
        Object $receiver$iv = ideaPluginDescriptorArray;
        Object[] objectArray = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv2) {
            IdeaPluginDescriptor ideaPluginDescriptor = it = (IdeaPluginDescriptor)element$iv$iv2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptor, (String)"it");
            if (!(!ideaPluginDescriptor.isBundled() || it.allowBundledUpdate())) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $receiver$iv = (List)destination$iv$iv;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv = $receiver$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        for (Object element$iv$iv2 : $receiver$iv$iv) {
            it = (IdeaPluginDescriptor)element$iv$iv2;
            object2 = destination$iv$iv2;
            IdeaPluginDescriptor ideaPluginDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptor, (String)"it");
            object = ideaPluginDescriptor.getPluginId();
            object2.put(object, element$iv$iv2);
        }
        $receiver$iv = destination$iv$iv2;
        map.putAll($receiver$iv);
        File onceInstalled = PluginManager.getOnceInstalledIfExists();
        if (onceInstalled != null) {
            try {
                PluginId it2;
                Object element$iv$iv;
                Iterator $receiver$iv$iv3;
                List list2 = FileUtil.loadLines((File)onceInstalled);
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"FileUtil.loadLines(onceInstalled)");
                $receiver$iv = list2;
                Object capacity$iv2 = $receiver$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                destination$iv$iv2 = $receiver$iv$iv3.iterator();
                while (destination$iv$iv2.hasNext()) {
                    void $receiver$iv2;
                    void line;
                    Object element$iv$iv2;
                    Object item$iv$iv = destination$iv$iv2.next();
                    element$iv$iv2 = (String)item$iv$iv;
                    object2 = destination$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)line, (String)"line");
                    CharSequence $receiver$iv$iv4 = (CharSequence)$receiver$iv2;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $receiver$iv$iv4.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it3 = $receiver$iv$iv4.charAt(index$iv$iv);
                        boolean bl = match$iv$iv = it3 <= ' ';
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    object = PluginId.getId((String)((Object)$receiver$iv$iv4.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                    object2.add(object);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv3 = $receiver$iv;
                destination$iv$iv = new ArrayList();
                destination$iv$iv2 = $receiver$iv$iv3.iterator();
                while (destination$iv$iv2.hasNext()) {
                    element$iv$iv = destination$iv$iv2.next();
                    it2 = (PluginId)element$iv$iv;
                    if (!(!updateable.contains((Object)it2))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv3 = $receiver$iv.iterator();
                while ($receiver$iv$iv3.hasNext()) {
                    element$iv = $receiver$iv$iv3.next();
                    PluginId it4 = (PluginId)element$iv;
                    THashMap tHashMap = updateable;
                    Intrinsics.checkExpressionValueIsNotNull((Object)tHashMap, (String)"updateable");
                    element$iv$iv = (Map)tHashMap;
                    it2 = null;
                    element$iv$iv.put((PluginId)it4, (PluginId)it2);
                }
            }
            catch (IOException e) {
                LOG.error(onceInstalled.getPath(), (Throwable)e);
            }
            onceInstalled.deleteOnExit();
        }
        if (!excludedFromUpdateCheckPlugins.isEmpty()) {
            Iterable $receiver$iv3;
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project[] projectArray = projectManager.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
            Object[] $receiver$iv$iv5 = projectArray;
            element$iv = $receiver$iv3;
            destination$iv$iv2 = new ArrayList();
            for (DependencyOnPlugin element$iv$iv : $receiver$iv$iv) {
                Project it5 = (Project)element$iv$iv;
                Iterable list$iv$iv = ExternalDependenciesManager.getInstance(it5).getDependencies(DependencyOnPlugin.class);
                CollectionsKt.addAll(destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $receiver$iv3 = (List)destination$iv$iv2;
            $receiver$iv$iv = $receiver$iv3;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                DependencyOnPlugin element$iv$iv;
                element$iv$iv = (DependencyOnPlugin)item$iv$iv;
                object2 = destination$iv$iv2;
                IdeaPluginDescriptor ideaPluginDescriptor = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptor, (String)"it");
                object = ideaPluginDescriptor.getPluginId();
                object2.add(object);
            }
            Set required = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            $receiver$iv3 = excludedFromUpdateCheckPlugins;
            $receiver$iv$iv = $receiver$iv3;
            destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (String)element$iv$iv;
                if (!(!required.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $receiver$iv3 = (List)destination$iv$iv2;
            for (Object element$iv2 : $receiver$iv3) {
                String it6 = (String)element$iv2;
                updateable.remove((Object)PluginId.getId((String)it6));
            }
        }
        THashMap tHashMap = updateable;
        Intrinsics.checkExpressionValueIsNotNull((Object)tHashMap, (String)"updateable");
        return (Map)tHashMap;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ExternalUpdate> updateExternal(boolean manualCheck, UpdateSettings updateSettings, ProgressIndicator indicator) {
        ArrayList result2 = new ArrayList();
        ExternalComponentManager manager = ExternalComponentManager.getInstance();
        ProgressIndicator progressIndicator = indicator;
        if (progressIndicator != null) {
            progressIndicator.setText(IdeBundle.message((String)"updates.external.progress", (Object[])new Object[0]));
        }
        ExternalComponentManager externalComponentManager = manager;
        Intrinsics.checkExpressionValueIsNotNull((Object)externalComponentManager, (String)"manager");
        for (ExternalComponentSource source : externalComponentManager.getComponentSources()) {
            ProgressIndicator progressIndicator2 = indicator;
            if (progressIndicator2 != null) {
                progressIndicator2.checkCanceled();
            }
            List<String> list2 = updateSettings.getEnabledExternalUpdateSources();
            ExternalComponentSource externalComponentSource = source;
            Intrinsics.checkExpressionValueIsNotNull((Object)externalComponentSource, (String)"source");
            if (!list2.contains(externalComponentSource.getName())) continue;
            try {
                void $receiver$iv$iv;
                void $receiver$iv;
                Collection<UpdatableExternalComponent> collection = source.getAvailableVersions(indicator, updateSettings);
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"source.getAvailableVersi\u2026ndicator, updateSettings)");
                Iterable iterable = collection;
                ExternalUpdate externalUpdate = $receiver$iv;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    UpdatableExternalComponent it = (UpdatableExternalComponent)element$iv$iv;
                    if (!it.isUpdateFor(manager.findExistingComponentMatching(it, source))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List siteResult = (List)destination$iv$iv;
                if (siteResult.isEmpty()) continue;
                iterable = result2;
                externalUpdate = new ExternalUpdate(siteResult, source);
                iterable.add(externalUpdate);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                Object[] objectArray = new Object[2];
                objectArray[0] = source.getName();
                String string = e.getMessage();
                if (string == null) {
                    string = "internal error";
                }
                objectArray[1] = string;
                String string2 = IdeBundle.message((String)"updates.external.error.message", (Object[])objectArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IdeBundle.message(\"updat\u2026sage ?: \"internal error\")");
                this.showErrorMessage(manualCheck, string2);
            }
        }
        return result2;
    }

    @JvmStatic
    public static final void checkAndPrepareToInstall(@NotNull PluginDownloader downloader, @NotNull InstalledPluginsState state, @NotNull Map<PluginId, PluginDownloader> toUpdate, @Nullable Collection<IdeaPluginDescriptor> incompatiblePlugins, @Nullable ProgressIndicator indicator) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)downloader, (String)"downloader");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull(toUpdate, (String)"toUpdate");
        PluginDownloader downloader2 = downloader;
        String pluginId = downloader2.getPluginId();
        if (PluginManagerCore.getDisabledPlugins().contains(pluginId)) {
            return;
        }
        String pluginVersion = downloader2.getPluginVersion();
        IdeaPluginDescriptor installedPlugin = PluginManager.getPlugin(PluginId.getId((String)pluginId));
        if (installedPlugin == null || pluginVersion == null || PluginDownloader.compareVersionsSkipBrokenAndIncompatible(installedPlugin, pluginVersion) > 0) {
            PluginDownloader pluginDownloader;
            String string;
            Map<PluginId, PluginDownloader> map;
            IdeaPluginDescriptor descriptor;
            PluginDownloader oldDownloader = ourUpdatedPlugins.get(pluginId);
            if (oldDownloader == null || StringUtil.compareVersionNumbers((String)pluginVersion, (String)oldDownloader.getPluginVersion()) > 0) {
                descriptor = downloader2.getDescriptor();
                if (descriptor instanceof PluginNode && ((PluginNode)descriptor).isIncomplete()) {
                    ProgressIndicator progressIndicator = indicator;
                    if (progressIndicator == null) {
                        progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
                    }
                    if (downloader2.prepareToInstall(progressIndicator)) {
                        descriptor = downloader2.getDescriptor();
                    }
                    map = (Map<PluginId, PluginDownloader>)ourUpdatedPlugins;
                    String string2 = pluginId;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"pluginId");
                    string = string2;
                    pluginDownloader = downloader2;
                    map.put((PluginId)string, pluginDownloader);
                }
            } else {
                downloader2 = oldDownloader;
                descriptor = oldDownloader.getDescriptor();
            }
            if (descriptor != null && PluginManagerCore.isCompatible(descriptor, downloader2.getBuildNumber()) && !state.wasUpdated(descriptor.getPluginId())) {
                map = toUpdate;
                PluginId pluginId2 = PluginId.getId((String)pluginId);
                Intrinsics.checkExpressionValueIsNotNull((Object)pluginId2, (String)"PluginId.getId(pluginId)");
                string = pluginId2;
                pluginDownloader = downloader2;
                map.put((PluginId)string, pluginDownloader);
            }
        }
        if (incompatiblePlugins != null && installedPlugin != null && installedPlugin.isEnabled() && !toUpdate.containsKey(installedPlugin.getPluginId()) && PluginManagerCore.isIncompatible(installedPlugin, downloader2.getBuildNumber())) {
            incompatiblePlugins.add(installedPlugin);
        }
    }

    private final void showErrorMessage(boolean showDialog, String message) {
        LOG.info(message);
        if (showDialog) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(message){
                final /* synthetic */ String $message;

                public final void run() {
                    Messages.showErrorDialog((String)this.$message, (String)IdeBundle.message((String)"updates.error.connection.title", (Object[])new Object[0]));
                }
                {
                    this.$message = string;
                }
            });
        }
    }

    private final void showUpdateResult(Project project, CheckForUpdateResult checkForUpdateResult, UpdateSettings updateSettings, Collection<? extends PluginDownloader> updatedPlugins, Collection<? extends IdeaPluginDescriptor> incompatiblePlugins, Collection<? extends ExternalUpdate> externalUpdates, boolean enableLink, boolean alwaysShowResults) {
        UpdateChannel updatedChannel = checkForUpdateResult.getUpdatedChannel();
        BuildInfo newBuild = checkForUpdateResult.getNewBuild();
        if (updatedChannel != null && newBuild != null) {
            Function0 runnable2 = (Function0)new Function0<Unit>(checkForUpdateResult, updateSettings, updatedChannel, newBuild, enableLink, updatedPlugins, incompatiblePlugins){
                final /* synthetic */ CheckForUpdateResult $checkForUpdateResult;
                final /* synthetic */ UpdateSettings $updateSettings;
                final /* synthetic */ UpdateChannel $updatedChannel;
                final /* synthetic */ BuildInfo $newBuild;
                final /* synthetic */ boolean $enableLink;
                final /* synthetic */ Collection $updatedPlugins;
                final /* synthetic */ Collection $incompatiblePlugins;

                public final void invoke() {
                    ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
                    PatchInfo patch = this.$checkForUpdateResult.findPatchForBuild(applicationInfo.getBuild());
                    boolean forceHttps = this.$updateSettings.canUseSecureConnection();
                    new UpdateInfoDialog(this.$updatedChannel, this.$newBuild, patch, this.$enableLink, forceHttps, this.$updatedPlugins, this.$incompatiblePlugins).show();
                }
                {
                    this.$checkForUpdateResult = checkForUpdateResult;
                    this.$updateSettings = updateSettings;
                    this.$updatedChannel = updateChannel;
                    this.$newBuild = buildInfo;
                    this.$enableLink = bl;
                    this.$updatedPlugins = collection;
                    this.$incompatiblePlugins = collection2;
                    super(0);
                }
            };
            Collection collection = ourShownNotifications.remove((Object)NotificationUniqueType.PLATFORM);
            if (collection != null) {
                Iterable iterable = collection;
                for (Object element$iv : iterable) {
                    Notification it = (Notification)element$iv;
                    it.expire();
                }
            }
            if (alwaysShowResults) {
                runnable2.invoke();
            } else {
                String string;
                Object[] objectArray = new Object[1];
                ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
                objectArray[0] = applicationNamesInfo.getFullProductName();
                String string2 = string = IdeBundle.message((String)"updates.ready.message", (Object[])objectArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message");
                this.showNotification(project, string2, (Function0<Unit>)runnable2, NotificationUniqueType.PLATFORM);
            }
            return;
        }
        boolean updateFound = false;
        if (updatedPlugins != null && !updatedPlugins.isEmpty()) {
            updateFound = true;
            Function0 function0 = (Function0)new Function0<Unit>(updatedPlugins, enableLink){
                final /* synthetic */ Collection $updatedPlugins;
                final /* synthetic */ boolean $enableLink;

                public final void invoke() {
                    new PluginUpdateInfoDialog(this.$updatedPlugins, this.$enableLink).show();
                }
                {
                    this.$updatedPlugins = collection;
                    this.$enableLink = bl;
                    super(0);
                }
            };
            Collection collection = ourShownNotifications.remove((Object)NotificationUniqueType.PLUGINS);
            if (collection != null) {
                Iterable $receiver$iv = collection;
                for (Object element$iv : $receiver$iv) {
                    Notification it = (Notification)element$iv;
                    it.expire();
                }
            }
            if (alwaysShowResults) {
                function0.invoke();
            } else {
                String message;
                String plugins2 = CollectionsKt.joinToString$default((Iterable)updatedPlugins, null, null, null, (int)0, null, (Function1)showUpdateResult.plugins.1.INSTANCE, (int)31, null);
                String string = message = IdeBundle.message((String)"updates.plugins.ready.message", (Object[])new Object[]{updatedPlugins.size(), plugins2});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                this.showNotification(project, string, (Function0<Unit>)function0, NotificationUniqueType.PLUGINS);
            }
        }
        if (externalUpdates != null && !externalUpdates.isEmpty()) {
            updateFound = true;
            Collection collection = ourShownNotifications.remove((Object)NotificationUniqueType.EXTERNAL);
            if (collection != null) {
                Iterable iterable = collection;
                for (Object element$iv : iterable) {
                    Notification it = (Notification)element$iv;
                    it.expire();
                }
            }
            for (ExternalUpdate externalUpdate : externalUpdates) {
                String message;
                Function0 runnable4 = (Function0)new Function0<Unit>(externalUpdate){
                    final /* synthetic */ ExternalUpdate $update;

                    public final void invoke() {
                        this.$update.getSource().installUpdates(this.$update.getComponents());
                    }
                    {
                        this.$update = externalUpdate;
                        super(0);
                    }
                };
                if (alwaysShowResults) {
                    runnable4.invoke();
                    continue;
                }
                Collection<UpdatableExternalComponent> collection2 = externalUpdate.getComponents();
                Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"update.components");
                String updates = CollectionsKt.joinToString$default((Iterable)collection2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                String string = message = IdeBundle.message((String)"updates.external.ready.message", (Object[])new Object[]{externalUpdate.getComponents().size(), updates});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
                this.showNotification(project, string, (Function0<Unit>)runnable4, NotificationUniqueType.EXTERNAL);
            }
        }
        if (!updateFound && alwaysShowResults) {
            new NoUpdatesDialog(enableLink).show();
        }
    }

    private final void showNotification(Project project, String message, Function0<Unit> action, NotificationUniqueType notificationType) {
        NotificationListener listener2 = new NotificationListener(action){
            final /* synthetic */ Function0 $action;

            public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent $noName_1) {
                Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                notification.expire();
                this.$action.invoke();
            }
            {
                this.$action = function0;
            }
        };
        String title = IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]);
        Notification notification = NOTIFICATIONS.createNotification(title, XmlStringUtil.wrapInHtml((CharSequence)message), NotificationType.INFORMATION, listener2);
        notification.whenExpired(new Runnable(notificationType, notification){
            final /* synthetic */ NotificationUniqueType $notificationType;
            final /* synthetic */ Notification $notification;

            public final void run() {
                UpdateChecker.access$getOurShownNotifications$p(UpdateChecker.INSTANCE).remove((Object)((Object)this.$notificationType), (Object)this.$notification);
            }
            {
                this.$notificationType = notificationUniqueType;
                this.$notification = notification;
            }
        });
        notification.notify(project);
        ourShownNotifications.putValue((Object)notificationType, (Object)notification);
    }

    @JvmStatic
    public static final void addUpdateRequestParameter(@NotNull String name, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Map map = ourAdditionalRequestOptions;
        String string = value;
        map.put(name, string);
    }

    private final void prepareUpdateCheckArgs(URIBuilder uriBuilder) {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        String string = applicationInfo.getBuild().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ApplicationInfo.getInstance().build.asString()");
        UpdateChecker.addUpdateRequestParameter("build", string);
        String string2 = PermanentInstallationID.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PermanentInstallationID.get()");
        UpdateChecker.addUpdateRequestParameter("uid", string2);
        UpdateChecker.addUpdateRequestParameter("os", SystemInfo.OS_NAME + ' ' + SystemInfo.OS_VERSION);
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)applicationInfoEx), (String)"ApplicationInfoEx.getInstanceEx()");
        if (applicationInfoEx.isEAP()) {
            UpdateChecker.addUpdateRequestParameter("eap", "");
        }
        Map map = ourAdditionalRequestOptions;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            String name = (String)entry2.getKey();
            entry2 = entry;
            String value = (String)entry2.getValue();
            uriBuilder.addParameter(name, StringUtil.isEmpty((String)value) ? null : value);
        }
    }

    @Deprecated(message="Replaced", replaceWith=@ReplaceWith(imports={"com.intellij.openapi.application.PermanentInstallationID"}, expression="PermanentInstallationID.get()"))
    @JvmStatic
    @NotNull
    public static final String getInstallationUID(@NotNull PropertiesComponent c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        return PermanentInstallationID.get();
    }

    @JvmStatic
    public static /* synthetic */ void disabledToUpdatePlugins$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<String> getDisabledToUpdatePlugins() {
        if (ourDisabledToUpdatePlugins == null) {
            ourDisabledToUpdatePlugins = new TreeSet();
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                try {
                    File file2 = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
                    if (file2.isFile()) {
                        Iterator iterator;
                        CharSequence charSequence;
                        void $receiver$iv$iv;
                        String string = FileUtil.loadFile((File)file2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.loadFile(file)");
                        CharSequence charSequence2 = string;
                        Object object = "[\\s]";
                        object = new Regex((String)object);
                        int n = 0;
                        Iterable $receiver$iv = object.split(charSequence2, n);
                        object = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (Object item$iv$iv : $receiver$iv$iv) {
                            void it;
                            void var7_9;
                            charSequence = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            void v2 = var7_9 = it;
                            if (v2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v2))).toString();
                            collection.add(string2);
                        }
                        $receiver$iv = (List)((Object)iterator);
                        Set<String> set2 = ourDisabledToUpdatePlugins;
                        if (set2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Collection destination$iv = set2;
                        for (Object element$iv : $receiver$iv) {
                            String it = (String)element$iv;
                            charSequence = it;
                            if (!(charSequence.length() > 0)) continue;
                            destination$iv.add(element$iv);
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        Set<String> set3 = ourDisabledToUpdatePlugins;
        if (set3 == null) {
            Intrinsics.throwNpe();
        }
        return set3;
    }

    @JvmStatic
    public static final void saveDisabledToUpdatePlugins() {
        File plugins2 = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
        try {
            PluginManagerCore.savePluginsList((Collection<String>)UpdateChecker.getDisabledToUpdatePlugins(), false, plugins2);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @JvmStatic
    public static final void checkForUpdate(@NotNull IdeaLoggingEvent event) {
        Application app;
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!(ourHasFailedPlugins || (app = ApplicationManager.getApplication()) == null || app.isDisposed() || app.isDisposeInProgress())) {
            IdeaPluginDescriptor pluginDescriptor;
            UpdateSettings updateSettings = UpdateSettings.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"UpdateSettings.getInstance()");
            if (updateSettings.isCheckNeeded() && (pluginDescriptor = PluginManager.getPlugin(IdeErrorsDialog.findPluginId(event.getThrowable()))) != null && !pluginDescriptor.isBundled()) {
                ourHasFailedPlugins = true;
                UpdateChecker.updateAndShowResult();
            }
        }
    }

    public final void testPlatformUpdate(@NotNull String updateInfoText, @Nullable String patchFilePath) {
        UpdatesInfo updateInfo;
        Intrinsics.checkParameterIsNotNull((Object)updateInfoText, (String)"updateInfoText");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isInternal()) {
            throw (Throwable)new IllegalStateException();
        }
        try {
            updateInfo = new UpdatesInfo(JdomKt.loadElement((CharSequence)updateInfoText));
        }
        catch (JDOMException e) {
            LOG.error((Throwable)e);
            return;
        }
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        BuildNumber buildNumber = applicationInfo.getBuild();
        Intrinsics.checkExpressionValueIsNotNull((Object)buildNumber, (String)"ApplicationInfo.getInstance().build");
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"UpdateSettings.getInstance()");
        UpdateStrategy strategy = new UpdateStrategy(buildNumber, updateInfo, updateSettings);
        CheckForUpdateResult checkForUpdateResult = strategy.checkForUpdates();
        UpdateChannel updatedChannel = checkForUpdateResult.getUpdatedChannel();
        BuildInfo newBuild = checkForUpdateResult.getNewBuild();
        if (updatedChannel != null && newBuild != null) {
            ApplicationInfo applicationInfo2 = ApplicationInfo.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo2, (String)"ApplicationInfo.getInstance()");
            PatchInfo patch = checkForUpdateResult.findPatchForBuild(applicationInfo2.getBuild());
            File patchFile = patchFilePath != null ? new File(FileUtil.toSystemDependentName((String)patchFilePath)) : null;
            new UpdateInfoDialog(updatedChannel, newBuild, patch, patchFile).show();
        } else {
            new NoUpdatesDialog(true).show();
        }
    }

    private UpdateChecker() {
    }

    static {
        UpdateChecker updateChecker;
        INSTANCE = updateChecker = new UpdateChecker();
        LOG = Logger.getInstance((String)"#com.intellij.openapi.updateSettings.impl.UpdateChecker");
        NOTIFICATIONS = new NotificationGroup(IdeBundle.message((String)"update.notifications.title", (Object[])new Object[0]), NotificationDisplayType.STICKY_BALLOON, true);
        ourAdditionalRequestOptions = new HashMap();
        ourUpdatedPlugins = new HashMap();
        ourShownNotifications = new MultiMap();
        excludedFromUpdateCheckPlugins = new HashSet();
    }

    public static final /* synthetic */ void access$doUpdateAndShowResult(UpdateChecker $this, @Nullable Project project, boolean fromSettings, boolean manualCheck, @NotNull UpdateSettings updateSettings, @Nullable ProgressIndicator indicator, @Nullable ActionCallback callback) {
        $this.doUpdateAndShowResult(project, fromSettings, manualCheck, updateSettings, indicator, callback);
    }

    public static final /* synthetic */ void access$showUpdateResult(UpdateChecker $this, @Nullable Project project, @NotNull CheckForUpdateResult checkForUpdateResult, @NotNull UpdateSettings updateSettings, @Nullable Collection updatedPlugins, @Nullable Collection incompatiblePlugins, @Nullable Collection externalUpdates, boolean enableLink, boolean alwaysShowResults) {
        $this.showUpdateResult(project, checkForUpdateResult, updateSettings, updatedPlugins, incompatiblePlugins, externalUpdates, enableLink, alwaysShowResults);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p(UpdateChecker $this) {
        UpdateChecker updateChecker = $this;
        return LOG;
    }

    @NotNull
    public static final /* synthetic */ MultiMap access$getOurShownNotifications$p(UpdateChecker $this) {
        UpdateChecker updateChecker = $this;
        return ourShownNotifications;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/updateSettings/impl/UpdateChecker$NotificationUniqueType;", "", "(Ljava/lang/String;I)V", "PLATFORM", "PLUGINS", "EXTERNAL", "intellij.platform.ide.impl"})
    private static final class NotificationUniqueType
    extends Enum<NotificationUniqueType> {
        public static final /* enum */ NotificationUniqueType PLATFORM;
        public static final /* enum */ NotificationUniqueType PLUGINS;
        public static final /* enum */ NotificationUniqueType EXTERNAL;
        private static final /* synthetic */ NotificationUniqueType[] $VALUES;

        static {
            NotificationUniqueType[] notificationUniqueTypeArray = new NotificationUniqueType[3];
            NotificationUniqueType[] notificationUniqueTypeArray2 = notificationUniqueTypeArray;
            notificationUniqueTypeArray[0] = PLATFORM = new NotificationUniqueType();
            notificationUniqueTypeArray[1] = PLUGINS = new NotificationUniqueType();
            notificationUniqueTypeArray[2] = EXTERNAL = new NotificationUniqueType();
            $VALUES = notificationUniqueTypeArray;
        }

        public static NotificationUniqueType[] values() {
            return (NotificationUniqueType[])$VALUES.clone();
        }

        public static NotificationUniqueType valueOf(String string) {
            return Enum.valueOf(NotificationUniqueType.class, string);
        }
    }
}

