/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CommitCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        PsiFile file2;
        Document document;
        if (parameters == null) {
            CommitCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            CommitCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(file2 = parameters.getOriginalFile()).getProject()).getDocument(file2)) == null) {
            return;
        }
        CommitMessage commitMessage = (CommitMessage)document.getUserData(CommitMessage.DATA_KEY);
        if (commitMessage == null) {
            return;
        }
        result2.stopHere();
        if (parameters.getInvocationCount() <= 0) {
            return;
        }
        List<ChangeList> lists = commitMessage.getChangeLists();
        if (lists.isEmpty()) {
            return;
        }
        String prefix = TextFieldWithAutoCompletionListProvider.getCompletionPrefix(parameters);
        CompletionResultSet insensitive = result2.caseInsensitive().withPrefixMatcher((PrefixMatcher)new CamelHumpMatcher(prefix));
        for (ChangeList list2 : lists) {
            ProgressManager.checkCanceled();
            for (Change change : list2.getChanges()) {
                ProgressManager.checkCanceled();
                ContentRevision revision = change.getAfterRevision() == null ? change.getBeforeRevision() : change.getAfterRevision();
                if (revision == null) continue;
                FilePath filePath = revision.getFile();
                LookupElementBuilder element = LookupElementBuilder.create((String)filePath.getName()).withIcon(filePath.getFileType().getIcon());
                insensitive.addElement((LookupElement)element);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/CommitCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

