/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListManagerSerialization;
import com.intellij.openapi.vcs.changes.ChangeListOwner;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.DummyChangesView;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.IgnoredFilesComponent;
import com.intellij.openapi.vcs.changes.IgnoredFilesCompositeHolder;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListsLoadedListener;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.Modifier;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.UpdateRequestsQueue;
import com.intellij.openapi.vcs.changes.UpdatingChangeListBuilder;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsConfirmationDialog;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeModifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListener;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.VirtualFileHolder;
import com.intellij.openapi.vcs.changes.actions.ChangeListRemoveConfirmation;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.changes.ui.CommitHelper;
import com.intellij.openapi.vcs.changes.ui.PlusMinusModify;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ChangeListManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ChangeListManagerImpl
extends ChangeListManagerEx
implements ProjectComponent,
ChangeListOwner,
PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListManagerImpl");
    private static final String EXCLUDED_CONVERTED_TO_IGNORED_OPTION = "EXCLUDED_CONVERTED_TO_IGNORED";
    public static final Topic<LocalChangeListsLoadedListener> LISTS_LOADED = new Topic("LOCAL_CHANGE_LISTS_LOADED", LocalChangeListsLoadedListener.class);
    private final Project myProject;
    private final VcsConfiguration myConfig;
    private final ChangesViewI myChangesViewManager;
    private final FileStatusManager myFileStatusManager;
    private final ChangelistConflictTracker myConflictTracker;
    private VcsDirtyScopeManager myDirtyScopeManager;
    private final Scheduler myScheduler;
    private final EventDispatcher<ChangeListListener> myListeners;
    private final DelayedNotificator myDelayedNotificator;
    private final Object myDataLock;
    private final IgnoredFilesComponent myIgnoredIdeaLevel;
    private final UpdateRequestsQueue myUpdater;
    private final Modifier myModifier;
    private final MyChangesDeltaForwarder myDeltaForwarder;
    private FileHolderComposite myComposite;
    private final ChangeListWorker myWorker;
    private VcsException myUpdateException;
    private Factory<JComponent> myAdditionalInfo;
    private boolean myShowLocalChangesInvalidated;
    @NotNull
    private ProgressIndicator myUpdateChangesProgressIndicator;
    private volatile String myFreezeName;
    @NotNull
    private final Collection<LocalChangeList> myListsToBeDeleted;
    private boolean myModalNotificationsBlocked;
    private final List<CommitExecutor> myRegisteredCommitExecutors;
    private boolean myExcludedConvertedToIgnored;

    public static ChangeListManagerImpl getInstanceImpl(Project project) {
        return (ChangeListManagerImpl)ChangeListManagerImpl.getInstance((Project)project);
    }

    void setDirtyScopeManager(VcsDirtyScopeManager dirtyScopeManager) {
        this.myDirtyScopeManager = dirtyScopeManager;
    }

    public ChangeListManagerImpl(@NotNull Project project, VcsConfiguration config) {
        if (project == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(0);
        }
        this.myScheduler = new Scheduler();
        this.myListeners = EventDispatcher.create(ChangeListListener.class);
        this.myDataLock = new Object();
        this.myUpdateChangesProgressIndicator = ChangeListManagerImpl.createProgressIndicator();
        this.myListsToBeDeleted = new HashSet<LocalChangeList>();
        this.myRegisteredCommitExecutors = new ArrayList<CommitExecutor>();
        this.myProject = project;
        this.myConfig = config;
        this.myChangesViewManager = this.myProject.isDefault() ? new DummyChangesView(this.myProject) : ChangesViewManager.getInstance(this.myProject);
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        this.myConflictTracker = new ChangelistConflictTracker(project, this, this.myFileStatusManager, EditorNotifications.getInstance((Project)project));
        this.myIgnoredIdeaLevel = new IgnoredFilesComponent(this.myProject, true);
        this.myComposite = new FileHolderComposite(project);
        this.myDeltaForwarder = new MyChangesDeltaForwarder(this.myProject, this.myScheduler);
        this.myDelayedNotificator = new DelayedNotificator(this.myListeners, this.myScheduler);
        this.myWorker = new ChangeListWorker(this.myProject, this.myDelayedNotificator);
        this.myUpdater = new UpdateRequestsQueue(this.myProject, this.myScheduler, () -> this.updateImmediately());
        this.myModifier = new Modifier(this.myWorker, this.myDelayedNotificator);
        this.myListeners.addListener((EventListener)new ChangeListAdapter(){

            public void defaultListChanged(ChangeList oldDefaultList, ChangeList newDefaultList) {
                LocalChangeList oldList = (LocalChangeList)oldDefaultList;
                if (oldDefaultList == null || oldList.hasDefaultName() || oldDefaultList.equals(newDefaultList)) {
                    return;
                }
                ChangeListManagerImpl.this.scheduleAutomaticEmptyChangeListDeletion(oldList);
            }
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ProjectManager.getInstance().addProjectManagerListener(project, new ProjectManagerListener(){

                public void projectClosing(Project project) {
                    ChangeListManagerImpl.this.waitEverythingDoneInTestMode();
                }
            });
        }
    }

    public void scheduleAutomaticEmptyChangeListDeletion(@NotNull LocalChangeList oldList) {
        if (oldList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION) {
            return;
        }
        this.invokeAfterUpdate(() -> {
            LocalChangeList actualList;
            if (oldList == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(115);
            }
            if ((actualList = this.getChangeList(oldList.getId())) == null || actualList.isDefault() || !actualList.getChanges().isEmpty()) {
                return;
            }
            if (this.myModalNotificationsBlocked && this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION) {
                this.myListsToBeDeleted.add(oldList);
            } else {
                this.deleteEmptyChangeLists(Collections.singletonList(actualList));
            }
        }, InvokeAfterUpdateMode.SILENT, null, null);
    }

    private void deleteEmptyChangeLists(@NotNull Collection<LocalChangeList> lists) {
        if (lists == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(2);
        }
        if (lists.isEmpty() || this.myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return;
        }
        ChangeListRemoveConfirmation.processLists(this.myProject, false, lists, new ChangeListRemoveConfirmation(){

            @Override
            public boolean askIfShouldRemoveChangeLists(@NotNull List<? extends LocalChangeList> toAsk) {
                if (toAsk == null) {
                    3.$$$reportNull$$$0(0);
                }
                return ((ChangeListManagerImpl)ChangeListManagerImpl.this).myConfig.REMOVE_EMPTY_INACTIVE_CHANGELISTS == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || ChangeListManagerImpl.showRemoveEmptyChangeListsProposal(ChangeListManagerImpl.this.myProject, ChangeListManagerImpl.this.myConfig, toAsk);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAsk", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$3", "askIfShouldRemoveChangeLists"));
            }
        });
    }

    public static boolean showRemoveEmptyChangeListsProposal(@NotNull Project project, final @NotNull VcsConfiguration config, @NotNull Collection<? extends ChangeList> lists) {
        if (project == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(3);
        }
        if (config == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(4);
        }
        if (lists == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(5);
        }
        if (lists.isEmpty()) {
            return false;
        }
        String question = lists.size() == 1 ? String.format("<html>The empty changelist '%s' is no longer active.<br>Do you want to remove it?</html>", StringUtil.first((String)lists.iterator().next().getName(), (int)30, (boolean)true)) : String.format("<html>Empty changelists<br/>%s are no longer active.<br>Do you want to remove them?</html>", StringUtil.join(lists, list2 -> StringUtil.first((String)list2.getName(), (int)30, (boolean)true), (String)"<br/>"));
        VcsConfirmationDialog dialog2 = new VcsConfirmationDialog(project, "Remove Empty Changelist", "Remove", "Cancel", new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return config.REMOVE_EMPTY_INACTIVE_CHANGELISTS;
            }

            public void setValue(VcsShowConfirmationOption.Value value) {
                config.REMOVE_EMPTY_INACTIVE_CHANGELISTS = value;
            }

            public boolean isPersistent() {
                return true;
            }
        }, question, "&Remember my choice");
        return dialog2.showAndGet();
    }

    @Override
    public void blockModalNotifications() {
        this.myModalNotificationsBlocked = true;
    }

    @Override
    public void unblockModalNotifications() {
        this.myModalNotificationsBlocked = false;
        this.deleteEmptyChangeLists(this.myListsToBeDeleted);
        this.myListsToBeDeleted.clear();
    }

    public void projectOpened() {
        this.initializeForNewProject();
        VcsListener vcsListener = new VcsListener(){

            public void directoryMappingChanged() {
                VcsDirtyScopeManager.getInstance((Project)ChangeListManagerImpl.this.myProject).markEverythingDirty();
            }
        };
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myUpdater.initialized();
            this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
        } else {
            ((ProjectLevelVcsManagerImpl)vcsManager).addInitializationRequest(VcsInitObject.CHANGE_LIST_MANAGER, (Runnable)((DumbAwareRunnable)() -> {
                this.myUpdater.initialized();
                this.broadcastStateAfterLoad();
                this.myProject.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)vcsListener);
            }));
            this.myConflictTracker.startTracking();
        }
    }

    private void broadcastStateAfterLoad() {
        List listCopy = this.getChangeListsCopy();
        if (!this.myProject.isDisposed()) {
            ((LocalChangeListsLoadedListener)this.myProject.getMessageBus().syncPublisher(LISTS_LOADED)).processLoadedLists(listCopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeForNewProject() {
        Object object = this.myDataLock;
        synchronized (object) {
            if (!Registry.is((String)"ide.hide.excluded.files") && !this.myExcludedConvertedToIgnored) {
                this.convertExcludedToIgnored();
                this.myExcludedConvertedToIgnored = true;
            }
        }
    }

    void convertExcludedToIgnored() {
        for (DirectoryIndexExcludePolicy policy : (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            for (VirtualFile file2 : policy.getExcludeRootsForProject()) {
                this.addDirectoryToIgnoreImplicitly(file2.getPath());
            }
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (String url : ModuleRootManager.getInstance((Module)module).getExcludeRootUrls()) {
                VirtualFile file3 = virtualFileManager.findFileByUrl(url);
                if (file3 != null && !fileIndex.isExcluded(file3)) continue;
                this.addDirectoryToIgnoreImplicitly(VfsUtilCore.urlToPath((String)url));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectClosed() {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateChangesProgressIndicator.cancel();
        }
        this.myUpdater.stop();
        this.myConflictTracker.stopTracking();
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("ChangeListManager" == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(6);
        }
        return "ChangeListManager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChangeTracker(@NotNull FilePath filePath, @NotNull ChangeListWorker.PartialChangeTracker tracker) {
        if (filePath == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(7);
        }
        if (tracker == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(8);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myWorker.registerChangeTracker(filePath, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterChangeTracker(@NotNull FilePath filePath, @NotNull ChangeListWorker.PartialChangeTracker tracker) {
        if (filePath == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(9);
        }
        if (tracker == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(10);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myWorker.unregisterChangeTracker(filePath, tracker);
        }
    }

    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title, @Nullable ModalityState state) {
        if (afterUpdate == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(11);
        }
        if (mode == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(12);
        }
        this.invokeAfterUpdate(afterUpdate, mode, title, null, state);
    }

    public void invokeAfterUpdate(@NotNull Runnable afterUpdate, @NotNull InvokeAfterUpdateMode mode, @Nullable String title, @Nullable Consumer<VcsDirtyScopeManager> dirtyScopeManagerFiller, @Nullable ModalityState state) {
        if (afterUpdate == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(13);
        }
        if (mode == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(14);
        }
        if (dirtyScopeManagerFiller != null && !this.myProject.isDisposed()) {
            dirtyScopeManagerFiller.consume((Object)VcsDirtyScopeManager.getInstance((Project)this.myProject));
        }
        this.myUpdater.invokeAfterUpdate(afterUpdate, mode, title, state);
    }

    @Override
    public void freeze(@NotNull String reason) {
        if (reason == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(15);
        }
        this.myUpdater.setIgnoreBackgroundOperation(true);
        Semaphore sem = new Semaphore();
        sem.down();
        this.invokeAfterUpdate(() -> {
            if (reason == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(114);
            }
            this.myUpdater.setIgnoreBackgroundOperation(false);
            this.myUpdater.pause();
            this.myFreezeName = reason;
            sem.up();
        }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, "", ModalityState.defaultModalityState());
        boolean free = false;
        while (!free) {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            if (pi != null) {
                pi.checkCanceled();
            }
            free = sem.waitFor(500L);
        }
    }

    @Override
    public void unfreeze() {
        this.myUpdater.go();
        this.myFreezeName = null;
    }

    public String isFreezed() {
        return this.myFreezeName;
    }

    public void executeOnUpdaterThread(@NotNull Runnable r) {
        if (r == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(16);
        }
        this.myScheduler.submit(r);
    }

    public void executeUnderDataLock(@NotNull Runnable r) {
        if (r == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (r == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(113);
            }
            Object object = this.myDataLock;
            synchronized (object) {
                r.run();
            }
        });
    }

    public void scheduleUpdate() {
        this.myUpdater.schedule();
    }

    public void scheduleUpdate(boolean updateUnversionedFiles) {
        this.myUpdater.schedule();
    }

    private void filterOutIgnoredFiles(List<VcsDirtyScope> scopes) {
        HashSet refreshFiles = new HashSet();
        try {
            ReadAction.run(() -> {
                Object object = this.myDataLock;
                synchronized (object) {
                    IgnoredFilesCompositeHolder fileHolder = this.myComposite.getIgnoredFileHolder();
                    Iterator iterator = scopes.iterator();
                    while (iterator.hasNext()) {
                        VcsModifiableDirtyScope scope = (VcsModifiableDirtyScope)iterator.next();
                        VcsDirtyScopeModifier modifier = scope.getModifier();
                        if (modifier == null) continue;
                        fileHolder.notifyVcsStarted(scope.getVcs());
                        this.filterOutIgnoredFiles(modifier.getDirtyFilesIterator(), fileHolder, refreshFiles);
                        for (VirtualFile root : modifier.getAffectedVcsRoots()) {
                            this.filterOutIgnoredFiles(modifier.getDirtyDirectoriesIterator(root), fileHolder, refreshFiles);
                        }
                        modifier.recheckDirtyKeys();
                        if (!scope.isEmpty()) continue;
                        iterator.remove();
                    }
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (AssertionError | Exception ex) {
            LOG.error((Throwable)ex);
        }
        for (VirtualFile file2 : refreshFiles) {
            this.myFileStatusManager.fileStatusChanged(file2);
        }
    }

    private void filterOutIgnoredFiles(Iterator<FilePath> iterator, IgnoredFilesCompositeHolder fileHolder, Set<VirtualFile> refreshFiles) {
        while (iterator.hasNext()) {
            VirtualFile file2 = iterator.next().getVirtualFile();
            if (file2 == null || !this.isIgnoredFile(file2)) continue;
            iterator.remove();
            fileHolder.addFile(file2);
            refreshFiles.add(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateImmediately() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        if (!vcsManager.hasActiveVcss()) {
            return;
        }
        VcsInvalidated invalidated = this.myDirtyScopeManager.retrieveScopes();
        if (this.checkScopeIsEmpty(invalidated)) {
            this.myDirtyScopeManager.changesProcessed();
            return;
        }
        boolean wasEverythingDirty = invalidated.isEverythingDirty();
        List scopes = invalidated.getScopes();
        try {
            boolean takeChanges;
            DataHolder dataHolder;
            if (this.myUpdater.isStopped()) {
                return;
            }
            ProgressIndicator indicator = ChangeListManagerImpl.createProgressIndicator();
            Object object = this.myDataLock;
            synchronized (object) {
                dataHolder = new DataHolder(this.myComposite.copy(), new ChangeListWorker.ChangeListUpdater(this.myWorker), wasEverythingDirty);
                this.myModifier.enterUpdate();
                if (wasEverythingDirty) {
                    this.myUpdateException = null;
                    this.myAdditionalInfo = null;
                }
                this.myUpdateChangesProgressIndicator = indicator;
                if (LOG.isDebugEnabled()) {
                    String scopeInString = StringUtil.join((Collection)scopes, scope -> scope.toString(), (String)"->\n");
                    LOG.debug("refresh procedure started, everything: " + wasEverythingDirty + " dirty scope: " + scopeInString + "\ncurrent changes: " + this.myWorker);
                }
            }
            dataHolder.notifyStart();
            this.myChangesViewManager.scheduleRefresh();
            ProgressManager.getInstance().runProcess(() -> this.iterateScopes(dataHolder, scopes, wasEverythingDirty, indicator), indicator);
            Iterator iterator = this.myDataLock;
            synchronized (iterator) {
                takeChanges = this.myUpdateException == null;
            }
            if (takeChanges) {
                this.updateIgnoredFiles(dataHolder.getComposite());
            }
            ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                this.clearCurrentRevisionsCache(invalidated);
                Object object = this.myDataLock;
                synchronized (object) {
                    dataHolder.notifyEnd();
                    if (takeChanges) {
                        ChangeListWorker updatedWorker = dataHolder.getChangeListUpdater().finish();
                        this.myModifier.finishUpdate(updatedWorker);
                        this.myWorker.applyChangesFromUpdate(updatedWorker, this.myDeltaForwarder);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("refresh procedure finished, unversioned size: " + dataHolder.getComposite().getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles().size() + "\nchanges: " + this.myWorker);
                        }
                        boolean statusChanged = !this.myComposite.equals(dataHolder.getComposite());
                        this.myComposite = dataHolder.getComposite();
                        if (statusChanged) {
                            this.myDelayedNotificator.unchangedFileStatusChanged();
                        }
                    } else {
                        this.myModifier.finishUpdate(null);
                    }
                    this.myShowLocalChangesInvalidated = false;
                }
            });
            for (VcsDirtyScope scope2 : scopes) {
                AbstractVcs vcs = scope2.getVcs();
                if (vcs == null || !vcs.isTrackingUnchangedContent()) continue;
                scope2.iterateExistingInsideScope(file2 -> {
                    LastUnchangedContentTracker.markUntouched(file2);
                    return true;
                });
            }
            this.myChangesViewManager.scheduleRefresh();
        }
        catch (ProcessCanceledException dataHolder2) {
            this.myDirtyScopeManager.changesProcessed();
            Object dataHolder2 = this.myDataLock;
            synchronized (dataHolder2) {
                this.myDelayedNotificator.changeListUpdateDone();
                this.myChangesViewManager.scheduleRefresh();
            }
        }
        catch (AssertionError | Exception ex) {
            LOG.error((Throwable)ex);
        }
        finally {
            this.myDirtyScopeManager.changesProcessed();
            Object object = this.myDataLock;
            synchronized (object) {
                this.myDelayedNotificator.changeListUpdateDone();
                this.myChangesViewManager.scheduleRefresh();
            }
        }
    }

    private boolean checkScopeIsEmpty(VcsInvalidated invalidated) {
        if (invalidated == null) {
            return true;
        }
        if (invalidated.isEverythingDirty()) {
            return false;
        }
        if (invalidated.isEmpty()) {
            return true;
        }
        this.filterOutIgnoredFiles(invalidated.getScopes());
        return invalidated.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateScopes(DataHolder dataHolder, List<VcsDirtyScope> scopes, boolean wasEverythingDirty, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(18);
        }
        ChangeListWorker.ChangeListUpdater updater = dataHolder.getChangeListUpdater();
        Getter disposedGetter = () -> this.myProject.isDisposed() || this.myUpdater.isStopped();
        UpdatingChangeListBuilder builder = new UpdatingChangeListBuilder(updater, dataHolder.getComposite(), (Getter<Boolean>)disposedGetter, this);
        for (VcsDirtyScope scope : scopes) {
            indicator.checkCanceled();
            AbstractVcs vcs = scope.getVcs();
            if (vcs == null) continue;
            scope.setWasEverythingDirty(wasEverythingDirty);
            this.myChangesViewManager.setBusy(true);
            this.actualUpdate(builder, scope, vcs, dataHolder, updater, indicator);
            Object object = this.myDataLock;
            synchronized (object) {
                if (this.myUpdateException != null) {
                    break;
                }
            }
        }
        Object object = this.myDataLock;
        synchronized (object) {
            if (this.myAdditionalInfo == null) {
                this.myAdditionalInfo = builder.getAdditionalInfo();
            }
        }
    }

    private void clearCurrentRevisionsCache(VcsInvalidated invalidated) {
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance((Project)this.myProject).getContentRevisionCache();
        if (invalidated.isEverythingDirty()) {
            cache.clearAllCurrent();
        } else {
            cache.clearScope(invalidated.getScopes());
        }
    }

    @NotNull
    private static ProgressIndicator createProgressIndicator() {
        EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
        if (emptyProgressIndicator == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(19);
        }
        return emptyProgressIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualUpdate(@NotNull UpdatingChangeListBuilder builder, @NotNull VcsDirtyScope scope, @NotNull AbstractVcs vcs, @NotNull DataHolder dataHolder, @NotNull ChangeListManagerGate gate, @NotNull ProgressIndicator indicator) {
        if (builder == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(21);
        }
        if (vcs == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(22);
        }
        if (dataHolder == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(23);
        }
        if (gate == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(25);
        }
        dataHolder.notifyStartProcessingChanges((VcsModifiableDirtyScope)scope);
        try {
            ChangeProvider changeProvider = vcs.getChangeProvider();
            if (changeProvider != null) {
                builder.setCurrent(scope);
                changeProvider.getChanges(scope, (ChangelistBuilder)builder, indicator, gate);
            }
        }
        catch (VcsException e) {
            this.handleUpdateException(e);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.debug(t);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        finally {
            if (!this.myUpdater.isStopped()) {
                dataHolder.notifyDoneProcessingChanges();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUpdateException(VcsException e) {
        LOG.info((Throwable)e);
        if (e instanceof VcsConnectionProblem) {
            ApplicationManager.getApplication().invokeLater(() -> ((VcsConnectionProblem)e).attemptQuickFix(false));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
            if (helper instanceof AbstractVcsHelperImpl && ((AbstractVcsHelperImpl)helper).handleCustom(e)) {
                return;
            }
            e.printStackTrace();
        }
        Object object = this.myDataLock;
        synchronized (object) {
            this.myUpdateException = e;
        }
    }

    public static boolean isUnder(Change change, VcsDirtyScope scope) {
        ContentRevision before = change.getBeforeRevision();
        ContentRevision after = change.getAfterRevision();
        return before != null && scope.belongsTo(before.getFile()) || after != null && scope.belongsTo(after.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<LocalChangeList> getChangeLists() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<LocalChangeList> list2 = this.myWorker.getChangeLists();
        // MONITOREXIT : object
        if (list2 != null) return list2;
        ChangeListManagerImpl.$$$reportNull$$$0(26);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<File> getAffectedPaths() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<File> list2 = this.myWorker.getAffectedPaths();
        // MONITOREXIT : object
        if (list2 != null) return list2;
        ChangeListManagerImpl.$$$reportNull$$$0(27);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<VirtualFile> list2 = this.myWorker.getAffectedFiles();
        // MONITOREXIT : object
        if (list2 != null) return list2;
        ChangeListManagerImpl.$$$reportNull$$$0(28);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Change> getAllChanges() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        Collection<Change> collection = this.myWorker.getAllChanges();
        // MONITOREXIT : object
        if (collection != null) return collection;
        ChangeListManagerImpl.$$$reportNull$$$0(29);
        return collection;
    }

    @NotNull
    public List<VirtualFile> getUnversionedFiles() {
        List list2 = (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles();
            }
        });
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @NotNull
    public List<VirtualFile> getModifiedWithoutEditing() {
        List list2 = (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).getFiles();
            }
        });
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(31);
        }
        return list2;
    }

    @NotNull
    public List<VirtualFile> getIgnoredFiles() {
        List list2 = (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return new ArrayList<VirtualFile>(this.myComposite.getIgnoredFileHolder().values());
            }
        });
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(32);
        }
        return list2;
    }

    boolean isIgnoredInUpdateMode() {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getIgnoredFileHolder().isInUpdatingMode();
            }
        });
    }

    public List<VirtualFile> getLockedFolders() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getVFHolder(FileHolder.HolderType.LOCKED).getFiles();
            }
        });
    }

    Map<VirtualFile, LogicalLock> getLogicallyLockedFolders() {
        return (Map)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return new HashMap<VirtualFile, LogicalLock>(this.myComposite.getLogicallyLockedFileHolder().getMap());
            }
        });
    }

    public boolean isLogicallyLocked(VirtualFile file2) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getLogicallyLockedFileHolder().containsKey(file2);
            }
        });
    }

    public boolean isContainedInLocallyDeleted(FilePath filePath) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getDeletedFileHolder().isContainedInLocallyDeleted(filePath);
            }
        });
    }

    public List<LocallyDeletedChange> getDeletedFiles() {
        return (List)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getDeletedFileHolder().getFiles();
            }
        });
    }

    MultiMap<String, VirtualFile> getSwitchedFilesMap() {
        return (MultiMap)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getSwitchedFileHolder().getBranchToFileMap();
            }
        });
    }

    @Nullable
    Map<VirtualFile, String> getSwitchedRoots() {
        return (Map)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getRootSwitchFileHolder().getFilesMapCopy();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsException getUpdateException() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myUpdateException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Factory<JComponent> getAdditionalUpdateInfo() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myAdditionalInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileAffected(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(33);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getStatus(file2) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList findChangeList(String name) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListByName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeList getChangeList(String id) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListById(id);
        }
    }

    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(34);
        }
        return this.addChangeList(name, comment, null);
    }

    @Override
    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment, @Nullable ChangeListData data) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(35);
        }
        LocalChangeList localChangeList = (LocalChangeList)ReadAction.compute(() -> {
            if (name == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(112);
            }
            Object object = this.myDataLock;
            synchronized (object) {
                LocalChangeList changeList = this.myModifier.addChangeList(name, comment, data);
                this.myChangesViewManager.scheduleRefresh();
                return changeList;
            }
        });
        if (localChangeList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(36);
        }
        return localChangeList;
    }

    public void removeChangeList(@NotNull String name) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(37);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (name == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(111);
            }
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.removeChangeList(name);
                this.myChangesViewManager.scheduleRefresh();
            }
        });
    }

    public void removeChangeList(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(38);
        }
        this.removeChangeList(list2.getName());
    }

    public void setDefaultChangeList(@NotNull String name) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(39);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (name == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(110);
            }
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.setDefault(name);
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    public void setDefaultChangeList(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(40);
        }
        this.setDefaultChangeList(list2.getName());
    }

    public boolean setReadOnly(@NotNull String name, boolean value) {
        if (name == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(41);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (name == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(109);
            }
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.setReadOnly(name, value);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(42);
        }
        if (toName == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(43);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (fromName == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(107);
            }
            if (toName == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(108);
            }
            Object object = this.myDataLock;
            synchronized (object) {
                boolean result2 = this.myModifier.editName(fromName, toName);
                this.myChangesViewManager.scheduleRefresh();
                return result2;
            }
        });
    }

    public String editComment(@NotNull String fromName, String newComment) {
        if (fromName == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(44);
        }
        return (String)ReadAction.compute(() -> {
            if (fromName == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(106);
            }
            Object object = this.myDataLock;
            synchronized (object) {
                String oldComment = this.myModifier.editComment(fromName, StringUtil.notNullize((String)newComment));
                this.myChangesViewManager.scheduleRefresh();
                return oldComment;
            }
        });
    }

    @Override
    public void moveChangesTo(@NotNull LocalChangeList list2, Change ... changes) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(45);
        }
        if (changes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(46);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (list2 == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(104);
            }
            if (changes == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(105);
            }
            Object object = this.myDataLock;
            synchronized (object) {
                this.myModifier.moveChangesTo(list2.getName(), changes);
            }
        });
        this.myChangesViewManager.scheduleRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public LocalChangeList getDefaultChangeList() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        LocalChangeList localChangeList = this.myWorker.getDefaultList();
        // MONITOREXIT : object
        if (localChangeList != null) return localChangeList;
        ChangeListManagerImpl.$$$reportNull$$$0(47);
        return localChangeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public String getDefaultListName() {
        Object object = this.myDataLock;
        // MONITORENTER : object
        String string = this.myWorker.getDefaultList().getName();
        // MONITOREXIT : object
        if (string != null) return string;
        ChangeListManagerImpl.$$$reportNull$$$0(48);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Collection<LocalChangeList> getAffectedLists(@NotNull Collection<Change> changes) {
        if (changes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(49);
        }
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<LocalChangeList> list2 = this.myWorker.getAffectedLists(changes);
        // MONITOREXIT : object
        if (list2 != null) return list2;
        ChangeListManagerImpl.$$$reportNull$$$0(50);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LocalChangeList getChangeList(@NotNull Change change) {
        if (change == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(51);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            List<LocalChangeList> lists = this.myWorker.getAffectedLists(change);
            return (LocalChangeList)ContainerUtil.getFirstItem(lists);
        }
    }

    public void notifyChangelistsChanged() {
        this.myWorker.notifyChangelistsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChangeListNameIfOnlyOne(Change[] changes) {
        Object object = this.myDataLock;
        synchronized (object) {
            List<LocalChangeList> lists = this.myWorker.getAffectedLists(Arrays.asList(changes));
            return lists.size() == 1 ? lists.get(0).getName() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInUpdate() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myModifier.isInsideUpdate() || this.myShowLocalChangesInvalidated;
        }
    }

    @Nullable
    public Change getChange(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(52);
        }
        return this.getChange(VcsUtil.getFilePath((VirtualFile)file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeList getChangeList(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(53);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            Change change = this.myWorker.getChangeForPath(VcsUtil.getFilePath((VirtualFile)file2));
            if (change == null) {
                return null;
            }
            return this.getChangeList(change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Change getChange(FilePath file2) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeForPath(file2);
        }
    }

    public boolean isUnversioned(VirtualFile file2) {
        return (Boolean)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file2);
            }
        });
    }

    @NotNull
    public FileStatus getStatus(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(54);
        }
        FileStatus fileStatus = (FileStatus)ReadAction.compute(() -> {
            if (file2 == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(103);
            }
            Object object = this.myDataLock;
            synchronized (object) {
                boolean switched;
                if (this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).containsFile(file2)) {
                    return FileStatus.UNKNOWN;
                }
                if (this.myComposite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING).containsFile(file2)) {
                    return FileStatus.HIJACKED;
                }
                if (this.myComposite.getIgnoredFileHolder().containsFile(file2)) {
                    return FileStatus.IGNORED;
                }
                FileStatus status = (FileStatus)ObjectUtils.notNull((Object)this.myWorker.getStatus(file2), (Object)FileStatus.NOT_CHANGED);
                if (FileStatus.NOT_CHANGED.equals(status) && (switched = this.myComposite.getSwitchedFileHolder().containsFile(file2))) {
                    return FileStatus.SWITCHED;
                }
                return status;
            }
        });
        if (fileStatus == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(55);
        }
        return fileStatus;
    }

    @NotNull
    public Collection<Change> getChangesIn(@NotNull VirtualFile dir) {
        if (dir == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(56);
        }
        Collection<Change> collection = this.getChangesIn(VcsUtil.getFilePath((VirtualFile)dir));
        if (collection == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(57);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ThreeState haveChangesUnder(@NotNull VirtualFile vf) {
        if (vf == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(58);
        }
        if (vf.isValid() && vf.isDirectory()) {
            Object object = this.myDataLock;
            // MONITORENTER : object
            ThreeState threeState = this.myWorker.haveChangesUnder(vf);
            // MONITOREXIT : object
            if (threeState != null) return threeState;
            ChangeListManagerImpl.$$$reportNull$$$0(60);
            return threeState;
        }
        ThreeState threeState = ThreeState.NO;
        if (threeState != null) return threeState;
        ChangeListManagerImpl.$$$reportNull$$$0(59);
        return threeState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<Change> getChangesIn(@NotNull FilePath dirPath) {
        if (dirPath == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(61);
        }
        Object object = this.myDataLock;
        // MONITORENTER : object
        List<Change> list2 = this.myWorker.getChangesUnder(dirPath);
        // MONITOREXIT : object
        if (list2 != null) return list2;
        ChangeListManagerImpl.$$$reportNull$$$0(62);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public AbstractVcs getVcsFor(@NotNull Change change) {
        VcsKey key;
        if (change == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(63);
        }
        Object object = this.myDataLock;
        synchronized (object) {
            key = this.myWorker.getVcsFor(change);
        }
        return key != null ? ProjectLevelVcsManager.getInstance((Project)this.myProject).findVcsByName(key.getName()) : null;
    }

    @Override
    public void addUnversionedFiles(@NotNull LocalChangeList list2, @NotNull List<VirtualFile> files) {
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(64);
        }
        if (files == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(65);
        }
        this.addUnversionedFiles(list2, files, ChangeListManagerImpl.getDefaultUnversionedFileCondition(), null);
    }

    @Deprecated
    @NotNull
    public List<VcsException> addUnversionedFiles(@NotNull LocalChangeList list2, @NotNull List<VirtualFile> files, @NotNull Condition<FileStatus> statusChecker, @Nullable Consumer<List<Change>> changesConsumer) {
        boolean syncUpdateRequired;
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(66);
        }
        if (files == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(67);
        }
        if (statusChecker == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(68);
        }
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        HashSet allProcessedFiles = new HashSet();
        ChangesUtil.processVirtualFilesByVcs((Project)this.myProject, files, (vcs, items) -> {
            CheckinEnvironment environment;
            if (statusChecker == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(102);
            }
            if ((environment = vcs.getCheckinEnvironment()) != null) {
                final Set<VirtualFile> descendants = this.getUnversionedDescendantsRecursively(items, statusChecker);
                Set<VirtualFile> parents = this.getUnversionedParents(vcs, items, statusChecker);
                final ArrayList result2 = ContainerUtil.newArrayList();
                ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, "Adding Files to VCS...", true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        indicator.setIndeterminate(true);
                        List exs = environment.scheduleUnversionedFilesForAddition((List)ContainerUtil.newArrayList((Iterable)descendants));
                        if (exs != null) {
                            ContainerUtil.addAll((Collection)result2, (Iterable)exs);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$6", "run"));
                    }
                });
                allProcessedFiles.addAll(descendants);
                allProcessedFiles.addAll(parents);
                exceptions.addAll(result2);
            }
        });
        if (!exceptions.isEmpty()) {
            StringBuilder message = new StringBuilder(VcsBundle.message((String)"error.adding.files.prompt", (Object[])new Object[0]));
            for (VcsException ex : exceptions) {
                message.append("\n").append(ex.getMessage());
            }
            Messages.showErrorDialog((Project)this.myProject, (String)message.toString(), (String)VcsBundle.message((String)"error.adding.files.title", (Object[])new Object[0]));
        }
        for (VirtualFile file2 : allProcessedFiles) {
            this.myFileStatusManager.fileStatusChanged(file2);
        }
        VcsDirtyScopeManager.getInstance((Project)this.myProject).filesDirty(allProcessedFiles, null);
        Ref foundChanges = Ref.create();
        boolean moveRequired = !list2.isDefault();
        boolean bl = syncUpdateRequired = changesConsumer != null;
        if (moveRequired || syncUpdateRequired) {
            InvokeAfterUpdateMode updateMode = syncUpdateRequired ? InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE : InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE;
            this.invokeAfterUpdate(() -> {
                if (list2 == null) {
                    ChangeListManagerImpl.$$$reportNull$$$0(100);
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (list2 == null) {
                        ChangeListManagerImpl.$$$reportNull$$$0(101);
                    }
                    Object object = this.myDataLock;
                    synchronized (object) {
                        List newChanges = ContainerUtil.filter((Collection)this.getDefaultChangeList().getChanges(), change -> {
                            FilePath path = ChangesUtil.getAfterPath((Change)change);
                            return path != null && allProcessedFiles.contains(path.getVirtualFile());
                        });
                        foundChanges.set((Object)newChanges);
                        if (moveRequired && !newChanges.isEmpty()) {
                            this.moveChangesTo(list2, newChanges.toArray(new Change[0]));
                        }
                    }
                });
                this.myChangesViewManager.scheduleRefresh();
            }, updateMode, VcsBundle.message((String)"change.lists.manager.add.unversioned", (Object[])new Object[0]), null);
            if (changesConsumer != null) {
                changesConsumer.consume(foundChanges.get());
            }
        } else {
            this.myChangesViewManager.scheduleRefresh();
        }
        ArrayList<VcsException> arrayList = exceptions;
        if (arrayList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(69);
        }
        return arrayList;
    }

    @NotNull
    public static Condition<FileStatus> getDefaultUnversionedFileCondition() {
        Condition condition = status -> status == FileStatus.UNKNOWN;
        if (condition == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(70);
        }
        return condition;
    }

    @NotNull
    private Set<VirtualFile> getUnversionedDescendantsRecursively(@NotNull List<VirtualFile> items, @NotNull Condition<FileStatus> condition) {
        if (items == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(71);
        }
        if (condition == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(72);
        }
        HashSet result2 = ContainerUtil.newHashSet();
        Processor addToResultProcessor = file2 -> {
            if (condition == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(99);
            }
            if (condition.value((Object)this.getStatus((VirtualFile)file2))) {
                result2.add(file2);
            }
            return true;
        };
        for (VirtualFile item : items) {
            VcsRootIterator.iterateVfUnderVcsRoot(this.myProject, item, (Processor<VirtualFile>)addToResultProcessor);
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(73);
        }
        return hashSet;
    }

    @NotNull
    private Set<VirtualFile> getUnversionedParents(@NotNull AbstractVcs vcs, @NotNull Collection<VirtualFile> items, @NotNull Condition<FileStatus> condition) {
        if (vcs == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(74);
        }
        if (items == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(75);
        }
        if (condition == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(76);
        }
        if (!vcs.areDirectoriesVersionedItems()) {
            Set<VirtualFile> set2 = Collections.emptySet();
            if (set2 == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(77);
            }
            return set2;
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (VirtualFile item : items) {
            for (VirtualFile parent = item.getParent(); parent != null && condition.value((Object)this.getStatus(parent)); parent = parent.getParent()) {
                result2.add(parent);
            }
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(78);
        }
        return hashSet;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public void addChangeListListener(@NotNull ChangeListListener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(79);
        }
        if (disposable == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(80);
        }
        this.myListeners.addListener((EventListener)listener2, disposable);
    }

    public void addChangeListListener(@NotNull ChangeListListener listener2) {
        if (listener2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(81);
        }
        this.myListeners.addListener((EventListener)listener2);
    }

    public void removeChangeListListener(@NotNull ChangeListListener listener2) {
        if (listener2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(82);
        }
        this.myListeners.removeListener((EventListener)listener2);
    }

    public void registerCommitExecutor(@NotNull CommitExecutor executor) {
        if (executor == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(83);
        }
        this.myRegisteredCommitExecutors.add(executor);
    }

    public void commitChanges(@NotNull LocalChangeList changeList, @NotNull List<Change> changes) {
        if (changeList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(84);
        }
        if (changes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(85);
        }
        this.doCommit(changeList, changes, false);
    }

    private boolean doCommit(LocalChangeList changeList, List<Change> changes, boolean synchronously) {
        FileDocumentManager.getInstance().saveAllDocuments();
        return new CommitHelper(this.myProject, (ChangeList)changeList, changes, changeList.getName(), StringUtil.isEmpty((String)changeList.getComment()) ? changeList.getName() : changeList.getComment(), new ArrayList<CheckinHandler>(), false, synchronously, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null, false, null).doCommit();
    }

    public boolean commitChangesSynchronouslyWithResult(@NotNull LocalChangeList changeList, @NotNull List<Change> changes) {
        if (changeList == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(86);
        }
        if (changes == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(87);
        }
        return this.doCommit(changeList, changes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element element) {
        if (element == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(88);
        }
        if (this.myProject.isDefault()) {
            return;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            ChangeListManagerSerialization.readExternal(element, this.myIgnoredIdeaLevel, this.myWorker);
        }
        this.myExcludedConvertedToIgnored = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)EXCLUDED_CONVERTED_TO_IGNORED_OPTION));
        this.myConflictTracker.loadState(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element getState() {
        ChangeListWorker worker;
        IgnoredFilesComponent ignoredFilesComponent;
        Element element = new Element("state");
        if (this.myProject.isDefault()) {
            return element;
        }
        Object object = this.myDataLock;
        synchronized (object) {
            ignoredFilesComponent = this.myIgnoredIdeaLevel.copy();
            worker = this.myWorker.copy();
        }
        ChangeListManagerSerialization.writeExternal(element, ignoredFilesComponent, worker);
        JDOMExternalizerUtil.writeField((Element)element, (String)EXCLUDED_CONVERTED_TO_IGNORED_OPTION, (String)Boolean.toString(this.myExcludedConvertedToIgnored), (String)Boolean.toString(false));
        this.myConflictTracker.saveState(element);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenFiles(@NotNull List<FilePath> paths) {
        if (paths == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(89);
        }
        ReadonlyStatusHandlerImpl readonlyStatusHandler = (ReadonlyStatusHandlerImpl)ReadonlyStatusHandler.getInstance((Project)this.myProject);
        boolean savedOption = readonlyStatusHandler.getState().SHOW_DIALOG;
        readonlyStatusHandler.getState().SHOW_DIALOG = false;
        try {
            readonlyStatusHandler.ensureFilesWritable(ContainerUtil.mapNotNull(paths, FilePath::getVirtualFile));
        }
        finally {
            readonlyStatusHandler.getState().SHOW_DIALOG = savedOption;
        }
    }

    @NotNull
    public List<CommitExecutor> getRegisteredExecutors() {
        List<CommitExecutor> list2 = Collections.unmodifiableList(this.myRegisteredCommitExecutors);
        if (list2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(90);
        }
        return list2;
    }

    public void addFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        if (filesToIgnore == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(91);
        }
        this.myIgnoredIdeaLevel.add(filesToIgnore);
        this.scheduleUnversionedUpdate();
    }

    public void addDirectoryToIgnoreImplicitly(@NotNull String path) {
        if (path == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(92);
        }
        this.myIgnoredIdeaLevel.addIgnoredDirectoryImplicitly(path, this.myProject);
    }

    public void removeImplicitlyIgnoredDirectory(@NotNull String path) {
        if (path == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(93);
        }
        this.myIgnoredIdeaLevel.removeImplicitlyIgnoredDirectory(path, this.myProject);
    }

    public IgnoredFilesComponent getIgnoredFilesComponent() {
        return this.myIgnoredIdeaLevel;
    }

    private void scheduleUnversionedUpdate() {
        Couple couple = (Couple)ReadAction.compute(() -> {
            Object object = this.myDataLock;
            synchronized (object) {
                List<VirtualFile> unversioned = this.myComposite.getVFHolder(FileHolder.HolderType.UNVERSIONED).getFiles();
                Collection<VirtualFile> ignored = this.myComposite.getIgnoredFileHolder().values();
                return Couple.of(unversioned, ignored);
            }
        });
        Collection unversioned = (Collection)couple.first;
        Collection ignored = (Collection)couple.second;
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        int ourPiecesLimit = 100;
        if (unversioned.size() + ignored.size() > 100) {
            vcsDirtyScopeManager.markEverythingDirty();
        } else {
            ArrayList<VirtualFile> dirs = new ArrayList<VirtualFile>();
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
            for (VirtualFile vf : ContainerUtil.concat((Iterable[])new Iterable[]{unversioned, ignored})) {
                if (vf.isDirectory()) {
                    dirs.add(vf);
                    continue;
                }
                files.add(vf);
            }
            vcsDirtyScopeManager.filesDirty(files, dirs);
        }
    }

    public void setFilesToIgnore(IgnoredFileBean ... filesToIgnore) {
        if (filesToIgnore == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(94);
        }
        this.myIgnoredIdeaLevel.set(filesToIgnore);
        this.scheduleUnversionedUpdate();
    }

    private void updateIgnoredFiles(FileHolderComposite composite) {
        VirtualFileHolder vfHolder = composite.getVFHolder(FileHolder.HolderType.UNVERSIONED);
        List<VirtualFile> unversionedFiles = vfHolder.getFiles();
        this.exchangeWithIgnored(composite, vfHolder, unversionedFiles);
        VirtualFileHolder vfModifiedHolder = composite.getVFHolder(FileHolder.HolderType.MODIFIED_WITHOUT_EDITING);
        List<VirtualFile> modifiedFiles = vfModifiedHolder.getFiles();
        this.exchangeWithIgnored(composite, vfModifiedHolder, modifiedFiles);
    }

    private void exchangeWithIgnored(FileHolderComposite composite, VirtualFileHolder vfHolder, List<VirtualFile> unversionedFiles) {
        for (VirtualFile file2 : unversionedFiles) {
            if (!this.isIgnoredFile(file2)) continue;
            vfHolder.removeFile(file2);
            composite.getIgnoredFileHolder().addFile(file2);
        }
    }

    @NotNull
    public IgnoredFileBean[] getFilesToIgnore() {
        IgnoredFileBean[] ignoredFileBeanArray = this.myIgnoredIdeaLevel.getFilesToIgnore();
        if (ignoredFileBeanArray == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(95);
        }
        return ignoredFileBeanArray;
    }

    public boolean isIgnoredFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(96);
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file2);
        return ContainerUtil.exists((Object[])IgnoredFileProvider.IGNORE_FILE.getExtensions(), it -> it.isIgnoredFile(this.myProject, filePath));
    }

    @Nullable
    public String getSwitchedBranch(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListManagerImpl.$$$reportNull$$$0(97);
        }
        return (String)ReadAction.compute(() -> {
            if (file2 == null) {
                ChangeListManagerImpl.$$$reportNull$$$0(98);
            }
            Object object = this.myDataLock;
            synchronized (object) {
                return this.myComposite.getSwitchedFileHolder().getBranchForFile(file2);
            }
        });
    }

    public void waitUntilRefreshed() {
        VcsDirtyScopeVfsListener.getInstance(this.myProject).flushDirt();
        this.myUpdater.waitUntilRefreshed();
        this.waitUpdateAlarm();
    }

    private void waitUpdateAlarm() {
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.myScheduler.submit(() -> semaphore.up());
        semaphore.waitFor();
    }

    public void stopEveryThingIfInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        Future future2 = (Future)this.myScheduler.myLastTask.get();
        if (future2 != null) {
            future2.cancel(true);
            this.myScheduler.myLastTask.compareAndSet(future2, null);
        }
    }

    public void waitEverythingDoneInTestMode() {
        Future future2;
        assert (ApplicationManager.getApplication().isUnitTestMode());
        while ((future2 = (Future)this.myScheduler.myLastTask.get()) != null) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            try {
                future2.get(10L, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error((Throwable)e);
            }
            catch (CancellationException | TimeoutException exception) {
            }
        }
    }

    public void forceGoInTestMode() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myUpdater.forceGo();
    }

    public boolean ensureUpToDate(boolean canBeCanceled) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.updateImmediately();
            return true;
        }
        VcsDirtyScopeVfsListener.getInstance(this.myProject).flushDirt();
        this.myUpdater.waitUntilRefreshed();
        this.waitUpdateAlarm();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChangeListsNumber() {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myWorker.getChangeListsNumber();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showLocalChangesInvalidated() {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myShowLocalChangesInvalidated = true;
        }
    }

    public ChangelistConflictTracker getConflictTracker() {
        return this.myConflictTracker;
    }

    public boolean isFreezedWithNotification(@Nullable String modalTitle) {
        String freezeReason = this.isFreezed();
        if (freezeReason == null) {
            return false;
        }
        if (modalTitle != null) {
            Messages.showErrorDialog((Project)this.myProject, (String)freezeReason, (String)modalTitle);
        } else {
            VcsBalloonProblemNotifier.showOverChangesView(this.myProject, freezeReason, MessageType.WARNING, new NamedRunnable[0]);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 47: 
            case 48: 
            case 50: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 69: 
            case 70: 
            case 73: 
            case 77: 
            case 78: 
            case 90: 
            case 95: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 47: 
            case 48: 
            case 50: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 69: 
            case 70: 
            case 73: 
            case 77: 
            case 78: 
            case 90: 
            case 95: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldList";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 47: 
            case 48: 
            case 50: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 69: 
            case 70: 
            case 73: 
            case 77: 
            case 78: 
            case 90: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterUpdate";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 15: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 16: 
            case 17: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 22: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gate";
                break;
            }
            case 33: 
            case 52: 
            case 53: 
            case 54: 
            case 96: 
            case 97: 
            case 98: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 38: 
            case 40: 
            case 45: 
            case 64: 
            case 66: 
            case 100: 
            case 101: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 42: 
            case 44: 
            case 106: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromName";
                break;
            }
            case 43: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 46: 
            case 49: 
            case 85: 
            case 87: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 51: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 68: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusChecker";
                break;
            }
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 72: 
            case 76: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 79: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 91: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToIgnore";
                break;
            }
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createProgressIndicator";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedPaths";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFiles";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedFiles";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedWithoutEditing";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredFiles";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "addChangeList";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultChangeList";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultListName";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedLists";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 57: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesIn";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "haveChangesUnder";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "addUnversionedFiles";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUnversionedFileCondition";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedDescendantsRecursively";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnversionedParents";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredExecutors";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToIgnore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAutomaticEmptyChangeListDeletion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteEmptyChangeLists";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showRemoveEmptyChangeListsProposal";
                break;
            }
            case 6: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 47: 
            case 48: 
            case 50: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 69: 
            case 70: 
            case 73: 
            case 77: 
            case 78: 
            case 90: 
            case 95: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerChangeTracker";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unregisterChangeTracker";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invokeAfterUpdate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "freeze";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "executeOnUpdaterThread";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "executeUnderDataLock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "iterateScopes";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "actualUpdate";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isFileAffected";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addChangeList";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeList";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultChangeList";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setReadOnly";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "editName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "editComment";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "moveChangesTo";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedLists";
                break;
            }
            case 51: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getChangeList";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getChange";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 56: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getChangesIn";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "haveChangesUnder";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addUnversionedFiles";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getUnversionedDescendantsRecursively";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getUnversionedParents";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListListener";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListListener";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "registerCommitExecutor";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "commitChanges";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "commitChangesSynchronouslyWithResult";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "reopenFiles";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToIgnore";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "addDirectoryToIgnoreImplicitly";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "removeImplicitlyIgnoredDirectory";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "setFilesToIgnore";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFile";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchedBranch";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSwitchedBranch$41";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getUnversionedDescendantsRecursively$38";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addUnversionedFiles$36";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$35";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addUnversionedFiles$33";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getStatus$32";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "lambda$moveChangesTo$30";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "lambda$editComment$29";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "lambda$editName$28";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setReadOnly$27";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setDefaultChangeList$26";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeChangeList$25";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addChangeList$24";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "lambda$executeUnderDataLock$5";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "lambda$freeze$4";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scheduleAutomaticEmptyChangeListDeletion$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 47: 
            case 48: 
            case 50: 
            case 55: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 69: 
            case 70: 
            case 73: 
            case 77: 
            case 78: 
            case 90: 
            case 95: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Scheduler {
        private final AtomicReference<Future> myLastTask = new AtomicReference();
        private final ScheduledExecutorService myExecutor = AppExecutorUtil.createBoundedScheduledExecutorService((String)"ChangeListManagerImpl pool", (int)1);

        Scheduler() {
        }

        /*
         * WARNING - void declaration
         */
        public void schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit timeUnit) {
            void unit;
            if (command == null) {
                Scheduler.$$$reportNull$$$0(0);
            }
            if (timeUnit == null) {
                Scheduler.$$$reportNull$$$0(1);
            }
            this.myLastTask.set(this.myExecutor.schedule(command, delay, (TimeUnit)unit));
        }

        public void submit(@NotNull Runnable command) {
            if (command == null) {
                Scheduler.$$$reportNull$$$0(2);
            }
            this.myLastTask.set(this.myExecutor.submit(command));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$Scheduler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "schedule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "submit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyChangesDeltaForwarder
    implements PlusMinusModify<BaseRevision> {
        private final RemoteRevisionsCache myRevisionsCache;
        private final ProjectLevelVcsManager myVcsManager;
        private final Project myProject;
        private final Scheduler myScheduler;

        public MyChangesDeltaForwarder(Project project, @NotNull Scheduler scheduler) {
            if (scheduler == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            this.myScheduler = scheduler;
            this.myRevisionsCache = RemoteRevisionsCache.getInstance(project);
            this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        }

        @Override
        public void modify(BaseRevision was, BaseRevision become) {
            this.doModify(was, become);
        }

        @Override
        public void plus(BaseRevision baseRevision) {
            this.doModify(baseRevision, baseRevision);
        }

        @Override
        public void minus(BaseRevision baseRevision) {
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(baseRevision);
                if (vcs != null) {
                    this.myRevisionsCache.minus((Pair<String, AbstractVcs>)Pair.create((Object)baseRevision.getPath(), (Object)vcs));
                }
                BackgroundTaskUtil.syncPublisher(this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED).dirty(baseRevision.getPath());
            });
        }

        private void doModify(BaseRevision was, BaseRevision become) {
            this.myScheduler.submit(() -> {
                AbstractVcs vcs = this.getVcs(was);
                if (vcs != null) {
                    this.myRevisionsCache.plus((Pair<String, AbstractVcs>)Pair.create((Object)was.getPath(), (Object)vcs));
                }
                BackgroundTaskUtil.syncPublisher(this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED).dirty(become);
            });
        }

        @Nullable
        private AbstractVcs getVcs(@NotNull BaseRevision baseRevision) {
            VcsKey vcsKey;
            if (baseRevision == null) {
                MyChangesDeltaForwarder.$$$reportNull$$$0(1);
            }
            if ((vcsKey = baseRevision.getVcs()) != null) {
                return this.myVcsManager.findVcsByName(vcsKey.getName());
            }
            return this.myVcsManager.getVcsFor(baseRevision.getFilePath());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheduler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseRevision";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$MyChangesDeltaForwarder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVcs";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DefaultIgnoredFileProvider
    implements IgnoredFileProvider {
        public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
            if (project == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                DefaultIgnoredFileProvider.$$$reportNull$$$0(1);
            }
            return ChangeListManagerImpl.getInstanceImpl(project).myIgnoredIdeaLevel.isIgnoredFile(filePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DefaultIgnoredFileProvider";
            objectArray[2] = "isIgnoredFile";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DataHolder {
        private final boolean myWasEverythingDirty;
        private final FileHolderComposite myComposite;
        private final ChangeListWorker.ChangeListUpdater myChangeListUpdater;

        private DataHolder(FileHolderComposite composite, ChangeListWorker.ChangeListUpdater changeListUpdater, boolean wasEverythingDirty) {
            this.myComposite = composite;
            this.myChangeListUpdater = changeListUpdater;
            this.myWasEverythingDirty = wasEverythingDirty;
        }

        private void notifyStart() {
            if (this.myWasEverythingDirty) {
                this.myComposite.cleanAll();
                this.myChangeListUpdater.notifyStartProcessingChanges(null);
            }
        }

        private void notifyStartProcessingChanges(@NotNull VcsModifiableDirtyScope scope) {
            if (scope == null) {
                DataHolder.$$$reportNull$$$0(0);
            }
            if (!this.myWasEverythingDirty) {
                this.myComposite.cleanAndAdjustScope(scope);
                this.myChangeListUpdater.notifyStartProcessingChanges(scope);
            }
            this.myComposite.notifyVcsStarted(scope.getVcs());
        }

        private void notifyDoneProcessingChanges() {
            if (!this.myWasEverythingDirty) {
                this.myChangeListUpdater.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator);
            }
        }

        void notifyEnd() {
            if (this.myWasEverythingDirty) {
                this.myChangeListUpdater.notifyDoneProcessingChanges(ChangeListManagerImpl.this.myDelayedNotificator);
            }
        }

        public FileHolderComposite getComposite() {
            return this.myComposite;
        }

        public ChangeListWorker.ChangeListUpdater getChangeListUpdater() {
            return this.myChangeListUpdater;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/openapi/vcs/changes/ChangeListManagerImpl$DataHolder", "notifyStartProcessingChanges"));
        }
    }
}

