/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.MoveChangesToAnotherListAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.ui.ChangelistMoveOfferDialog;
import com.intellij.openapi.vcs.changes.ui.DefaultCommitResultHandler;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ConfirmationDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitHelper {
    public static final Key<Object> DOCUMENT_BEING_COMMITTED_KEY = new Key("DOCUMENT_BEING_COMMITTED");
    private static final Logger LOG = Logger.getInstance(CommitHelper.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ChangeList myChangeList;
    @NotNull
    private final List<Change> myIncludedChanges;
    @NotNull
    private final String myActionName;
    @NotNull
    private final String myCommitMessage;
    @NotNull
    private final List<CheckinHandler> myHandlers;
    private final boolean myAllOfDefaultChangeListChangesIncluded;
    private final boolean myForceSyncCommit;
    @NotNull
    private final NullableFunction<Object, Object> myAdditionalData;
    @NotNull
    private final CommitResultHandler myResultHandler;
    @NotNull
    private final List<Document> myCommittingDocuments;
    @NotNull
    private final VcsConfiguration myConfiguration;
    @NotNull
    private final HashSet<String> myFeedback;
    @NotNull
    private final GeneralCommitProcessor myCommitProcessor;

    public CommitHelper(@NotNull Project project, @NotNull ChangeList changeList, @NotNull List<Change> includedChanges, @NotNull String actionName, @NotNull String commitMessage, @NotNull List<CheckinHandler> handlers, boolean allOfDefaultChangeListChangesIncluded, boolean synchronously, @NotNull NullableFunction<Object, Object> additionalDataHolder, @Nullable CommitResultHandler customResultHandler) {
        if (project == null) {
            CommitHelper.$$$reportNull$$$0(0);
        }
        if (changeList == null) {
            CommitHelper.$$$reportNull$$$0(1);
        }
        if (includedChanges == null) {
            CommitHelper.$$$reportNull$$$0(2);
        }
        if (actionName == null) {
            CommitHelper.$$$reportNull$$$0(3);
        }
        if (commitMessage == null) {
            CommitHelper.$$$reportNull$$$0(4);
        }
        if (handlers == null) {
            CommitHelper.$$$reportNull$$$0(5);
        }
        if (additionalDataHolder == null) {
            CommitHelper.$$$reportNull$$$0(6);
        }
        this(project, changeList, includedChanges, actionName, commitMessage, handlers, allOfDefaultChangeListChangesIncluded, synchronously, additionalDataHolder, customResultHandler, false, null);
    }

    public CommitHelper(@NotNull Project project, @NotNull ChangeList changeList, @NotNull List<Change> includedChanges, @NotNull String actionName, @NotNull String commitMessage, @NotNull List<CheckinHandler> handlers, boolean allOfDefaultChangeListChangesIncluded, boolean synchronously, @NotNull NullableFunction<Object, Object> additionalDataHolder, @Nullable CommitResultHandler resultHandler, boolean isAlien, @Nullable AbstractVcs vcs) {
        if (project == null) {
            CommitHelper.$$$reportNull$$$0(7);
        }
        if (changeList == null) {
            CommitHelper.$$$reportNull$$$0(8);
        }
        if (includedChanges == null) {
            CommitHelper.$$$reportNull$$$0(9);
        }
        if (actionName == null) {
            CommitHelper.$$$reportNull$$$0(10);
        }
        if (commitMessage == null) {
            CommitHelper.$$$reportNull$$$0(11);
        }
        if (handlers == null) {
            CommitHelper.$$$reportNull$$$0(12);
        }
        if (additionalDataHolder == null) {
            CommitHelper.$$$reportNull$$$0(13);
        }
        this.myCommittingDocuments = ContainerUtil.newArrayList();
        this.myFeedback = ContainerUtil.newHashSet();
        this.myProject = project;
        this.myChangeList = changeList;
        this.myIncludedChanges = includedChanges;
        this.myActionName = actionName;
        this.myCommitMessage = commitMessage;
        this.myHandlers = handlers;
        this.myAllOfDefaultChangeListChangesIncluded = allOfDefaultChangeListChangesIncluded;
        this.myForceSyncCommit = synchronously;
        this.myAdditionalData = additionalDataHolder;
        this.myConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myCommitProcessor = isAlien ? new AlienCommitProcessor((AbstractVcs)ObjectUtils.notNull((Object)vcs)) : new CommitProcessor(vcs);
        this.myResultHandler = (CommitResultHandler)ObjectUtils.notNull((Object)resultHandler, (Object)new DefaultCommitResultHandler(this.myProject, this.myIncludedChanges, this.myCommitMessage, this.myCommitProcessor, this.myFeedback));
    }

    public boolean doCommit() {
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, this.myActionName, true, this.myConfiguration.getCommitOption()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
                vcsManager.startBackgroundVcsOperation();
                try {
                    CommitHelper.this.delegateCommitToVcsThread();
                }
                finally {
                    LineStatusTrackerManager.getInstanceImpl(this.myProject).resetExcludedFromCommitMarkers();
                    vcsManager.stopBackgroundVcsOperation();
                }
            }

            public boolean shouldStartInBackground() {
                return !CommitHelper.this.myForceSyncCommit && super.shouldStartInBackground();
            }

            public boolean isConditionalModal() {
                return CommitHelper.this.myForceSyncCommit;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ui/CommitHelper$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
        return CommitHelper.hasOnlyWarnings(this.myCommitProcessor.getVcsExceptions());
    }

    private void delegateCommitToVcsThread() {
        DelegatingProgressIndicator indicator = new DelegatingProgressIndicator();
        TransactionGuard.getInstance().assertWriteSafeContext(indicator.getModalityState());
        Semaphore endSemaphore = new Semaphore();
        endSemaphore.down();
        ChangeListManagerImpl.getInstanceImpl(this.myProject).executeOnUpdaterThread(() -> this.lambda$delegateCommitToVcsThread$1((ProgressIndicator)indicator, endSemaphore));
        indicator.setText("Waiting for VCS background tasks to finish...");
        while (!endSemaphore.waitFor(20L)) {
            indicator.checkCanceled();
        }
    }

    static boolean hasOnlyWarnings(@NotNull List<VcsException> exceptions) {
        if (exceptions == null) {
            CommitHelper.$$$reportNull$$$0(14);
        }
        return exceptions.stream().allMatch(VcsException::isWarning);
    }

    private void generalCommit() throws RuntimeException {
        try {
            ReadAction.run(() -> this.markCommittingDocuments());
            try {
                this.myCommitProcessor.callSelf();
            }
            finally {
                ReadAction.run(() -> this.unmarkCommittingDocuments());
            }
            this.myCommitProcessor.doBeforeRefresh();
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e) {
            LOG.error(e);
            this.myCommitProcessor.myVcsExceptions.add(new VcsException(e));
            ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            this.commitCompleted(this.myCommitProcessor.getVcsExceptions());
            this.myCommitProcessor.customRefresh();
            WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> this.myCommitProcessor.doPostRefresh(), null, (Project)this.myProject);
        }
    }

    private void markCommittingDocuments() {
        this.myCommittingDocuments.addAll(CommitHelper.markCommittingDocuments(this.myProject, this.myIncludedChanges));
    }

    private void unmarkCommittingDocuments() {
        CommitHelper.unmarkCommittingDocuments(this.myCommittingDocuments);
        this.myCommittingDocuments.clear();
    }

    @NotNull
    private static Collection<Document> markCommittingDocuments(@NotNull Project project, @NotNull List<Change> changes) {
        if (project == null) {
            CommitHelper.$$$reportNull$$$0(15);
        }
        if (changes == null) {
            CommitHelper.$$$reportNull$$$0(16);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Change change : changes) {
            Document doc;
            VirtualFile virtualFile = ChangesUtil.getFilePath((Change)change).getVirtualFile();
            if (virtualFile == null || virtualFile.getFileType().isBinary() || (doc = FileDocumentManager.getInstance().getDocument(virtualFile)) == null) continue;
            doc.putUserData(DOCUMENT_BEING_COMMITTED_KEY, (Object)project);
            result2.add(doc);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            CommitHelper.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static void unmarkCommittingDocuments(@NotNull Collection<Document> committingDocs) {
        if (committingDocs == null) {
            CommitHelper.$$$reportNull$$$0(18);
        }
        committingDocs.forEach(document -> document.putUserData(DOCUMENT_BEING_COMMITTED_KEY, null));
    }

    private void commitCompleted(@NotNull List<VcsException> allExceptions) {
        if (allExceptions == null) {
            CommitHelper.$$$reportNull$$$0(19);
        }
        List<VcsException> errors = CommitHelper.collectErrors(allExceptions);
        boolean noErrors = errors.isEmpty();
        boolean noWarnings = allExceptions.isEmpty();
        if (noErrors) {
            this.myHandlers.forEach(CheckinHandler::checkinSuccessful);
            this.myCommitProcessor.afterSuccessfulCheckIn();
            this.myResultHandler.onSuccess(this.myCommitMessage);
            if (noWarnings) {
                ProgressManager.progress((String)VcsBundle.message((String)"commit.dialog.completed.successfully", (Object[])new Object[0]));
            }
        } else {
            this.myHandlers.forEach(handler2 -> handler2.checkinFailed(errors));
            this.myCommitProcessor.afterFailedCheckIn();
            this.myResultHandler.onFailure();
        }
    }

    public static void moveToFailedList(@NotNull ChangeList changeList, @NotNull String commitMessage, @NotNull List<Change> failedChanges, @NotNull String newChangelistName, @NotNull Project project) {
        VcsShowConfirmationOption option;
        boolean result2;
        if (changeList == null) {
            CommitHelper.$$$reportNull$$$0(20);
        }
        if (commitMessage == null) {
            CommitHelper.$$$reportNull$$$0(21);
        }
        if (failedChanges == null) {
            CommitHelper.$$$reportNull$$$0(22);
        }
        if (newChangelistName == null) {
            CommitHelper.$$$reportNull$$$0(23);
        }
        if (project == null) {
            CommitHelper.$$$reportNull$$$0(24);
        }
        if (failedChanges.containsAll(changeList.getChanges())) {
            return;
        }
        final VcsConfiguration configuration = VcsConfiguration.getInstance((Project)project);
        if (configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST != VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY && !(result2 = ConfirmationDialog.requestForConfirmation((VcsShowConfirmationOption)(option = new VcsShowConfirmationOption(){

            public VcsShowConfirmationOption.Value getValue() {
                return configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST;
            }

            public void setValue(VcsShowConfirmationOption.Value value) {
                configuration.MOVE_TO_FAILED_COMMIT_CHANGELIST = value;
            }

            public boolean isPersistent() {
                return true;
            }
        }), (Project)project, (String)VcsBundle.message((String)"commit.failed.confirm.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.failed.confirm.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()))) {
            return;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        int index = 1;
        String failedListName = newChangelistName;
        while (changeListManager.findChangeList(failedListName) != null) {
            failedListName = newChangelistName + " (" + ++index + ")";
        }
        LocalChangeList failedList = changeListManager.addChangeList(failedListName, commitMessage);
        changeListManager.moveChangesTo(failedList, (Change[])ArrayUtil.toObjectArray(failedChanges, Change.class));
    }

    @NotNull
    static List<VcsException> collectErrors(@NotNull List<VcsException> exceptions) {
        if (exceptions == null) {
            CommitHelper.$$$reportNull$$$0(25);
        }
        List<VcsException> list2 = exceptions.stream().filter(e -> !e.isWarning()).collect(Collectors.toList());
        if (list2 == null) {
            CommitHelper.$$$reportNull$$$0(26);
        }
        return list2;
    }

    private /* synthetic */ void lambda$delegateCommitToVcsThread$1(ProgressIndicator indicator, Semaphore endSemaphore) {
        indicator.setText("Performing VCS commit...");
        try {
            ProgressManager.getInstance().runProcess(() -> {
                indicator.checkCanceled();
                this.generalCommit();
            }, indicator);
        }
        finally {
            endSemaphore.up();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedChanges";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 4: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitMessage";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlers";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalDataHolder";
                break;
            }
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommitHelper";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "committingDocs";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allExceptions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedChanges";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChangelistName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommitHelper";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "markCommittingDocuments";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "collectErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyWarnings";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "markCommittingDocuments";
                break;
            }
            case 17: 
            case 26: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unmarkCommittingDocuments";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "commitCompleted";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "moveToFailedList";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectErrors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CommitProcessor
    extends GeneralCommitProcessor {
        @NotNull
        private LocalHistoryAction myAction;
        private boolean myCommitSuccess;
        @Nullable
        private final AbstractVcs myVcs;

        private CommitProcessor(AbstractVcs vcs) {
            this.myAction = LocalHistoryAction.NULL;
            this.myVcs = vcs;
        }

        @Override
        public void callSelf() {
            if (this.myVcs != null && CommitHelper.this.myIncludedChanges.isEmpty()) {
                this.process(this.myVcs, CommitHelper.this.myIncludedChanges);
            }
            ChangesUtil.processChangesByVcs((Project)CommitHelper.this.myProject, (Collection)CommitHelper.this.myIncludedChanges, this::process);
        }

        @Override
        public void afterSuccessfulCheckIn() {
            this.myCommitSuccess = true;
        }

        @Override
        public void afterFailedCheckIn() {
            ApplicationManager.getApplication().invokeLater(() -> CommitHelper.moveToFailedList(CommitHelper.this.myChangeList, CommitHelper.this.myCommitMessage, this.getChangesFailedToCommit(), VcsBundle.message((String)"commit.dialog.failed.commit.template", (Object[])new Object[]{CommitHelper.this.myChangeList.getName()}), CommitHelper.this.myProject), ModalityState.defaultModalityState(), CommitHelper.this.myProject.getDisposed());
        }

        @Override
        public void doBeforeRefresh() {
            ChangeListManagerImpl.getInstanceImpl(CommitHelper.this.myProject).showLocalChangesInvalidated();
            this.myAction = (LocalHistoryAction)ReadAction.compute(() -> LocalHistory.getInstance().startAction(CommitHelper.this.myActionName));
        }

        @Override
        public void customRefresh() {
            ArrayList toRefresh = ContainerUtil.newArrayList();
            ChangesUtil.processChangesByVcs((Project)CommitHelper.this.myProject, (Collection)CommitHelper.this.myIncludedChanges, (vcs, changes) -> {
                CheckinEnvironment environment = vcs.getCheckinEnvironment();
                if (environment != null && environment.isRefreshAfterCommitNeeded()) {
                    toRefresh.addAll(changes);
                }
            });
            if (!toRefresh.isEmpty()) {
                ProgressManager.progress((String)VcsBundle.message((String)"commit.dialog.refresh.files", (Object[])new Object[0]));
                RefreshVFsSynchronously.updateChanges(toRefresh);
            }
        }

        @Override
        public void doPostRefresh() {
            this.myAction.finish();
            if (!CommitHelper.this.myProject.isDisposed()) {
                VcsDirtyScopeManager.getInstance((Project)CommitHelper.this.myProject).filePathsDirty(this.getPathsToRefresh(), null);
                ChangeListManager clManager = ChangeListManager.getInstance((Project)CommitHelper.this.myProject);
                clManager.invokeAfterUpdate(() -> {
                    if (this.myCommitSuccess) {
                        this.updateChangelistAfterRefresh();
                    }
                    CommittedChangesCache cache = CommittedChangesCache.getInstance(CommitHelper.this.myProject);
                    cache.refreshAllCachesAsync(false, true);
                    cache.refreshIncomingChangesAsync();
                }, InvokeAfterUpdateMode.SILENT, null, null);
                LocalHistory.getInstance().putSystemLabel(CommitHelper.this.myProject, CommitHelper.this.myActionName + ": " + CommitHelper.this.myCommitMessage);
            }
        }

        private void updateChangelistAfterRefresh() {
            if (!(CommitHelper.this.myChangeList instanceof LocalChangeList)) {
                return;
            }
            ChangeListManager clManager = ChangeListManager.getInstance((Project)CommitHelper.this.myProject);
            LocalChangeList localList = clManager.findChangeList(CommitHelper.this.myChangeList.getName());
            if (localList == null) {
                return;
            }
            if (!localList.isDefault()) {
                clManager.scheduleAutomaticEmptyChangeListDeletion(localList);
            } else {
                ChangelistMoveOfferDialog dialog2;
                Collection changes = localList.getChanges();
                if (((CommitHelper)CommitHelper.this).myConfiguration.OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT && !changes.isEmpty() && CommitHelper.this.myAllOfDefaultChangeListChangesIncluded && (dialog2 = new ChangelistMoveOfferDialog(CommitHelper.this.myConfiguration)).showAndGet()) {
                    MoveChangesToAnotherListAction.askAndMove(CommitHelper.this.myProject, changes, Collections.emptyList());
                }
            }
        }
    }

    abstract class GeneralCommitProcessor {
        @NotNull
        protected final List<FilePath> myPathsToRefresh = ContainerUtil.newArrayList();
        @NotNull
        protected final List<VcsException> myVcsExceptions = ContainerUtil.newArrayList();
        @NotNull
        protected final List<Change> myChangesFailedToCommit = ContainerUtil.newArrayList();

        GeneralCommitProcessor() {
        }

        public abstract void callSelf();

        public abstract void afterSuccessfulCheckIn();

        public abstract void afterFailedCheckIn();

        public abstract void doBeforeRefresh();

        public abstract void customRefresh();

        public abstract void doPostRefresh();

        protected void process(@NotNull AbstractVcs vcs, @NotNull List<Change> changes) {
            CheckinEnvironment environment;
            if (vcs == null) {
                GeneralCommitProcessor.$$$reportNull$$$0(0);
            }
            if (changes == null) {
                GeneralCommitProcessor.$$$reportNull$$$0(1);
            }
            if ((environment = vcs.getCheckinEnvironment()) != null) {
                this.myPathsToRefresh.addAll(ChangesUtil.getPaths(changes));
                List exceptions = environment.commit(changes, CommitHelper.this.myCommitMessage, CommitHelper.this.myAdditionalData, (Set)CommitHelper.this.myFeedback);
                if (!ContainerUtil.isEmpty((Collection)exceptions)) {
                    this.myVcsExceptions.addAll(exceptions);
                    this.myChangesFailedToCommit.addAll(changes);
                }
            }
        }

        @NotNull
        public List<FilePath> getPathsToRefresh() {
            List<FilePath> list2 = this.myPathsToRefresh;
            if (list2 == null) {
                GeneralCommitProcessor.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @NotNull
        public List<VcsException> getVcsExceptions() {
            List<VcsException> list2 = this.myVcsExceptions;
            if (list2 == null) {
                GeneralCommitProcessor.$$$reportNull$$$0(3);
            }
            return list2;
        }

        @NotNull
        public List<Change> getChangesFailedToCommit() {
            List<Change> list2 = this.myChangesFailedToCommit;
            if (list2 == null) {
                GeneralCommitProcessor.$$$reportNull$$$0(4);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommitHelper$GeneralCommitProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommitHelper$GeneralCommitProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPathsToRefresh";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVcsExceptions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangesFailedToCommit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class AlienCommitProcessor
    extends GeneralCommitProcessor {
        @NotNull
        private final AbstractVcs myVcs;

        private AlienCommitProcessor(AbstractVcs vcs) {
            if (vcs == null) {
                AlienCommitProcessor.$$$reportNull$$$0(0);
            }
            this.myVcs = vcs;
        }

        @Override
        public void callSelf() {
            ChangesUtil.processItemsByVcs((Collection)CommitHelper.this.myIncludedChanges, change -> this.myVcs, this::process);
        }

        @Override
        protected void process(@NotNull AbstractVcs vcs, @NotNull List<Change> items) {
            if (vcs == null) {
                AlienCommitProcessor.$$$reportNull$$$0(1);
            }
            if (items == null) {
                AlienCommitProcessor.$$$reportNull$$$0(2);
            }
            if (!this.myVcs.getName().equals(vcs.getName())) {
                return;
            }
            super.process(vcs, items);
        }

        @Override
        public void afterSuccessfulCheckIn() {
        }

        @Override
        public void afterFailedCheckIn() {
        }

        @Override
        public void doBeforeRefresh() {
        }

        @Override
        public void customRefresh() {
        }

        @Override
        public void doPostRefresh() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommitHelper$AlienCommitProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

