/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b&\u0018\u0000 z*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003yz{B\u0019\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010;\u001a\b\u0012\u0004\u0012\u0002040\u00132\u0006\u0010<\u001a\u00020\u0014H\u0002J\b\u0010=\u001a\u000208H\u0014J\b\u0010>\u001a\u00020?H\u0014J\u0010\u0010@\u001a\u00020A2\u0006\u0010<\u001a\u00020\u0014H\u0003J\u0010\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020DH\u0007J\b\u0010E\u001a\u00020AH\u0007J\u0012\u0010F\u001a\u0004\u0018\u00010\u00142\u0006\u0010G\u001a\u00020\u0002H\u0004J\u0015\u0010H\u001a\u0004\u0018\u00018\u00002\u0006\u0010G\u001a\u00020\u0002\u00a2\u0006\u0002\u0010IJ\b\u0010J\u001a\u00020AH\u0015J\u0018\u0010K\u001a\u00020A2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020MH\u0014J\u0010\u0010O\u001a\u0002082\u0006\u0010<\u001a\u00020\u0014H\u0004J\b\u0010P\u001a\u00020\u000bH\u0007J\u0015\u0010Q\u001a\u0004\u0018\u00018\u00002\u0006\u0010R\u001a\u00020M\u00a2\u0006\u0002\u0010SJ\u0015\u0010T\u001a\u0004\u0018\u00018\u00002\u0006\u0010R\u001a\u00020M\u00a2\u0006\u0002\u0010SJ\u0015\u0010U\u001a\u0004\u0018\u00018\u00002\u0006\u0010R\u001a\u00020M\u00a2\u0006\u0002\u0010SJ\u000e\u0010V\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0013J\u0016\u0010W\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00132\u0006\u0010X\u001a\u00020YJ\u0010\u0010Z\u001a\u00020A2\u0006\u0010<\u001a\u00020\u0014H\u0003J\b\u0010[\u001a\u00020!H\u0015J\u000e\u0010\\\u001a\u00020!2\u0006\u0010R\u001a\u00020MJ\u0006\u0010]\u001a\u00020!J\u0016\u0010^\u001a\u00020!2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020MJ\u0006\u0010_\u001a\u00020!J\u0006\u0010`\u001a\u00020AJ\u0010\u0010a\u001a\u00020A2\u0006\u0010G\u001a\u00020\u0002H\u0007J\u0010\u0010a\u001a\u00020A2\u0006\u0010X\u001a\u00020YH\u0007J\u001c\u0010b\u001a\u00020A2\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020!0dH\u0005J\u0010\u0010e\u001a\u00020A2\u0006\u0010f\u001a\u00020gH\u0007J \u0010e\u001a\u00020A2\u0006\u0010f\u001a\u00020g2\u000e\u0010h\u001a\n\u0012\u0004\u0012\u00020A\u0018\u00010iH\u0005J \u0010j\u001a\u00020M2\u0006\u0010R\u001a\u00020M2\u0006\u0010k\u001a\u00020!2\u0006\u0010l\u001a\u00020!H\u0002J\u0016\u0010m\u001a\u00020M2\u0006\u0010R\u001a\u00020M2\u0006\u0010k\u001a\u00020!J\u0016\u0010n\u001a\u00020M2\u0006\u0010R\u001a\u00020M2\u0006\u0010k\u001a\u00020!J$\u0010o\u001a\u00020!2\u0006\u0010p\u001a\u00020q2\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020A0dH\u0005J.\u0010o\u001a\u00020!2\u0006\u0010p\u001a\u00020q2\b\u0010r\u001a\u0004\u0018\u00010s2\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020A0dH\u0005J\u0010\u0010t\u001a\u00020A2\u0006\u0010<\u001a\u00020\u0014H\u0005J\b\u0010u\u001a\u00020AH\u0005J\b\u0010v\u001a\u00020AH\u0005J\u0011\u0010w\u001a\u00028\u0000*\u00020\u0014H$\u00a2\u0006\u0002\u0010xR\u0018\u0010\t\u001a\u00060\nR\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020!@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0012\u0010)\u001a\u00020*X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001cR\u0016\u0010/\u001a\u0004\u0018\u0001008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R \u00103\u001a\n\u0012\u0004\u0012\u000204\u0018\u00010\u0013*\u00020\u00148DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0018\u00107\u001a\u000208*\u00020\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\u00a8\u0006|"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;", "R", "Lcom/intellij/openapi/vcs/ex/Range;", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;)V", "LOCK", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker;", "getLOCK$intellij_platform_diff_impl", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker$Lock;", "application", "Lcom/intellij/openapi/application/Application;", "getApplication", "()Lcom/intellij/openapi/application/Application;", "blocks", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getBlocks", "()Ljava/util/List;", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "documentTracker", "getDocumentTracker", "()Lcom/intellij/openapi/vcs/ex/DocumentTracker;", "isInitialized", "", "<set-?>", "isReleased", "()Z", "setReleased", "(Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "renderer", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRenderer;", "getRenderer", "()Lcom/intellij/openapi/vcs/ex/LineStatusMarkerRenderer;", "vcsDocument", "getVcsDocument", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "innerRanges", "Lcom/intellij/openapi/vcs/ex/Range$InnerRange;", "getInnerRanges", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Ljava/util/List;", "ourData", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$BlockData;", "getOurData", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$BlockData;", "calcInnerRanges", "block", "createBlockData", "createDocumentTrackerHandler", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "destroyHighlighter", "", "doFrozen", "task", "Ljava/lang/Runnable;", "dropBaseRevision", "findBlock", "range", "findRange", "(Lcom/intellij/openapi/vcs/ex/Range;)Lcom/intellij/openapi/vcs/ex/Range;", "fireFileUnchanged", "fireLinesUnchanged", "startLine", "", "endLine", "getBlockData", "getDocumentTrackerInTestMode", "getNextRange", "line", "(I)Lcom/intellij/openapi/vcs/ex/Range;", "getPrevRange", "getRangeForLine", "getRanges", "getRangesForLines", "lines", "Ljava/util/BitSet;", "installHighlighter", "isDetectWhitespaceChangedLines", "isLineModified", "isOperational", "isRangeModified", "isValid", "release", "rollbackChanges", "runBulkRollback", "condition", "Lkotlin/Function1;", "setBaseRevision", "vcsContent", "", "beforeUnfreeze", "Lkotlin/Function0;", "transferLine", "approximate", "fromVcs", "transferLineToFromVcs", "transferLineToVcs", "updateDocument", "side", "Lcom/intellij/diff/util/Side;", "commandName", "", "updateHighlighter", "updateHighlighters", "updateInnerRanges", "toRange", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Lcom/intellij/openapi/vcs/ex/Range;", "BlockData", "Companion", "MyDocumentTrackerHandler", "intellij.platform.diff.impl"})
public abstract class LineStatusTrackerBase<R extends Range> {
    @NotNull
    private final Application application;
    @Nullable
    private final Project project;
    @NotNull
    private final Document document;
    @NotNull
    private final Document vcsDocument;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final DocumentTracker documentTracker;
    private boolean isReleased;
    private boolean isInitialized;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    protected final Application getApplication() {
        return this.application;
    }

    @Nullable
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    @NotNull
    public final Document getVcsDocument() {
        return this.vcsDocument;
    }

    @NotNull
    protected final Disposable getDisposable() {
        return this.disposable;
    }

    @NotNull
    protected final DocumentTracker getDocumentTracker() {
        return this.documentTracker;
    }

    @NotNull
    protected abstract LineStatusMarkerRenderer getRenderer();

    public final boolean isReleased() {
        return this.isReleased;
    }

    private final void setReleased(boolean bl) {
        this.isReleased = bl;
    }

    @NotNull
    protected final List<DocumentTracker.Block> getBlocks() {
        return this.documentTracker.getBlocks();
    }

    @NotNull
    public final DocumentTracker.Lock getLOCK$intellij_platform_diff_impl() {
        return this.documentTracker.getLOCK$intellij_platform_diff_impl();
    }

    protected boolean isDetectWhitespaceChangedLines() {
        return false;
    }

    protected void fireFileUnchanged() {
    }

    protected void fireLinesUnchanged(int startLine, int endLine) {
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @NotNull
    protected abstract R toRange(@NotNull DocumentTracker.Block var1);

    @NotNull
    protected DocumentTracker.Handler createDocumentTrackerHandler() {
        return new MyDocumentTrackerHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final List<R> getRanges() {
        this.application.assertReadAccessAllowed();
        DocumentTracker.Lock this_$iv = this.getLOCK$intellij_platform_diff_impl();
        Lock lock = DocumentTracker.Lock.access$getMyLock$p(this_$iv);
        lock.lock();
        try {
            DocumentTracker.Block it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            if (!this.isValid()) {
                List<R> list2 = null;
                return list2;
            }
            Iterable iterable = $receiver$iv = (Iterable)this.getBlocks();
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (DocumentTracker.Block)element$iv$iv;
                if (!(!it.getRange().isEmpty())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (DocumentTracker.Block)item$iv$iv;
                Collection collection = destination$iv$iv;
                R r = this.toRange(it);
                collection.add(r);
            }
            List list3 = (List)destination$iv$iv;
            return list3;
        }
        finally {
            lock.unlock();
        }
    }

    public final void setBaseRevision(@NotNull CharSequence vcsContent) {
        Intrinsics.checkParameterIsNotNull((Object)vcsContent, (String)"vcsContent");
        this.setBaseRevision(vcsContent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final void setBaseRevision(@NotNull CharSequence vcsContent, @Nullable Function0<Unit> beforeUnfreeze) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)vcsContent, (String)"vcsContent");
        this.application.assertIsDispatchThread();
        if (this.isReleased) {
            return;
        }
        DocumentTracker documentTracker = this.documentTracker;
        Side side$iv = Side.LEFT;
        this_$iv.freeze(side$iv);
        try {
            this.updateDocument(Side.LEFT, (Function1<Document, Unit>)((Function1)new Function1<Document, Unit>(this, vcsContent, beforeUnfreeze){
                final /* synthetic */ LineStatusTrackerBase this$0;
                final /* synthetic */ CharSequence $vcsContent$inlined;
                final /* synthetic */ Function0 $beforeUnfreeze$inlined;
                {
                    this.this$0 = lineStatusTrackerBase;
                    this.$vcsContent$inlined = charSequence;
                    this.$beforeUnfreeze$inlined = function0;
                    super(1);
                }

                public final void invoke(@NotNull Document it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.this$0.getVcsDocument().setText(this.$vcsContent$inlined);
                }
            }));
            Function0<Unit> function0 = beforeUnfreeze;
            if (function0 != null) {
                Unit cfr_ignored_0 = (Unit)function0.invoke();
            }
        }
        finally {
            this_$iv.unfreeze(side$iv);
        }
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.updateHighlighters();
        }
    }

    public final void dropBaseRevision() {
        this.application.assertIsDispatchThread();
        if (this.isReleased) {
            return;
        }
        this.isInitialized = false;
        this.updateHighlighters();
    }

    protected final boolean updateDocument(@NotNull Side side, @NotNull Function1<? super Document, Unit> task) {
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        return this.updateDocument(side, null, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean updateDocument(@NotNull Side side, @Nullable String commandName, @NotNull Function1<? super Document, Unit> task) {
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        Document doc = RangesBuilder.get(side, this.vcsDocument, this.document);
        if (side.isLeft()) {
            doc.setReadOnly(false);
        }
        try {
            boolean bl = DiffUtil.executeWriteCommand(doc, this.getProject(), commandName, new Runnable(task, doc){
                final /* synthetic */ Function1 $task;
                final /* synthetic */ Document $doc;

                public final void run() {
                    this.$task.invoke((Object)this.$doc);
                }
                {
                    this.$task = function1;
                    this.$doc = document;
                }
            });
            return bl;
        }
        finally {
            if (side.isLeft()) {
                doc.setReadOnly(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void doFrozen(@NotNull Runnable task) {
        void this_$iv$iv;
        DocumentTracker this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        DocumentTracker documentTracker = this_$iv = this.documentTracker;
        Side side$iv$iv = Side.LEFT;
        this_$iv$iv.freeze(side$iv$iv);
        try {
            void this_$iv$iv2;
            DocumentTracker documentTracker2 = this_$iv;
            Side side$iv$iv2 = Side.RIGHT;
            this_$iv$iv2.freeze(side$iv$iv2);
            try {
                task.run();
            }
            finally {
                this_$iv$iv2.unfreeze(side$iv$iv2);
            }
        }
        finally {
            this_$iv$iv.unfreeze(side$iv$iv);
        }
    }

    public final void release() {
        Runnable runnable2 = new Runnable(this){
            final /* synthetic */ LineStatusTrackerBase this$0;

            public final void run() {
                if (this.this$0.isReleased()) {
                    return;
                }
                LineStatusTrackerBase.access$setReleased$p(this.this$0, true);
                this.this$0.updateHighlighters();
                Disposer.dispose((Disposable)this.this$0.getDisposable());
            }
            {
                this.this$0 = lineStatusTrackerBase;
            }
        };
        if (!this.application.isDispatchThread() || this.getLOCK$intellij_platform_diff_impl().isHeldByCurrentThread$intellij_platform_diff_impl()) {
            this.application.invokeLater(runnable2);
        } else {
            runnable2.run();
        }
    }

    private final List<Range.InnerRange> calcInnerRanges(DocumentTracker.Block block) {
        if (Companion.getStart(block) == Companion.getEnd(block) || Companion.getVcsStart(block) == Companion.getVcsEnd(block)) {
            return CollectionsKt.emptyList();
        }
        com.intellij.diff.util.Range range2 = block.getRange();
        CharSequence charSequence = this.vcsDocument.getImmutableCharSequence();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"vcsDocument.immutableCharSequence");
        CharSequence charSequence2 = this.document.getImmutableCharSequence();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence2, (String)"document.immutableCharSequence");
        return RangesBuilder.createInnerRanges(range2, charSequence, charSequence2, RangesBuilder.getLineOffsets(this.vcsDocument), RangesBuilder.getLineOffsets(this.document));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateHighlighters() {
        DocumentTracker.Lock this_$iv = this.getLOCK$intellij_platform_diff_impl();
        Lock lock = DocumentTracker.Lock.access$getMyLock$p(this_$iv);
        lock.lock();
        try {
            for (DocumentTracker.Block block : this.getBlocks()) {
                this.updateHighlighter(block);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateHighlighter(@NotNull DocumentTracker.Block block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        DocumentTracker.Lock this_$iv = this.getLOCK$intellij_platform_diff_impl();
        Lock lock = DocumentTracker.Lock.access$getMyLock$p(this_$iv);
        lock.lock();
        try {
            this.destroyHighlighter(block);
            this.installHighlighter(block);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateInnerRanges() {
        DocumentTracker.Lock this_$iv = this.getLOCK$intellij_platform_diff_impl();
        Lock lock = DocumentTracker.Lock.access$getMyLock$p(this_$iv);
        lock.lock();
        try {
            if (this.isDetectWhitespaceChangedLines()) {
                for (DocumentTracker.Block block : this.getBlocks()) {
                    this.getOurData(block).setInnerRanges$intellij_platform_diff_impl(this.calcInnerRanges(block));
                }
            } else {
                for (DocumentTracker.Block block : this.getBlocks()) {
                    this.getOurData(block).setInnerRanges$intellij_platform_diff_impl(null);
                }
            }
            this.updateHighlighters();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void installHighlighter(DocumentTracker.Block block) {
        if (this.getOurData(block).getRangeHighlighter$intellij_platform_diff_impl() != null) {
            return;
        }
        if (!this.isValid() || block.getRange().isEmpty()) {
            return;
        }
        try {
            this.getOurData(block).setRangeHighlighter$intellij_platform_diff_impl(this.getRenderer().createHighlighter((Range)this.toRange(block)));
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Exception e) {
            Companion.getLOG().error((Throwable)e);
        }
    }

    private final void destroyHighlighter(DocumentTracker.Block block) {
        RangeHighlighter rangeHighlighter = this.getOurData(block).getRangeHighlighter$intellij_platform_diff_impl();
        if (rangeHighlighter == null) {
            return;
        }
        RangeHighlighter highlighter = rangeHighlighter;
        try {
            this.getOurData(block).setRangeHighlighter$intellij_platform_diff_impl(null);
            highlighter.dispose();
        }
        catch (Exception e) {
            Companion.getLOG().error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOperational() {
        DocumentTracker.Lock this_$iv = this.getLOCK$intellij_platform_diff_impl();
        Lock lock = DocumentTracker.Lock.access$getMyLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl = this.isInitialized && !this.isReleased;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isValid() {
        DocumentTracker.Lock this_$iv = this.getLOCK$intellij_platform_diff_impl();
        Lock lock = DocumentTracker.Lock.access$getMyLock$p(this_$iv);
        lock.lock();
        try {
            boolean bl = this.isOperational() && !this.documentTracker.isFrozen();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Nullable
    public final R findRange(@NotNull Range range2) {
        Intrinsics.checkParameterIsNotNull((Object)range2, (String)"range");
        DocumentTracker.Block block = this.findBlock(range2);
        return block != null ? (R)this.toRange(block) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final DocumentTracker.Block findBlock(@NotNull Range range2) {
        Intrinsics.checkParameterIsNotNull((Object)range2, (String)"range");
        DocumentTracker.Lock this_$iv = this.getLOCK$intellij_platform_diff_impl();
        Lock lock = DocumentTracker.Lock.access$getMyLock$p(this_$iv);
        lock.lock();
        try {
            if (!this.isValid()) {
                DocumentTracker.Block block = null;
                return block;
            }
            for (DocumentTracker.Block block : this.getBlocks()) {
                if (Companion.getStart(block) != range2.getLine1() || Companion.getEnd(block) != range2.getLine2() || Companion.getVcsStart(block) != range2.getVcsLine1() || Companion.getVcsEnd(block) != range2.getVcsLine2()) continue;
                DocumentTracker.Block block2 = block;
                return block2;
            }
            DocumentTracker.Block block = null;
            return block;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final R getNextRange(int line) {
        DocumentTracker.Lock this_$iv = this.getLOCK$intellij_platform_diff_impl();
        Lock lock = DocumentTracker.Lock.access$getMyLock$p(this_$iv);
        lock.lock();
        try {
            if (!this.isValid()) {
                R r = null;
                return r;
            }
            for (DocumentTracker.Block block : this.getBlocks()) {
                if (line >= Companion.getEnd(block) || Companion.isSelectedByLine(block, line)) continue;
                R r = this.toRange(block);
                return r;
            }
            R r = null;
            return r;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final R getPrevRange(int line) {
        DocumentTracker.Lock this_$iv = this.getLOCK$intellij_platform_diff_impl();
        Lock lock = DocumentTracker.Lock.access$getMyLock$p(this_$iv);
        lock.lock();
        try {
            if (!this.isValid()) {
                R r = null;
                return r;
            }
            for (DocumentTracker.Block block : CollectionsKt.reversed((Iterable)this.getBlocks())) {
                if (line <= Companion.getStart(block) || Companion.isSelectedByLine(block, line)) continue;
                R r = this.toRange(block);
                return r;
            }
            R r = null;
            return r;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final List<R> getRangesForLines(@NotNull BitSet lines2) {
        Intrinsics.checkParameterIsNotNull((Object)lines2, (String)"lines");
        DocumentTracker.Lock this_$iv = this.getLOCK$intellij_platform_diff_impl();
        Lock lock = DocumentTracker.Lock.access$getMyLock$p(this_$iv);
        lock.lock();
        try {
            if (!this.isValid()) {
                List<R> list2 = null;
                return list2;
            }
            ArrayList<R> result2 = new ArrayList<R>();
            for (DocumentTracker.Block block : this.getBlocks()) {
                if (!Companion.isSelectedByLine(block, lines2)) continue;
                result2.add(this.toRange(block));
            }
            List list3 = result2;
            return list3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final R getRangeForLine(int line) {
        DocumentTracker.Lock this_$iv = this.getLOCK$intellij_platform_diff_impl();
        Lock lock = DocumentTracker.Lock.access$getMyLock$p(this_$iv);
        lock.lock();
        try {
            if (!this.isValid()) {
                R r = null;
                return r;
            }
            for (DocumentTracker.Block block : this.getBlocks()) {
                if (!Companion.isSelectedByLine(block, line)) continue;
                R r = this.toRange(block);
                return r;
            }
            R r = null;
            return r;
        }
        finally {
            lock.unlock();
        }
    }

    public final void rollbackChanges(@NotNull Range range2) {
        Intrinsics.checkParameterIsNotNull((Object)range2, (String)"range");
        DocumentTracker.Block newRange = this.findBlock(range2);
        if (newRange != null) {
            this.runBulkRollback((Function1<DocumentTracker.Block, Boolean>)((Function1)new Function1<DocumentTracker.Block, Boolean>(newRange){
                final /* synthetic */ DocumentTracker.Block $newRange;

                public final boolean invoke(@NotNull DocumentTracker.Block it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$newRange);
                }
                {
                    this.$newRange = block;
                    super(1);
                }
            }));
        }
    }

    public final void rollbackChanges(@NotNull BitSet lines2) {
        Intrinsics.checkParameterIsNotNull((Object)lines2, (String)"lines");
        this.runBulkRollback((Function1<DocumentTracker.Block, Boolean>)((Function1)new Function1<DocumentTracker.Block, Boolean>(lines2){
            final /* synthetic */ BitSet $lines;

            public final boolean invoke(@NotNull DocumentTracker.Block it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return LineStatusTrackerBase.Companion.isSelectedByLine(it, this.$lines);
            }
            {
                this.$lines = bitSet;
                super(1);
            }
        }));
    }

    protected final void runBulkRollback(@NotNull Function1<? super DocumentTracker.Block, Boolean> condition) {
        Intrinsics.checkParameterIsNotNull(condition, (String)"condition");
        if (!this.isValid()) {
            return;
        }
        this.updateDocument(Side.RIGHT, VcsBundle.message((String)"command.name.rollback.change", (Object[])new Object[0]), (Function1<Document, Unit>)((Function1)new Function1<Document, Unit>(this, condition){
            final /* synthetic */ LineStatusTrackerBase this$0;
            final /* synthetic */ Function1 $condition;

            public final void invoke(@NotNull Document it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.getDocumentTracker().partiallyApplyBlocks(Side.RIGHT, (Function1<? super DocumentTracker.Block, Boolean>)this.$condition, (Function2<? super DocumentTracker.Block, ? super Integer, Unit>)((Function2)new Function2<DocumentTracker.Block, Integer, Unit>(this){
                    final /* synthetic */ runBulkRollback.1 this$0;

                    public final void invoke(@NotNull DocumentTracker.Block block, int shift) {
                        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                        this.this$0.this$0.fireLinesUnchanged(LineStatusTrackerBase.Companion.getStart(block) + shift, LineStatusTrackerBase.Companion.getStart(block) + shift + (LineStatusTrackerBase.Companion.getVcsEnd(block) - LineStatusTrackerBase.Companion.getVcsStart(block)));
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                }));
            }
            {
                this.this$0 = lineStatusTrackerBase;
                this.$condition = function1;
                super(1);
            }
        }));
    }

    public final boolean isLineModified(int line) {
        return this.isRangeModified(line, line + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRangeModified(int startLine, int endLine) {
        boolean bl;
        if (startLine == endLine) {
            return false;
        }
        boolean bl2 = bl = startLine < endLine;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        DocumentTracker.Lock this_$iv = this.getLOCK$intellij_platform_diff_impl();
        Lock lock = DocumentTracker.Lock.access$getMyLock$p(this_$iv);
        lock.lock();
        try {
            if (!this.isValid()) {
                boolean bl3 = false;
                return bl3;
            }
            for (DocumentTracker.Block block : this.getBlocks()) {
                if (Companion.getStart(block) >= endLine) {
                    boolean bl4 = false;
                    return bl4;
                }
                if (Companion.getEnd(block) <= startLine) continue;
                boolean bl5 = true;
                return bl5;
            }
            boolean bl6 = false;
            return bl6;
        }
        finally {
            lock.unlock();
        }
    }

    public final int transferLineToFromVcs(int line, boolean approximate) {
        return this.transferLine(line, approximate, true);
    }

    public final int transferLineToVcs(int line, boolean approximate) {
        return this.transferLine(line, approximate, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int transferLine(int line, boolean approximate, boolean fromVcs) {
        DocumentTracker.Lock this_$iv = this.getLOCK$intellij_platform_diff_impl();
        Lock lock = DocumentTracker.Lock.access$getMyLock$p(this_$iv);
        lock.lock();
        try {
            if (!this.isValid()) {
                int n = approximate ? line : -1;
                return n;
            }
            int result2 = line;
            for (DocumentTracker.Block block : this.getBlocks()) {
                int startLine1 = fromVcs ? Companion.getVcsStart(block) : Companion.getStart(block);
                int endLine1 = fromVcs ? Companion.getVcsEnd(block) : Companion.getEnd(block);
                int startLine2 = fromVcs ? Companion.getStart(block) : Companion.getVcsStart(block);
                int endLine2 = fromVcs ? Companion.getEnd(block) : Companion.getVcsEnd(block);
                int n = line;
                if (startLine1 <= n && endLine1 > n) {
                    int n2 = approximate ? startLine2 : -1;
                    return n2;
                }
                if (endLine1 > line) {
                    int n3 = result2;
                    return n3;
                }
                int length1 = endLine1 - startLine1;
                int length2 = endLine2 - startLine2;
                result2 += length2 - length1;
            }
            int n = result2;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    protected BlockData createBlockData() {
        return new BlockData(null, null, 3, null);
    }

    @NotNull
    protected BlockData getOurData(@NotNull DocumentTracker.Block $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return this.getBlockData($receiver);
    }

    @NotNull
    protected final BlockData getBlockData(@NotNull DocumentTracker.Block block) {
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        if (block.getData() == null) {
            block.setData(this.createBlockData());
        }
        Object object = block.getData();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vcs.ex.LineStatusTrackerBase.BlockData");
        }
        return (BlockData)object;
    }

    @Nullable
    protected final List<Range.InnerRange> getInnerRanges(@NotNull DocumentTracker.Block $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return UtilKt.nullize(this.getOurData($receiver).getInnerRanges$intellij_platform_diff_impl());
    }

    @NotNull
    public final DocumentTracker getDocumentTrackerInTestMode() {
        return this.documentTracker;
    }

    public LineStatusTrackerBase(@Nullable Project project, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        this.application = application;
        this.disposable = Disposer.newDisposable();
        this.project = project;
        this.document = document;
        this.vcsDocument = new DocumentImpl(this.document.getImmutableCharSequence());
        this.vcsDocument.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)true);
        this.vcsDocument.setReadOnly(true);
        this.documentTracker = new DocumentTracker(this.vcsDocument, this.document, this.createDocumentTrackerHandler());
        Disposer.register((Disposable)this.disposable, (Disposable)this.documentTracker);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.ex.LineStatusTracker");
    }

    public static final /* synthetic */ boolean access$isReleased$p(LineStatusTrackerBase $this) {
        return $this.isReleased;
    }

    public static final /* synthetic */ void access$setReleased$p(LineStatusTrackerBase $this, boolean bl) {
        $this.isReleased = bl;
    }

    @NotNull
    protected static final Logger getLOG() {
        return Companion.getLOG();
    }

    protected static final int getStart(@NotNull DocumentTracker.Block $receiver) {
        return Companion.getStart($receiver);
    }

    protected static final int getEnd(@NotNull DocumentTracker.Block $receiver) {
        return Companion.getEnd($receiver);
    }

    protected static final int getVcsStart(@NotNull DocumentTracker.Block $receiver) {
        return Companion.getVcsStart($receiver);
    }

    protected static final int getVcsEnd(@NotNull DocumentTracker.Block $receiver) {
        return Companion.getVcsEnd($receiver);
    }

    @JvmStatic
    protected static final boolean isSelectedByLine(@NotNull DocumentTracker.Block $receiver, int line) {
        return Companion.isSelectedByLine($receiver, line);
    }

    @JvmStatic
    protected static final boolean isSelectedByLine(@NotNull DocumentTracker.Block $receiver, @NotNull BitSet lines2) {
        return Companion.isSelectedByLine($receiver, lines2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0094\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\b\u0010\b\u001a\u00020\u0004H\u0002J\b\u0010\t\u001a\u00020\u0004H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$MyDocumentTrackerHandler;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "(Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;)V", "afterExplicitChange", "", "afterRangeChange", "afterRefresh", "calcInnerRanges", "checkIfFileUnchanged", "installMissingHighlighters", "onRangeRemoved", "block", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "onRangeShifted", "before", "after", "onUnfreeze", "side", "Lcom/intellij/diff/util/Side;", "intellij.platform.diff.impl"})
    protected class MyDocumentTrackerHandler
    implements DocumentTracker.Handler {
        @Override
        public void onRangeRemoved(@NotNull DocumentTracker.Block block) {
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            LineStatusTrackerBase.this.destroyHighlighter(block);
        }

        @Override
        public void onRangeShifted(@NotNull DocumentTracker.Block before, @NotNull DocumentTracker.Block after) {
            Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
            Intrinsics.checkParameterIsNotNull((Object)after, (String)"after");
            LineStatusTrackerBase.this.getOurData(after).setInnerRanges$intellij_platform_diff_impl(LineStatusTrackerBase.this.getOurData(before).getInnerRanges$intellij_platform_diff_impl());
        }

        @Override
        public void afterRefresh() {
            this.checkIfFileUnchanged();
            this.calcInnerRanges();
            this.installMissingHighlighters();
        }

        @Override
        public void afterRangeChange() {
            this.installMissingHighlighters();
        }

        @Override
        public void afterExplicitChange() {
            this.checkIfFileUnchanged();
            this.calcInnerRanges();
            this.installMissingHighlighters();
        }

        @Override
        public void onUnfreeze(@NotNull Side side) {
            Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
            this.calcInnerRanges();
            this.installMissingHighlighters();
        }

        private final void checkIfFileUnchanged() {
            if (LineStatusTrackerBase.this.getBlocks().isEmpty()) {
                LineStatusTrackerBase.this.fireFileUnchanged();
            }
        }

        private final void calcInnerRanges() {
            if (LineStatusTrackerBase.this.isDetectWhitespaceChangedLines() && !LineStatusTrackerBase.this.getDocumentTracker().isFrozen()) {
                for (DocumentTracker.Block block : LineStatusTrackerBase.this.getBlocks()) {
                    if (LineStatusTrackerBase.this.getOurData(block).getInnerRanges$intellij_platform_diff_impl() != null) continue;
                    LineStatusTrackerBase.this.getOurData(block).setInnerRanges$intellij_platform_diff_impl(LineStatusTrackerBase.this.calcInnerRanges(block));
                    LineStatusTrackerBase.this.destroyHighlighter(block);
                }
            }
        }

        private final void installMissingHighlighters() {
            for (DocumentTracker.Block block : LineStatusTrackerBase.this.getBlocks()) {
                LineStatusTrackerBase.this.installHighlighter(block);
            }
        }

        @Override
        public void onUnfreeze() {
            DocumentTracker.Handler.DefaultImpls.onUnfreeze(this);
        }

        @Override
        public void onRangeRefreshed(@NotNull DocumentTracker.Block before, @NotNull List<DocumentTracker.Block> after) {
            Intrinsics.checkParameterIsNotNull((Object)before, (String)"before");
            Intrinsics.checkParameterIsNotNull(after, (String)"after");
            DocumentTracker.Handler.DefaultImpls.onRangeRefreshed(this, before, after);
        }

        @Override
        public void onRangesChanged(@NotNull List<DocumentTracker.Block> before, @NotNull DocumentTracker.Block after) {
            Intrinsics.checkParameterIsNotNull(before, (String)"before");
            Intrinsics.checkParameterIsNotNull((Object)after, (String)"after");
            DocumentTracker.Handler.DefaultImpls.onRangesChanged(this, before, after);
        }

        @Override
        public boolean onRangesMerged(@NotNull DocumentTracker.Block range1, @NotNull DocumentTracker.Block range2, @NotNull DocumentTracker.Block merged) {
            Intrinsics.checkParameterIsNotNull((Object)range1, (String)"range1");
            Intrinsics.checkParameterIsNotNull((Object)range2, (String)"range2");
            Intrinsics.checkParameterIsNotNull((Object)merged, (String)"merged");
            return DocumentTracker.Handler.DefaultImpls.onRangesMerged(this, range1, range2, merged);
        }

        @Override
        public void onRangeAdded(@NotNull DocumentTracker.Block block) {
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            DocumentTracker.Handler.DefaultImpls.onRangeAdded(this, block);
        }

        @Override
        public void onFreeze(@NotNull Side side) {
            Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
            DocumentTracker.Handler.DefaultImpls.onFreeze(this, side);
        }

        @Override
        public void onFreeze() {
            DocumentTracker.Handler.DefaultImpls.onFreeze(this);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0014\u0018\u00002\u00020\u0001B#\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\"\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$BlockData;", "", "innerRanges", "", "Lcom/intellij/openapi/vcs/ex/Range$InnerRange;", "rangeHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "(Ljava/util/List;Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "getInnerRanges$intellij_platform_diff_impl", "()Ljava/util/List;", "setInnerRanges$intellij_platform_diff_impl", "(Ljava/util/List;)V", "getRangeHighlighter$intellij_platform_diff_impl", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "setRangeHighlighter$intellij_platform_diff_impl", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "intellij.platform.diff.impl"})
    protected static class BlockData {
        @Nullable
        private List<Range.InnerRange> innerRanges;
        @Nullable
        private RangeHighlighter rangeHighlighter;

        @Nullable
        public final List<Range.InnerRange> getInnerRanges$intellij_platform_diff_impl() {
            return this.innerRanges;
        }

        public final void setInnerRanges$intellij_platform_diff_impl(@Nullable List<Range.InnerRange> list2) {
            this.innerRanges = list2;
        }

        @Nullable
        public final RangeHighlighter getRangeHighlighter$intellij_platform_diff_impl() {
            return this.rangeHighlighter;
        }

        public final void setRangeHighlighter$intellij_platform_diff_impl(@Nullable RangeHighlighter rangeHighlighter) {
            this.rangeHighlighter = rangeHighlighter;
        }

        public BlockData(@Nullable List<Range.InnerRange> innerRanges, @Nullable RangeHighlighter rangeHighlighter) {
            this.innerRanges = innerRanges;
            this.rangeHighlighter = rangeHighlighter;
        }

        public /* synthetic */ BlockData(List list2, RangeHighlighter rangeHighlighter, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list2 = null;
            }
            if ((n & 2) != 0) {
                rangeHighlighter = null;
            }
            this(list2, rangeHighlighter);
        }

        public BlockData() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0005J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\n2\u0006\u0010\u001c\u001a\u00020\tH\u0005R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u00020\t*\u00020\n8DX\u0085\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\t*\u00020\n8DX\u0085\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\f\u001a\u0004\b\u0011\u0010\u000eR\u001e\u0010\u0012\u001a\u00020\t*\u00020\n8DX\u0085\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\f\u001a\u0004\b\u0014\u0010\u000eR\u001e\u0010\u0015\u001a\u00020\t*\u00020\n8DX\u0085\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\f\u001a\u0004\b\u0017\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "LOG$annotations", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "end", "", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "end$annotations", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)V", "getEnd", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)I", "start", "start$annotations", "getStart", "vcsEnd", "vcsEnd$annotations", "getVcsEnd", "vcsStart", "vcsStart$annotations", "getVcsStart", "isSelectedByLine", "", "lines", "Ljava/util/BitSet;", "line", "intellij.platform.diff.impl"})
    public static final class Companion {
        @JvmStatic
        protected static /* synthetic */ void LOG$annotations() {
        }

        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        @JvmStatic
        protected static /* synthetic */ void start$annotations(DocumentTracker.Block block) {
        }

        protected final int getStart(@NotNull DocumentTracker.Block $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return $receiver.getRange().start2;
        }

        @JvmStatic
        protected static /* synthetic */ void end$annotations(DocumentTracker.Block block) {
        }

        protected final int getEnd(@NotNull DocumentTracker.Block $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return $receiver.getRange().end2;
        }

        @JvmStatic
        protected static /* synthetic */ void vcsStart$annotations(DocumentTracker.Block block) {
        }

        protected final int getVcsStart(@NotNull DocumentTracker.Block $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return $receiver.getRange().start1;
        }

        @JvmStatic
        protected static /* synthetic */ void vcsEnd$annotations(DocumentTracker.Block block) {
        }

        protected final int getVcsEnd(@NotNull DocumentTracker.Block $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return $receiver.getRange().end1;
        }

        @JvmStatic
        protected final boolean isSelectedByLine(@NotNull DocumentTracker.Block $receiver, int line) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return DiffUtil.isSelectedByLine(line, $receiver.getRange().start2, $receiver.getRange().end2);
        }

        @JvmStatic
        protected final boolean isSelectedByLine(@NotNull DocumentTracker.Block $receiver, @NotNull BitSet lines2) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)lines2, (String)"lines");
            return DiffUtil.isSelectedByLine(lines2, $receiver.getRange().start2, $receiver.getRange().end2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

