/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.google.common.collect.Multiset;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.SimpleLocalLineStatusTracker;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager$MyBaseRevisionLoader$handleResult$;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager$restoreTrackersForPartiallyChangedFiles$;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerKt$sam$Runnable$78ff56e2;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.openapi.vcs.impl.Result;
import com.intellij.openapi.vcs.impl.SingleThreadLoader;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 l2\u00020\u00012\u00020\u0002:\u0011lmnopqrstuvwxyz{|B?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0001\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020\u001fH\u0016J\u0010\u00102\u001a\u00020%2\u0006\u00101\u001a\u00020\u001fH\u0002J\u0012\u00103\u001a\u00020%2\b\u00101\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u00104\u001a\u00020.2\u0006\u00105\u001a\u00020\u0018H\u0003J\u0013\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0001\u00a2\u0006\u0002\b9J\b\u0010:\u001a\u00020.H\u0016J\u0016\u0010;\u001a\u00020.2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020.0=H\u0002J\b\u0010>\u001a\u00020.H\u0003J\b\u0010?\u001a\u00020@H\u0017J\u0016\u0010A\u001a\b\u0012\u0002\b\u0003\u0018\u00010B2\u0006\u00105\u001a\u00020\u0018H\u0016J\u0016\u0010A\u001a\b\u0012\u0002\b\u0003\u0018\u00010B2\u0006\u0010C\u001a\u00020\u001fH\u0016J\u0010\u0010D\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030B07J\b\u0010E\u001a\u00020FH\u0002J\b\u0010G\u001a\u00020.H\u0016J\u0018\u0010H\u001a\u00020.2\u0006\u00101\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u0018H\u0003J0\u0010H\u001a\u00020.2\u0006\u00101\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u00182\b\u0010I\u001a\u0004\u0018\u00010@2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020K07H\u0003J\u0010\u0010L\u001a\u00020.2\u0006\u0010<\u001a\u00020MH\u0016J\u001a\u0010N\u001a\u00020.2\u0006\u0010O\u001a\u00020@2\b\u0010C\u001a\u0004\u0018\u00010\u001fH\u0002J\u0015\u0010P\u001a\u00020.2\u0006\u00101\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\bQJ\b\u0010R\u001a\u00020.H\u0003J\u0010\u0010S\u001a\u00020.2\u0006\u00101\u001a\u00020\u001fH\u0003J \u0010T\u001a\u00020.2\n\u0010U\u001a\u0006\u0012\u0002\b\u00030B2\n\b\u0002\u0010V\u001a\u0004\u0018\u00010@H\u0003J\u0014\u0010W\u001a\u00020.2\n\u0010U\u001a\u0006\u0012\u0002\b\u00030BH\u0002J\u0010\u0010X\u001a\u00020.2\u0006\u00105\u001a\u00020\u0018H\u0003J\u0018\u0010Y\u001a\u00020.2\u0006\u00105\u001a\u00020\u00182\u0006\u0010Z\u001a\u00020\u0013H\u0017J\u0018\u0010[\u001a\u00020.2\u0006\u00105\u001a\u00020\u00182\u0006\u0010Z\u001a\u00020\u0013H\u0017J$\u0010\\\u001a\u00020.2\n\u0010U\u001a\u0006\u0012\u0002\b\u00030B2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020^H\u0002J\b\u0010`\u001a\u00020.H\u0007J\u001b\u0010a\u001a\u00020.2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020 07H\u0001\u00a2\u0006\u0002\bcJ\u001a\u0010d\u001a\u00020%2\b\u0010e\u001a\u0004\u0018\u00010f2\u0006\u0010g\u001a\u00020fH\u0002J\b\u0010h\u001a\u00020.H\u0002J\u0014\u0010i\u001a\u00020.2\n\u0010U\u001a\u0006\u0012\u0002\b\u00030BH\u0002J\b\u0010j\u001a\u00020.H\u0002J\u001a\u0010k\u001a\u00020.2\u0006\u0010O\u001a\u00020@2\b\u00105\u001a\u0004\u0018\u00010\u0018H\u0002J\u001a\u0010k\u001a\u00020.2\u0006\u0010O\u001a\u00020@2\b\u0010C\u001a\u0004\u0018\u00010\u001fH\u0002R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0019\u001a&\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b \u001c*\u0012\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130#0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020,0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006}"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "Lcom/intellij/openapi/components/ProjectComponent;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "project", "Lcom/intellij/openapi/project/Project;", "application", "Lcom/intellij/openapi/application/Application;", "statusProvider", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManagerImpl;", "fileDocumentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "fileEditorManager", "Lcom/intellij/openapi/fileEditor/ex/FileEditorManagerEx;", "makeSureIndexIsInitializedFirst", "Lcom/intellij/openapi/roots/impl/DirectoryIndex;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/application/Application;Lcom/intellij/openapi/vcs/impl/VcsBaseContentProvider;Lcom/intellij/openapi/vcs/changes/ChangeListManagerImpl;Lcom/intellij/openapi/fileEditor/FileDocumentManager;Lcom/intellij/openapi/fileEditor/ex/FileEditorManagerEx;Lcom/intellij/openapi/roots/impl/DirectoryIndex;)V", "LOCK", "", "disposable", "Lcom/intellij/openapi/Disposable;", "documentsInDefaultChangeList", "Ljava/util/HashSet;", "Lcom/intellij/openapi/editor/Document;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "kotlin.jvm.PlatformType", "fileStatesAwaitingRefresh", "Ljava/util/HashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker$State;", "filesWithDamagedInactiveRanges", "forcedDocuments", "Lcom/google/common/collect/Multiset;", "isDisposed", "", "loader", "Lcom/intellij/openapi/vcs/impl/SingleThreadLoader;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "partialChangeListsEnabled", "trackers", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "addTrackerListener", "", "listener", "arePartialChangelistsEnabled", "virtualFile", "canCreatePartialTrackerFor", "canGetBaseRevisionFor", "checkIfTrackerCanBeReleased", "document", "collectPartiallyChangedFilesStates", "", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker$FullState;", "collectPartiallyChangedFilesStates$intellij_platform_vcs_impl", "disposeComponent", "edt", "task", "Lkotlin/Function0;", "expireInactiveRangesDamagedNotifications", "getComponentName", "", "getLineStatusTracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "file", "getTrackers", "getTrackingMode", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker$Mode;", "initComponent", "installTracker", "oldChangesChangelistId", "events", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "invokeAfterUpdate", "Ljava/lang/Runnable;", "log", "message", "notifyInactiveRangesDamaged", "notifyInactiveRangesDamaged$intellij_platform_vcs_impl", "onEverythingChanged", "onFileChanged", "refreshTracker", "tracker", "changelistId", "registerTrackerInCLM", "releaseTracker", "releaseTrackerFor", "requester", "requestTrackerFor", "reregisterTrackerInCLM", "oldPath", "Lcom/intellij/openapi/vcs/FilePath;", "newPath", "resetExcludedFromCommitMarkers", "restoreTrackersForPartiallyChangedFiles", "trackerStates", "restoreTrackersForPartiallyChangedFiles$intellij_platform_vcs_impl", "shouldBeUpdated", "oldInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "newInfo", "showInactiveRangesDamagedNotification", "unregisterTrackerInCLM", "updateTrackingModes", "warn", "Companion", "ContentInfo", "InactiveRangesDamagedNotification", "Listener", "ListenerAdapter", "MyApplicationListener", "MyBaseRevisionLoader", "MyChangeListListener", "MyCommandListener", "MyDocumentListener", "MyEditorFactoryListener", "MyFileStatusListener", "MyLineStatusTrackerSettingListener", "MyVirtualFileListener", "RefreshData", "RefreshRequest", "TrackerData", "intellij.platform.vcs.impl"})
public final class LineStatusTrackerManager
implements ProjectComponent,
LineStatusTrackerManagerI {
    private final Object LOCK;
    private final Disposable disposable;
    private boolean isDisposed;
    private final HashMap<Document, TrackerData> trackers;
    private final HashMap<Document, Multiset<Object>> forcedDocuments;
    private final EventDispatcher<Listener> eventDispatcher;
    private boolean partialChangeListsEnabled;
    private final HashSet<Document> documentsInDefaultChangeList;
    private final HashSet<VirtualFile> filesWithDamagedInactiveRanges;
    private final HashMap<VirtualFile, PartialLocalLineStatusTracker.State> fileStatesAwaitingRefresh;
    private final SingleThreadLoader<RefreshRequest, RefreshData> loader;
    private final Project project;
    private final Application application;
    private final VcsBaseContentProvider statusProvider;
    private final ChangeListManagerImpl changeListManager;
    private final FileDocumentManager fileDocumentManager;
    private final FileEditorManagerEx fileEditorManager;
    private static final Logger LOG;
    public static final Companion Companion;

    public void initComponent() {
        StartupManager.getInstance((Project)this.project).registerPreStartupActivity(new Runnable(this){
            final /* synthetic */ LineStatusTrackerManager this$0;

            public final void run() {
                if (LineStatusTrackerManager.access$isDisposed$p(this.this$0)) {
                    return;
                }
                LineStatusTrackerManager.access$getApplication$p(this.this$0).addApplicationListener((ApplicationListener)this.this$0.new MyApplicationListener(), LineStatusTrackerManager.access$getDisposable$p(this.this$0));
                MessageBusConnection busConnection = LineStatusTrackerManager.access$getProject$p(this.this$0).getMessageBus().connect(LineStatusTrackerManager.access$getDisposable$p(this.this$0));
                busConnection.subscribe(LineStatusTrackerSettingListener.TOPIC, (Object)this.this$0.new MyLineStatusTrackerSettingListener());
                FileStatusManager fsManager = FileStatusManager.getInstance((Project)LineStatusTrackerManager.access$getProject$p(this.this$0));
                fsManager.addFileStatusListener((FileStatusListener)this.this$0.new MyFileStatusListener(), LineStatusTrackerManager.access$getDisposable$p(this.this$0));
                EditorFactory editorFactory = EditorFactory.getInstance();
                editorFactory.addEditorFactoryListener((EditorFactoryListener)this.this$0.new MyEditorFactoryListener(), LineStatusTrackerManager.access$getDisposable$p(this.this$0));
                EditorFactory editorFactory2 = editorFactory;
                Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory2, (String)"editorFactory");
                editorFactory2.getEventMulticaster().addDocumentListener((DocumentListener)this.this$0.new MyDocumentListener(), LineStatusTrackerManager.access$getDisposable$p(this.this$0));
                LineStatusTrackerManager.access$getChangeListManager$p(this.this$0).addChangeListListener((ChangeListListener)this.this$0.new MyChangeListListener());
                VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                virtualFileManager.addVirtualFileListener((VirtualFileListener)this.this$0.new MyVirtualFileListener(), LineStatusTrackerManager.access$getDisposable$p(this.this$0));
                CommandProcessor.getInstance().addCommandListener((CommandListener)this.this$0.new MyCommandListener(), LineStatusTrackerManager.access$getDisposable$p(this.this$0));
            }
            {
                this.this$0 = lineStatusTrackerManager;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponent() {
        this.isDisposed = true;
        Disposer.dispose((Disposable)this.disposable);
        Object object = this.LOCK;
        synchronized (object) {
            Map map = this.forcedDocuments;
            Iterator<Object> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                Document document = (Document)entry2.getKey();
                entry2 = entry;
                Multiset multiset2 = (Multiset)entry2.getValue();
                for (Object requester : multiset2.elementSet()) {
                    this.warn("Tracker for is being held on dispose by " + requester, document);
                }
            }
            this.forcedDocuments.clear();
            for (TrackerData data : this.trackers.values()) {
                this.unregisterTrackerInCLM(data.getTracker());
                data.getTracker().release();
            }
            this.trackers.clear();
            this.loader.clear();
            iterator = Unit.INSTANCE;
        }
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        return "LineStatusTrackerManager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Object object = this.LOCK;
        synchronized (object) {
            TrackerData trackerData = this.trackers.get(document);
            LineStatusTracker<?> lineStatusTracker = trackerData != null ? trackerData.getTracker() : null;
            return lineStatusTracker;
        }
    }

    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull VirtualFile file2) {
        Document document;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Document document2 = this.fileDocumentManager.getCachedDocument(file2);
        if (document2 == null) {
            return null;
        }
        Document document3 = document = document2;
        Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"document");
        return this.getLineStatusTracker(document3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestTrackerFor(@NotNull Document document, @NotNull Object requester) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)requester, (String)"requester");
        Object object = this.LOCK;
        synchronized (object) {
            Multiset<Object> multiset2 = this.forcedDocuments.computeIfAbsent(document, requestTrackerFor.1.multiset.1.INSTANCE);
            multiset2.add(requester);
            if (this.trackers.get(document) == null) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = this.fileDocumentManager.getFile(document);
                if (virtualFile2 == null) {
                    return;
                }
                VirtualFile virtualFile3 = virtualFile = virtualFile2;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
                this.installTracker(virtualFile3, document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseTrackerFor(@NotNull Document document, @NotNull Object requester) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)requester, (String)"requester");
        Object object = this.LOCK;
        synchronized (object) {
            Multiset<Object> multiset2 = this.forcedDocuments.get(document);
            if (multiset2 == null || !multiset2.contains(requester)) {
                this.warn("Tracker release underflow by " + requester, document);
                return;
            }
            multiset2.remove(requester);
            if (multiset2.isEmpty()) {
                this.forcedDocuments.remove(document);
                this.checkIfTrackerCanBeReleased(document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void invokeAfterUpdate(@NotNull Runnable task) {
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        this.loader.addAfterUpdateRunnable(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<LineStatusTracker<?>> getTrackers() {
        Object object = this.LOCK;
        synchronized (object) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Collection<TrackerData> collection = this.trackers.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"trackers.values");
            Iterable iterable = $receiver$iv = (Iterable)collection;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TrackerData trackerData = (TrackerData)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                LineStatusTracker<?> lineStatusTracker = it.getTracker();
                collection2.add(lineStatusTracker);
            }
            List list2 = (List)destination$iv$iv;
            return list2;
        }
    }

    public final void addTrackerListener(@NotNull Listener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
        this.eventDispatcher.addListener((EventListener)listener2, disposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkIfTrackerCanBeReleased(Document document) {
        Object object = this.LOCK;
        synchronized (object) {
            TrackerData trackerData = this.trackers.get(document);
            if (trackerData == null) {
                return;
            }
            TrackerData data = trackerData;
            if (this.forcedDocuments.containsKey(document)) {
                return;
            }
            if (data.getTracker() instanceof PartialLocalLineStatusTracker) {
                boolean hasPartialChanges = ((PartialLocalLineStatusTracker)data.getTracker()).getAffectedChangeListsIds().size() > 1;
                boolean hasBlocksExcludedFromCommit2 = ((PartialLocalLineStatusTracker)data.getTracker()).hasBlocksExcludedFromCommit();
                boolean isLoading = this.loader.hasRequest(new RefreshRequest(document, null, 2, null));
                if (hasPartialChanges || hasBlocksExcludedFromCommit2 || isLoading) {
                    return;
                }
            }
            this.releaseTracker(document);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onEverythingChanged() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isDisposed) {
                return;
            }
            this.log("onEverythingChanged", null);
            HashSet<VirtualFile> files = new HashSet<VirtualFile>();
            for (TrackerData data : this.trackers.values()) {
                files.add(data.getTracker().getVirtualFile());
            }
            for (Document document : this.forcedDocuments.keySet()) {
                VirtualFile file2 = this.fileDocumentManager.getFile(document);
                if (file2 == null) continue;
                files.add(file2);
            }
            Iterator<TrackerData> iterator = files.iterator();
            while (iterator.hasNext()) {
                VirtualFile file3;
                VirtualFile virtualFile = file3 = (VirtualFile)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                this.onFileChanged(virtualFile);
            }
            iterator = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onFileChanged(VirtualFile virtualFile) {
        Document document = this.fileDocumentManager.getCachedDocument(virtualFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        Object object = this.LOCK;
        synchronized (object) {
            LineStatusTracker<?> tracker;
            if (this.isDisposed) {
                return;
            }
            this.log("onFileChanged", virtualFile);
            TrackerData trackerData = this.trackers.get(document2);
            LineStatusTracker<Object> lineStatusTracker = tracker = trackerData != null ? trackerData.getTracker() : null;
            if (tracker == null) {
                if (this.forcedDocuments.containsKey(document2)) {
                    Document document3 = document2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"document");
                    this.installTracker(virtualFile, document3);
                }
            } else {
                boolean isPartialTracker;
                boolean isPartialTrackerExpected = this.canCreatePartialTrackerFor(virtualFile);
                if (isPartialTrackerExpected == (isPartialTracker = tracker instanceof PartialLocalLineStatusTracker)) {
                    LineStatusTrackerManager.refreshTracker$default(this, tracker, null, 2, null);
                } else {
                    Document document4 = document2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)document4, (String)"document");
                    this.releaseTracker(document4);
                    this.installTracker(virtualFile, document2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void registerTrackerInCLM(LineStatusTracker<?> tracker) {
        if (tracker instanceof PartialLocalLineStatusTracker) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)tracker.getVirtualFile());
            this.changeListManager.registerChangeTracker(filePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        }
    }

    private final void unregisterTrackerInCLM(LineStatusTracker<?> tracker) {
        if (tracker instanceof PartialLocalLineStatusTracker) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)tracker.getVirtualFile());
            this.changeListManager.unregisterChangeTracker(filePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        }
    }

    private final void reregisterTrackerInCLM(LineStatusTracker<?> tracker, FilePath oldPath, FilePath newPath) {
        if (tracker instanceof PartialLocalLineStatusTracker) {
            this.changeListManager.unregisterChangeTracker(oldPath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
            this.changeListManager.registerChangeTracker(newPath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        }
    }

    private final boolean canGetBaseRevisionFor(VirtualFile virtualFile) {
        if (this.isDisposed) {
            return false;
        }
        if (virtualFile == null || virtualFile instanceof LightVirtualFile || !virtualFile.isValid()) {
            return false;
        }
        FileType fileType = virtualFile.getFileType();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"virtualFile.fileType");
        if (fileType.isBinary() || FileUtilRt.isTooLarge((long)virtualFile.getLength())) {
            return false;
        }
        if (!this.statusProvider.isSupported(virtualFile)) {
            return false;
        }
        FileStatus status = FileStatusManager.getInstance((Project)this.project).getStatus(virtualFile);
        return !Intrinsics.areEqual((Object)status, (Object)FileStatus.ADDED) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.DELETED) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.UNKNOWN) && !Intrinsics.areEqual((Object)status, (Object)FileStatus.IGNORED);
    }

    private final boolean canCreatePartialTrackerFor(VirtualFile virtualFile) {
        if (!this.arePartialChangelistsEnabled(virtualFile)) {
            return false;
        }
        FileStatus status = FileStatusManager.getInstance((Project)this.project).getStatus(virtualFile);
        if (Intrinsics.areEqual((Object)status, (Object)FileStatus.MODIFIED) ^ true && Intrinsics.areEqual((Object)status, (Object)FileStatus.NOT_CHANGED) ^ true) {
            return false;
        }
        Change change = ChangeListManager.getInstance((Project)this.project).getChange(virtualFile);
        return change != null && Intrinsics.areEqual(change.getClass(), Change.class) && (Intrinsics.areEqual((Object)change.getType(), (Object)Change.Type.MODIFICATION) || Intrinsics.areEqual((Object)change.getType(), (Object)Change.Type.MOVED)) && change.getAfterRevision() instanceof CurrentContentRevision;
    }

    @Override
    public boolean arePartialChangelistsEnabled(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        if (!this.partialChangeListsEnabled) {
            return false;
        }
        if (Intrinsics.areEqual((Object)((Object)this.getTrackingMode()), (Object)((Object)LineStatusTracker.Mode.SILENT))) {
            return false;
        }
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)this.project, (VirtualFile)virtualFile);
        return vcs != null && vcs.arePartialChangelistsSupported();
    }

    private final void installTracker(VirtualFile virtualFile, Document document) {
        if (!this.canGetBaseRevisionFor(virtualFile)) {
            return;
        }
        LocalChangeList localChangeList = this.changeListManager.getChangeList(virtualFile);
        String changelistId = localChangeList != null ? localChangeList.getId() : null;
        this.installTracker(virtualFile, document, changelistId, CollectionsKt.emptyList());
    }

    private final void installTracker(VirtualFile virtualFile, Document document, String oldChangesChangelistId, List<? extends DocumentEvent> events) {
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(this, document, virtualFile, events, oldChangesChangelistId){
            final /* synthetic */ LineStatusTrackerManager this$0;
            final /* synthetic */ Document $document$inlined;
            final /* synthetic */ VirtualFile $virtualFile$inlined;
            final /* synthetic */ List $events$inlined;
            final /* synthetic */ String $oldChangesChangelistId$inlined;
            {
                this.this$0 = lineStatusTrackerManager;
                this.$document$inlined = document;
                this.$virtualFile$inlined = virtualFile;
                this.$events$inlined = list2;
                this.$oldChangesChangelistId$inlined = string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T compute() {
                Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0);
                synchronized (object) {
                    if (LineStatusTrackerManager.access$isDisposed$p(this.this$0)) {
                    } else if (LineStatusTrackerManager.access$getTrackers$p(this.this$0).get(this.$document$inlined) != null) {
                    } else {
                        LineStatusTracker tracker = LineStatusTrackerManager.access$canCreatePartialTrackerFor(this.this$0, this.$virtualFile$inlined) ? (LineStatusTracker)PartialLocalLineStatusTracker.Companion.createTracker(LineStatusTrackerManager.access$getProject$p(this.this$0), this.$document$inlined, this.$virtualFile$inlined, LineStatusTrackerManager.access$getTrackingMode(this.this$0), this.$events$inlined) : (LineStatusTracker)SimpleLocalLineStatusTracker.Companion.createTracker(LineStatusTrackerManager.access$getProject$p(this.this$0), this.$document$inlined, this.$virtualFile$inlined, LineStatusTrackerManager.access$getTrackingMode(this.this$0));
                        LineStatusTrackerManager.access$getTrackers$p(this.this$0).put(this.$document$inlined, new TrackerData(tracker, null, 2, null));
                        LineStatusTrackerManager.access$registerTrackerInCLM(this.this$0, tracker);
                        LineStatusTrackerManager.access$refreshTracker(this.this$0, tracker, this.$oldChangesChangelistId$inlined);
                        EventDispatcher eventDispatcher = LineStatusTrackerManager.access$getEventDispatcher$p(this.this$0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"eventDispatcher");
                        ((Listener)eventDispatcher.getMulticaster()).onTrackerAdded(tracker);
                        LineStatusTrackerManager.access$log(this.this$0, "Tracker installed", this.$virtualFile$inlined);
                        Unit unit = Unit.INSTANCE;
                    }
                }
                return (T)Unit.INSTANCE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void releaseTracker(Document document) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isDisposed) {
                return;
            }
            TrackerData trackerData = this.trackers.remove(document);
            if (trackerData == null) {
                return;
            }
            TrackerData data = trackerData;
            EventDispatcher<Listener> eventDispatcher = this.eventDispatcher;
            Intrinsics.checkExpressionValueIsNotNull(eventDispatcher, (String)"eventDispatcher");
            ((Listener)eventDispatcher.getMulticaster()).onTrackerRemoved(data.getTracker());
            this.unregisterTrackerInCLM(data.getTracker());
            data.getTracker().release();
            this.log("Tracker released", data.getTracker().getVirtualFile());
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void updateTrackingModes() {
        Object object = this.LOCK;
        synchronized (object) {
            void $receiver$iv$iv;
            if (this.isDisposed) {
                return;
            }
            LineStatusTracker.Mode mode = this.getTrackingMode();
            Collection<TrackerData> collection = this.trackers.values();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"trackers.values");
            Iterable $receiver$iv = collection;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                TrackerData trackerData = (TrackerData)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                LineStatusTracker<?> lineStatusTracker = it.getTracker();
                collection2.add(lineStatusTracker);
            }
            List trackers = (List)destination$iv$iv;
            for (LineStatusTracker tracker : trackers) {
                boolean isPartialTracker;
                Document document = tracker.getDocument();
                VirtualFile virtualFile = tracker.getVirtualFile();
                boolean isPartialTrackerExpected = this.canCreatePartialTrackerFor(virtualFile);
                if (isPartialTrackerExpected == (isPartialTracker = tracker instanceof PartialLocalLineStatusTracker)) {
                    tracker.setMode(mode);
                    continue;
                }
                this.releaseTracker(document);
                this.installTracker(virtualFile, document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final LineStatusTracker.Mode getTrackingMode() {
        VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
        if (!settings.SHOW_LST_GUTTER_MARKERS) {
            return LineStatusTracker.Mode.SILENT;
        }
        if (settings.SHOW_WHITESPACES_IN_LST) {
            return LineStatusTracker.Mode.SMART;
        }
        return LineStatusTracker.Mode.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshTracker(LineStatusTracker<?> tracker, String changelistId) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isDisposed) {
                return;
            }
            this.loader.scheduleRefresh(new RefreshRequest(tracker.getDocument(), changelistId));
            this.log("Refresh queued", tracker.getVirtualFile());
            Unit unit = Unit.INSTANCE;
        }
    }

    static /* bridge */ /* synthetic */ void refreshTracker$default(LineStatusTrackerManager lineStatusTrackerManager, LineStatusTracker lineStatusTracker, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        lineStatusTrackerManager.refreshTracker(lineStatusTracker, string);
    }

    private final boolean shouldBeUpdated(ContentInfo oldInfo, ContentInfo newInfo) {
        if (oldInfo == null) {
            return true;
        }
        if (Intrinsics.areEqual((Object)oldInfo.getRevision(), (Object)newInfo.getRevision()) && Intrinsics.areEqual((Object)oldInfo.getRevision(), (Object)VcsRevisionNumber.NULL) ^ true) {
            return Intrinsics.areEqual((Object)oldInfo.getCharset(), (Object)newInfo.getCharset()) ^ true;
        }
        return true;
    }

    private final void edt(Function0<Unit> task) {
        Object object = task;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new LineStatusTrackerManagerKt$sam$Runnable$78ff56e2(function0);
        }
        GuiUtils.invokeLaterIfNeeded((Runnable)((Runnable)object), (ModalityState)ModalityState.any());
    }

    private final void log(String message, VirtualFile file2) {
        Logger logger = LineStatusTrackerManager.Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        if (logger.isDebugEnabled()) {
            if (file2 != null) {
                LineStatusTrackerManager.Companion.getLOG().debug(message + "; file: " + file2.getPath());
            } else {
                LineStatusTrackerManager.Companion.getLOG().debug(message);
            }
        }
    }

    private final void warn(String message, Document document) {
        VirtualFile virtualFile;
        Document document2 = document;
        if (document2 != null) {
            Document document3;
            Document it = document3 = document2;
            virtualFile = this.fileDocumentManager.getFile(it);
        } else {
            virtualFile = null;
        }
        VirtualFile file2 = virtualFile;
        this.warn(message, file2);
    }

    private final void warn(String message, VirtualFile file2) {
        if (file2 != null) {
            LineStatusTrackerManager.Companion.getLOG().warn(message + "; file: " + file2.getPath());
        } else {
            LineStatusTrackerManager.Companion.getLOG().warn(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetExcludedFromCommitMarkers() {
        Object object = this.LOCK;
        synchronized (object) {
            List documents = new ArrayList();
            for (TrackerData data : this.trackers.values()) {
                LineStatusTracker<?> tracker = data.getTracker();
                if (!(tracker instanceof PartialLocalLineStatusTracker)) continue;
                ((PartialLocalLineStatusTracker)tracker).setExcludedFromCommit(false);
                documents.add(tracker.getDocument());
            }
            for (Document document : documents) {
                this.checkIfTrackerCanBeReleased(document);
            }
            Iterator<TrackerData> iterator = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PartialLocalLineStatusTracker.FullState> collectPartiallyChangedFilesStates$intellij_platform_vcs_impl() {
        List result2 = new ArrayList();
        Object object = this.LOCK;
        synchronized (object) {
            for (TrackerData data : this.trackers.values()) {
                boolean hasPartialChanges;
                LineStatusTracker<?> tracker = data.getTracker();
                if (!(tracker instanceof PartialLocalLineStatusTracker) || !(hasPartialChanges = ((PartialLocalLineStatusTracker)tracker).getAffectedChangeListsIds().size() > 1)) continue;
                result2.add(((PartialLocalLineStatusTracker)tracker).storeTrackerState$intellij_platform_vcs_impl());
            }
            Unit unit = Unit.INSTANCE;
        }
        return result2;
    }

    public final void restoreTrackersForPartiallyChangedFiles$intellij_platform_vcs_impl(@NotNull List<? extends PartialLocalLineStatusTracker.State> trackerStates) {
        Intrinsics.checkParameterIsNotNull(trackerStates, (String)"trackerStates");
        ApplicationManager.getApplication().runWriteAction(new Computable<T>(this, trackerStates){
            final /* synthetic */ LineStatusTrackerManager this$0;
            final /* synthetic */ List $trackerStates$inlined;
            {
                this.this$0 = lineStatusTrackerManager;
                this.$trackerStates$inlined = list2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T compute() {
                Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0);
                synchronized (object) {
                    for (PartialLocalLineStatusTracker.State state : this.$trackerStates$inlined) {
                        boolean stateRestored;
                        LineStatusTracker<?> oldTracker;
                        Document document;
                        VirtualFile virtualFile = state.getVirtualFile();
                        if (LineStatusTrackerManager.access$getFileDocumentManager$p(this.this$0).getDocument(virtualFile) == null) {
                            continue;
                        }
                        if (!LineStatusTrackerManager.access$canCreatePartialTrackerFor(this.this$0, virtualFile)) continue;
                        TrackerData trackerData = (TrackerData)LineStatusTrackerManager.access$getTrackers$p(this.this$0).get(document);
                        LineStatusTracker<Object> lineStatusTracker = oldTracker = trackerData != null ? trackerData.getTracker() : null;
                        if (oldTracker instanceof PartialLocalLineStatusTracker) {
                            boolean stateRestored2;
                            boolean bl = stateRestored2 = state instanceof PartialLocalLineStatusTracker.FullState && ((PartialLocalLineStatusTracker)oldTracker).restoreState$intellij_platform_vcs_impl(state);
                            if (stateRestored2) {
                                LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: reused, full restored", virtualFile);
                                continue;
                            }
                            SingleThreadLoader singleThreadLoader = LineStatusTrackerManager.access$getLoader$p(this.this$0);
                            Document document2 = document;
                            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
                            boolean isLoading = singleThreadLoader.hasRequest(new RefreshRequest(document2, null, 2, null));
                            if (isLoading) {
                                LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(this.this$0).put(state.getVirtualFile(), state);
                                LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: reused, restore scheduled", virtualFile);
                                continue;
                            }
                            ((PartialLocalLineStatusTracker)oldTracker).restoreState$intellij_platform_vcs_impl(state);
                            LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: reused, restored", virtualFile);
                            continue;
                        }
                        Project project = LineStatusTrackerManager.access$getProject$p(this.this$0);
                        Document document3 = document;
                        Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"document");
                        PartialLocalLineStatusTracker tracker = PartialLocalLineStatusTracker.Companion.createTracker(project, document3, virtualFile, LineStatusTrackerManager.access$getTrackingMode(this.this$0));
                        LineStatusTrackerManager.access$getTrackers$p(this.this$0).put(document, new TrackerData(tracker, null, 2, null));
                        if (oldTracker != null) {
                            EventDispatcher eventDispatcher = LineStatusTrackerManager.access$getEventDispatcher$p(this.this$0);
                            Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"eventDispatcher");
                            ((Listener)eventDispatcher.getMulticaster()).onTrackerRemoved(tracker);
                            LineStatusTrackerManager.access$unregisterTrackerInCLM(this.this$0, oldTracker);
                            oldTracker.release();
                            LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: removed existing", virtualFile);
                        }
                        LineStatusTrackerManager.access$registerTrackerInCLM(this.this$0, tracker);
                        LineStatusTrackerManager.refreshTracker$default(this.this$0, tracker, null, 2, null);
                        EventDispatcher eventDispatcher = LineStatusTrackerManager.access$getEventDispatcher$p(this.this$0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"eventDispatcher");
                        ((Listener)eventDispatcher.getMulticaster()).onTrackerAdded(tracker);
                        boolean bl = stateRestored = state instanceof PartialLocalLineStatusTracker.FullState && tracker.restoreState$intellij_platform_vcs_impl(state);
                        if (stateRestored) {
                            LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: created, full restored", virtualFile);
                            continue;
                        }
                        LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(this.this$0).put(state.getVirtualFile(), state);
                        LineStatusTrackerManager.access$log(this.this$0, "Tracker restore: created, restore scheduled", virtualFile);
                    }
                    LineStatusTrackerManager.access$getLoader$p(this.this$0).addAfterUpdateRunnable(new Runnable(this){
                        final /* synthetic */ restoreTrackersForPartiallyChangedFiles$$inlined$runWriteAction$1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.this$0);
                            synchronized (object) {
                                LineStatusTrackerManager.access$log(this.this$0.this$0, "Tracker restore: finished", null);
                                LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(this.this$0.this$0).clear();
                                Unit unit = Unit.INSTANCE;
                            }
                        }
                    });
                    Unit unit = Unit.INSTANCE;
                }
                return (T)Unit.INSTANCE;
            }
        });
    }

    public final void notifyInactiveRangesDamaged$intellij_platform_vcs_impl(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        if (this.filesWithDamagedInactiveRanges.contains(virtualFile)) {
            return;
        }
        if (Intrinsics.areEqual((Object)virtualFile, (Object)this.fileEditorManager.getCurrentFile())) {
            return;
        }
        this.filesWithDamagedInactiveRanges.add(virtualFile);
    }

    private final void showInactiveRangesDamagedNotification() {
        Object object;
        InactiveRangesDamagedNotification it;
        InactiveRangesDamagedNotification[] currentNotifications;
        block3: {
            currentNotifications = (InactiveRangesDamagedNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(InactiveRangesDamagedNotification.class, this.project);
            Intrinsics.checkExpressionValueIsNotNull((Object)currentNotifications, (String)"currentNotifications");
            Object[] $receiver$iv = (Object[])currentNotifications;
            Iterator iterator = CollectionsKt.reversed((Iterable)((Iterable)ArraysKt.getIndices((Object[])$receiver$iv))).iterator();
            while (iterator.hasNext()) {
                int index$iv = ((Number)iterator.next()).intValue();
                Object element$iv = $receiver$iv[index$iv];
                InactiveRangesDamagedNotification inactiveRangesDamagedNotification = it = (InactiveRangesDamagedNotification)((Object)element$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)inactiveRangesDamagedNotification), (String)"it");
                if (!(!inactiveRangesDamagedNotification.isExpired())) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        InactiveRangesDamagedNotification lastNotification = (InactiveRangesDamagedNotification)((Object)object);
        if (lastNotification != null) {
            this.filesWithDamagedInactiveRanges.addAll((Collection<VirtualFile>)lastNotification.getVirtualFiles());
        }
        for (Object element$iv : (Object[])currentNotifications) {
            it = (InactiveRangesDamagedNotification)((Object)element$iv);
            it.expire();
        }
        Set files = CollectionsKt.toSet((Iterable)this.filesWithDamagedInactiveRanges);
        this.filesWithDamagedInactiveRanges.clear();
        new InactiveRangesDamagedNotification(this.project, files).notify(this.project);
    }

    private final void expireInactiveRangesDamagedNotifications() {
        this.filesWithDamagedInactiveRanges.clear();
        InactiveRangesDamagedNotification[] currentNotifications = (InactiveRangesDamagedNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(InactiveRangesDamagedNotification.class, this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)currentNotifications, (String)"currentNotifications");
        for (Object element$iv : (Object[])currentNotifications) {
            InactiveRangesDamagedNotification it = (InactiveRangesDamagedNotification)((Object)element$iv);
            it.expire();
        }
    }

    public LineStatusTrackerManager(@NotNull Project project, @NotNull Application application, @NotNull VcsBaseContentProvider statusProvider, @NotNull ChangeListManagerImpl changeListManager, @NotNull FileDocumentManager fileDocumentManager, @NotNull FileEditorManagerEx fileEditorManager, @NotNull DirectoryIndex makeSureIndexIsInitializedFirst) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)statusProvider, (String)"statusProvider");
        Intrinsics.checkParameterIsNotNull((Object)changeListManager, (String)"changeListManager");
        Intrinsics.checkParameterIsNotNull((Object)fileDocumentManager, (String)"fileDocumentManager");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fileEditorManager), (String)"fileEditorManager");
        Intrinsics.checkParameterIsNotNull((Object)makeSureIndexIsInitializedFirst, (String)"makeSureIndexIsInitializedFirst");
        this.project = project;
        this.application = application;
        this.statusProvider = statusProvider;
        this.changeListManager = changeListManager;
        this.fileDocumentManager = fileDocumentManager;
        this.fileEditorManager = fileEditorManager;
        this.LOCK = new Object();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
        this.disposable = disposable;
        this.trackers = new HashMap();
        this.forcedDocuments = new HashMap();
        this.eventDispatcher = EventDispatcher.create(Listener.class);
        this.partialChangeListsEnabled = VcsApplicationSettings.getInstance().ENABLE_PARTIAL_CHANGELISTS && Registry.is((String)"vcs.enable.partial.changelists");
        this.documentsInDefaultChangeList = new HashSet();
        this.filesWithDamagedInactiveRanges = new HashSet();
        this.fileStatesAwaitingRefresh = new HashMap();
        this.loader = new MyBaseRevisionLoader();
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(LineStatusTrackerManager.class);
    }

    public static final /* synthetic */ void access$setDisposed$p(LineStatusTrackerManager $this, boolean bl) {
        $this.isDisposed = bl;
    }

    public static final /* synthetic */ void access$expireInactiveRangesDamagedNotifications(LineStatusTrackerManager $this) {
        $this.expireInactiveRangesDamagedNotifications();
    }

    @NotNull
    public static final /* synthetic */ Application access$getApplication$p(LineStatusTrackerManager $this) {
        return $this.application;
    }

    @NotNull
    public static final /* synthetic */ Disposable access$getDisposable$p(LineStatusTrackerManager $this) {
        return $this.disposable;
    }

    @NotNull
    public static final /* synthetic */ LineStatusTracker.Mode access$getTrackingMode(LineStatusTrackerManager $this) {
        return $this.getTrackingMode();
    }

    public static final /* synthetic */ void access$registerTrackerInCLM(LineStatusTrackerManager $this, @NotNull LineStatusTracker tracker) {
        $this.registerTrackerInCLM(tracker);
    }

    public static final /* synthetic */ void access$refreshTracker(LineStatusTrackerManager $this, @NotNull LineStatusTracker tracker, @Nullable String changelistId) {
        $this.refreshTracker(tracker, changelistId);
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(LineStatusTrackerManager $this) {
        return $this.eventDispatcher;
    }

    @NotNull
    public static final /* synthetic */ SingleThreadLoader access$getLoader$p(LineStatusTrackerManager $this) {
        return $this.loader;
    }

    public static final /* synthetic */ void access$unregisterTrackerInCLM(LineStatusTrackerManager $this, @NotNull LineStatusTracker tracker) {
        $this.unregisterTrackerInCLM(tracker);
    }

    @JvmStatic
    @NotNull
    public static final LineStatusTrackerManagerI getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final LineStatusTrackerManager getInstanceImpl(@NotNull Project project) {
        return Companion.getInstanceImpl(project);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ListenerAdapter;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "()V", "intellij.platform.vcs.impl"})
    public static class ListenerAdapter
    implements Listener {
        @Override
        public void onTrackerAdded(@NotNull LineStatusTracker<?> tracker) {
            Intrinsics.checkParameterIsNotNull(tracker, (String)"tracker");
            Listener.DefaultImpls.onTrackerAdded(this, tracker);
        }

        @Override
        public void onTrackerRemoved(@NotNull LineStatusTracker<?> tracker) {
            Intrinsics.checkParameterIsNotNull(tracker, (String)"tracker");
            Listener.DefaultImpls.onTrackerRemoved(this, tracker);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0014\u0010\u0006\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "Ljava/util/EventListener;", "onTrackerAdded", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "onTrackerRemoved", "intellij.platform.vcs.impl"})
    public static interface Listener
    extends EventListener {
        public void onTrackerAdded(@NotNull LineStatusTracker<?> var1);

        public void onTrackerRemoved(@NotNull LineStatusTracker<?> var1);

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=3)
        public static final class DefaultImpls {
            public static void onTrackerAdded(Listener $this, @NotNull LineStatusTracker<?> tracker) {
                Intrinsics.checkParameterIsNotNull(tracker, (String)"tracker");
            }

            public static void onTrackerRemoved(Listener $this, @NotNull LineStatusTracker<?> tracker) {
                Intrinsics.checkParameterIsNotNull(tracker, (String)"tracker");
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0014J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyBaseRevisionLoader;", "Lcom/intellij/openapi/vcs/impl/SingleThreadLoader;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "handleResult", "", "request", "result", "Lcom/intellij/openapi/vcs/impl/Result;", "loadRequest", "intellij.platform.vcs.impl"})
    private final class MyBaseRevisionLoader
    extends SingleThreadLoader<RefreshRequest, RefreshData> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected Result<RefreshData> loadRequest(@NotNull RefreshRequest request) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            if (LineStatusTrackerManager.this.isDisposed) {
                return new Result.Canceled();
            }
            Document document = request.getDocument();
            VirtualFile virtualFile = LineStatusTrackerManager.this.fileDocumentManager.getFile(document);
            LineStatusTrackerManager.this.log("Loading started", virtualFile);
            if (virtualFile == null || !virtualFile.isValid()) {
                LineStatusTrackerManager.this.log("Loading error: virtual file is not valid", virtualFile);
                return new Result.Error();
            }
            if (!LineStatusTrackerManager.this.canGetBaseRevisionFor(virtualFile)) {
                LineStatusTrackerManager.this.log("Loading error: cant get base revision", virtualFile);
                return new Result.Error();
            }
            VcsBaseContentProvider.BaseContent baseContent = LineStatusTrackerManager.this.statusProvider.getBaseRevision(virtualFile);
            if (baseContent == null) {
                LineStatusTrackerManager.this.log("Loading error: base revision not found", virtualFile);
                return new Result.Error();
            }
            VcsRevisionNumber vcsRevisionNumber = baseContent.getRevisionNumber();
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsRevisionNumber, (String)"baseContent.revisionNumber");
            Charset charset = virtualFile.getCharset();
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"virtualFile.charset");
            ContentInfo newContentInfo = new ContentInfo(vcsRevisionNumber, charset);
            Object object = LineStatusTrackerManager.this.LOCK;
            synchronized (object) {
                block11: {
                    TrackerData data;
                    block10: {
                        data = (TrackerData)LineStatusTrackerManager.this.trackers.get(document);
                        if (data != null) break block10;
                        LineStatusTrackerManager.this.log("Loading cancelled: tracker not found", virtualFile);
                        Result result2 = new Result.Canceled();
                        return result2;
                    }
                    if (LineStatusTrackerManager.this.shouldBeUpdated(data.getContentInfo(), newContentInfo)) break block11;
                    LineStatusTrackerManager.this.log("Loading cancelled: no need to update", virtualFile);
                    Result result3 = new Result.Canceled();
                    return result3;
                }
                Unit unit = Unit.INSTANCE;
            }
            String lastUpToDateContent = baseContent.loadContent();
            if (lastUpToDateContent == null) {
                LineStatusTrackerManager.this.log("Loading error: provider failure", virtualFile);
                return new Result.Error();
            }
            String converted = StringUtil.convertLineSeparators((String)lastUpToDateContent);
            LineStatusTrackerManager.this.log("Loading successful", virtualFile);
            String string = converted;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"converted");
            return new Result.Success<RefreshData>(new RefreshData(string, newContentInfo));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handleResult(@NotNull RefreshRequest request, @NotNull Result<RefreshData> result2) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull(result2, (String)"result");
            Document document = request.getDocument();
            Result<RefreshData> result3 = result2;
            if (result3 instanceof Result.Canceled) {
                Object object = LineStatusTrackerManager.this.LOCK;
                synchronized (object) {
                    VirtualFile virtualFile = LineStatusTrackerManager.this.fileDocumentManager.getFile(document);
                    if (virtualFile == null) {
                        return;
                    }
                    PartialLocalLineStatusTracker.State state = (PartialLocalLineStatusTracker.State)LineStatusTrackerManager.this.fileStatesAwaitingRefresh.remove(virtualFile);
                    if (state == null) {
                        return;
                    }
                    LineStatusTrackerManager.this.edt((Function0<Unit>)((Function0)new Function0<Unit>(state, virtualFile, this, document){
                        final /* synthetic */ PartialLocalLineStatusTracker.State $state;
                        final /* synthetic */ VirtualFile $virtualFile;
                        final /* synthetic */ MyBaseRevisionLoader this$0;
                        final /* synthetic */ Document $document$inlined;
                        {
                            this.$state = state;
                            this.$virtualFile = virtualFile;
                            this.this$0 = myBaseRevisionLoader;
                            this.$document$inlined = document;
                            super(0);
                        }

                        public final void invoke() {
                            ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                                final /* synthetic */ MyBaseRevisionLoader$handleResult$$inlined$synchronized$lambda$1 this$0;
                                {
                                    this.this$0 = var1_1;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public final T compute() {
                                    Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.this$0.LineStatusTrackerManager.this);
                                    synchronized (object) {
                                        TrackerData data = (TrackerData)LineStatusTrackerManager.access$getTrackers$p(this.this$0.this$0.LineStatusTrackerManager.this).get(this.this$0.$document$inlined);
                                        if (data == null) {
                                        } else {
                                            if (data.getTracker() instanceof PartialLocalLineStatusTracker) {
                                                ((PartialLocalLineStatusTracker)data.getTracker()).restoreState$intellij_platform_vcs_impl(this.this$0.$state);
                                                LineStatusTrackerManager.access$log(this.this$0.this$0.LineStatusTrackerManager.this, "Loading canceled: state restored", this.this$0.$virtualFile);
                                            }
                                            Unit unit = Unit.INSTANCE;
                                        }
                                    }
                                    return (T)Unit.INSTANCE;
                                }
                            });
                        }
                    }));
                    Unit unit = Unit.INSTANCE;
                }
            } else if (result3 instanceof Result.Error) {
                LineStatusTrackerManager.this.edt((Function0<Unit>)((Function0)new Function0<Unit>(this, document){
                    final /* synthetic */ MyBaseRevisionLoader this$0;
                    final /* synthetic */ Document $document;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke() {
                        Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.LineStatusTrackerManager.this);
                        synchronized (object) {
                            TrackerData trackerData = (TrackerData)LineStatusTrackerManager.access$getTrackers$p(this.this$0.LineStatusTrackerManager.this).get(this.$document);
                            if (trackerData == null) {
                                return;
                            }
                            TrackerData data = trackerData;
                            data.getTracker().dropBaseRevision();
                            data.setContentInfo(null);
                            LineStatusTrackerManager.access$checkIfTrackerCanBeReleased(this.this$0.LineStatusTrackerManager.this, this.$document);
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                    {
                        this.this$0 = myBaseRevisionLoader;
                        this.$document = document;
                        super(0);
                    }
                }));
            } else if (result3 instanceof Result.Success) {
                LineStatusTrackerManager.this.edt((Function0<Unit>)((Function0)new Function0<Unit>(this, document, result2, request){
                    final /* synthetic */ MyBaseRevisionLoader this$0;
                    final /* synthetic */ Document $document;
                    final /* synthetic */ Result $result;
                    final /* synthetic */ RefreshRequest $request;

                    public final void invoke() {
                        VirtualFile virtualFile = LineStatusTrackerManager.access$getFileDocumentManager$p(this.this$0.LineStatusTrackerManager.this).getFile(this.$document);
                        if (virtualFile == null) {
                            Intrinsics.throwNpe();
                        }
                        VirtualFile virtualFile2 = virtualFile;
                        RefreshData refreshData = (RefreshData)((Result.Success)this.$result).getData();
                        ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this, virtualFile2, refreshData){
                            final /* synthetic */ handleResult.3 this$0;
                            final /* synthetic */ VirtualFile $virtualFile$inlined;
                            final /* synthetic */ RefreshData $refreshData$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$virtualFile$inlined = virtualFile;
                                this.$refreshData$inlined = refreshData;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final T compute() {
                                Object object = LineStatusTrackerManager.access$getLOCK$p(this.this$0.this$0.LineStatusTrackerManager.this);
                                synchronized (object) {
                                    TrackerData data = (TrackerData)LineStatusTrackerManager.access$getTrackers$p(this.this$0.this$0.LineStatusTrackerManager.this).get(this.this$0.$document);
                                    if (data == null) {
                                        LineStatusTrackerManager.access$log(this.this$0.this$0.LineStatusTrackerManager.this, "Loading finished: tracker already released", this.$virtualFile$inlined);
                                    } else if (!LineStatusTrackerManager.access$shouldBeUpdated(this.this$0.this$0.LineStatusTrackerManager.this, data.getContentInfo(), this.$refreshData$inlined.getInfo())) {
                                        LineStatusTrackerManager.access$log(this.this$0.this$0.LineStatusTrackerManager.this, "Loading finished: no need to update", this.$virtualFile$inlined);
                                    } else {
                                        data.setContentInfo(this.$refreshData$inlined.getInfo());
                                        LineStatusTracker<?> tracker = data.getTracker();
                                        if (tracker instanceof PartialLocalLineStatusTracker) {
                                            String string = this.this$0.$request.getChangelistId();
                                            if (string == null) {
                                                LocalChangeList localChangeList = LineStatusTrackerManager.access$getChangeListManager$p(this.this$0.this$0.LineStatusTrackerManager.this).getChangeList(this.$virtualFile$inlined);
                                                string = localChangeList != null ? localChangeList.getId() : null;
                                            }
                                            String changelist = string;
                                            ((PartialLocalLineStatusTracker)tracker).setBaseRevision((CharSequence)this.$refreshData$inlined.getText(), changelist);
                                            PartialLocalLineStatusTracker.State state = (PartialLocalLineStatusTracker.State)LineStatusTrackerManager.access$getFileStatesAwaitingRefresh$p(this.this$0.this$0.LineStatusTrackerManager.this).remove(tracker.getVirtualFile());
                                            if (state != null) {
                                                ((PartialLocalLineStatusTracker)tracker).restoreState$intellij_platform_vcs_impl(state);
                                                LineStatusTrackerManager.access$log(this.this$0.this$0.LineStatusTrackerManager.this, "Loading finished: state restored", this.$virtualFile$inlined);
                                            }
                                        } else {
                                            tracker.setBaseRevision(this.$refreshData$inlined.getText());
                                        }
                                        LineStatusTrackerManager.access$log(this.this$0.this$0.LineStatusTrackerManager.this, "Loading finished: success", this.$virtualFile$inlined);
                                        Unit unit = Unit.INSTANCE;
                                    }
                                }
                                return (T)Unit.INSTANCE;
                            }
                        });
                    }
                    {
                        this.this$0 = myBaseRevisionLoader;
                        this.$document = document;
                        this.$result = result2;
                        this.$request = refreshRequest;
                        super(0);
                    }
                }));
            }
        }

        public MyBaseRevisionLoader() {
            super(LineStatusTrackerManager.this.project);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFileStatusListener;", "Lcom/intellij/openapi/vcs/FileStatusListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "fileStatusChanged", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatusesChanged", "intellij.platform.vcs.impl"})
    private final class MyFileStatusListener
    implements FileStatusListener {
        public void fileStatusesChanged() {
            LineStatusTrackerManager.this.onEverythingChanged();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
            LineStatusTrackerManager.this.onFileChanged(virtualFile);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryAdapter;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorReleased", "isTrackedEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.vcs.impl"})
    private final class MyEditorFactoryListener
    extends EditorFactoryAdapter {
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Editor editor;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Editor editor2 = editor = event.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
            if (this.isTrackedEditor(editor2)) {
                Document document = editor.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
                LineStatusTrackerManager.this.requestTrackerFor(document, editor);
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Editor editor;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Editor editor2 = editor = event.getEditor();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor");
            if (this.isTrackedEditor(editor2)) {
                Document document = editor.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
                LineStatusTrackerManager.this.releaseTrackerFor(document, editor);
            }
        }

        private final boolean isTrackedEditor(Editor editor) {
            return editor.getProject() == null || Intrinsics.areEqual((Object)editor.getProject(), (Object)LineStatusTrackerManager.this.project);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016J*\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e0\rH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "beforeFileMovement", "", "event", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "beforePropertyChange", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "handleFileMovement", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPaths", "Lkotlin/Function0;", "Lkotlin/Pair;", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.platform.vcs.impl"})
    private final class MyVirtualFileListener
    implements VirtualFileListener {
        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (Intrinsics.areEqual((Object)"encoding", (Object)event.getPropertyName())) {
                VirtualFile virtualFile = event.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"event.file");
                LineStatusTrackerManager.this.onFileChanged(virtualFile);
            }
            if (Intrinsics.areEqual((Object)"name", (Object)event.getPropertyName())) {
                VirtualFile file2 = event.getFile();
                VirtualFile parent = event.getParent();
                if (parent != null) {
                    VirtualFile virtualFile = file2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
                    this.handleFileMovement(virtualFile, (Function0<? extends Pair<? extends FilePath, ? extends FilePath>>)((Function0)new Function0<Pair<? extends FilePath, ? extends FilePath>>(parent, event){
                        final /* synthetic */ VirtualFile $parent;
                        final /* synthetic */ VirtualFilePropertyEvent $event;

                        @NotNull
                        public final Pair<FilePath, FilePath> invoke() {
                            Object object = this.$event.getOldValue();
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                            }
                            Object object2 = this.$event.getNewValue();
                            if (object2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                            }
                            return new Pair((Object)VcsUtil.getFilePath((VirtualFile)this.$parent, (String)((String)object)), (Object)VcsUtil.getFilePath((VirtualFile)this.$parent, (String)((String)object2)));
                        }
                        {
                            this.$parent = virtualFile;
                            this.$event = virtualFilePropertyEvent;
                            super(0);
                        }
                    }));
                }
            }
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            VirtualFile file2;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            VirtualFile virtualFile = file2 = event.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
            this.handleFileMovement(virtualFile, (Function0<? extends Pair<? extends FilePath, ? extends FilePath>>)((Function0)new Function0<Pair<? extends FilePath, ? extends FilePath>>(event, file2){
                final /* synthetic */ VirtualFileMoveEvent $event;
                final /* synthetic */ VirtualFile $file;

                @NotNull
                public final Pair<FilePath, FilePath> invoke() {
                    VirtualFile virtualFile = this.$event.getOldParent();
                    VirtualFile virtualFile2 = this.$file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
                    FilePath filePath = VcsUtil.getFilePath((VirtualFile)virtualFile, (String)virtualFile2.getName());
                    VirtualFile virtualFile3 = this.$event.getNewParent();
                    VirtualFile virtualFile4 = this.$file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"file");
                    return new Pair((Object)filePath, (Object)VcsUtil.getFilePath((VirtualFile)virtualFile3, (String)virtualFile4.getName()));
                }
                {
                    this.$event = virtualFileMoveEvent;
                    this.$file = virtualFile;
                    super(0);
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void handleFileMovement(VirtualFile file2, Function0<? extends Pair<? extends FilePath, ? extends FilePath>> getPaths) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            synchronized (object) {
                Unit unit;
                LineStatusTracker<?> tracker = LineStatusTrackerManager.this.getLineStatusTracker(file2);
                if (tracker != null) {
                    void oldPath;
                    unit = (Pair)getPaths.invoke();
                    FilePath filePath = (FilePath)unit.component1();
                    FilePath newPath = (FilePath)unit.component2();
                    LineStatusTrackerManager.this.reregisterTrackerInCLM(tracker, (FilePath)oldPath, newPath);
                }
                unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.platform.vcs.impl"})
    private final class MyDocumentListener
    implements DocumentListener {
        public void documentChanged(@NotNull DocumentEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isDispatchThread()) {
                return;
            }
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Document document = event.getDocument();
            if (LineStatusTrackerManager.this.documentsInDefaultChangeList.contains(document)) {
                return;
            }
            VirtualFile virtualFile = LineStatusTrackerManager.this.fileDocumentManager.getFile(document);
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            Document document2 = document;
            Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
            if (LineStatusTrackerManager.this.getLineStatusTracker(document2) != null) {
                return;
            }
            if (!LineStatusTrackerManager.this.canGetBaseRevisionFor(virtualFile2)) {
                return;
            }
            VirtualFile virtualFile3 = virtualFile2;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
            if (!LineStatusTrackerManager.this.canCreatePartialTrackerFor(virtualFile3)) {
                return;
            }
            LocalChangeList changeList = LineStatusTrackerManager.this.changeListManager.getChangeList(virtualFile2);
            if (changeList != null && !changeList.isDefault()) {
                LineStatusTrackerManager.this.log("Tracker install from DocumentListener: ", virtualFile2);
                LineStatusTrackerManager.this.installTracker(virtualFile2, document, changeList.getId(), CollectionsKt.listOf((Object)event));
                return;
            }
            LineStatusTrackerManager.this.documentsInDefaultChangeList.add(document);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyApplicationListener;", "Lcom/intellij/openapi/application/ApplicationAdapter;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "afterWriteActionFinished", "", "action", "", "intellij.platform.vcs.impl"})
    private final class MyApplicationListener
    extends ApplicationAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void afterWriteActionFinished(@NotNull Object action) {
            Intrinsics.checkParameterIsNotNull((Object)action, (String)"action");
            LineStatusTrackerManager.this.documentsInDefaultChangeList.clear();
            Object object = LineStatusTrackerManager.this.LOCK;
            synchronized (object) {
                void $receiver$iv$iv;
                Collection collection = LineStatusTrackerManager.this.trackers.values();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"trackers.values");
                Iterable $receiver$iv = collection;
                Object object2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    TrackerData trackerData = (TrackerData)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    Document document = it.getTracker().getDocument();
                    collection2.add(document);
                }
                List documents = (List)destination$iv$iv;
                for (Document document : documents) {
                    LineStatusTrackerManager.this.checkIfTrackerCanBeReleased(document);
                }
                object2 = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyLineStatusTrackerSettingListener;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerSettingListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "settingsUpdated", "", "intellij.platform.vcs.impl"})
    private final class MyLineStatusTrackerSettingListener
    implements LineStatusTrackerSettingListener {
        @Override
        public void settingsUpdated() {
            LineStatusTrackerManager.this.partialChangeListsEnabled = VcsApplicationSettings.getInstance().ENABLE_PARTIAL_CHANGELISTS && Registry.is((String)"vcs.enable.partial.changelists");
            LineStatusTrackerManager.this.updateTrackingModes();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyChangeListListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListAdapter;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "defaultListChanged", "", "oldDefaultList", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "newDefaultList", "intellij.platform.vcs.impl"})
    private final class MyChangeListListener
    extends ChangeListAdapter {
        public void defaultListChanged(@Nullable ChangeList oldDefaultList, @Nullable ChangeList newDefaultList) {
            LineStatusTrackerManager.this.edt((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ MyChangeListListener this$0;

                public final void invoke() {
                    LineStatusTrackerManager.access$expireInactiveRangesDamagedNotifications(this.this$0.LineStatusTrackerManager.this);
                    EditorFactory editorFactory = EditorFactory.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
                    Editor[] editorArray = editorFactory.getAllEditors();
                    Intrinsics.checkExpressionValueIsNotNull((Object)editorArray, (String)"EditorFactory.getInstance().allEditors");
                    Iterable $receiver$iv = ArraysKt.filterIsInstance((Object[])editorArray, EditorEx.class);
                    for (T element$iv : $receiver$iv) {
                        EditorEx it = (EditorEx)element$iv;
                        it.getGutterComponentEx().repaint();
                    }
                }
                {
                    this.this$0 = myChangeListListener;
                    super(0);
                }
            }));
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyCommandListener;", "Lcom/intellij/openapi/command/CommandListener;", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "commandFinished", "", "event", "Lcom/intellij/openapi/command/CommandEvent;", "intellij.platform.vcs.impl"})
    private final class MyCommandListener
    implements CommandListener {
        public void commandFinished(@Nullable CommandEvent event) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)commandProcessor, (String)"CommandProcessor.getInstance()");
            if (commandProcessor.getCurrentCommand() == null && !LineStatusTrackerManager.this.filesWithDamagedInactiveRanges.isEmpty()) {
                LineStatusTrackerManager.this.showInactiveRangesDamagedNotification();
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "contentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "(Lcom/intellij/openapi/vcs/ex/LineStatusTracker;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;)V", "getContentInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "setContentInfo", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "intellij.platform.vcs.impl"})
    private static final class TrackerData {
        @NotNull
        private final LineStatusTracker<?> tracker;
        @Nullable
        private ContentInfo contentInfo;

        @NotNull
        public final LineStatusTracker<?> getTracker() {
            return this.tracker;
        }

        @Nullable
        public final ContentInfo getContentInfo() {
            return this.contentInfo;
        }

        public final void setContentInfo(@Nullable ContentInfo contentInfo) {
            this.contentInfo = contentInfo;
        }

        public TrackerData(@NotNull LineStatusTracker<?> tracker, @Nullable ContentInfo contentInfo) {
            Intrinsics.checkParameterIsNotNull(tracker, (String)"tracker");
            this.tracker = tracker;
            this.contentInfo = contentInfo;
        }

        public /* synthetic */ TrackerData(LineStatusTracker lineStatusTracker, ContentInfo contentInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                contentInfo = null;
            }
            this(lineStatusTracker, contentInfo);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "", "revision", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "charset", "Ljava/nio/charset/Charset;", "(Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Ljava/nio/charset/Charset;)V", "getCharset", "()Ljava/nio/charset/Charset;", "getRevision", "()Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "intellij.platform.vcs.impl"})
    private static final class ContentInfo {
        @NotNull
        private final VcsRevisionNumber revision;
        @NotNull
        private final Charset charset;

        @NotNull
        public final VcsRevisionNumber getRevision() {
            return this.revision;
        }

        @NotNull
        public final Charset getCharset() {
            return this.charset;
        }

        public ContentInfo(@NotNull VcsRevisionNumber revision, @NotNull Charset charset) {
            Intrinsics.checkParameterIsNotNull((Object)revision, (String)"revision");
            Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
            this.revision = revision;
            this.charset = charset;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "", "document", "Lcom/intellij/openapi/editor/Document;", "changelistId", "", "(Lcom/intellij/openapi/editor/Document;Ljava/lang/String;)V", "getChangelistId", "()Ljava/lang/String;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "equals", "", "other", "hashCode", "", "intellij.platform.vcs.impl"})
    private static final class RefreshRequest {
        @NotNull
        private final Document document;
        @Nullable
        private final String changelistId;

        public boolean equals(@Nullable Object other) {
            return other instanceof RefreshRequest && Intrinsics.areEqual((Object)this.document, (Object)((RefreshRequest)other).document);
        }

        public int hashCode() {
            return this.document.hashCode();
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @Nullable
        public final String getChangelistId() {
            return this.changelistId;
        }

        public RefreshRequest(@NotNull Document document, @Nullable String changelistId) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            this.document = document;
            this.changelistId = changelistId;
        }

        public /* synthetic */ RefreshRequest(Document document, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = null;
            }
            this(document, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "", "text", "", "info", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "(Ljava/lang/String;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;)V", "getInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ContentInfo;", "getText", "()Ljava/lang/String;", "intellij.platform.vcs.impl"})
    private static final class RefreshData {
        @NotNull
        private final String text;
        @NotNull
        private final ContentInfo info;

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final ContentInfo getInfo() {
            return this.info;
        }

        public RefreshData(@NotNull String text, @NotNull ContentInfo info) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            this.text = text;
            this.info = info;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$InactiveRangesDamagedNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "getVirtualFiles", "()Ljava/util/Set;", "intellij.platform.vcs.impl"})
    private static final class InactiveRangesDamagedNotification
    extends Notification {
        @NotNull
        private final Set<VirtualFile> virtualFiles;

        @NotNull
        public final Set<VirtualFile> getVirtualFiles() {
            return this.virtualFiles;
        }

        public InactiveRangesDamagedNotification(final @NotNull Project project, @NotNull Set<? extends VirtualFile> virtualFiles) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(virtualFiles, (String)"virtualFiles");
            NotificationGroup notificationGroup = VcsNotifier.STANDARD_NOTIFICATION;
            Intrinsics.checkExpressionValueIsNotNull((Object)notificationGroup, (String)"VcsNotifier.STANDARD_NOTIFICATION");
            super(notificationGroup.getDisplayId(), AllIcons.Toolwindows.ToolWindowChanges, null, null, VcsBundle.getString((String)"lst.inactive.ranges.damaged.notification"), NotificationType.INFORMATION, null);
            this.virtualFiles = virtualFiles;
            this.addAction((AnAction)NotificationAction.createSimple((String)"View Changes...", (Runnable)new Runnable(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void run() {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    LocalChangeList defaultList;
                    ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                    Intrinsics.checkExpressionValueIsNotNull((Object)changeListManager, (String)"ChangeListManager.getInstance(project)");
                    LocalChangeList localChangeList = defaultList = changeListManager.getDefaultChangeList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)localChangeList, (String)"defaultList");
                    Collection collection = localChangeList.getChanges();
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"defaultList.changes");
                    Iterable iterable = $receiver$iv = (Iterable)collection;
                    Collection destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        Change it = (Change)element$iv$iv;
                        Iterable iterable2 = this.getVirtualFiles();
                        Change change = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"it");
                        if (!CollectionsKt.contains((Iterable)iterable2, (Object)change.getVirtualFile())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    final List changes = (List)destination$iv$iv;
                    ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
                    window.activate(new Runnable(){

                        @Override
                        public final void run() {
                            ChangesViewManager.getInstance(project).selectChanges(changes);
                        }
                    });
                    this.expire();
                }
            }));
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceImpl", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        @JvmStatic
        @NotNull
        public final LineStatusTrackerManagerI getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = project.getComponent(LineStatusTrackerManagerI.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.getComponent(Lin\u2026ckerManagerI::class.java)");
            return (LineStatusTrackerManagerI)object;
        }

        @JvmStatic
        @NotNull
        public final LineStatusTrackerManager getInstanceImpl(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            LineStatusTrackerManagerI lineStatusTrackerManagerI = this.getInstance(project);
            if (lineStatusTrackerManagerI == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vcs.impl.LineStatusTrackerManager");
            }
            return (LineStatusTrackerManager)lineStatusTrackerManagerI;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

