/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DesktopLayout {
    private static final Logger LOG = Logger.getInstance(DesktopLayout.class);
    @NonNls
    static final String TAG = "layout";
    private final Map<String, WindowInfoImpl> myRegisteredId2Info = new HashMap<String, WindowInfoImpl>();
    private final Map<String, WindowInfoImpl> myUnregisteredId2Info = new THashMap();
    private static final MyWindowInfoComparator ourWindowInfoComparator = new MyWindowInfoComparator();
    private WindowInfoImpl[] myRegisteredInfos;
    private WindowInfoImpl[] myUnregisteredInfos;
    private WindowInfoImpl[] myAllInfos;

    public final void copyFrom(@NotNull DesktopLayout layout) {
        if (layout == null) {
            DesktopLayout.$$$reportNull$$$0(0);
        }
        for (WindowInfoImpl info1 : layout.getAllInfos()) {
            WindowInfoImpl info = this.myRegisteredId2Info.get(info1.getId());
            if (info != null) {
                info.copyFrom(info1);
                continue;
            }
            info = this.myUnregisteredId2Info.get(info1.getId());
            if (info == null) {
                this.myUnregisteredId2Info.put(info1.getId(), info1.copy());
                continue;
            }
            info.copyFrom(info1);
        }
        this.myRegisteredInfos = null;
        this.myUnregisteredInfos = null;
        this.myAllInfos = null;
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.TOP));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.LEFT));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.BOTTOM));
        DesktopLayout.normalizeOrder(this.getAllInfos(ToolWindowAnchor.RIGHT));
    }

    final WindowInfoImpl register(@NotNull String id, @NotNull ToolWindowAnchor anchor2, boolean splitMode) {
        WindowInfoImpl info;
        if (id == null) {
            DesktopLayout.$$$reportNull$$$0(1);
        }
        if (anchor2 == null) {
            DesktopLayout.$$$reportNull$$$0(2);
        }
        if ((info = this.myUnregisteredId2Info.get(id)) == null) {
            info = new WindowInfoImpl();
            info.setId(id);
            info.setAnchor(anchor2);
            info.setSplit(splitMode);
        } else {
            this.myUnregisteredId2Info.remove(id);
        }
        this.myRegisteredId2Info.put(id, info);
        this.myRegisteredInfos = null;
        this.myUnregisteredInfos = null;
        this.myAllInfos = null;
        return info;
    }

    final void unregister(@NotNull String id) {
        if (id == null) {
            DesktopLayout.$$$reportNull$$$0(3);
        }
        WindowInfoImpl info = this.myRegisteredId2Info.remove(id).copy();
        this.myUnregisteredId2Info.put(id, info);
        this.myRegisteredInfos = null;
        this.myUnregisteredInfos = null;
        this.myAllInfos = null;
    }

    final WindowInfoImpl getInfo(@NotNull String id, boolean onlyRegistered) {
        if (id == null) {
            DesktopLayout.$$$reportNull$$$0(4);
        }
        WindowInfoImpl info = this.myRegisteredId2Info.get(id);
        if (onlyRegistered || info != null) {
            return info;
        }
        return this.myUnregisteredId2Info.get(id);
    }

    @Nullable
    final String getActiveId() {
        WindowInfoImpl[] infos;
        for (WindowInfoImpl info : infos = this.getInfos()) {
            if (!info.isActive()) continue;
            return info.getId();
        }
        return null;
    }

    @NotNull
    final WindowInfoImpl[] getInfos() {
        if (this.myRegisteredInfos == null) {
            this.myRegisteredInfos = this.myRegisteredId2Info.values().toArray(new WindowInfoImpl[0]);
        }
        if (this.myRegisteredInfos == null) {
            DesktopLayout.$$$reportNull$$$0(5);
        }
        return this.myRegisteredInfos;
    }

    @NotNull
    private WindowInfoImpl[] getUnregisteredInfos() {
        if (this.myUnregisteredInfos == null) {
            this.myUnregisteredInfos = this.myUnregisteredId2Info.values().toArray(new WindowInfoImpl[0]);
        }
        if (this.myUnregisteredInfos == null) {
            DesktopLayout.$$$reportNull$$$0(6);
        }
        return this.myUnregisteredInfos;
    }

    @NotNull
    private WindowInfoImpl[] getAllInfos() {
        Object[] registeredInfos = this.getInfos();
        Object[] unregisteredInfos = this.getUnregisteredInfos();
        this.myAllInfos = (WindowInfoImpl[])ArrayUtil.mergeArrays((Object[])registeredInfos, (Object[])unregisteredInfos);
        if (this.myAllInfos == null) {
            DesktopLayout.$$$reportNull$$$0(7);
        }
        return this.myAllInfos;
    }

    @NotNull
    private WindowInfoImpl[] getAllInfos(@NotNull ToolWindowAnchor anchor2) {
        if (anchor2 == null) {
            DesktopLayout.$$$reportNull$$$0(8);
        }
        WindowInfoImpl[] infos = this.getAllInfos();
        ArrayList<WindowInfoImpl> list2 = new ArrayList<WindowInfoImpl>(infos.length);
        for (WindowInfoImpl info : infos) {
            if (anchor2 != info.getAnchor()) continue;
            list2.add(info);
        }
        infos = list2.toArray(new WindowInfoImpl[0]);
        Arrays.sort(infos, ourWindowInfoComparator);
        if (infos == null) {
            DesktopLayout.$$$reportNull$$$0(9);
        }
        return infos;
    }

    private static void normalizeOrder(@NotNull WindowInfoImpl[] infos) {
        if (infos == null) {
            DesktopLayout.$$$reportNull$$$0(10);
        }
        for (int i = 0; i < infos.length; ++i) {
            infos[i].setOrder(i);
        }
    }

    final boolean isToolWindowRegistered(@NotNull String id) {
        if (id == null) {
            DesktopLayout.$$$reportNull$$$0(11);
        }
        return this.myRegisteredId2Info.containsKey(id);
    }

    final boolean isToolWindowUnregistered(@NotNull String id) {
        if (id == null) {
            DesktopLayout.$$$reportNull$$$0(12);
        }
        return this.myUnregisteredId2Info.containsKey(id);
    }

    @NotNull
    final Comparator<StripeButton> comparator(@NotNull ToolWindowAnchor anchor2) {
        if (anchor2 == null) {
            DesktopLayout.$$$reportNull$$$0(13);
        }
        MyStripeButtonComparator myStripeButtonComparator = new MyStripeButtonComparator(anchor2);
        if (myStripeButtonComparator == null) {
            DesktopLayout.$$$reportNull$$$0(14);
        }
        return myStripeButtonComparator;
    }

    private int getMaxOrder(@NotNull ToolWindowAnchor anchor2) {
        WindowInfoImpl[] infos;
        if (anchor2 == null) {
            DesktopLayout.$$$reportNull$$$0(15);
        }
        int res = -1;
        for (WindowInfoImpl info : infos = this.getAllInfos()) {
            if (anchor2 != info.getAnchor() || res >= info.getOrder()) continue;
            res = info.getOrder();
        }
        return res;
    }

    final void setAnchor(@NotNull String id, @NotNull ToolWindowAnchor newAnchor, int newOrder) {
        if (id == null) {
            DesktopLayout.$$$reportNull$$$0(16);
        }
        if (newAnchor == null) {
            DesktopLayout.$$$reportNull$$$0(17);
        }
        if (newOrder == -1) {
            newOrder = this.getMaxOrder(newAnchor) + 1;
        }
        WindowInfoImpl info = this.getInfo(id, true);
        ToolWindowAnchor oldAnchor = info.getAnchor();
        WindowInfoImpl[] infos = this.getAllInfos(newAnchor);
        for (int i = infos.length - 1; i > -1; --i) {
            WindowInfoImpl info2 = infos[i];
            if (newOrder > info2.getOrder()) continue;
            info2.setOrder(info2.getOrder() + 1);
        }
        info.setAnchor(newAnchor);
        info.setOrder(newOrder);
        DesktopLayout.normalizeOrder(this.getAllInfos(oldAnchor));
        if (oldAnchor != newAnchor) {
            DesktopLayout.normalizeOrder(this.getAllInfos(newAnchor));
        }
    }

    final void setSplitMode(@NotNull String id, boolean split) {
        if (id == null) {
            DesktopLayout.$$$reportNull$$$0(18);
        }
        WindowInfoImpl info = this.getInfo(id, true);
        info.setSplit(split);
    }

    public final void readExternal(@NotNull Element layoutElement) {
        if (layoutElement == null) {
            DesktopLayout.$$$reportNull$$$0(19);
        }
        this.myUnregisteredInfos = null;
        for (Element e : layoutElement.getChildren("window_info")) {
            WindowInfoImpl info = (WindowInfoImpl)XmlSerializer.deserialize((Element)e, WindowInfoImpl.class);
            if (info.getId() == null) {
                LOG.warn("Skip invalid window info (no id): " + JDOMUtil.writeElement((Element)e));
                continue;
            }
            if (info.getOrder() == -1) {
                info.setOrder(this.getMaxOrder(info.getAnchor()) + 1);
            }
            this.myUnregisteredId2Info.put(info.getId(), info);
        }
    }

    @Nullable
    public final Element writeExternal(@NotNull String tagName) {
        WindowInfoImpl[] infos;
        if (tagName == null) {
            DesktopLayout.$$$reportNull$$$0(20);
        }
        if ((infos = this.getAllInfos()).length == 0) {
            return null;
        }
        Element state = new Element(tagName);
        for (WindowInfoImpl info : infos) {
            Element element = XmlSerializer.serialize((Object)info);
            if (element == null) continue;
            state.addContent(element);
        }
        return state;
    }

    @NotNull
    List<String> getVisibleIdsOn(@NotNull ToolWindowAnchor anchor2, @NotNull ToolWindowManagerImpl manager) {
        if (anchor2 == null) {
            DesktopLayout.$$$reportNull$$$0(21);
        }
        if (manager == null) {
            DesktopLayout.$$$reportNull$$$0(22);
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (WindowInfoImpl each : this.getAllInfos(anchor2)) {
            ToolWindow window = manager.getToolWindow(each.getId());
            if (window == null || !window.isAvailable() && !UISettings.getInstance().getAlwaysShowWindowsButton()) continue;
            ids.add(each.getId());
        }
        ArrayList<String> arrayList = ids;
        if (arrayList == null) {
            DesktopLayout.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = TAG;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 8: 
            case 13: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/DesktopLayout";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAnchor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutElement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/DesktopLayout";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnregisteredInfos";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInfos";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "comparator";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleIdsOn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 23: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllInfos";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "normalizeOrder";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isToolWindowRegistered";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isToolWindowUnregistered";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "comparator";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMaxOrder";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setAnchor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setSplitMode";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleIdsOn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyStripeButtonComparator
    implements Comparator<StripeButton> {
        private final HashMap<String, WindowInfoImpl> myId2Info;

        public MyStripeButtonComparator(ToolWindowAnchor anchor2) {
            WindowInfoImpl[] infos;
            if (anchor2 == null) {
                MyStripeButtonComparator.$$$reportNull$$$0(0);
            }
            this.myId2Info = new HashMap();
            for (WindowInfoImpl info : infos = DesktopLayout.this.getInfos()) {
                if (anchor2 != info.getAnchor()) continue;
                this.myId2Info.put(info.getId(), info.copy());
            }
        }

        @Override
        public final int compare(StripeButton obj1, StripeButton obj2) {
            WindowInfoImpl info1 = this.myId2Info.get(obj1.getWindowInfo().getId());
            int order1 = info1 != null ? info1.getOrder() : 0;
            WindowInfoImpl info2 = this.myId2Info.get(obj2.getWindowInfo().getId());
            int order2 = info2 != null ? info2.getOrder() : 0;
            return order1 - order2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/openapi/wm/impl/DesktopLayout$MyStripeButtonComparator", "<init>"));
        }
    }

    private static final class MyWindowInfoComparator
    implements Comparator<WindowInfoImpl> {
        private MyWindowInfoComparator() {
        }

        @Override
        public int compare(WindowInfoImpl info1, WindowInfoImpl info2) {
            return info1.getOrder() - info2.getOrder();
        }
    }
}

