/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.X11UiUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.mac.MacMainFrameDecorator;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JMenuBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeFrameDecorator
implements Disposable {
    protected IdeFrameImpl myFrame;

    protected IdeFrameDecorator(IdeFrameImpl frame) {
        this.myFrame = frame;
    }

    public abstract boolean isInFullScreen();

    public abstract ActionCallback toggleFullScreen(boolean var1);

    public void dispose() {
        this.myFrame = null;
    }

    @Nullable
    public static IdeFrameDecorator decorate(@NotNull IdeFrameImpl frame) {
        if (frame == null) {
            IdeFrameDecorator.$$$reportNull$$$0(0);
        }
        if (SystemInfo.isMac) {
            return new MacMainFrameDecorator(frame, PlatformUtils.isAppCode());
        }
        if (SystemInfo.isWindows) {
            return new WinMainFrameDecorator(frame);
        }
        if (SystemInfo.isXWindow && X11UiUtil.isFullScreenSupported()) {
            return new EWMHFrameDecorator(frame);
        }
        return null;
    }

    protected void notifyFrameComponents(boolean state) {
        if (this.myFrame != null) {
            this.myFrame.getRootPane().putClientProperty("ide.frame.full.screen", state);
            JMenuBar menuBar = this.myFrame.getJMenuBar();
            if (menuBar != null) {
                menuBar.putClientProperty("ide.frame.full.screen", state);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/openapi/wm/impl/IdeFrameDecorator", "decorate"));
    }

    private static class EWMHFrameDecorator
    extends IdeFrameDecorator {
        private Boolean myRequestedState = null;

        private EWMHFrameDecorator(IdeFrameImpl frame) {
            super(frame);
            frame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (myRequestedState != null) {
                        this.notifyFrameComponents(myRequestedState);
                        myRequestedState = null;
                    }
                }
            });
        }

        @Override
        public boolean isInFullScreen() {
            return this.myFrame != null && X11UiUtil.isInFullScreenMode(this.myFrame);
        }

        @Override
        public ActionCallback toggleFullScreen(boolean state) {
            if (this.myFrame != null) {
                this.myRequestedState = state;
                X11UiUtil.toggleFullScreenMode(this.myFrame);
            }
            return ActionCallback.DONE;
        }
    }

    private static class WinMainFrameDecorator
    extends IdeFrameDecorator {
        private WinMainFrameDecorator(@NotNull IdeFrameImpl frame) {
            if (frame == null) {
                WinMainFrameDecorator.$$$reportNull$$$0(0);
            }
            super(frame);
        }

        @Override
        public boolean isInFullScreen() {
            if (this.myFrame == null) {
                return false;
            }
            Rectangle frameBounds = this.myFrame.getBounds();
            GraphicsDevice device = ScreenUtil.getScreenDevice((Rectangle)frameBounds);
            return device != null && device.getDefaultConfiguration().getBounds().equals(frameBounds) && this.myFrame.isUndecorated();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActionCallback toggleFullScreen(boolean state) {
            if (this.myFrame == null) {
                return ActionCallback.REJECTED;
            }
            GraphicsDevice device = ScreenUtil.getScreenDevice((Rectangle)this.myFrame.getBounds());
            if (device == null) {
                return ActionCallback.REJECTED;
            }
            try {
                this.myFrame.getRootPane().putClientProperty("dispose.temporary", Boolean.TRUE);
                if (state) {
                    this.myFrame.getRootPane().putClientProperty("oldBounds", this.myFrame.getBounds());
                }
                this.myFrame.dispose();
                if (!Registry.is((String)"ide.win.frame.decoration") || !UIUtil.isUnderDarcula() && !UIUtil.isUnderIntelliJLaF()) {
                    this.myFrame.setUndecorated(state);
                }
            }
            finally {
                if (state) {
                    this.myFrame.setBounds(device.getDefaultConfiguration().getBounds());
                } else {
                    Object o = this.myFrame.getRootPane().getClientProperty("oldBounds");
                    if (o instanceof Rectangle) {
                        this.myFrame.setBounds((Rectangle)o);
                    }
                }
                this.myFrame.setVisible(true);
                this.myFrame.getRootPane().putClientProperty("dispose.temporary", null);
                this.notifyFrameComponents(state);
            }
            return ActionCallback.DONE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/openapi/wm/impl/IdeFrameDecorator$WinMainFrameDecorator", "<init>"));
        }
    }
}

