/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.injection.ReferenceInjector;
import java.util.Iterator;
import java.util.List;

class InjectionResult
implements ModificationTracker {
    final List<PsiFile> files;
    final List<Pair<ReferenceInjector, Place>> references;

    InjectionResult(List<PsiFile> files, List<Pair<ReferenceInjector, Place>> references) {
        this.files = files;
        this.references = references;
        if (files == null && references == null) {
            throw new IllegalArgumentException("At least one argument must not be null");
        }
    }

    boolean isValid() {
        if (this.files != null) {
            for (PsiFile file2 : this.files) {
                if (file2.isValid()) continue;
                return false;
            }
        } else {
            for (Pair<ReferenceInjector, Place> pair : this.references) {
                Place place = (Place)((Object)pair.getSecond());
                if (place.isValid()) continue;
                return false;
            }
        }
        return true;
    }

    public long getModificationCount() {
        long modCount = 0L;
        if (this.files != null) {
            for (PsiFile psiFile : this.files) {
                if (!psiFile.isValid()) {
                    return -1L;
                }
                modCount += psiFile.getModificationStamp();
            }
        }
        if (this.references != null) {
            for (Pair pair : this.references) {
                Place place = (Place)((Object)pair.getSecond());
                if (!place.isValid()) {
                    return -1L;
                }
                Iterator iterator = place.iterator();
                while (iterator.hasNext()) {
                    PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)iterator.next();
                    PsiLanguageInjectionHost host = shred.getHost();
                    if (host == null || !host.isValid()) {
                        return -1L;
                    }
                    PsiFile file3 = host.getContainingFile();
                    modCount += file3.getModificationStamp();
                }
            }
        }
        return modCount;
    }
}

