/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.history.FileHistoryFilterUi;
import com.intellij.vcs.log.history.FileHistoryPanel;
import com.intellij.vcs.log.history.FileHistoryUiProperties;
import com.intellij.vcs.log.history.FileHistoryVisiblePack;
import com.intellij.vcs.log.history.VcsLogFileRevision;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryUi
extends AbstractVcsLogUi {
    @NotNull
    private static final List<String> HIGHLIGHTERS = Arrays.asList("MY_COMMITS", "CURRENT_BRANCH");
    @NotNull
    private final FileHistoryUiProperties myUiProperties;
    @NotNull
    private final FileHistoryFilterUi myFilterUi;
    @NotNull
    private final FilePath myPath;
    @Nullable
    private final Hash myRevision;
    @NotNull
    private final FileHistoryPanel myFileHistoryPanel;
    @NotNull
    private final IndexDataGetter myIndexDataGetter;
    @NotNull
    private final MyPropertiesChangeListener myPropertiesChangeListener;

    public FileHistoryUi(@NotNull VcsLogData logData, @NotNull Project project, @NotNull VcsLogColorManager manager, @NotNull FileHistoryUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @NotNull FilePath path, @Nullable Hash revision) {
        if (logData == null) {
            FileHistoryUi.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FileHistoryUi.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            FileHistoryUi.$$$reportNull$$$0(2);
        }
        if (uiProperties == null) {
            FileHistoryUi.$$$reportNull$$$0(3);
        }
        if (refresher == null) {
            FileHistoryUi.$$$reportNull$$$0(4);
        }
        if (path == null) {
            FileHistoryUi.$$$reportNull$$$0(5);
        }
        super(logData, project, manager, refresher);
        this.myUiProperties = uiProperties;
        this.myIndexDataGetter = (IndexDataGetter)ObjectUtils.assertNotNull((Object)logData.getIndex().getDataGetter());
        this.myRevision = revision;
        CommitId commitId = revision == null ? null : new CommitId(revision, (VirtualFile)ObjectUtils.assertNotNull((Object)VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path)));
        this.myFilterUi = new FileHistoryFilterUi(path, commitId, uiProperties);
        this.myPath = path;
        this.myFileHistoryPanel = new FileHistoryPanel(this, logData, this.myVisiblePack, path);
        this.updateFilter();
        for (VcsLogHighlighterFactory factory : ContainerUtil.filter((Object[])Extensions.getExtensions((ExtensionPointName)LOG_HIGHLIGHTER_FACTORY_EP, (AreaInstance)this.myProject), f -> HIGHLIGHTERS.contains(f.getId()))) {
            this.getTable().addHighlighter(factory.createHighlighter(logData, this));
        }
        this.myPropertiesChangeListener = new MyPropertiesChangeListener();
        this.myUiProperties.addChangeListener(this.myPropertiesChangeListener);
    }

    @Nullable
    public VirtualFile createVcsVirtualFile(@NotNull VcsFullCommitDetails details) {
        if (details == null) {
            FileHistoryUi.$$$reportNull$$$0(6);
        }
        VcsFileRevision revision = this.createRevision(details);
        return this.createVcsVirtualFile(revision);
    }

    @Nullable
    public VirtualFile createVcsVirtualFile(@Nullable VcsFileRevision revision) {
        if (!VcsHistoryUtil.isEmpty(revision) && revision instanceof VcsFileRevisionEx) {
            FilePath path = ((VcsFileRevisionEx)revision).getPath();
            return path.isDirectory() ? new VcsVirtualFolder(path.getPath(), null, (VirtualFileSystem)VcsFileSystem.getInstance()) : new VcsVirtualFile(path.getPath(), revision, (VirtualFileSystem)VcsFileSystem.getInstance());
        }
        return null;
    }

    @Nullable
    public VcsFileRevision createRevision(@Nullable VcsFullCommitDetails details) {
        if (details != null && !(details instanceof LoadingDetails)) {
            List<Change> changes = this.collectRelevantChanges(details);
            for (Change change : changes) {
                ContentRevision revision = change.getAfterRevision();
                if (revision == null) continue;
                return new VcsLogFileRevision(details, revision, revision.getFile());
            }
            if (!changes.isEmpty()) {
                return VcsFileRevision.NULL;
            }
        }
        return null;
    }

    @Nullable
    public FilePath getPath(@NotNull VcsFullCommitDetails details) {
        if (details == null) {
            FileHistoryUi.$$$reportNull$$$0(7);
        }
        if (this.myPath.isDirectory()) {
            return this.myPath;
        }
        List<Change> changes = this.collectRelevantChanges(details);
        for (Change change : changes) {
            ContentRevision revision = change.getAfterRevision();
            if (revision == null) continue;
            return revision.getFile();
        }
        return null;
    }

    @NotNull
    public List<Change> collectRelevantChanges(@NotNull VcsFullCommitDetails details) {
        if (details == null) {
            FileHistoryUi.$$$reportNull$$$0(8);
        }
        Set<FilePath> fileNames = this.getFileNames(details);
        if (this.myPath.isDirectory()) {
            List list2 = ContainerUtil.filter((Collection)details.getChanges(), change -> FileHistoryUi.affectsDirectories(change, fileNames));
            if (list2 == null) {
                FileHistoryUi.$$$reportNull$$$0(9);
            }
            return list2;
        }
        List list3 = ContainerUtil.filter((Collection)details.getChanges(), change -> FileHistoryUi.affectsFiles(change, fileNames));
        if (list3 == null) {
            FileHistoryUi.$$$reportNull$$$0(10);
        }
        return list3;
    }

    @NotNull
    private Set<FilePath> getFileNames(@NotNull VcsFullCommitDetails details) {
        Set<FilePath> names;
        if (details == null) {
            FileHistoryUi.$$$reportNull$$$0(11);
        }
        int commitIndex = this.myLogData.getStorage().getCommitIndex((Hash)details.getId(), details.getRoot());
        if (this.myVisiblePack instanceof FileHistoryVisiblePack) {
            Map<Integer, FilePath> namesData = ((FileHistoryVisiblePack)this.myVisiblePack).getNamesData();
            names = Collections.singleton(namesData.get(commitIndex));
        } else {
            names = this.myIndexDataGetter.getFileNames(this.myPath, commitIndex);
        }
        if (names.isEmpty()) {
            Set<FilePath> set2 = Collections.singleton(this.myPath);
            if (set2 == null) {
                FileHistoryUi.$$$reportNull$$$0(12);
            }
            return set2;
        }
        Set<FilePath> set3 = names;
        if (set3 == null) {
            FileHistoryUi.$$$reportNull$$$0(13);
        }
        return set3;
    }

    private static boolean affectsFiles(@NotNull Change change, @NotNull Set<FilePath> files) {
        if (change == null) {
            FileHistoryUi.$$$reportNull$$$0(14);
        }
        if (files == null) {
            FileHistoryUi.$$$reportNull$$$0(15);
        }
        ContentRevision revision = (ContentRevision)ObjectUtils.notNull((Object)ObjectUtils.chooseNotNull((Object)change.getAfterRevision(), (Object)change.getBeforeRevision()));
        return files.contains(revision.getFile());
    }

    private static boolean affectsDirectories(@NotNull Change change, @NotNull Set<FilePath> directories) {
        FilePath file2;
        if (change == null) {
            FileHistoryUi.$$$reportNull$$$0(16);
        }
        if (directories == null) {
            FileHistoryUi.$$$reportNull$$$0(17);
        }
        return ContainerUtil.find(directories, arg_0 -> FileHistoryUi.lambda$affectsDirectories$3(file2 = ((ContentRevision)ObjectUtils.notNull((Object)ObjectUtils.chooseNotNull((Object)change.getAfterRevision(), (Object)change.getBeforeRevision()))).getFile(), arg_0)) != null;
    }

    @NotNull
    public List<Change> collectChanges(@NotNull List<VcsFullCommitDetails> detailsList, boolean onlyRelevant) {
        if (detailsList == null) {
            FileHistoryUi.$$$reportNull$$$0(18);
        }
        ArrayList changes = ContainerUtil.newArrayList();
        List detailsListReversed = ContainerUtil.reverse(detailsList);
        for (VcsFullCommitDetails details : detailsListReversed) {
            changes.addAll(onlyRelevant ? this.collectRelevantChanges(details) : details.getChanges());
        }
        List<Change> list2 = CommittedChangesTreeBrowser.zipChanges(changes);
        if (list2 == null) {
            FileHistoryUi.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @Override
    protected <T> void handleCommitNotFound(@NotNull T commitId, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        if (commitId == null) {
            FileHistoryUi.$$$reportNull$$$0(20);
        }
        if (rowGetter == null) {
            FileHistoryUi.$$$reportNull$$$0(21);
        }
        String mainText = "Commit " + commitId.toString() + " does not exist in history for " + this.myPath.getName();
        if (this.getFilters().get(VcsLogFilterCollection.BRANCH_FILTER) != null) {
            this.showWarningWithLink(mainText + " in current branch.", "Show all branches and search again.", () -> {
                if (commitId == null) {
                    FileHistoryUi.$$$reportNull$$$0(29);
                }
                if (rowGetter == null) {
                    FileHistoryUi.$$$reportNull$$$0(30);
                }
                this.myUiProperties.set(FileHistoryUiProperties.SHOW_ALL_BRANCHES, true);
                this.invokeOnChange(() -> {
                    if (commitId == null) {
                        FileHistoryUi.$$$reportNull$$$0(31);
                    }
                    if (rowGetter == null) {
                        FileHistoryUi.$$$reportNull$$$0(32);
                    }
                    this.jumpTo(commitId, rowGetter, (SettableFuture<Boolean>)SettableFuture.create());
                });
            });
        } else {
            VcsLogUiImpl mainLogUi = VcsProjectLog.getInstance(this.myProject).getMainLogUi();
            if (mainLogUi != null) {
                this.showWarningWithLink(mainText + ".", "Search in Log.", () -> {
                    if (commitId == null) {
                        FileHistoryUi.$$$reportNull$$$0(28);
                    }
                    if (VcsLogContentUtil.selectLogUi(this.myProject, mainLogUi)) {
                        if (commitId instanceof Hash) {
                            mainLogUi.jumpToCommit((Hash)commitId, (VirtualFile)ObjectUtils.notNull((Object)VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)this.myPath)), (SettableFuture<Boolean>)SettableFuture.create());
                        } else if (commitId instanceof String) {
                            mainLogUi.jumpToCommitByPartOfHash((String)commitId, (SettableFuture<Boolean>)SettableFuture.create());
                        }
                    }
                });
            } else {
                super.handleCommitNotFound(commitId, rowGetter);
            }
        }
    }

    @NotNull
    public FilePath getPath() {
        FilePath filePath = this.myPath;
        if (filePath == null) {
            FileHistoryUi.$$$reportNull$$$0(22);
        }
        return filePath;
    }

    @Nullable
    public Hash getRevision() {
        return this.myRevision;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        FileHistoryFilterUi fileHistoryFilterUi = this.myFilterUi;
        if (fileHistoryFilterUi == null) {
            FileHistoryUi.$$$reportNull$$$0(23);
        }
        return fileHistoryFilterUi;
    }

    @Override
    public boolean areGraphActionsEnabled() {
        return false;
    }

    public boolean isMultipleRoots() {
        return false;
    }

    @Override
    public boolean isShowRootNames() {
        return false;
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        if (id == null) {
            FileHistoryUi.$$$reportNull$$$0(24);
        }
        return HIGHLIGHTERS.contains(id);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        this.myFileHistoryPanel.updateDataPack(this.myVisiblePack, permGraphChanged);
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myFileHistoryPanel.getGraphTable();
        if (vcsLogGraphTable == null) {
            FileHistoryUi.$$$reportNull$$$0(25);
        }
        return vcsLogGraphTable;
    }

    @Override
    @NotNull
    public Component getMainComponent() {
        FileHistoryPanel fileHistoryPanel = this.myFileHistoryPanel;
        if (fileHistoryPanel == null) {
            FileHistoryUi.$$$reportNull$$$0(26);
        }
        return fileHistoryPanel;
    }

    @Override
    protected VcsLogFilterCollection getFilters() {
        return this.myFilterUi.getFilters();
    }

    private void updateFilter() {
        this.myRefresher.onFiltersChange(this.myFilterUi.getFilters());
    }

    @Override
    @NotNull
    public FileHistoryUiProperties getProperties() {
        FileHistoryUiProperties fileHistoryUiProperties = this.myUiProperties;
        if (fileHistoryUiProperties == null) {
            FileHistoryUi.$$$reportNull$$$0(27);
        }
        return fileHistoryUiProperties;
    }

    @Override
    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myPropertiesChangeListener);
        super.dispose();
    }

    private static /* synthetic */ boolean lambda$affectsDirectories$3(FilePath file2, FilePath dir) {
        return VfsUtilCore.isAncestor((File)dir.getIOFile(), (File)file2.getIOFile(), (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/FileHistoryUi";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsList";
                break;
            }
            case 20: 
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 21: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/FileHistoryUi";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRelevantChanges";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNames";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectChanges";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainComponent";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createVcsVirtualFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectRelevantChanges";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileNames";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "affectsFiles";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "affectsDirectories";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectChanges";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighterEnabled";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$handleCommitNotFound$6";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$handleCommitNotFound$5";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyPropertiesChangeListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyPropertiesChangeListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (property == null) {
                MyPropertiesChangeListener.$$$reportNull$$$0(0);
            }
            if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
                FileHistoryUi.this.myFileHistoryPanel.showDetails(FileHistoryUi.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
            } else if (FileHistoryUiProperties.SHOW_ALL_BRANCHES.equals(property)) {
                FileHistoryUi.this.updateFilter();
            } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
                FileHistoryUi.this.getTable().onColumnOrderSettingChanged();
            } else if (property instanceof CommonUiProperties.TableColumnProperty) {
                FileHistoryUi.this.getTable().forceReLayout(((CommonUiProperties.TableColumnProperty)property).getColumn());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/history/FileHistoryUi$MyPropertiesChangeListener", "onPropertyChanged"));
        }
    }
}

