/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;

public class OpenAnotherLogTabAction
extends DumbAwareAction {
    protected OpenAnotherLogTabAction() {
        super("Open Another Log Tab", "Open Another Log Tab", AllIcons.General.Add);
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null || !Registry.is((String)"vcs.log.open.another.log.visible")) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project);
        VcsLogManager logManager = (VcsLogManager)e.getData(VcsLogInternalDataKeys.LOG_MANAGER);
        e.getPresentation().setEnabledAndVisible(logManager != null && projectLog.getLogManager() == logManager);
    }

    public void actionPerformed(AnActionEvent e) {
        VcsLogUtil.triggerUsage(e);
        VcsLogContentUtil.openAnotherLogTab((VcsLogManager)e.getRequiredData(VcsLogInternalDataKeys.LOG_MANAGER), (Project)e.getRequiredData(CommonDataKeys.PROJECT));
    }
}

