/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphTableModel
extends AbstractTableModel {
    public static final int ROOT_COLUMN = 0;
    public static final int COMMIT_COLUMN = 1;
    public static final int AUTHOR_COLUMN = 2;
    public static final int DATE_COLUMN = 3;
    private static final int COLUMN_COUNT = 4;
    private static final String[] COLUMN_NAMES = new String[]{"", "Subject", "Author", "Date"};
    private static final int UP_PRELOAD_COUNT = 20;
    private static final int DOWN_PRELOAD_COUNT = 40;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    protected final AbstractVcsLogUi myUi;
    @NotNull
    protected VisiblePack myDataPack;
    private boolean myMoreRequested;

    public GraphTableModel(@NotNull VisiblePack dataPack, @NotNull VcsLogData logData, @NotNull AbstractVcsLogUi ui) {
        if (dataPack == null) {
            GraphTableModel.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            GraphTableModel.$$$reportNull$$$0(1);
        }
        if (ui == null) {
            GraphTableModel.$$$reportNull$$$0(2);
        }
        this.myLogData = logData;
        this.myUi = ui;
        this.myDataPack = dataPack;
    }

    @Override
    public int getRowCount() {
        return this.myDataPack.getVisibleGraph().getVisibleCommitCount();
    }

    @NotNull
    public VirtualFile getRoot(int rowIndex) {
        VirtualFile virtualFile = this.myDataPack.getRoot(rowIndex);
        if (virtualFile == null) {
            GraphTableModel.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public Integer getIdAtRow(int row) {
        Integer n = (Integer)this.myDataPack.getVisibleGraph().getRowInfo(row).getCommit();
        if (n == null) {
            GraphTableModel.$$$reportNull$$$0(4);
        }
        return n;
    }

    @Nullable
    public CommitId getCommitIdAtRow(int row) {
        return this.myLogData.getCommitId(this.getIdAtRow(row));
    }

    public int getRowOfCommit(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            GraphTableModel.$$$reportNull$$$0(5);
        }
        if (root == null) {
            GraphTableModel.$$$reportNull$$$0(6);
        }
        int commitIndex = this.myLogData.getCommitIndex(hash, root);
        return ContainerUtil.indexOf(VcsLogUtil.getVisibleCommits(this.myDataPack.getVisibleGraph()), i -> i == commitIndex);
    }

    public int getRowOfCommitByPartOfHash(@NotNull String partialHash) {
        if (partialHash == null) {
            GraphTableModel.$$$reportNull$$$0(7);
        }
        CommitIdByStringCondition hashByString = new CommitIdByStringCondition(partialHash);
        CommitId commitId = this.myLogData.getStorage().findCommitId((Condition<CommitId>)((Condition)commitId1 -> hashByString.value((CommitId)commitId1) && this.getRowOfCommit(commitId1.getHash(), commitId1.getRoot()) != -1));
        return commitId != null ? this.getRowOfCommit(commitId.getHash(), commitId.getRoot()) : -1;
    }

    @Override
    public final int getColumnCount() {
        return 4;
    }

    public void requestToLoadMore(@NotNull Runnable onLoaded) {
        if (onLoaded == null) {
            GraphTableModel.$$$reportNull$$$0(8);
        }
        this.myMoreRequested = true;
        this.myUi.getRefresher().moreCommitsNeeded(onLoaded);
        this.myUi.getTable().setPaintBusy(true);
    }

    @Override
    @NotNull
    public final Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount() - 1 && this.canRequestMore()) {
            this.requestToLoadMore(EmptyRunnable.INSTANCE);
        }
        VcsShortCommitDetails data = this.getShortDetails(rowIndex);
        switch (columnIndex) {
            case 0: {
                VirtualFile virtualFile = this.getRoot(rowIndex);
                if (virtualFile == null) {
                    GraphTableModel.$$$reportNull$$$0(9);
                }
                return virtualFile;
            }
            case 1: {
                GraphCommitCell graphCommitCell = new GraphCommitCell(data.getSubject(), this.getRefsAtRow(rowIndex), this.myDataPack.getVisibleGraph().getRowInfo(rowIndex).getPrintElements());
                if (graphCommitCell == null) {
                    GraphTableModel.$$$reportNull$$$0(10);
                }
                return graphCommitCell;
            }
            case 2: {
                String authorString = VcsUserUtil.getShortPresentation(data.getAuthor());
                String string = authorString + (VcsUserUtil.isSamePerson(data.getAuthor(), data.getCommitter()) ? "" : "*");
                if (string == null) {
                    GraphTableModel.$$$reportNull$$$0(11);
                }
                return string;
            }
            case 3: {
                if (data.getAuthorTime() < 0L) {
                    if ("" == null) {
                        GraphTableModel.$$$reportNull$$$0(12);
                    }
                    return "";
                }
                String string = DateFormatUtil.formatDateTime((long)data.getAuthorTime());
                if (string == null) {
                    GraphTableModel.$$$reportNull$$$0(13);
                }
                return string;
            }
        }
        throw new IllegalArgumentException("columnIndex is " + columnIndex + " > " + (this.getColumnCount() - 1));
    }

    public boolean canRequestMore() {
        return !this.myMoreRequested && this.myDataPack.canRequestMore();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return VirtualFile.class;
            }
            case 1: {
                return GraphCommitCell.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("columnIndex is " + column + " > " + (this.getColumnCount() - 1));
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public void setVisiblePack(@NotNull VisiblePack visiblePack) {
        if (visiblePack == null) {
            GraphTableModel.$$$reportNull$$$0(14);
        }
        this.myDataPack = visiblePack;
        this.myMoreRequested = false;
        this.fireTableDataChanged();
    }

    @NotNull
    public VisiblePack getVisiblePack() {
        VisiblePack visiblePack = this.myDataPack;
        if (visiblePack == null) {
            GraphTableModel.$$$reportNull$$$0(15);
        }
        return visiblePack;
    }

    @NotNull
    public VcsFullCommitDetails getFullDetails(int row) {
        VcsFullCommitDetails vcsFullCommitDetails = this.getDetails(row, this.myLogData.getCommitDetailsGetter());
        if (vcsFullCommitDetails == null) {
            GraphTableModel.$$$reportNull$$$0(16);
        }
        return vcsFullCommitDetails;
    }

    @NotNull
    public VcsShortCommitDetails getShortDetails(int row) {
        VcsShortCommitDetails vcsShortCommitDetails = this.getDetails(row, this.myLogData.getMiniDetailsGetter());
        if (vcsShortCommitDetails == null) {
            GraphTableModel.$$$reportNull$$$0(17);
        }
        return vcsShortCommitDetails;
    }

    @NotNull
    private <T extends VcsShortCommitDetails> T getDetails(int row, @NotNull DataGetter<T> dataGetter) {
        if (dataGetter == null) {
            GraphTableModel.$$$reportNull$$$0(18);
        }
        Iterable<Integer> iterable = this.createRowsIterable(row, 20, 40, this.getRowCount());
        T t = dataGetter.getCommitData(this.getIdAtRow(row), iterable);
        if (t == null) {
            GraphTableModel.$$$reportNull$$$0(19);
        }
        return t;
    }

    @NotNull
    public Collection<VcsRef> getRefsAtRow(int row) {
        Collection<VcsRef> collection = ((RefsModel)this.myDataPack.getRefs()).refsToCommit(this.getIdAtRow(row));
        if (collection == null) {
            GraphTableModel.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @NotNull
    public List<VcsRef> getBranchesAtRow(int row) {
        List<VcsRef> list2 = this.getRefsAtRow(row).stream().filter(ref -> ref.getType().isBranch()).collect(Collectors.toList());
        if (list2 == null) {
            GraphTableModel.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @NotNull
    private Iterable<Integer> createRowsIterable(final int row, final int above, final int below, final int maxRows) {
        Iterable<Integer> iterable = () -> new Iterator<Integer>(){
            private int myRowIndex;
            {
                this.myRowIndex = Math.max(0, row - above);
            }

            @Override
            public boolean hasNext() {
                return this.myRowIndex < row + below && this.myRowIndex < maxRows;
            }

            @Override
            public Integer next() {
                int nextRow = this.myRowIndex++;
                return GraphTableModel.this.getIdAtRow(nextRow);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing elements is not supported.");
            }
        };
        if (iterable == null) {
            GraphTableModel.$$$reportNull$$$0(22);
        }
        return iterable;
    }

    @NotNull
    public List<Integer> convertToCommitIds(@NotNull List<Integer> rows) {
        if (rows == null) {
            GraphTableModel.$$$reportNull$$$0(23);
        }
        List list2 = ContainerUtil.map(rows, (Function)((NotNullFunction)this::getIdAtRow));
        if (list2 == null) {
            GraphTableModel.$$$reportNull$$$0(24);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/table/GraphTableModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialHash";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onLoaded";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGetter";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/table/GraphTableModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdAtRow";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAt";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisiblePack";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullDetails";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortDetails";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetails";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefsAtRow";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchesAtRow";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createRowsIterable";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToCommitIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRowOfCommit";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRowOfCommitByPartOfHash";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "requestToLoadMore";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setVisiblePack";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDetails";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "convertToCommitIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

