/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.DebuggerFramesList;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerFramesList
extends DebuggerFramesList {
    private final Project myProject;
    private final Map<VirtualFile, Color> myFileColors;
    private static final TransferHandler DEFAULT_TRANSFER_HANDLER = new TransferHandler(){

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (!(c instanceof XDebuggerFramesList)) {
                return null;
            }
            XDebuggerFramesList list2 = (XDebuggerFramesList)((Object)c);
            Object[] values = list2.getSelectedValues();
            if (values == null || values.length == 0) {
                return null;
            }
            StringBuilder plainBuf = new StringBuilder();
            StringBuilder htmlBuf = new StringBuilder();
            TextTransferable.ColoredStringBuilder coloredTextContainer = new TextTransferable.ColoredStringBuilder();
            htmlBuf.append("<html>\n<body>\n<ul>\n");
            for (Object value : values) {
                htmlBuf.append("  <li>");
                if (value != null) {
                    if (value instanceof XStackFrame) {
                        ((XStackFrame)value).customizePresentation((ColoredTextContainer)coloredTextContainer);
                        coloredTextContainer.appendTo(plainBuf, htmlBuf);
                    } else {
                        String text = value.toString();
                        plainBuf.append(text);
                        htmlBuf.append(text);
                    }
                }
                plainBuf.append('\n');
                htmlBuf.append("</li>\n");
            }
            plainBuf.setLength(plainBuf.length() - 1);
            htmlBuf.append("</ul>\n</body>\n</html>");
            return new TextTransferable(htmlBuf.toString(), plainBuf.toString());
        }

        @Override
        public int getSourceActions(@NotNull JComponent c) {
            if (c == null) {
                1.$$$reportNull$$$0(0);
            }
            return 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$1", "getSourceActions"));
        }
    };
    private XStackFrame mySelectedFrame;

    public XDebuggerFramesList(@NotNull Project project) {
        if (project == null) {
            XDebuggerFramesList.$$$reportNull$$$0(0);
        }
        this.myFileColors = new HashMap<VirtualFile, Color>();
        this.myProject = project;
        this.doInit();
        this.setTransferHandler(DEFAULT_TRANSFER_HANDLER);
        this.setDataProvider(new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (XDebuggerFramesList.this.mySelectedFrame != null) {
                    VirtualFile file2;
                    if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                        return XDebuggerFramesList.getFile(XDebuggerFramesList.this.mySelectedFrame);
                    }
                    if (CommonDataKeys.PSI_FILE.is(dataId) && (file2 = XDebuggerFramesList.getFile(XDebuggerFramesList.this.mySelectedFrame)) != null && file2.isValid()) {
                        return PsiManager.getInstance((Project)XDebuggerFramesList.this.myProject).findFile(file2);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void clear() {
        super.clear();
        this.myFileColors.clear();
    }

    @Nullable
    private static VirtualFile getFile(XStackFrame frame) {
        XSourcePosition position = frame.getSourcePosition();
        return position != null ? position.getFile() : null;
    }

    @Override
    protected ListCellRenderer createListRenderer() {
        return new XDebuggerGroupedFrameListRenderer();
    }

    @Override
    protected void onFrameChanged(Object selectedValue) {
        if (this.mySelectedFrame != selectedValue) {
            SwingUtilities.invokeLater(() -> this.repaint());
            this.mySelectedFrame = selectedValue instanceof XStackFrame ? (XStackFrame)selectedValue : null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/frame/XDebuggerFramesList", "<init>"));
    }

    public static interface ItemWithCustomBackgroundColor {
        @Nullable
        public Color getBackgroundColor();
    }

    public static interface ItemWithSeparatorAbove {
        public boolean hasSeparatorAbove();

        public String getCaptionAboveOf();
    }

    private class XDebuggerFrameListRenderer
    extends ColoredListCellRenderer {
        private final FileColorManager myColorsManager;

        public XDebuggerFrameListRenderer(Project project) {
            if (project == null) {
                XDebuggerFrameListRenderer.$$$reportNull$$$0(0);
            }
            this.myColorsManager = FileColorManager.getInstance((Project)project);
        }

        protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
            Color c;
            if (list2 == null) {
                XDebuggerFrameListRenderer.$$$reportNull$$$0(1);
            }
            if (UIUtil.isUnderGTKLookAndFeel()) {
                Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                UIUtil.changeBackGround((Component)((Object)this), (Color)background);
            }
            if (value == null) {
                this.append(XDebuggerBundle.message((String)"stack.frame.loading.text", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                return;
            }
            if (value instanceof String) {
                this.append((String)value, SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            XStackFrame stackFrame = (XStackFrame)value;
            if (!selected && (c = this.getFrameBgColor(stackFrame)) != null) {
                this.setBackground(c);
            }
            stackFrame.customizePresentation((ColoredTextContainer)this);
        }

        Color getFrameBgColor(XStackFrame stackFrame) {
            if (stackFrame instanceof ItemWithCustomBackgroundColor) {
                return ((ItemWithCustomBackgroundColor)stackFrame).getBackgroundColor();
            }
            VirtualFile virtualFile = XDebuggerFramesList.getFile(stackFrame);
            if (virtualFile != null) {
                if (XDebuggerFramesList.this.myFileColors.containsKey(virtualFile)) {
                    return (Color)XDebuggerFramesList.this.myFileColors.get(virtualFile);
                }
                if (virtualFile.isValid()) {
                    Color color = this.myColorsManager.getFileColor(virtualFile);
                    XDebuggerFramesList.this.myFileColors.put(virtualFile, color);
                    return color;
                }
            } else {
                return this.myColorsManager.getScopeColor("Non-Project Files");
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$XDebuggerFrameListRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class XDebuggerGroupedFrameListRenderer
    extends GroupedItemsListRenderer {
        private final XDebuggerFrameListRenderer myOriginalRenderer;

        public XDebuggerGroupedFrameListRenderer() {
            super(new ListItemDescriptorAdapter(){

                @Nullable
                public String getTextFor(Object value) {
                    return null;
                }

                @Nullable
                public String getCaptionAboveOf(Object value) {
                    return value instanceof ItemWithSeparatorAbove ? ((ItemWithSeparatorAbove)value).getCaptionAboveOf() : null;
                }

                public boolean hasSeparatorAboveOf(Object value) {
                    return value instanceof ItemWithSeparatorAbove && ((ItemWithSeparatorAbove)value).hasSeparatorAbove();
                }
            });
            this.myOriginalRenderer = new XDebuggerFrameListRenderer(XDebuggerFramesList.this.myProject);
            this.mySeparatorComponent.setCaptionCentered(false);
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (this.myDescriptor.hasSeparatorAboveOf(value)) {
                Component component = super.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
                ((XDebuggerFrameListRenderer)((Object)this.myComponent)).getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
                return component;
            }
            return this.myOriginalRenderer.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
        }

        @Override
        protected JComponent createItemComponent() {
            this.createLabel();
            return new XDebuggerFrameListRenderer(XDebuggerFramesList.this.myProject);
        }
    }
}

