/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Processor;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlLinkUtil {
    @NonNls
    public static final String LINK = "link";

    public static void processLinks(@NotNull XmlFile xhtmlFile, @NotNull Processor<XmlTag> tagProcessor) {
        XmlDocument doc;
        if (xhtmlFile == null) {
            HtmlLinkUtil.$$$reportNull$$$0(0);
        }
        if (tagProcessor == null) {
            HtmlLinkUtil.$$$reportNull$$$0(1);
        }
        if ((doc = HtmlUtil.getRealXmlDocument(xhtmlFile.getDocument())) == null) {
            return;
        }
        XmlTag rootTag = doc.getRootTag();
        if (rootTag == null) {
            return;
        }
        if (LINK.equalsIgnoreCase(rootTag.getName())) {
            tagProcessor.process((Object)rootTag);
        } else {
            HtmlLinkUtil.findLinkStylesheets(rootTag, tagProcessor);
        }
    }

    public static void findLinkStylesheets(@NotNull XmlTag tag, @NotNull Processor<XmlTag> tagProcessor) {
        if (tag == null) {
            HtmlLinkUtil.$$$reportNull$$$0(2);
        }
        if (tagProcessor == null) {
            HtmlLinkUtil.$$$reportNull$$$0(3);
        }
        HtmlLinkUtil.processInjectedContent(tag, tagProcessor);
        for (XmlTag subTag : tag.getSubTags()) {
            HtmlLinkUtil.findLinkStylesheets(subTag, tagProcessor);
        }
        if (LINK.equalsIgnoreCase(tag.getName())) {
            tagProcessor.process((Object)tag);
        }
    }

    public static void processInjectedContent(XmlTag element, @NotNull Processor<XmlTag> tagProcessor) {
        XmlComment[] comments;
        if (tagProcessor == null) {
            HtmlLinkUtil.$$$reportNull$$$0(4);
        }
        PsiLanguageInjectionHost.InjectedPsiVisitor injectedPsiVisitor = (injectedPsi, places) -> {
            XmlTag rootTag;
            XmlDocument injectedDocument;
            if (tagProcessor == null) {
                HtmlLinkUtil.$$$reportNull$$$0(5);
            }
            if (injectedPsi instanceof XmlFile && (injectedDocument = ((XmlFile)injectedPsi).getDocument()) != null && (rootTag = injectedDocument.getRootTag()) != null) {
                for (XmlTag element1 = rootTag; element1 != null; element1 = element1.getNextSibling()) {
                    if (!(element1 instanceof XmlTag)) continue;
                    XmlTag tag = element1;
                    String tagName = tag.getLocalName();
                    if (element1 instanceof HtmlTag || tag.getNamespacePrefix().length() > 0) {
                        tagName = tagName.toLowerCase();
                    }
                    if (!LINK.equalsIgnoreCase(tagName)) continue;
                    tagProcessor.process((Object)element1);
                }
            }
        };
        XmlText[] texts = (XmlText[])PsiTreeUtil.getChildrenOfType((PsiElement)element, XmlText.class);
        if (texts != null && texts.length > 0) {
            for (XmlText text : texts) {
                for (PsiElement _element2 : text.getChildren()) {
                    if (!(_element2 instanceof PsiLanguageInjectionHost)) continue;
                    InjectedLanguageManager.getInstance((Project)_element2.getProject()).enumerate(_element2, injectedPsiVisitor);
                }
            }
        }
        if ((comments = (XmlComment[])PsiTreeUtil.getChildrenOfType((PsiElement)element, XmlComment.class)) != null && comments.length > 0) {
            for (XmlComment comment : comments) {
                if (!(comment instanceof PsiLanguageInjectionHost)) continue;
                InjectedLanguageManager.getInstance((Project)comment.getProject()).enumerate((PsiElement)comment, injectedPsiVisitor);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xhtmlFile";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/util/HtmlLinkUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processLinks";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findLinkStylesheets";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processInjectedContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processInjectedContent$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

