/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.google.common.base.Predicates;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonSchemaAnnotatorChecker {
    private static final Set<JsonSchemaType> PRIMITIVE_TYPES = ContainerUtil.set((Object[])new JsonSchemaType[]{JsonSchemaType._integer, JsonSchemaType._number, JsonSchemaType._boolean, JsonSchemaType._string, JsonSchemaType._null});
    private final Map<PsiElement, String> myErrors = new HashMap<PsiElement, String>();
    private boolean myHadTypeError;

    protected JsonSchemaAnnotatorChecker() {
    }

    public Map<PsiElement, String> getErrors() {
        return this.myErrors;
    }

    public boolean isHadTypeError() {
        return this.myHadTypeError;
    }

    public static JsonSchemaAnnotatorChecker checkByMatchResult(@NotNull JsonValueAdapter elementToCheck, @NotNull MatchResult result2) {
        if (elementToCheck == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(1);
        }
        ArrayList<Object> checkers = new ArrayList<Object>();
        if (result2.myExcludingSchemas.isEmpty() && result2.mySchemas.size() == 1) {
            JsonSchemaAnnotatorChecker checker2 = new JsonSchemaAnnotatorChecker();
            checker2.checkByScheme(elementToCheck, result2.mySchemas.iterator().next());
            checkers.add(checker2);
        } else {
            if (!result2.mySchemas.isEmpty()) {
                checkers.add(JsonSchemaAnnotatorChecker.processSchemasVariants(result2.mySchemas, elementToCheck, false).getSecond());
            }
            if (!result2.myExcludingSchemas.isEmpty()) {
                SmartList selectedSchemas = new SmartList();
                List<JsonSchemaAnnotatorChecker> list2 = result2.myExcludingSchemas.stream().map(arg_0 -> JsonSchemaAnnotatorChecker.lambda$checkByMatchResult$0(elementToCheck, (List)selectedSchemas, arg_0)).collect(Collectors.toList());
                checkers.add(JsonSchemaAnnotatorChecker.mergeErrors(list2, (List<JsonSchemaObject>)selectedSchemas));
            }
        }
        if (checkers.isEmpty()) {
            return null;
        }
        return checkers.stream().filter(checker -> !checker.isHadTypeError()).findFirst().orElse((JsonSchemaAnnotatorChecker)checkers.get(0));
    }

    private static JsonSchemaAnnotatorChecker mergeErrors(@NotNull List<JsonSchemaAnnotatorChecker> list2, @NotNull List<JsonSchemaObject> selectedSchemas) {
        if (list2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(2);
        }
        if (selectedSchemas == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(3);
        }
        Set skipErrors = selectedSchemas.stream().filter(Predicates.notNull()).map(schema -> schema.getProperties().keySet()).flatMap(Collection::stream).map(name -> JsonBundle.message("json.schema.annotation.not.allowed.property", name)).collect(Collectors.toSet());
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker();
        list2.stream().map(ch -> {
            Map<PsiElement, String> map = ch.myErrors;
            List<PsiElement> toRemove2 = map.keySet().stream().filter(key -> skipErrors.contains(map.get(key))).collect(Collectors.toList());
            toRemove2.forEach(map::remove);
            return map;
        }).forEach(map -> checker.myErrors.putAll((Map<PsiElement, String>)map));
        return checker;
    }

    private void error(String error, PsiElement holder) {
        if (this.myErrors.containsKey(holder)) {
            return;
        }
        this.myErrors.put(holder, error);
    }

    private void typeError(@NotNull PsiElement value) {
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(4);
        }
        this.error("Type is not allowed", value);
        this.myHadTypeError = true;
    }

    public void checkByScheme(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema) {
        JsonSchemaType type;
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(5);
        }
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(6);
        }
        if ((type = JsonSchemaType.getType(value)) != null) {
            JsonSchemaType schemaType = JsonSchemaAnnotatorChecker.getMatchingSchemaType(schema, type);
            if (schemaType != null && !schemaType.equals((Object)type)) {
                this.typeError(value.getDelegate());
            } else if (JsonSchemaType._boolean.equals((Object)type)) {
                this.checkForEnum(value.getDelegate(), schema);
            } else if (JsonSchemaType._number.equals((Object)type) || JsonSchemaType._integer.equals((Object)type)) {
                this.checkNumber(value.getDelegate(), schema, type);
                this.checkForEnum(value.getDelegate(), schema);
            } else if (JsonSchemaType._string.equals((Object)type)) {
                this.checkString(value.getDelegate(), schema);
                this.checkForEnum(value.getDelegate(), schema);
            } else if (JsonSchemaType._array.equals((Object)type)) {
                this.checkArray(value, schema);
                this.checkForEnum(value.getDelegate(), schema);
            } else if (JsonSchemaType._object.equals((Object)type)) {
                this.checkObject(value, schema);
                this.checkForEnum(value.getDelegate(), schema);
            }
        }
        if (schema.getNot() != null) {
            MatchResult result2 = new JsonSchemaResolver(schema.getNot()).detailedResolve();
            if (result2.mySchemas.isEmpty() && result2.myExcludingSchemas.isEmpty()) {
                return;
            }
            if (result2.mySchemas.stream().anyMatch(s -> {
                if (schema == null) {
                    JsonSchemaAnnotatorChecker.$$$reportNull$$$0(29);
                }
                return schema.getJsonObject().equals(s.getJsonObject());
            }) || result2.myExcludingSchemas.stream().flatMap(Collection::stream).anyMatch(s -> {
                if (schema == null) {
                    JsonSchemaAnnotatorChecker.$$$reportNull$$$0(28);
                }
                return schema.getJsonObject().equals(s.getJsonObject());
            })) {
                return;
            }
            JsonSchemaAnnotatorChecker checker = JsonSchemaAnnotatorChecker.checkByMatchResult(value, result2);
            if (checker == null || checker.isCorrect()) {
                this.error("Validates against 'not' schema", value.getDelegate());
            }
        }
    }

    private void checkObjectBySchemaRecordErrors(@NotNull JsonSchemaObject schema, @NotNull JsonValueAdapter object) {
        JsonSchemaAnnotatorChecker checker;
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(7);
        }
        if (object == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(8);
        }
        if ((checker = JsonSchemaAnnotatorChecker.checkByMatchResult(object, new JsonSchemaResolver(schema).detailedResolve())) != null) {
            this.myHadTypeError = checker.isHadTypeError();
            this.myErrors.putAll(checker.getErrors());
        }
    }

    private void checkObject(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema) {
        JsonObjectValueAdapter object;
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(9);
        }
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(10);
        }
        if ((object = value.getAsObject()) == null) {
            return;
        }
        List<JsonPropertyAdapter> propertyList = object.getPropertyList();
        HashSet<String> set2 = new HashSet<String>();
        for (JsonPropertyAdapter jsonPropertyAdapter : propertyList) {
            String string = StringUtil.notNullize((String)jsonPropertyAdapter.getName());
            JsonSchemaVariantsTreeBuilder.Step step = JsonSchemaVariantsTreeBuilder.Step.createPropertyStep(string);
            Pair<ThreeState, JsonSchemaObject> pair = step.step(schema, true);
            if (ThreeState.NO.equals(pair.getFirst()) && !set2.contains(string)) {
                this.error(JsonBundle.message("json.schema.annotation.not.allowed.property", string), jsonPropertyAdapter.getDelegate());
            } else if (ThreeState.UNSURE.equals(pair.getFirst()) && jsonPropertyAdapter.getValue() != null) {
                this.checkObjectBySchemaRecordErrors((JsonSchemaObject)pair.getSecond(), jsonPropertyAdapter.getValue());
            }
            set2.add(string);
        }
        if (object.shouldCheckIntegralRequirements()) {
            Map<String, JsonSchemaObject> map;
            Map<String, List<String>> map2;
            List<String> required = schema.getRequired();
            if (required != null) {
                for (String string : required) {
                    if (set2.contains(string)) continue;
                    this.error("Missing required property '" + string + "'", value.getDelegate());
                }
            }
            if (schema.getMinProperties() != null && propertyList.size() < schema.getMinProperties()) {
                this.error("Number of properties is less than " + schema.getMinProperties(), value.getDelegate());
            }
            if (schema.getMaxProperties() != null && propertyList.size() > schema.getMaxProperties()) {
                this.error("Number of properties is greater than " + schema.getMaxProperties(), value.getDelegate());
            }
            if ((map2 = schema.getPropertyDependencies()) != null) {
                for (Map.Entry<String, List<String>> entry : map2.entrySet()) {
                    if (!set2.contains(entry.getKey())) continue;
                    List<String> list2 = entry.getValue();
                    for (String s : list2) {
                        if (set2.contains(s)) continue;
                        this.error("Dependency is violated: '" + s + "' must be specified, since '" + entry.getKey() + "' is specified", value.getDelegate());
                    }
                }
            }
            if ((map = schema.getSchemaDependencies()) != null) {
                for (Map.Entry<String, JsonSchemaObject> entry : map.entrySet()) {
                    if (!set2.contains(entry.getKey())) continue;
                    this.checkObjectBySchemaRecordErrors(entry.getValue(), value);
                }
            }
        }
        this.validateAsJsonSchema(object.getDelegate());
    }

    private void validateAsJsonSchema(@NotNull PsiElement objElement) {
        JsonObject object;
        if (objElement == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(11);
        }
        if ((object = (JsonObject)ObjectUtils.tryCast((Object)objElement, JsonObject.class)) == null) {
            return;
        }
        if (JsonSchemaService.isSchemaFile(objElement.getContainingFile())) {
            VirtualFile schemaFile = object.getContainingFile().getVirtualFile();
            if (schemaFile == null) {
                return;
            }
            JsonSchemaObject schemaObject = JsonSchemaService.Impl.get(object.getProject()).getSchemaObjectForSchemaFile(schemaFile);
            if (schemaObject == null) {
                return;
            }
            List<JsonSchemaVariantsTreeBuilder.Step> steps = JsonSchemaAnnotatorChecker.skipProperties(JsonOriginalPsiWalker.INSTANCE.findPosition(object, false, true));
            MatchResult result2 = new JsonSchemaResolver(schemaObject, false, steps).detailedResolve();
            ArrayList<JsonSchemaObject> schemas = new ArrayList<JsonSchemaObject>(result2.mySchemas);
            schemas.addAll(result2.myExcludingSchemas.stream().flatMap(Collection::stream).collect(Collectors.toSet()));
            schemas.forEach(schema -> {
                if (schemaFile.equals(schema.getSchemaFile())) {
                    Map<JsonObject, String> invalidPatternProperties = schema.getInvalidPatternProperties();
                    if (invalidPatternProperties != null) {
                        for (Map.Entry<JsonObject, String> entry : invalidPatternProperties.entrySet()) {
                            PsiElement parent;
                            JsonObject element = entry.getKey();
                            if (element == null || !element.isValid() || !((parent = element.getParent()) instanceof JsonProperty)) continue;
                            this.error(StringUtil.convertLineSeparators((String)entry.getValue()), ((JsonProperty)parent).getNameElement());
                        }
                    }
                    schema.getProperties().values().forEach(prop -> {
                        JsonProperty pattern;
                        JsonObject element;
                        String patternError = prop.getPatternError();
                        if (patternError != null && prop.getPattern() != null && (element = prop.getJsonObject()).isValid() && (pattern = element.findProperty("pattern")) != null) {
                            this.error(StringUtil.convertLineSeparators((String)patternError), pattern.getValue());
                        }
                    });
                }
            });
        }
    }

    private static List<JsonSchemaVariantsTreeBuilder.Step> skipProperties(List<JsonSchemaVariantsTreeBuilder.Step> position) {
        Iterator<JsonSchemaVariantsTreeBuilder.Step> iterator = position.iterator();
        boolean canSkip = true;
        while (iterator.hasNext()) {
            JsonSchemaVariantsTreeBuilder.Step step = iterator.next();
            if (canSkip && step.isFromObject() && "properties".equals(step.getName())) {
                iterator.remove();
                canSkip = false;
                continue;
            }
            canSkip = true;
        }
        return position;
    }

    private void checkForEnum(PsiElement value, JsonSchemaObject schema) {
        if (schema.getEnum() == null || schema.getPattern() != null) {
            return;
        }
        String text = StringUtil.notNullize((String)value.getText());
        List<Object> objects = schema.getEnum();
        for (Object object : objects) {
            if (!(JsonLikePsiWalker.getWalker(value, schema).onlyDoubleQuotesForStringLiterals() ? object.toString().equalsIgnoreCase(text) : JsonSchemaAnnotatorChecker.equalsIgnoreQuotesAndCase(object.toString(), text))) continue;
            return;
        }
        this.error("Value should be one of: [" + StringUtil.join(objects, o -> o.toString(), (String)", ") + "]", value);
    }

    private static boolean equalsIgnoreQuotesAndCase(@NotNull String s1, @NotNull String s2) {
        boolean quoted2;
        boolean quoted1;
        if (s1 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(12);
        }
        if (s2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(13);
        }
        if ((quoted1 = StringUtil.isQuotedString((String)s1)) != (quoted2 = StringUtil.isQuotedString((String)s2))) {
            return false;
        }
        if (!quoted1) {
            return s1.equalsIgnoreCase(s2);
        }
        return StringUtil.unquoteString((String)s1).equalsIgnoreCase(StringUtil.unquoteString((String)s2));
    }

    private void checkArray(JsonValueAdapter value, JsonSchemaObject schema) {
        JsonArrayValueAdapter asArray = value.getAsArray();
        if (asArray == null) {
            return;
        }
        List<JsonValueAdapter> elements = asArray.getElements();
        if (schema.getMinLength() != null && elements.size() < schema.getMinLength()) {
            this.error("Array is shorter than " + schema.getMinLength(), value.getDelegate());
            return;
        }
        this.checkArrayItems(value, elements, schema);
    }

    @NotNull
    private static Pair<JsonSchemaObject, JsonSchemaAnnotatorChecker> processSchemasVariants(@NotNull Collection<JsonSchemaObject> collection, @NotNull JsonValueAdapter value, boolean isOneOf) {
        if (collection == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(14);
        }
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(15);
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker();
        JsonSchemaType type = JsonSchemaType.getType(value);
        JsonSchemaObject selected = null;
        if (type == null) {
            if (!value.isShouldBeIgnored()) {
                checker.typeError(value.getDelegate());
            }
        } else {
            List<JsonSchemaObject> filtered = collection.stream().filter(schema -> JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(schema, type)).collect(Collectors.toList());
            if (filtered.isEmpty()) {
                checker.typeError(value.getDelegate());
            } else {
                selected = isOneOf ? checker.processOneOf(value, filtered) : checker.processAnyOf(value, filtered);
            }
        }
        Pair pair = Pair.create(selected, (Object)checker);
        if (pair == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(16);
        }
        return pair;
    }

    public static boolean areSchemaTypesCompatible(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType type) {
        JsonSchemaType matchingSchemaType;
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(17);
        }
        if (type == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(18);
        }
        if ((matchingSchemaType = JsonSchemaAnnotatorChecker.getMatchingSchemaType(schema, type)) != null) {
            return matchingSchemaType.equals((Object)type);
        }
        if (schema.getEnum() != null) {
            return PRIMITIVE_TYPES.contains((Object)type);
        }
        return true;
    }

    @Nullable
    private static JsonSchemaType getMatchingSchemaType(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType input) {
        JsonSchemaType matchType;
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(19);
        }
        if (input == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(20);
        }
        if (schema.getType() != null && (matchType = schema.getType()) != null) {
            if (JsonSchemaType._integer.equals((Object)input) && JsonSchemaType._number.equals((Object)matchType)) {
                return input;
            }
            return matchType;
        }
        if (schema.getTypeVariants() != null) {
            List<JsonSchemaType> matchTypes = schema.getTypeVariants();
            if (matchTypes.contains((Object)input)) {
                return input;
            }
            if (JsonSchemaType._integer.equals((Object)input) && matchTypes.contains((Object)JsonSchemaType._number)) {
                return input;
            }
            return matchTypes.get(0);
        }
        if (!schema.getProperties().isEmpty() && JsonSchemaType._object.equals((Object)input)) {
            return JsonSchemaType._object;
        }
        return null;
    }

    private void checkArrayItems(@NotNull JsonValueAdapter array, @NotNull List<JsonValueAdapter> list2, JsonSchemaObject schema) {
        if (array == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(21);
        }
        if (list2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(22);
        }
        if (schema.isUniqueItems()) {
            MultiMap valueTexts = new MultiMap();
            list2.forEach(item -> valueTexts.putValue((Object)item.getDelegate().getText(), item));
            valueTexts.keySet().stream().filter(key -> valueTexts.get(key).size() > 1).map(key -> valueTexts.get(key)).flatMap(Collection::stream).forEach(item -> this.error("Item is not unique", item.getDelegate()));
        }
        if (schema.getItemsSchema() != null) {
            list2.forEach(item -> this.checkObjectBySchemaRecordErrors(schema.getItemsSchema(), (JsonValueAdapter)item));
        } else if (schema.getItemsSchemaList() != null) {
            Iterator<JsonSchemaObject> iterator = schema.getItemsSchemaList().iterator();
            for (JsonValueAdapter arrayValue : list2) {
                if (iterator.hasNext()) {
                    this.checkObjectBySchemaRecordErrors(iterator.next(), arrayValue);
                    continue;
                }
                if (Boolean.TRUE.equals(schema.getAdditionalItemsAllowed())) continue;
                this.error("Additional items are not allowed", arrayValue.getDelegate());
            }
        }
        if (schema.getMinItems() != null && list2.size() < schema.getMinItems()) {
            this.error("Array is shorter than " + schema.getMinItems(), array.getDelegate());
        }
        if (schema.getMaxItems() != null && list2.size() > schema.getMaxItems()) {
            this.error("Array is longer than " + schema.getMaxItems(), array.getDelegate());
        }
    }

    private void checkString(PsiElement propValue, JsonSchemaObject schema) {
        String value = StringUtil.unquoteString((String)propValue.getText());
        if (schema.getMinLength() != null && value.length() < schema.getMinLength()) {
            this.error("String is shorter than " + schema.getMinLength(), propValue);
            return;
        }
        if (schema.getMaxLength() != null && value.length() > schema.getMaxLength()) {
            this.error("String is longer than " + schema.getMaxLength(), propValue);
            return;
        }
        if (schema.getPattern() != null) {
            if (schema.getPatternError() != null) {
                this.error("Can not check string by pattern because of error: " + StringUtil.convertLineSeparators((String)schema.getPatternError()), propValue);
            }
            if (!schema.checkByPattern(value)) {
                this.error("String is violating the pattern: '" + StringUtil.convertLineSeparators((String)schema.getPattern()) + "'", propValue);
            }
        }
    }

    private void checkNumber(PsiElement propValue, JsonSchemaObject schema, JsonSchemaType schemaType) {
        double leftOver;
        Number value;
        if (JsonSchemaType._integer.equals((Object)schemaType)) {
            try {
                value = Integer.valueOf(propValue.getText());
            }
            catch (NumberFormatException e) {
                this.error("Integer value expected", propValue);
                return;
            }
        }
        try {
            value = Double.valueOf(propValue.getText());
        }
        catch (NumberFormatException e) {
            this.error("Double value expected", propValue);
            return;
        }
        Number multipleOf = schema.getMultipleOf();
        if (multipleOf != null && (leftOver = value.doubleValue() % multipleOf.doubleValue()) > 1.0E-6) {
            String multipleOfValue = String.valueOf(Math.abs(multipleOf.doubleValue() - (double)multipleOf.intValue()) < 1.0E-6 ? (Number)multipleOf.intValue() : (Number)multipleOf);
            this.error("Is not multiple of " + multipleOfValue, propValue);
            return;
        }
        if (schema.getMinimum() != null) {
            this.checkMinimum(schema, value, propValue, schemaType);
        }
        if (schema.getMaximum() != null) {
            this.checkMaximum(schema, value, propValue, schemaType);
        }
    }

    private void checkMaximum(JsonSchemaObject schema, Number value, PsiElement propertyValue, @NotNull JsonSchemaType propValueType) {
        if (propValueType == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(23);
        }
        if (JsonSchemaType._integer.equals((Object)propValueType)) {
            int intValue = schema.getMaximum().intValue();
            if (Boolean.TRUE.equals(schema.isExclusiveMaximum())) {
                if (value.intValue() >= intValue) {
                    this.error("Greater than an exclusive maximum " + intValue, propertyValue);
                }
            } else if (value.intValue() > intValue) {
                this.error("Greater than a maximum " + intValue, propertyValue);
            }
        } else {
            double doubleValue = schema.getMaximum().doubleValue();
            if (Boolean.TRUE.equals(schema.isExclusiveMaximum())) {
                if (value.doubleValue() >= doubleValue) {
                    this.error("Greater than an exclusive maximum " + schema.getMinimum(), propertyValue);
                }
            } else if (value.doubleValue() > doubleValue) {
                this.error("Greater than a maximum " + schema.getMaximum(), propertyValue);
            }
        }
    }

    private void checkMinimum(JsonSchemaObject schema, Number value, PsiElement propertyValue, @NotNull JsonSchemaType schemaType) {
        if (schemaType == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(24);
        }
        if (JsonSchemaType._integer.equals((Object)schemaType)) {
            int intValue = schema.getMinimum().intValue();
            if (Boolean.TRUE.equals(schema.isExclusiveMinimum())) {
                if (value.intValue() <= intValue) {
                    this.error("Less than an exclusive minimum " + intValue, propertyValue);
                }
            } else if (value.intValue() < intValue) {
                this.error("Less than a minimum " + intValue, propertyValue);
            }
        } else {
            double doubleValue = schema.getMinimum().doubleValue();
            if (Boolean.TRUE.equals(schema.isExclusiveMinimum())) {
                if (value.doubleValue() <= doubleValue) {
                    this.error("Less than an exclusive minimum " + schema.getMinimum(), propertyValue);
                }
            } else if (value.doubleValue() < doubleValue) {
                this.error("Less than a minimum " + schema.getMinimum(), propertyValue);
            }
        }
    }

    private JsonSchemaObject processOneOf(@NotNull JsonValueAdapter value, List<JsonSchemaObject> oneOf) {
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(25);
        }
        HashMap<PsiElement, String> errors = new HashMap<PsiElement, String>();
        boolean wasTypeError = false;
        SmartList correct = new SmartList();
        JsonSchemaObject current = null;
        for (JsonSchemaObject jsonSchemaObject : oneOf) {
            if (jsonSchemaObject.isShouldValidateAgainstJSType()) continue;
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker();
            checker.checkByScheme(value, jsonSchemaObject);
            if (checker.isCorrect()) {
                current = jsonSchemaObject;
                errors.clear();
                correct.add(jsonSchemaObject);
                continue;
            }
            if (!errors.isEmpty() && (!wasTypeError || checker.isHadTypeError()) && errors.size() <= checker.getErrors().size()) continue;
            wasTypeError = checker.isHadTypeError();
            current = jsonSchemaObject;
            errors.clear();
            errors.putAll(checker.getErrors());
        }
        if (correct.size() == 1) {
            return current;
        }
        if (correct.size() > 0) {
            JsonSchemaType type = JsonSchemaType.getType(value);
            if (type != null && !JsonSchemaAnnotatorChecker.schemesDifferWithNotCheckedProperties((List<JsonSchemaObject>)correct)) {
                this.error("Validates to more than one variant", value.getDelegate());
            }
        } else if (!errors.isEmpty()) {
            for (Map.Entry entry : errors.entrySet()) {
                this.error((String)entry.getValue(), (PsiElement)entry.getKey());
            }
        }
        return current;
    }

    private static boolean schemesDifferWithNotCheckedProperties(@NotNull List<JsonSchemaObject> list2) {
        if (list2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(26);
        }
        return list2.stream().anyMatch(s -> !StringUtil.isEmptyOrSpaces((String)s.getFormat()));
    }

    private JsonSchemaObject processAnyOf(@NotNull JsonValueAdapter value, List<JsonSchemaObject> anyOf) {
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(27);
        }
        HashMap<PsiElement, String> errors = new HashMap<PsiElement, String>();
        JsonSchemaObject current = null;
        for (JsonSchemaObject jsonSchemaObject : anyOf) {
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker();
            checker.checkByScheme(value, jsonSchemaObject);
            if (checker.isCorrect()) {
                return jsonSchemaObject;
            }
            if (!errors.isEmpty() || checker.isHadTypeError()) continue;
            current = jsonSchemaObject;
            errors.clear();
            errors.putAll(checker.getErrors());
        }
        if (!errors.isEmpty()) {
            for (Map.Entry entry : errors.entrySet()) {
                this.error((String)entry.getValue(), (PsiElement)entry.getKey());
            }
        }
        return current;
    }

    public boolean isCorrect() {
        return this.myErrors.isEmpty();
    }

    private static /* synthetic */ JsonSchemaAnnotatorChecker lambda$checkByMatchResult$0(@NotNull JsonValueAdapter elementToCheck, List selectedSchemas, Set group) {
        Pair<JsonSchemaObject, JsonSchemaAnnotatorChecker> pair;
        if (elementToCheck == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(30);
        }
        if ((pair = JsonSchemaAnnotatorChecker.processSchemasVariants(group, elementToCheck, true)).getFirst() != null) {
            selectedSchemas.add(pair.getFirst());
        }
        return (JsonSchemaAnnotatorChecker)pair.getSecond();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedSchemas";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 15: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 17: 
            case 19: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propValueType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "processSchemasVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkByMatchResult";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mergeErrors";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "typeError";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkByScheme";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkObjectBySchemaRecordErrors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkObject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateAsJsonSchema";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "equalsIgnoreQuotesAndCase";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processSchemasVariants";
                break;
            }
            case 16: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "areSchemaTypesCompatible";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingSchemaType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayItems";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkMaximum";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkMinimum";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processOneOf";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "schemesDifferWithNotCheckedProperties";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processAnyOf";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkByScheme$8";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkByScheme$7";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkByMatchResult$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

