/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMethodFromMethodReferenceFix
extends CreateFromUsageBaseFix {
    private static final Logger LOG = Logger.getInstance(CreateMethodFromMethodReferenceFix.class);
    private final SmartPsiElementPointer myMethodReferenceExpression;

    public CreateMethodFromMethodReferenceFix(@NotNull PsiMethodReferenceExpression methodRef) {
        if (methodRef == null) {
            CreateMethodFromMethodReferenceFix.$$$reportNull$$$0(0);
        }
        this.myMethodReferenceExpression = SmartPointerManager.getInstance((Project)methodRef.getProject()).createSmartPsiElementPointer((PsiElement)methodRef);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiMethodReferenceExpression call = this.getMethodReference();
        if (call == null || !call.isValid()) {
            return false;
        }
        PsiType functionalInterfaceType = CreateMethodFromMethodReferenceFix.getFunctionalExpressionType(call);
        if (functionalInterfaceType == null || LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType) == null) {
            return false;
        }
        String name = call.getReferenceName();
        if (name == null) {
            return false;
        }
        if (call.isConstructor() && name.equals("new") || PsiNameHelper.getInstance((Project)call.getProject()).isIdentifier(name)) {
            this.setText(call.isConstructor() ? QuickFixBundle.message("create.constructor.from.new.text", new Object[0]) : QuickFixBundle.message("create.method.from.usage.text", name));
            return true;
        }
        return false;
    }

    private static PsiType getFunctionalExpressionType(PsiMethodReferenceExpression ref) {
        PsiType functionalInterfaceType = ref.getFunctionalInterfaceType();
        if (functionalInterfaceType != null) {
            return functionalInterfaceType;
        }
        Ref type2 = new Ref();
        if (LambdaUtil.processParentOverloads((PsiFunctionalExpression)ref, fType -> type2.set(fType))) {
            return (PsiType)type2.get();
        }
        return null;
    }

    @Override
    protected PsiElement getElement() {
        PsiMethodReferenceExpression call = this.getMethodReference();
        if (call == null || !call.getManager().isInProject((PsiElement)call)) {
            return null;
        }
        return call;
    }

    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        List<PsiClass> targets = super.getTargetClasses(element);
        PsiMethodReferenceExpression call = this.getMethodReference();
        if (call == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                CreateMethodFromMethodReferenceFix.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<PsiClass> list = targets;
        if (list == null) {
            CreateMethodFromMethodReferenceFix.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        PsiMethod method;
        if (targetClass == null) {
            return;
        }
        PsiMethodReferenceExpression expression2 = this.getMethodReference();
        if (expression2 == null) {
            return;
        }
        if (this.isValidElement((PsiElement)expression2)) {
            return;
        }
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiClass.class);
        PsiMember enclosingContext = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClassInitializer.class});
        String methodName = expression2.getReferenceName();
        LOG.assertTrue(methodName != null);
        Project project = targetClass.getProject();
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)targetClass.getLanguage(), (Project)project);
        if (elementFactory == null) {
            elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        }
        PsiMethod psiMethod = method = expression2.isConstructor() ? (PsiMethod)targetClass.add((PsiElement)elementFactory.createConstructor()) : CreateMethodFromUsageFix.createMethod(targetClass, parentClass, enclosingContext, methodName);
        if (method == null) {
            return;
        }
        if (!expression2.isConstructor()) {
            this.setupVisibility(parentClass, targetClass, method.getModifierList());
        }
        expression2 = this.getMethodReference();
        LOG.assertTrue(expression2.isValid());
        boolean shouldBeAbstract = false;
        if (!expression2.isConstructor()) {
            if (CreateMethodFromMethodReferenceFix.shouldCreateStaticMember((PsiReferenceExpression)expression2, targetClass)) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)true);
            } else if (targetClass.isInterface()) {
                shouldBeAbstract = true;
                PsiCodeBlock body2 = method.getBody();
                assert (body2 != null);
                body2.delete();
            }
        }
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{PsiClass.class, PsiMethod.class});
        PsiType functionalInterfaceType = CreateMethodFromMethodReferenceFix.getFunctionalExpressionType(expression2);
        PsiClassType.ClassResolveResult classResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)classResolveResult);
        LOG.assertTrue(interfaceMethod != null);
        PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
        LOG.assertTrue(interfaceReturnType != null);
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)classResolveResult);
        ExpectedTypeInfo[] expectedTypes = new ExpectedTypeInfo[]{new ExpectedTypeInfoImpl(interfaceReturnType, 1, interfaceReturnType, TailType.NONE, null, ExpectedTypeInfoImpl.NULL)};
        CreateMethodFromUsageFix.doCreate(targetClass, method, shouldBeAbstract, ContainerUtil.map2List((Object[])interfaceMethod.getParameterList().getParameters(), parameter2 -> Pair.create(null, (Object)substitutor.substitute(parameter2.getType()))), PsiSubstitutor.EMPTY, expectedTypes, context);
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
        if (string == null) {
            CreateMethodFromMethodReferenceFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    protected PsiMethodReferenceExpression getMethodReference() {
        return (PsiMethodReferenceExpression)this.myMethodReferenceExpression.getElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromMethodReferenceFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateMethodFromMethodReferenceFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetClasses";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

