/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class GeneralizeCatchFix
implements IntentionAction {
    private final PsiElement myElement;
    private final PsiClassType myUnhandledException;
    private PsiTryStatement myTryStatement;
    private PsiParameter myCatchParameter;

    public GeneralizeCatchFix(@NotNull PsiElement element, @NotNull PsiClassType unhandledException) {
        if (element == null) {
            GeneralizeCatchFix.$$$reportNull$$$0(0);
        }
        if (unhandledException == null) {
            GeneralizeCatchFix.$$$reportNull$$$0(1);
        }
        this.myElement = element;
        this.myUnhandledException = unhandledException;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("generalize.catch.text", JavaHighlightUtil.formatType(this.myCatchParameter == null ? null : this.myCatchParameter.getType()), JavaHighlightUtil.formatType((PsiType)this.myUnhandledException));
        if (string == null) {
            GeneralizeCatchFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("generalize.catch.family", new Object[0]);
        if (string == null) {
            GeneralizeCatchFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiParameter[] catchBlockParameters;
        if (project == null) {
            GeneralizeCatchFix.$$$reportNull$$$0(4);
        }
        if (!(this.myElement.isValid() && this.myUnhandledException.isValid() && this.myElement.getManager().isInProject(this.myElement))) {
            return false;
        }
        for (PsiElement element = this.myElement; element != null; element = element.getParent()) {
            if (PsiUtil.isTryBlock((PsiElement)element) || element instanceof PsiResourceList) {
                this.myTryStatement = (PsiTryStatement)element.getParent();
                break;
            }
            if (element instanceof PsiMethod || element instanceof PsiFunctionalExpression || element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) break;
        }
        if (this.myTryStatement == null) {
            return false;
        }
        for (PsiParameter catchBlockParameter : catchBlockParameters = this.myTryStatement.getCatchBlockParameters()) {
            PsiType type2 = catchBlockParameter.getType();
            if (!this.myUnhandledException.isAssignableFrom(type2)) continue;
            this.myCatchParameter = catchBlockParameter;
            break;
        }
        return this.myCatchParameter != null;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        if (file == null) {
            GeneralizeCatchFix.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            GeneralizeCatchFix.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            GeneralizeCatchFix.$$$reportNull$$$0(7);
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myElement.getProject()).getElementFactory();
        PsiTypeElement type2 = factory.createTypeElement((PsiType)this.myUnhandledException);
        this.myCatchParameter.getTypeElement().replace((PsiElement)type2);
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unhandledException";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/GeneralizeCatchFix";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/GeneralizeCatchFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToMakeWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

