/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class QualifyThisOrSuperArgumentFix
implements IntentionAction {
    protected static final Logger LOG = Logger.getInstance(QualifyThisOrSuperArgumentFix.class);
    protected final PsiExpression myExpression;
    protected final PsiClass myPsiClass;
    private String myText;

    public QualifyThisOrSuperArgumentFix(@NotNull PsiExpression expression2, @NotNull PsiClass psiClass) {
        if (expression2 == null) {
            QualifyThisOrSuperArgumentFix.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            QualifyThisOrSuperArgumentFix.$$$reportNull$$$0(1);
        }
        this.myExpression = expression2;
        this.myPsiClass = psiClass;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            QualifyThisOrSuperArgumentFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected abstract String getQualifierText();

    protected abstract PsiExpression getQualifier(PsiManager var1);

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            QualifyThisOrSuperArgumentFix.$$$reportNull$$$0(3);
        }
        if (!this.myExpression.isValid()) {
            return false;
        }
        if (!this.myPsiClass.isValid()) {
            return false;
        }
        this.myText = "Qualify " + this.getQualifierText() + " expression with '" + this.myPsiClass.getQualifiedName() + "'";
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = "Qualify " + this.getQualifierText();
        if (string == null) {
            QualifyThisOrSuperArgumentFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            QualifyThisOrSuperArgumentFix.$$$reportNull$$$0(5);
        }
        this.myExpression.replace((PsiElement)this.getQualifier(PsiManager.getInstance((Project)project)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/QualifyThisOrSuperArgumentFix";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/QualifyThisOrSuperArgumentFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

