/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateEqualsHelper;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.ui.GenerateEqualsWizard;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GenerateEqualsHandler
extends GenerateMembersHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateEqualsHandler");
    private PsiField[] myEqualsFields;
    private PsiField[] myHashCodeFields;
    private PsiField[] myNonNullFields;
    private static final PsiElementClassMember[] DUMMY_RESULT = new PsiElementClassMember[1];

    public GenerateEqualsHandler() {
        super("");
    }

    @Override
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project, Editor editor) {
        boolean hasNonStaticFields;
        this.myEqualsFields = null;
        this.myHashCodeFields = null;
        this.myNonNullFields = PsiField.EMPTY_ARRAY;
        GlobalSearchScope scope = aClass.getResolveScope();
        PsiMethod equalsMethod = GenerateEqualsHelper.findMethod(aClass, GenerateEqualsHelper.getEqualsSignature(project, scope));
        PsiMethod hashCodeMethod = GenerateEqualsHelper.findMethod(aClass, GenerateEqualsHelper.getHashCodeSignature());
        boolean needEquals = GenerateEqualsHandler.needToGenerateMethod(equalsMethod);
        boolean needHashCode = GenerateEqualsHandler.needToGenerateMethod(hashCodeMethod);
        if (!needEquals && !needHashCode) {
            String text2;
            String string = text2 = aClass instanceof PsiAnonymousClass ? CodeInsightBundle.message((String)"generate.equals.and.hashcode.already.defined.warning.anonymous", (Object[])new Object[0]) : CodeInsightBundle.message((String)"generate.equals.and.hashcode.already.defined.warning", (Object[])new Object[]{aClass.getQualifiedName()});
            if (Messages.showYesNoDialog((Project)project, (String)text2, (String)CodeInsightBundle.message((String)"generate.equals.and.hashcode.already.defined.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                if (!((Boolean)WriteAction.compute(() -> {
                    try {
                        equalsMethod.delete();
                        hashCodeMethod.delete();
                        return Boolean.TRUE;
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                        return Boolean.FALSE;
                    }
                })).booleanValue()) {
                    return null;
                }
                needHashCode = true;
                needEquals = true;
            } else {
                return null;
            }
        }
        if (!(hasNonStaticFields = GenerateEqualsHandler.hasNonStaticFields(aClass))) {
            HintManager.getInstance().showErrorHint(editor, "No fields to include in equals/hashCode have been found");
            return null;
        }
        GenerateEqualsWizard wizard = new GenerateEqualsWizard(project, aClass, needEquals, needHashCode);
        if (!wizard.showAndGet()) {
            return null;
        }
        this.myEqualsFields = wizard.getEqualsFields();
        this.myHashCodeFields = wizard.getHashCodeFields();
        this.myNonNullFields = wizard.getNonNullFields();
        return DUMMY_RESULT;
    }

    static boolean needToGenerateMethod(PsiMethod equalsMethod) {
        return equalsMethod == null || !equalsMethod.isPhysical();
    }

    private static boolean hasNonStaticFields(PsiClass aClass) {
        for (PsiField field : aClass.getFields()) {
            if (field.hasModifierProperty("static")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasMembers(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GenerateEqualsHandler.$$$reportNull$$$0(0);
        }
        return GenerateEqualsHandler.hasNonStaticFields(aClass);
    }

    @Override
    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] originalMembers) throws IncorrectOperationException {
        Project project = aClass.getProject();
        boolean useInstanceofToCheckParameterType = CodeInsightSettings.getInstance().USE_INSTANCEOF_ON_EQUALS_PARAMETER;
        boolean useAccessors = CodeInsightSettings.getInstance().USE_ACCESSORS_IN_EQUALS_HASHCODE;
        GenerateEqualsHelper helper = new GenerateEqualsHelper(project, aClass, this.myEqualsFields, this.myHashCodeFields, this.myNonNullFields, useInstanceofToCheckParameterType, useAccessors);
        List<PsiGenerationInfo<PsiMethod>> list = OverrideImplementUtil.convert2GenerationInfos(helper.generateMembers());
        if (list == null) {
            GenerateEqualsHandler.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        return null;
    }

    @Override
    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) {
        return null;
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.myEqualsFields = null;
        this.myHashCodeFields = null;
        this.myNonNullFields = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/generation/GenerateEqualsHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/generation/GenerateEqualsHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMemberPrototypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasMembers";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

