/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateServiceClassFixBase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateClassInPackageInModuleFix
implements IntentionAction {
    public static final Key<Boolean> IS_INTERFACE = Key.create((String)"CREATE_CLASS_IN_PACKAGE_IS_INTERFACE");
    public static final Key<PsiDirectory> ROOT_DIR = Key.create((String)"CREATE_CLASS_IN_PACKAGE_ROOT_DIR");
    public static final Key<String> NAME = Key.create((String)"CREATE_CLASS_IN_PACKAGE_NAME");
    private final String myModuleName;
    private final String myPackageName;

    public CreateClassInPackageInModuleFix(String moduleName, String packageName) {
        this.myModuleName = moduleName;
        this.myPackageName = packageName;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = "Create a class in '" + this.myPackageName + "'";
        if (string == null) {
            CreateClassInPackageInModuleFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Create a class in package" == null) {
            CreateClassInPackageInModuleFix.$$$reportNull$$$0(1);
        }
        return "Create a class in package";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            CreateClassInPackageInModuleFix.$$$reportNull$$$0(2);
        }
        return ModuleManager.getInstance((Project)project).findModuleByName(this.myModuleName) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            CreateClassInPackageInModuleFix.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Boolean isInterface = (Boolean)IS_INTERFACE.get((UserDataHolder)file);
            PsiDirectory rootDir = (PsiDirectory)ROOT_DIR.get((UserDataHolder)file);
            String name = (String)NAME.get((UserDataHolder)file);
            if (isInterface != null && rootDir != null && name != null) {
                WriteAction.run(() -> this.createClassInPackage(isInterface != false ? CreateClassKind.INTERFACE : CreateClassKind.CLASS, rootDir, name, (PsiElement)file));
            }
            return;
        }
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(this.myModuleName);
        if (module != null) {
            CreateClassInPackageDialog dialog;
            ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
            JavaProjectRootsUtil.collectSuitableDestinationSourceRoots(module, roots);
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiDirectory[] rootDirs = (PsiDirectory[])roots.stream().sorted(Comparator.comparing(VirtualFile::getPresentableUrl)).map(arg_0 -> ((PsiManager)psiManager).findDirectory(arg_0)).filter(Objects::nonNull).toArray(PsiDirectory[]::new);
            if (rootDirs.length != 0 && (dialog = new CreateClassInPackageDialog(project, rootDirs)).showAndGet()) {
                CreateClassKind kind2 = dialog.getKind();
                PsiDirectory rootDir = dialog.getRootDir();
                String name = dialog.getName();
                if (rootDir != null) {
                    PsiClass psiClass = (PsiClass)WriteAction.compute(() -> this.createClassInPackage(kind2, rootDir, name, (PsiElement)file));
                    CreateServiceClassFixBase.positionCursor(psiClass);
                }
            }
        }
    }

    @Nullable
    private PsiClass createClassInPackage(@NotNull CreateClassKind kind2, @NotNull PsiDirectory rootDir, @NotNull String name, @NotNull PsiElement contextElement) {
        PsiDirectory psiPackageDir;
        if (kind2 == null) {
            CreateClassInPackageInModuleFix.$$$reportNull$$$0(4);
        }
        if (rootDir == null) {
            CreateClassInPackageInModuleFix.$$$reportNull$$$0(5);
        }
        if (name == null) {
            CreateClassInPackageInModuleFix.$$$reportNull$$$0(6);
        }
        if (contextElement == null) {
            CreateClassInPackageInModuleFix.$$$reportNull$$$0(7);
        }
        if ((psiPackageDir = CreateServiceClassFixBase.getOrCreatePackageDirInRoot(this.myPackageName, rootDir)) != null) {
            return CreateFromUsageUtils.createClass(kind2, psiPackageDir, name, contextElement.getManager(), contextElement, null, null);
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public static IntentionAction createFix(@NotNull Module module, @Nullable String packageName) {
        if (module == null) {
            CreateClassInPackageInModuleFix.$$$reportNull$$$0(8);
        }
        return StringUtil.isNotEmpty((String)packageName) ? new CreateClassInPackageInModuleFix(module.getName(), packageName) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/CreateClassInPackageInModuleFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/CreateClassInPackageInModuleFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createClassInPackage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CreateClassInPackageDialog
    extends DialogWrapper {
        private final JBTextField myNameTextField;
        private final ComboBoxWithWidePopup<PsiDirectory> myRootDirCombo;
        private final TemplateKindCombo myKindCombo;
        @Nullable
        private final Project myProject;

        protected CreateClassInPackageDialog(@NotNull Project project, PsiDirectory[] rootDirs) {
            if (rootDirs == null) {
                CreateClassInPackageDialog.$$$reportNull$$$0(0);
            }
            super(project);
            this.myNameTextField = new JBTextField();
            this.myRootDirCombo = new ComboBoxWithWidePopup();
            this.myKindCombo = new TemplateKindCombo();
            this.myProject = project;
            this.setTitle("Create Class in Package");
            this.myRootDirCombo.setRenderer((ListCellRenderer)((Object)new CreateServiceClassFixBase.PsiDirectoryListCellRenderer()));
            this.myRootDirCombo.setModel(new DefaultComboBoxModel<PsiDirectory>(rootDirs));
            for (CreateClassKind kind2 : CreateClassKind.values()) {
                this.myKindCombo.addItem(CommonRefactoringUtil.capitalize((String)kind2.getDescription()), this.getKindIcon(kind2), kind2.name());
            }
            this.init();
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
            if (actionArray == null) {
                CreateClassInPackageDialog.$$$reportNull$$$0(1);
            }
            return actionArray;
        }

        protected JComponent createCenterPanel() {
            return null;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myNameTextField;
        }

        @Nullable
        protected JComponent createNorthPanel() {
            PanelGridBuilder builder = UI.PanelFactory.grid();
            builder.add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myNameTextField).withLabel("Name:").withComment("The class will be created in the package '" + CreateClassInPackageInModuleFix.this.myPackageName + "'"));
            if (this.myRootDirCombo.getModel().getSize() > 1) {
                builder.add((PanelBuilder)UI.PanelFactory.panel(this.myRootDirCombo).withLabel("Source root:"));
            }
            builder.add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myKindCombo).withLabel("Kind:"));
            return builder.createPanel();
        }

        @Nullable
        protected ValidationInfo doValidate() {
            LanguageLevel level;
            String name = this.getName();
            PsiDirectory rootDir = this.getRootDir();
            LanguageLevel languageLevel = level = rootDir != null ? PsiUtil.getLanguageLevel((PsiElement)rootDir) : LanguageLevel.HIGHEST;
            if (PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(name, level)) {
                return null;
            }
            return new ValidationInfo("This is not a valid Java class name", (JComponent)this.myNameTextField);
        }

        @NotNull
        public String getName() {
            String string = this.myNameTextField.getText().trim();
            if (string == null) {
                CreateClassInPackageDialog.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        public PsiDirectory getRootDir() {
            return (PsiDirectory)this.myRootDirCombo.getSelectedItem();
        }

        public CreateClassKind getKind() {
            return CreateClassKind.valueOf(this.myKindCombo.getSelectedName());
        }

        private Icon getKindIcon(@NotNull CreateClassKind kind2) {
            if (kind2 == null) {
                CreateClassInPackageDialog.$$$reportNull$$$0(3);
            }
            switch (kind2) {
                case CLASS: {
                    return PlatformIcons.CLASS_ICON;
                }
                case INTERFACE: {
                    return PlatformIcons.INTERFACE_ICON;
                }
                case ENUM: {
                    return PlatformIcons.ENUM_ICON;
                }
                case ANNOTATION: {
                    return PlatformIcons.ANNOTATION_TYPE_ICON;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootDirs";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/intention/impl/CreateClassInPackageInModuleFix$CreateClassInPackageDialog";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/intention/impl/CreateClassInPackageInModuleFix$CreateClassInPackageDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getKindIcon";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

