/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NumericOverflowInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Key<String> HAS_OVERFLOW_IN_CHILD = Key.create((String)"HAS_OVERFLOW_IN_CHILD");

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.NUMERIC_GROUP_NAME;
        if (string == null) {
            NumericOverflowInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Numeric overflow" == null) {
            NumericOverflowInspection.$$$reportNull$$$0(1);
        }
        return "Numeric overflow";
    }

    @NotNull
    public String getShortName() {
        if ("NumericOverflow" == null) {
            NumericOverflowInspection.$$$reportNull$$$0(2);
        }
        return "NumericOverflow";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            NumericOverflowInspection.$$$reportNull$$$0(3);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.visitExpression((PsiExpression)expression2);
            }

            public void visitExpression(PsiExpression expression2) {
                boolean info = NumericOverflowInspection.hasOverflow(expression2, holder.getProject());
                if (info) {
                    holder.registerProblem((PsiElement)expression2, JavaErrorMessages.message("numeric.overflow.in.expression", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            NumericOverflowInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasOverflow(PsiExpression expr, @NotNull Project project) {
        if (project == null) {
            NumericOverflowInspection.$$$reportNull$$$0(5);
        }
        if (!TypeConversionUtil.isNumericType((PsiType)expr.getType())) {
            return false;
        }
        boolean result = false;
        boolean toStoreInParent = false;
        try {
            if (expr.getUserData(HAS_OVERFLOW_IN_CHILD) == null) {
                JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr, true);
            } else {
                toStoreInParent = true;
                expr.putUserData(HAS_OVERFLOW_IN_CHILD, null);
            }
        }
        catch (ConstantEvaluationOverflowException e) {
            toStoreInParent = true;
            result = true;
        }
        finally {
            PsiElement parent = expr.getParent();
            if (toStoreInParent && parent instanceof PsiExpression) {
                parent.putUserData(HAS_OVERFLOW_IN_CHILD, (Object)"");
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/NumericOverflowInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/NumericOverflowInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasOverflow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

