/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.codeInspection.streamToLoop.Operation;
import com.intellij.codeInspection.streamToLoop.StreamToLoopInspection;
import com.intellij.codeInspection.streamToLoop.StreamVariable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SourceOperation
extends Operation {
    SourceOperation() {
    }

    @Override
    @Contract(value=" -> true", pure=true)
    final boolean changesVariable() {
        return true;
    }

    @Override
    @NotNull
    final String wrap(StreamVariable inVar, StreamVariable outVar, String code, StreamToLoopInspection.StreamToLoopReplacementContext context) {
        String result = this.wrap(outVar, code, context);
        String string = context.drainBeforeSteps() + result + context.drainAfterSteps();
        if (string == null) {
            SourceOperation.$$$reportNull$$$0(0);
        }
        return string;
    }

    abstract String wrap(StreamVariable var1, String var2, StreamToLoopInspection.StreamToLoopReplacementContext var3);

    @Nullable
    static SourceOperation createSource(PsiMethodCallExpression call, boolean supportUnknownSources) {
        PsiType type2;
        PsiExpression[] args = call.getArgumentList().getExpressions();
        PsiType callType = call.getType();
        if (callType == null || PsiType.VOID.equals((Object)callType)) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        String name = method.getName();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        String className = aClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        if ((name.equals("range") || name.equals("rangeClosed")) && args.length == 2 && method.getModifierList().hasExplicitModifier("static") && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream")) {
            return new RangeSource(args[0], args[1], name.equals("rangeClosed"));
        }
        if (name.equals("of") && method.getModifierList().hasExplicitModifier("static") && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream")) {
            if (method.getParameterList().getParametersCount() != 1) {
                return null;
            }
            if (args.length == 1) {
                PsiType type3 = args[0].getType();
                PsiType componentType = null;
                if (type3 instanceof PsiArrayType) {
                    componentType = ((PsiArrayType)type3).getComponentType();
                } else if (InheritanceUtil.isInheritor((PsiType)type3, (String)"java.lang.Iterable")) {
                    componentType = PsiUtil.substituteTypeParameter((PsiType)type3, (String)"java.lang.Iterable", (int)0, (boolean)false);
                }
                PsiType elementType = StreamApiUtil.getStreamElementType(callType);
                if (componentType != null && elementType.isAssignableFrom(componentType)) {
                    return new ForEachSource(args[0]);
                }
                if (type3 == null || !elementType.isAssignableFrom(type3)) {
                    return null;
                }
            }
            return new ExplicitSource(call);
        }
        if (name.equals("generate") && args.length == 1 && method.getModifierList().hasExplicitModifier("static") && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream")) {
            FunctionHelper fn = FunctionHelper.create(args[0], 0);
            return fn == null ? null : new GenerateSource(fn, null);
        }
        if (name.equals("iterate") && args.length == 2 && method.getModifierList().hasExplicitModifier("static") && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream")) {
            FunctionHelper fn = FunctionHelper.create(args[1], 1);
            return fn == null ? null : new IterateSource(args[0], fn);
        }
        if (name.equals("stream") && args.length == 0 && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection")) {
            return new ForEachSource(call.getMethodExpression().getQualifierExpression());
        }
        if (name.equals("stream") && args.length == 1 && "java.util.Arrays".equals(className)) {
            return new ForEachSource(args[0]);
        }
        if (name.equals("stream") && args.length == 3 && "java.util.Arrays".equals(className) && args[0].getType() != null && PsiType.INT.equals((Object)args[1].getType()) && PsiType.INT.equals((Object)args[2].getType())) {
            return new ArraySliceSource(args[0], args[1], args[2]);
        }
        if (supportUnknownSources && (type2 = StreamApiUtil.getStreamElementType(call.getType(), false)) != null) {
            return new StreamIteratorSource(call, type2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamToLoop/SourceOperation", "wrap"));
    }

    private static class StreamIteratorSource
    extends SourceOperation {
        private final String myElementType;
        private PsiMethodCallExpression myCall;

        public StreamIteratorSource(PsiMethodCallExpression call, PsiType type2) {
            this.myCall = call;
            this.myElementType = type2.getCanonicalText();
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myCall = FunctionHelper.replaceVarReference(this.myCall, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            consumer.accept((PsiElement)this.myCall);
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            String unpluralized;
            String name = this.myCall.getMethodExpression().getReferenceName();
            if (name != null && (unpluralized = StringUtil.unpluralize((String)name)) != null && !unpluralized.equals(name)) {
                outVar.addOtherNameCandidate(unpluralized);
            }
        }

        static String getIteratorType(String type2) {
            switch (type2) {
                case "int": {
                    return "java.util.PrimitiveIterator.OfInt";
                }
                case "long": {
                    return "java.util.PrimitiveIterator.OfLong";
                }
                case "double": {
                    return "java.util.PrimitiveIterator.OfDouble";
                }
            }
            return "java.util.Iterator<" + type2 + ">";
        }

        @Override
        String wrap(StreamVariable outVar, String code, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String iterator = context.registerVarName(Arrays.asList("it", "iter", "iterator"));
            String declaration2 = StreamIteratorSource.getIteratorType(this.myElementType) + " " + iterator + "=" + this.myCall.getText() + ".iterator()";
            String condition2 = iterator + ".hasNext()";
            return "for(" + declaration2 + ";" + condition2 + ";) {\n" + outVar.getDeclaration(iterator + ".next()") + code + "}\n";
        }
    }

    static class ArraySliceSource
    extends SourceOperation {
        @NotNull
        private PsiExpression myArray;
        @NotNull
        private PsiExpression myOrigin;
        @NotNull
        private PsiExpression myBound;
        @NotNull
        private final PsiType myArrayType;

        ArraySliceSource(@NotNull PsiExpression array, @NotNull PsiExpression origin, @NotNull PsiExpression bound) {
            if (array == null) {
                ArraySliceSource.$$$reportNull$$$0(0);
            }
            if (origin == null) {
                ArraySliceSource.$$$reportNull$$$0(1);
            }
            if (bound == null) {
                ArraySliceSource.$$$reportNull$$$0(2);
            }
            this.myOrigin = origin;
            this.myBound = bound;
            this.myArray = array;
            this.myArrayType = Objects.requireNonNull(this.myArray.getType());
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myOrigin = FunctionHelper.replaceVarReference(this.myOrigin, oldName, newName, context);
            this.myBound = FunctionHelper.replaceVarReference(this.myBound, oldName, newName, context);
            this.myArray = FunctionHelper.replaceVarReference(this.myArray, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            consumer.accept((PsiElement)this.myOrigin);
            consumer.accept((PsiElement)this.myBound);
            consumer.accept((PsiElement)this.myArray);
        }

        @Override
        String wrap(StreamVariable outVar, String code, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String bound = this.myBound.getText();
            String array = this.myArray.getText();
            if (!ExpressionUtils.isSafelyRecomputableExpression(context.createExpression(array))) {
                array = context.declare("array", this.myArrayType.getCanonicalText(), array);
            }
            if (!ExpressionUtils.isSafelyRecomputableExpression(context.createExpression(bound))) {
                bound = context.declare("bound", "int", bound);
            }
            String loopVar = context.registerVarName(Arrays.asList("i", "j", "idx"));
            String element = outVar.getDeclaration(array + "[" + loopVar + "]");
            return context.getLoopLabel() + "for(int " + loopVar + " = " + this.myOrigin.getText() + ";" + loopVar + "<" + bound + ";" + loopVar + "++) {\n" + element + code + "}\n";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "array";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "origin";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bound";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/streamToLoop/SourceOperation$ArraySliceSource";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class RangeSource
    extends SourceOperation {
        private PsiExpression myOrigin;
        private PsiExpression myBound;
        private final boolean myInclusive;

        RangeSource(PsiExpression origin, PsiExpression bound, boolean inclusive) {
            this.myOrigin = origin;
            this.myBound = bound;
            this.myInclusive = inclusive;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myOrigin = FunctionHelper.replaceVarReference(this.myOrigin, oldName, newName, context);
            this.myBound = FunctionHelper.replaceVarReference(this.myBound, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            consumer.accept((PsiElement)this.myOrigin);
            consumer.accept((PsiElement)this.myBound);
        }

        @Override
        String wrap(StreamVariable outVar, String code, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String bound = this.myBound.getText();
            if (!ExpressionUtils.isSafelyRecomputableExpression(context.createExpression(bound))) {
                bound = context.declare("bound", outVar.getType().getCanonicalText(), bound);
            }
            String loopVar = outVar.getName();
            String reassign = "";
            if (outVar.isFinal()) {
                loopVar = context.registerVarName(Arrays.asList("i", "j", "idx"));
                reassign = outVar.getDeclaration(loopVar);
            }
            return context.getLoopLabel() + "for(" + outVar.getType().getCanonicalText() + " " + loopVar + " = " + this.myOrigin.getText() + ";" + loopVar + (this.myInclusive ? "<=" : "<") + bound + ";" + loopVar + "++) {\n" + reassign + code + "}\n";
        }
    }

    static class IterateSource
    extends SourceOperation {
        private PsiExpression myInitializer;
        private final FunctionHelper myFn;

        IterateSource(PsiExpression initializer, FunctionHelper fn) {
            this.myInitializer = initializer;
            this.myFn = fn;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myInitializer = FunctionHelper.replaceVarReference(this.myInitializer, oldName, newName, context);
            this.myFn.rename(oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            consumer.accept((PsiElement)this.myInitializer);
            this.myFn.registerReusedElements(consumer);
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            this.myFn.preprocessVariable(context, outVar, 0);
        }

        @Override
        String wrap(StreamVariable outVar, String code, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myFn.transform(context, outVar.getName());
            return context.getLoopLabel() + "for(" + outVar.getDeclaration() + "=" + this.myInitializer.getText() + ";;" + outVar + "=" + this.myFn.getText() + ") {\n" + code + "}\n";
        }
    }

    static class GenerateSource
    extends SourceOperation {
        private final FunctionHelper myFn;
        private PsiExpression myLimit;

        GenerateSource(FunctionHelper fn, PsiExpression limit) {
            this.myFn = fn;
            this.myLimit = limit;
        }

        @Override
        Operation combineWithNext(Operation next) {
            if (this.myLimit == null && next instanceof Operation.LimitOperation) {
                return new GenerateSource(this.myFn, ((Operation.LimitOperation)next).myLimit);
            }
            return null;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myFn.rename(oldName, newName, context);
            if (this.myLimit != null) {
                this.myLimit = FunctionHelper.replaceVarReference(this.myLimit, oldName, newName, context);
            }
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            this.myFn.registerReusedElements(consumer);
            if (this.myLimit != null) {
                consumer.accept((PsiElement)this.myLimit);
            }
        }

        @Override
        String wrap(StreamVariable outVar, String code, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myFn.transform(context, new String[0]);
            String loop = "while(true)";
            if (this.myLimit != null) {
                String loopIdx = context.registerVarName(Arrays.asList("count", "limit"));
                loop = "for(long " + loopIdx + "=" + this.myLimit.getText() + ";" + loopIdx + ">0;" + loopIdx + "--)";
            }
            return context.getLoopLabel() + loop + "{\n" + outVar.getDeclaration(this.myFn.getText()) + code + "}\n";
        }
    }

    static class ExplicitSource
    extends SourceOperation {
        private PsiMethodCallExpression myCall;

        ExplicitSource(PsiMethodCallExpression call) {
            this.myCall = call;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            this.myCall = FunctionHelper.replaceVarReference(this.myCall, oldName, newName, context);
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            consumer.accept((PsiElement)this.myCall.getArgumentList());
        }

        @Override
        public String wrap(StreamVariable outVar, String code, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            String iterationParameter;
            PsiType type2 = outVar.getType();
            PsiExpressionList argList = this.myCall.getArgumentList();
            if (type2 instanceof PsiPrimitiveType) {
                Object[] children = argList.getChildren();
                iterationParameter = StreamEx.of((Object[])children, (int)1, (int)(children.length - 1)).map(PsiElement::getText).joining((CharSequence)"", (CharSequence)("new " + type2.getCanonicalText() + "[] {"), (CharSequence)"}");
            } else {
                iterationParameter = "java.util.Arrays.<" + type2.getCanonicalText() + ">asList" + argList.getText();
            }
            return context.getLoopLabel() + "for(" + outVar.getDeclaration() + ": " + iterationParameter + ") {" + code + "}\n";
        }
    }

    static class ForEachSource
    extends SourceOperation {
        @Nullable
        private PsiExpression myQualifier;

        ForEachSource(@Nullable PsiExpression qualifier) {
            this.myQualifier = qualifier;
        }

        @Override
        void rename(String oldName, String newName, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            if (this.myQualifier != null) {
                this.myQualifier = FunctionHelper.replaceVarReference(this.myQualifier, oldName, newName, context);
            }
        }

        @Override
        public void registerReusedElements(Consumer<PsiElement> consumer) {
            consumer.accept((PsiElement)this.myQualifier);
        }

        @Override
        public void preprocessVariables(StreamToLoopInspection.StreamToLoopReplacementContext context, StreamVariable inVar, StreamVariable outVar) {
            String singularName;
            String name;
            if (this.myQualifier instanceof PsiReferenceExpression && (name = ((PsiReferenceExpression)this.myQualifier).getReferenceName()) != null && (singularName = StringUtil.unpluralize((String)name)) != null && !name.equals(singularName)) {
                outVar.addOtherNameCandidate(singularName);
            }
        }

        @Override
        public String wrap(StreamVariable outVar, String code, StreamToLoopInspection.StreamToLoopReplacementContext context) {
            PsiExpression iterationParameter = this.myQualifier == null ? ExpressionUtils.getQualifierOrThis(((PsiMethodCallExpression)context.createExpression("stream()")).getMethodExpression()) : this.myQualifier;
            return context.getLoopLabel() + "for(" + outVar.getDeclaration() + ": " + iterationParameter.getText() + ") {" + code + "}\n";
        }
    }
}

