/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.BasePsiMemberNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.Collection;
import java.util.Objects;

public class PsiFieldNode
extends BasePsiMemberNode<PsiField> {
    public PsiFieldNode(Project project, PsiField value2, ViewSettings viewSettings) {
        super(project, value2, viewSettings);
    }

    public Collection<AbstractTreeNode> getChildrenImpl() {
        return null;
    }

    public void updateImpl(PresentationData data) {
        String name;
        PsiField field = (PsiField)Objects.requireNonNull(this.getValue());
        try {
            name = PsiFormatUtil.formatVariable((PsiVariable)field, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        }
        catch (IndexNotReadyException e) {
            name = StringUtil.notNullize((String)field.getName());
        }
        int c = name.indexOf(10);
        if (c > -1) {
            name = name.substring(0, c - 1);
        }
        data.setPresentableText(name);
    }

    public int getWeight() {
        return 70;
    }

    public boolean isAlwaysLeaf() {
        return true;
    }

    public String getTitle() {
        PsiField field = (PsiField)this.getValue();
        if (field != null) {
            PsiClass aClass = field.getContainingClass();
            if (aClass != null) {
                return aClass.getQualifiedName();
            }
            return field.toString();
        }
        return super.getTitle();
    }
}

