/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeClassSignature;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeParameterInfo {
    public String getName(PsiTypeParameter[] var1);

    public PsiTypeParameter getTypeParameter(PsiTypeParameter[] var1, Project var2);

    public static class Existing
    implements TypeParameterInfo {
        private final int myOldParameterIndex;

        public Existing(int oldIndex) {
            this.myOldParameterIndex = oldIndex;
        }

        public int getParameterIndex() {
            return this.myOldParameterIndex;
        }

        @Override
        public String getName(PsiTypeParameter[] parameters2) {
            return parameters2[this.myOldParameterIndex].getName();
        }

        @Override
        public PsiTypeParameter getTypeParameter(PsiTypeParameter[] parameters2, Project project) {
            return parameters2[this.myOldParameterIndex];
        }
    }

    public static class New
    implements TypeParameterInfo {
        private String myNewName;
        private CanonicalTypes.Type myDefaultValue;
        private CanonicalTypes.Type myBoundValue;

        public New(@NotNull String name, @Nullable PsiType aType, @Nullable PsiType boundValue) {
            if (name == null) {
                New.$$$reportNull$$$0(0);
            }
            this.myNewName = name;
            this.myDefaultValue = aType != null ? CanonicalTypes.createTypeWrapper(aType) : null;
            this.myBoundValue = boundValue != null ? CanonicalTypes.createTypeWrapper(boundValue) : null;
        }

        public New(@NotNull PsiClass aClass, @NotNull @NonNls String name, @NotNull @NonNls String defaultValue, @NotNull @NonNls String boundValue) throws IncorrectOperationException {
            if (aClass == null) {
                New.$$$reportNull$$$0(1);
            }
            if (name == null) {
                New.$$$reportNull$$$0(2);
            }
            if (defaultValue == null) {
                New.$$$reportNull$$$0(3);
            }
            if (boundValue == null) {
                New.$$$reportNull$$$0(4);
            }
            this(name, JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createTypeFromText(defaultValue, aClass.getLBrace()), boundValue.isEmpty() ? null : JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory().createTypeFromText(boundValue, aClass.getLBrace()));
        }

        public void setNewName(String newName) {
            this.myNewName = newName;
        }

        public void setBoundValue(PsiType aType) {
            this.myBoundValue = CanonicalTypes.createTypeWrapper(aType);
        }

        public void setDefaultValue(PsiType aType) {
            this.myDefaultValue = CanonicalTypes.createTypeWrapper(aType);
        }

        @Override
        public String getName(PsiTypeParameter[] parameters2) {
            return this.myNewName;
        }

        @Override
        public PsiTypeParameter getTypeParameter(PsiTypeParameter[] parameters2, Project project) {
            String extendsText = this.myBoundValue == null ? "" : " extends " + New.getCanonicalText(this.myBoundValue.getType(null, PsiManager.getInstance((Project)project)));
            return JavaPsiFacade.getElementFactory((Project)project).createTypeParameterFromText(this.myNewName + extendsText, null);
        }

        public CanonicalTypes.Type getDefaultValue() {
            return this.myDefaultValue;
        }

        private static String getCanonicalText(PsiType boundType) {
            if (boundType instanceof PsiIntersectionType) {
                return StringUtil.join((Collection)ContainerUtil.map((Object[])((PsiIntersectionType)boundType).getConjuncts(), type2 -> type2.getCanonicalText()), (String)" & ");
            }
            return boundType.getCanonicalText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "boundValue";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/changeClassSignature/TypeParameterInfo$New";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

