/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.convertToInstanceMethod;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodHandler;
import com.intellij.refactoring.convertToInstanceMethod.ImplementingClassUsageInfo;
import com.intellij.refactoring.convertToInstanceMethod.JavaDocUsageInfo;
import com.intellij.refactoring.convertToInstanceMethod.MethodCallUsageInfo;
import com.intellij.refactoring.convertToInstanceMethod.MethodReferenceUsageInfo;
import com.intellij.refactoring.convertToInstanceMethod.ParameterUsageInfo;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodViewDescriptor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToInstanceMethodProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodProcessor");
    private PsiMethod myMethod;
    @Nullable
    private PsiParameter myTargetParameter;
    private PsiClass myTargetClass;
    private Map<PsiTypeParameter, PsiTypeParameter> myTypeParameterReplacements;
    private static final Key<PsiTypeParameter> BIND_TO_TYPE_PARAMETER = Key.create((String)"REPLACEMENT");
    private final String myOldVisibility;
    private final String myNewVisibility;

    public ConvertToInstanceMethodProcessor(Project project, PsiMethod method, @Nullable PsiParameter targetParameter, String newVisibility) {
        super(project);
        this.myMethod = method;
        this.myTargetParameter = targetParameter;
        LOG.assertTrue(method.hasModifierProperty("static"));
        if (this.myTargetParameter != null) {
            LOG.assertTrue(this.myTargetParameter.getDeclarationScope() == this.myMethod);
            LOG.assertTrue(this.myTargetParameter.getType() instanceof PsiClassType);
            PsiType type2 = this.myTargetParameter.getType();
            LOG.assertTrue(type2 instanceof PsiClassType);
            this.myTargetClass = ((PsiClassType)type2).resolve();
        } else {
            this.myTargetClass = method.getContainingClass();
        }
        this.myOldVisibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
        this.myNewVisibility = newVisibility;
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(0);
        }
        MoveInstanceMethodViewDescriptor moveInstanceMethodViewDescriptor = new MoveInstanceMethodViewDescriptor(this.myMethod, (PsiVariable)this.myTargetParameter, this.myTargetClass);
        if (moveInstanceMethodViewDescriptor == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(1);
        }
        return moveInstanceMethodViewDescriptor;
    }

    protected void refreshElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(elements.length > 1);
        this.myMethod = (PsiMethod)elements[0];
        this.myTargetParameter = elements.length == 3 ? (PsiParameter)elements[1] : null;
        this.myTargetClass = (PsiClass)elements[elements.length - 1];
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        LOG.assertTrue(this.myTargetParameter == null || this.myTargetParameter.getDeclarationScope() == this.myMethod);
        Project project = this.myMethod.getProject();
        PsiReference[] methodReferences = (PsiReference[])ReferencesSearch.search((PsiElement)this.myMethod, (SearchScope)GlobalSearchScope.projectScope((Project)project), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY);
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (PsiReference ref : methodReferences) {
            PsiElement element = ref.getElement();
            if (element instanceof PsiReferenceExpression) {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    result.add(new MethodCallUsageInfo((PsiMethodCallExpression)parent));
                    continue;
                }
                if (!(element instanceof PsiMethodReferenceExpression)) continue;
                result.add(new MethodReferenceUsageInfo((PsiMethodReferenceExpression)element, this.myTargetParameter == null || this.myMethod.getParameterList().getParameterIndex(this.myTargetParameter) == 0));
                continue;
            }
            if (!(element instanceof PsiDocTagValue)) continue;
            result.add(new JavaDocUsageInfo(ref));
        }
        if (this.myTargetParameter != null) {
            for (PsiReference ref : ReferencesSearch.search((PsiElement)this.myTargetParameter, (SearchScope)new LocalSearchScope((PsiElement)this.myMethod), (boolean)false)) {
                PsiElement element = ref.getElement();
                if (!(element instanceof PsiReferenceExpression) && !(element instanceof PsiDocParamRef)) continue;
                result.add(new ParameterUsageInfo(ref));
            }
        }
        if (this.myTargetClass.isInterface()) {
            PsiClass[] implementingClasses;
            for (PsiClass implementingClass : implementingClasses = RefactoringHierarchyUtil.findImplementingClasses(this.myTargetClass)) {
                result.add(new ImplementingClassUsageInfo(implementingClass));
            }
        }
        UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.makeInstance";
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(new PsiElement[]{this.myMethod, this.myTargetClass});
        return data;
    }

    @Nullable
    protected RefactoringEventData getAfterData(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(4);
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myTargetClass);
        return data;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(5);
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        Set<PsiMethod> methods = Collections.singleton(this.myMethod);
        if (!this.myTargetClass.isInterface()) {
            RefactoringConflictsUtil.analyzeAccessibilityConflicts(methods, this.myTargetClass, (MultiMap<PsiElement, String>)conflicts, this.myNewVisibility);
        } else {
            for (UsageInfo usage : usagesIn) {
                if (!(usage instanceof ImplementingClassUsageInfo)) continue;
                RefactoringConflictsUtil.analyzeAccessibilityConflicts(methods, ((ImplementingClassUsageInfo)usage).getPsiClass(), (MultiMap<PsiElement, String>)conflicts, "public");
            }
        }
        for (UsageInfo usageInfo : usagesIn) {
            PsiMethodCallExpression place = null;
            if (usageInfo instanceof MethodCallUsageInfo) {
                place = ((MethodCallUsageInfo)usageInfo).getMethodCall();
                if (this.myTargetParameter != null) {
                    PsiExpression[] expressions2 = place.getArgumentList().getExpressions();
                    int index = this.myMethod.getParameterList().getParameterIndex(this.myTargetParameter);
                    if (index < expressions2.length) {
                        PsiExpression instanceValue = expressions2[index];
                        if ((instanceValue = RefactoringUtil.unparenthesizeExpression(instanceValue)) instanceof PsiLiteralExpression && ((PsiLiteralExpression)instanceValue).getValue() == null) {
                            String message2 = RefactoringBundle.message((String)"0.contains.call.with.null.argument.for.parameter.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer((PsiElement)place), (boolean)true), CommonRefactoringUtil.htmlEmphasize((String)this.myTargetParameter.getName())});
                            conflicts.putValue((Object)place, (Object)message2);
                        }
                    }
                }
            } else if (usageInfo instanceof MethodReferenceUsageInfo) {
                place = ((MethodReferenceUsageInfo)usageInfo).getExpression();
                if (!((MethodReferenceUsageInfo)usageInfo).isApplicableBySecondSearch()) {
                    conflicts.putValue((Object)place, (Object)RefactoringBundle.message((String)"expand.method.reference.warning"));
                }
            }
            if (this.myTargetParameter != null || place == null || !this.myTargetClass.hasTypeParameters() || this.thisAccessExpressionApplicable((PsiElement)place)) continue;
            conflicts.putValue((Object)place, (Object)("Impossible to infer class type arguments. When proceed, raw " + this.myTargetClass.getName() + " would be created"));
        }
        return this.showConflicts(conflicts, usagesIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(6);
        }
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            this.doRefactoring(usages);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        finally {
            a.finish();
        }
    }

    private void doRefactoring(UsageInfo[] usages) throws IncorrectOperationException {
        this.myTypeParameterReplacements = this.buildTypeParameterReplacements();
        ArrayList<PsiClass> inheritors = new ArrayList<PsiClass>();
        CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
        for (UsageInfo usage : usages) {
            if (usage instanceof MethodCallUsageInfo) {
                this.processMethodCall(((MethodCallUsageInfo)usage).getMethodCall());
                continue;
            }
            if (usage instanceof ParameterUsageInfo) {
                this.processParameterUsage((ParameterUsageInfo)usage);
                continue;
            }
            if (usage instanceof ImplementingClassUsageInfo) {
                inheritors.add(((ImplementingClassUsageInfo)usage).getPsiClass());
                continue;
            }
            if (!(usage instanceof MethodReferenceUsageInfo)) continue;
            this.processMethodReference((MethodReferenceUsageInfo)usage);
        }
        this.prepareTypeParameterReplacement();
        if (this.myTargetParameter != null) {
            this.myTargetParameter.delete();
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myMethod, true);
        if (!this.myTargetClass.isInterface()) {
            PsiMethod method = this.addMethodToClass(this.myTargetClass);
            this.fixVisibility(method, usages);
            EditorHelper.openInEditor((PsiElement)method);
        } else {
            PsiMethod interfaceMethod = this.addMethodToClass(this.myTargetClass);
            PsiModifierList modifierList = interfaceMethod.getModifierList();
            boolean markAsDefault = PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myTargetClass);
            if (markAsDefault) {
                modifierList.setModifierProperty("default", true);
            }
            RefactoringUtil.makeMethodAbstract(this.myTargetClass, interfaceMethod);
            EditorHelper.openInEditor((PsiElement)interfaceMethod);
            if (!markAsDefault) {
                for (PsiClass psiClass : inheritors) {
                    PsiMethod newMethod = this.addMethodToClass(psiClass);
                    PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)(this.myNewVisibility != null && !this.myNewVisibility.equals("EscalateVisible") ? this.myNewVisibility : "public"), (boolean)true);
                }
            }
        }
        this.myMethod.delete();
    }

    private void processMethodReference(MethodReferenceUsageInfo usage) {
        PsiMethodReferenceExpression expression2 = usage.getExpression();
        if (usage.isApplicableBySecondSearch()) {
            boolean thisAccess;
            PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
            LOG.assertTrue(qualifierExpression2 != null);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
            Object qualifier = this.myTargetParameter != null ? factory.createReferenceExpression(this.myTargetClass) : ((thisAccess = this.thisAccessExpressionApplicable((PsiElement)expression2)) ? factory.createExpressionFromText("this", (PsiElement)qualifierExpression2) : this.createSyntheticAccessExpression(factory, (PsiElement)expression2));
            qualifierExpression2.replace((PsiElement)qualifier);
        } else {
            PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda(expression2, false, true);
            List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)lambdaExpression);
            if (!returnExpressions.isEmpty()) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)returnExpressions.get(0);
                this.processMethodCall(methodCall);
                usage.setReplacement(methodCall);
            }
        }
    }

    private void fixVisibility(PsiMethod method, UsageInfo[] usages) throws IncorrectOperationException {
        PsiModifierList modifierList = method.getModifierList();
        if ("EscalateVisible".equals(this.myNewVisibility)) {
            for (UsageInfo usage : usages) {
                Object place = null;
                if (usage instanceof MethodCallUsageInfo) {
                    place = usage.getElement();
                } else if (usage instanceof MethodReferenceUsageInfo) {
                    PsiMethodReferenceExpression expression2 = ((MethodReferenceUsageInfo)usage).getExpression();
                    place = expression2 != null && expression2.isValid() ? expression2 : ((MethodReferenceUsageInfo)usage).getReplacement();
                }
                if (place == null) continue;
                VisibilityUtil.escalateVisibility((PsiMember)method, (PsiElement)place);
            }
        } else if (this.myNewVisibility != null && !this.myNewVisibility.equals(this.myOldVisibility)) {
            modifierList.setModifierProperty(this.myNewVisibility, true);
        }
    }

    private void prepareTypeParameterReplacement() throws IncorrectOperationException {
        if (this.myTypeParameterReplacements == null) {
            return;
        }
        Set<PsiTypeParameter> typeParameters = this.myTypeParameterReplacements.keySet();
        for (PsiTypeParameter parameter2 : typeParameters) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter2, (SearchScope)new LocalSearchScope((PsiElement)this.myMethod), (boolean)false)) {
                if (!(reference.getElement() instanceof PsiJavaCodeReferenceElement)) continue;
                reference.getElement().putCopyableUserData(BIND_TO_TYPE_PARAMETER, (Object)this.myTypeParameterReplacements.get(parameter2));
            }
        }
        Set<PsiTypeParameter> methodTypeParameters = this.myTypeParameterReplacements.keySet();
        for (PsiTypeParameter methodTypeParameter : methodTypeParameters) {
            methodTypeParameter.delete();
        }
    }

    private PsiMethod addMethodToClass(PsiClass targetClass) throws IncorrectOperationException {
        HashMap<PsiTypeParameter, PsiTypeParameter> additionalReplacements;
        PsiMethod newMethod = (PsiMethod)targetClass.add((PsiElement)this.myMethod);
        PsiModifierList modifierList = newMethod.getModifierList();
        modifierList.setModifierProperty("static", false);
        ChangeContextUtil.decodeContextInfo((PsiElement)newMethod, null, null);
        if (this.myTypeParameterReplacements == null) {
            return newMethod;
        }
        if (targetClass != this.myTargetClass) {
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.myTargetClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            Map<PsiTypeParameter, PsiTypeParameter> map = ConvertToInstanceMethodProcessor.calculateReplacementMap(superClassSubstitutor, this.myTargetClass, (PsiElement)targetClass);
            if (map == null) {
                return newMethod;
            }
            additionalReplacements = new HashMap<PsiTypeParameter, PsiTypeParameter>();
            for (Map.Entry<PsiTypeParameter, PsiTypeParameter> entry : map.entrySet()) {
                additionalReplacements.put(entry.getValue(), entry.getKey());
            }
        } else {
            additionalReplacements = null;
        }
        newMethod.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiTypeParameter typeParameterToBind = (PsiTypeParameter)reference.getCopyableUserData(BIND_TO_TYPE_PARAMETER);
                if (typeParameterToBind != null) {
                    reference.putCopyableUserData(BIND_TO_TYPE_PARAMETER, null);
                    try {
                        if (additionalReplacements != null) {
                            typeParameterToBind = (PsiTypeParameter)additionalReplacements.get(typeParameterToBind);
                        }
                        reference.bindToElement((PsiElement)typeParameterToBind);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                } else {
                    this.visitElement((PsiElement)reference);
                }
            }
        });
        return newMethod;
    }

    private void processParameterUsage(ParameterUsageInfo usage) throws IncorrectOperationException {
        PsiReference reference = usage.getReferenceExpression();
        if (reference instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)reference;
            PsiElement parent = referenceExpression.getParent();
            if (parent instanceof PsiReferenceExpression && ConvertToInstanceMethodProcessor.sameUnqualified(parent)) {
                referenceExpression.delete();
            } else {
                PsiExpression expression2 = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory().createExpressionFromText("this", null);
                referenceExpression.replace((PsiElement)expression2);
            }
        } else {
            PsiElement element = reference.getElement();
            if (element instanceof PsiDocParamRef) {
                element.getParent().delete();
            }
        }
    }

    private static boolean sameUnqualified(PsiElement parent) {
        if (parent instanceof PsiMethodReferenceExpression) {
            return false;
        }
        PsiElement resolve = ((PsiReferenceExpression)parent).resolve();
        if (resolve instanceof PsiField) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)resolve.getProject());
            PsiExpression unqualifiedFieldReference = elementFactory.createExpressionFromText(((PsiField)resolve).getName(), parent);
            return resolve == ((PsiReferenceExpression)unqualifiedFieldReference).resolve();
        }
        return true;
    }

    private void processMethodCall(PsiMethodCallExpression methodCall) throws IncorrectOperationException {
        PsiExpression qualifier;
        PsiExpression argument;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethod.getProject()).getElementFactory();
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        if (this.myTargetParameter != null) {
            PsiParameterList parameterList = this.myMethod.getParameterList();
            int parameterIndex = parameterList.getParameterIndex(this.myTargetParameter);
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            if (arguments.length <= parameterIndex) {
                return;
            }
            argument = arguments[parameterIndex];
        } else {
            if (this.thisAccessExpressionApplicable((PsiElement)methodCall)) {
                PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
                if (qualifierExpression2 != null) {
                    qualifierExpression2.delete();
                }
                return;
            }
            argument = this.createSyntheticAccessExpression(factory, (PsiElement)methodCall);
        }
        if (methodExpression.getQualifierExpression() != null) {
            qualifier = methodExpression.getQualifierExpression();
        } else {
            PsiReferenceExpression newRefExpr = (PsiReferenceExpression)factory.createExpressionFromText("x." + this.myMethod.getName(), null);
            qualifier = ((PsiReferenceExpression)methodExpression.replace((PsiElement)newRefExpr)).getQualifierExpression();
        }
        qualifier.replace((PsiElement)argument);
        argument.delete();
    }

    private PsiExpression createSyntheticAccessExpression(PsiElementFactory factory, PsiElement context) {
        return factory.createExpressionFromText("new " + this.myTargetClass.getName() + "()", context);
    }

    private boolean thisAccessExpressionApplicable(PsiElement expression2) {
        return PsiTreeUtil.isAncestor((PsiElement)this.myTargetClass, (PsiElement)expression2, (boolean)false) && PsiUtil.getEnclosingStaticElement((PsiElement)expression2, (PsiClass)this.myTargetClass) == null;
    }

    @NotNull
    protected String getCommandName() {
        String string = ConvertToInstanceMethodHandler.REFACTORING_NAME;
        if (string == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public Map<PsiTypeParameter, PsiTypeParameter> buildTypeParameterReplacements() {
        if (this.myTargetParameter == null) {
            return Collections.emptyMap();
        }
        PsiClassType type2 = (PsiClassType)this.myTargetParameter.getType();
        PsiSubstitutor substitutor = type2.resolveGenerics().getSubstitutor();
        return ConvertToInstanceMethodProcessor.calculateReplacementMap(substitutor, this.myTargetClass, (PsiElement)this.myMethod);
    }

    @Nullable
    private static Map<PsiTypeParameter, PsiTypeParameter> calculateReplacementMap(PsiSubstitutor substitutor, PsiClass targetClass, PsiElement containingElement) {
        HashMap<PsiTypeParameter, PsiTypeParameter> result = new HashMap<PsiTypeParameter, PsiTypeParameter>();
        for (PsiTypeParameter classTypeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)targetClass)) {
            PsiType substitution = substitutor.substitute(classTypeParameter);
            if (!(substitution instanceof PsiClassType)) {
                return null;
            }
            PsiClass aClass = ((PsiClassType)substitution).resolve();
            if (!(aClass instanceof PsiTypeParameter)) {
                return null;
            }
            PsiTypeParameter methodTypeParameter = (PsiTypeParameter)aClass;
            if (methodTypeParameter.getOwner() != containingElement) {
                return null;
            }
            if (result.keySet().contains(methodTypeParameter)) {
                return null;
            }
            result.put(methodTypeParameter, classTypeParameter);
        }
        return result;
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    @Nullable
    public PsiParameter getTargetParameter() {
        return this.myTargetParameter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

