/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Segment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.ExtractMethodSnapshot;
import com.intellij.refactoring.extractMethod.JavaDuplicatesExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.ParametrizedDuplicates;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractDuplicatesProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(ExtractDuplicatesProcessor.class);
    private final PsiMethod myMethod;
    private final List<Couple<SmartPsiElementPointer<PsiElement>>> myDuplicatesPointers = new ArrayList<Couple<SmartPsiElementPointer<PsiElement>>>();
    private final ExtractMethodSnapshot myExtractMethodSnapshot;
    private final List<SmartPsiElementPointer<PsiElement>> myElementPointers;

    public ExtractDuplicatesProcessor(ExtractMethodProcessor processor) {
        super(processor.getProject());
        this.myExtractMethodSnapshot = new ExtractMethodSnapshot(processor);
        Object[] elements = processor.getElements();
        PsiMethod method = processor.generateEmptyMethod(processor.getMethodName(), processor.getTargetClass().getLBrace());
        List<Match> duplicates = processor.getDuplicates();
        if (ContainerUtil.isEmpty(duplicates)) {
            ParametrizedDuplicates parametrizedDuplicates = processor.getParametrizedDuplicates();
            if (parametrizedDuplicates != null) {
                duplicates = parametrizedDuplicates.getDuplicates();
                method = parametrizedDuplicates.getParametrizedMethod();
            } else {
                duplicates = Collections.emptyList();
            }
        }
        this.myMethod = method;
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)processor.getProject());
        this.myElementPointers = StreamEx.of((Object[])elements).map(arg_0 -> ((SmartPointerManager)manager).createSmartPsiElementPointer(arg_0)).toList();
        this.myDuplicatesPointers.add(this.createPointerPair((PsiElement)elements[0], (PsiElement)elements[elements.length - 1], manager));
        for (Match duplicate : duplicates) {
            this.myDuplicatesPointers.add(this.createPointerPair(duplicate.getMatchStart(), duplicate.getMatchEnd(), manager));
        }
        this.setPreviewUsages(true);
    }

    Couple<SmartPsiElementPointer<PsiElement>> createPointerPair(@NotNull PsiElement start, @NotNull PsiElement end, @NotNull SmartPointerManager manager) {
        if (start == null) {
            ExtractDuplicatesProcessor.$$$reportNull$$$0(0);
        }
        if (end == null) {
            ExtractDuplicatesProcessor.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            ExtractDuplicatesProcessor.$$$reportNull$$$0(2);
        }
        if (start == end) {
            SmartPsiElementPointer pointer = manager.createSmartPsiElementPointer(start);
            return Couple.of((Object)pointer, (Object)pointer);
        }
        SmartPsiElementPointer startPointer = manager.createSmartPsiElementPointer(start);
        SmartPsiElementPointer endPointer = manager.createSmartPsiElementPointer(end);
        return Couple.of((Object)startPointer, (Object)endPointer);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ExtractDuplicatesProcessor.$$$reportNull$$$0(3);
        }
        UsageViewDescriptorAdapter usageViewDescriptorAdapter = new UsageViewDescriptorAdapter(){

            @NotNull
            public PsiElement[] getElements() {
                PsiElement[] psiElementArray = new PsiElement[]{ExtractDuplicatesProcessor.this.myMethod};
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return RefactoringBundle.message((String)"refactoring.extract.method.preview.tree.method");
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return RefactoringBundle.message((String)"refactoring.extract.method.preview.tree.duplicates", (Object[])new Object[]{usagesCount, filesCount});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/extractMethod/ExtractDuplicatesProcessor$1", "getElements"));
            }
        };
        if (usageViewDescriptorAdapter == null) {
            ExtractDuplicatesProcessor.$$$reportNull$$$0(4);
        }
        return usageViewDescriptorAdapter;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<MyUsageInfo> infos = new ArrayList<MyUsageInfo>();
        for (Couple<SmartPsiElementPointer<PsiElement>> pointers : this.myDuplicatesPointers) {
            PsiElement start = ((SmartPsiElementPointer)pointers.getFirst()).getElement();
            PsiElement end = ((SmartPsiElementPointer)pointers.getSecond()).getElement();
            if (start == null || end == null || !start.isValid() || !end.isValid()) continue;
            infos.add(MyUsageInfo.create(start, end));
        }
        UsageInfo[] usageInfoArray = infos.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            ExtractDuplicatesProcessor.$$$reportNull$$$0(5);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            ExtractDuplicatesProcessor.$$$reportNull$$$0(6);
        }
        if (usages.length == 0) {
            return;
        }
        Object[] elements = (PsiElement[])StreamEx.of(this.myElementPointers).map(SmartPsiElementPointer::getElement).toArray((Object[])PsiElement.EMPTY_ARRAY);
        LOG.assertTrue(!ArrayUtil.contains(null, (Object[])elements));
        JavaDuplicatesExtractMethodProcessor myProcessor = new JavaDuplicatesExtractMethodProcessor((PsiElement[])elements, ExtractMethodHandler.REFACTORING_NAME);
        myProcessor.applyFromSnapshot(this.myExtractMethodSnapshot);
        myProcessor.setShowErrorDialogs(true);
        try {
            if (!myProcessor.prepare(null)) {
                return;
            }
        }
        catch (PrepareFailedException e) {
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, null, (String)e.getMessage(), (String)ExtractMethodHandler.REFACTORING_NAME, (String)"refactoring.extractMethod");
        }
        ExtractMethodHandler.extractMethod(this.myProject, myProcessor);
        myProcessor.initParametrizedDuplicates(false);
        PsiMethodCallExpression call = myProcessor.getMethodCall();
        Editor editor = EditorHelper.openInEditor((PsiElement)call);
        if (editor != null) {
            MyMatchProvider provider = new MyMatchProvider(myProcessor, usages);
            DuplicatesImpl.invoke(this.myProject, provider, false);
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"refactoring.extract.method.preview.command");
        if (string == null) {
            ExtractDuplicatesProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static PsiElement[] getUsageInfoElements(@NotNull UsageInfo usageInfo) {
        PsiElement[] elements;
        if (usageInfo == null) {
            ExtractDuplicatesProcessor.$$$reportNull$$$0(8);
        }
        Segment segment = usageInfo.getSegment();
        PsiFile file = usageInfo.getFile();
        if (segment != null && file != null && (elements = ExtractDuplicatesProcessor.getSegmentElements(segment, file)).length != 0) {
            return elements;
        }
        return null;
    }

    @NotNull
    public static PsiElement[] getSegmentElements(@NotNull Segment textRange, @NotNull PsiFile file) {
        PsiExpression expr;
        if (textRange == null) {
            ExtractDuplicatesProcessor.$$$reportNull$$$0(9);
        }
        if (file == null) {
            ExtractDuplicatesProcessor.$$$reportNull$$$0(10);
        }
        if ((expr = CodeInsightUtil.findExpressionInRange(file, textRange.getStartOffset(), textRange.getEndOffset())) != null) {
            PsiElement[] psiElementArray = new PsiElement[]{expr};
            if (psiElementArray == null) {
                ExtractDuplicatesProcessor.$$$reportNull$$$0(11);
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = CodeInsightUtil.findStatementsInRange(file, textRange.getStartOffset(), textRange.getEndOffset());
        if (psiElementArray == null) {
            ExtractDuplicatesProcessor.$$$reportNull$$$0(12);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/ExtractDuplicatesProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractDuplicatesProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSegmentElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPointerPair";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUsageInfoElements";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSegmentElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyMatchProvider
    implements MatchProvider {
        private final JavaDuplicatesExtractMethodProcessor myProcessor;
        private final UsageInfo[] myUsages;

        public MyMatchProvider(JavaDuplicatesExtractMethodProcessor processor, UsageInfo[] usages) {
            this.myProcessor = processor;
            this.myUsages = usages;
        }

        @Override
        public void prepareSignature(Match match) {
            this.myProcessor.prepareSignature(match);
        }

        @Override
        public PsiElement processMatch(Match match) throws IncorrectOperationException {
            return this.myProcessor.processMatch(match);
        }

        @Override
        public List<Match> getDuplicates() {
            THashSet selected = new THashSet();
            for (UsageInfo usage : this.myUsages) {
                PsiElement[] elements = ExtractDuplicatesProcessor.getUsageInfoElements(usage);
                if (elements == null || elements.length == 0 || elements[0] == null || !elements[0].isValid()) continue;
                selected.add(elements[0]);
            }
            List<Match> duplicates = this.myProcessor.getDuplicates();
            return ContainerUtil.filter(duplicates, arg_0 -> MyMatchProvider.lambda$getDuplicates$0((Set)selected, arg_0));
        }

        @Override
        @Nullable
        public Boolean hasDuplicates() {
            return this.myUsages.length > 1 ? null : Boolean.valueOf(false);
        }

        @Override
        @Nullable
        public String getConfirmDuplicatePrompt(Match match) {
            return null;
        }

        @Override
        public String getReplaceDuplicatesTitle(int idx, int size) {
            return this.myProcessor.getReplaceDuplicatesTitle(idx, size);
        }

        private static /* synthetic */ boolean lambda$getDuplicates$0(Set selected, Match d) {
            return selected.contains(d.getMatchStart());
        }
    }

    private static class MyUsageInfo
    extends UsageInfo {
        private MyUsageInfo(int startOffset, int endOffset, @NotNull PsiElement parent) {
            if (parent == null) {
                MyUsageInfo.$$$reportNull$$$0(0);
            }
            super(parent, startOffset, endOffset);
        }

        private MyUsageInfo(@NotNull PsiElement element) {
            if (element == null) {
                MyUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
        }

        static MyUsageInfo create(@NotNull PsiElement start, @NotNull PsiElement end) {
            if (start == null) {
                MyUsageInfo.$$$reportNull$$$0(2);
            }
            if (end == null) {
                MyUsageInfo.$$$reportNull$$$0(3);
            }
            if (start == end) {
                return new MyUsageInfo(start);
            }
            PsiElement parent = start.getParent();
            int parentOffset = parent.getTextRange().getStartOffset();
            int startOffset = start.getTextRange().getStartOffset() - parentOffset;
            int endOffset = end.getTextRange().getEndOffset() - parentOffset;
            return new MyUsageInfo(startOffset, endOffset, parent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "start";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "end";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractDuplicatesProcessor$MyUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

