/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.openapi.vcs.FileStatus;
import com.intellij.refactoring.extractMethod.preview.FragmentNode;
import com.intellij.refactoring.extractMethod.preview.MethodNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

class PreviewTreeRenderer
extends ColoredTreeCellRenderer {
    PreviewTreeRenderer() {
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object object;
        if (tree == null) {
            PreviewTreeRenderer.$$$reportNull$$$0(0);
        }
        if (value2 instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)value2;
            this.setIcon(methodNode.getIcon());
            this.appendText(methodNode);
        } else if (value2 instanceof FragmentNode) {
            FragmentNode node = (FragmentNode)value2;
            this.appendText(node);
        }
        if (value2 instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)value2).getUserObject()) instanceof String) {
            this.append((String)object, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    private void appendText(@NotNull FragmentNode node) {
        if (node == null) {
            PreviewTreeRenderer.$$$reportNull$$$0(1);
        }
        TextChunk[] text2 = node.getTextChunks();
        for (int i = 0; i < text2.length; ++i) {
            TextChunk textChunk = text2[i];
            SimpleTextAttributes attributes = PreviewTreeRenderer.patchMainTextAttrs(textChunk.getSimpleAttributesIgnoreBackground(), node);
            this.append(textChunk.getText() + (i == 0 ? " " : ""), attributes, true);
        }
    }

    private static SimpleTextAttributes patchMainTextAttrs(@NotNull SimpleTextAttributes attributes, @NotNull FragmentNode node) {
        if (attributes == null) {
            PreviewTreeRenderer.$$$reportNull$$$0(2);
        }
        if (node == null) {
            PreviewTreeRenderer.$$$reportNull$$$0(3);
        }
        if (node.isExcluded()) {
            return attributes.derive(attributes.getStyle() | 4, null, null, null);
        }
        if (!node.isValid()) {
            return attributes.derive(-1, FileStatus.IGNORED.getColor(), null, null);
        }
        return attributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethod/preview/PreviewTreeRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "appendText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "patchMainTextAttrs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

