/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass.usageInfo;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.IncorrectOperationException;

public class CopyDefaultConstructorUsageInfo
extends FixableUsageInfo {
    private final PsiClass myTargetClass;
    private final PsiMethod myConstructor;

    public CopyDefaultConstructorUsageInfo(PsiClass targetClass, PsiMethod constructor) {
        super((PsiElement)targetClass);
        this.myTargetClass = targetClass;
        this.myConstructor = constructor;
    }

    public void fixUsage() throws IncorrectOperationException {
        PsiCodeBlock body2 = this.myConstructor.getBody();
        assert (body2 != null);
        if (body2.getFirstBodyElement() != null) {
            PsiElement constructorCopy = this.myConstructor.copy();
            PsiClass srcClass = this.myConstructor.getContainingClass();
            assert (srcClass != null);
            InlineUtil.substituteTypeParams(constructorCopy, TypeConversionUtil.getSuperClassSubstitutor((PsiClass)srcClass, (PsiClass)this.myTargetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY), JavaPsiFacade.getElementFactory((Project)this.getProject()));
            this.myTargetClass.add(constructorCopy);
        }
    }
}

