/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SimplifiableConditionalExpressionInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("simplifiable.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            SimplifiableConditionalExpressionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiConditionalExpression expression2 = (PsiConditionalExpression)infos[0];
        String string = InspectionGadgetsBundle.message("simplifiable.conditional.expression.problem.descriptor", SimplifiableConditionalExpressionInspection.calculateReplacementExpression(expression2, new CommentTracker()));
        if (string == null) {
            SimplifiableConditionalExpressionInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifiableConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableConditionalExpressionVisitor();
    }

    @NonNls
    static String calculateReplacementExpression(PsiConditionalExpression expression2, CommentTracker tracker) {
        PsiExpression thenExpression2 = expression2.getThenExpression();
        PsiExpression elseExpression2 = expression2.getElseExpression();
        PsiExpression condition2 = expression2.getCondition();
        assert (thenExpression2 != null);
        assert (elseExpression2 != null);
        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(BoolUtils.getNegated(thenExpression2), elseExpression2)) {
            return ParenthesesUtils.getText(tracker.markUnchanged(condition2), 9) + " != " + BoolUtils.getNegatedExpressionText(thenExpression2, 9, tracker);
        }
        if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression2, BoolUtils.getNegated(elseExpression2))) {
            return ParenthesesUtils.getText(tracker.markUnchanged(condition2), 9) + " == " + ParenthesesUtils.getText(tracker.markUnchanged(thenExpression2), 9);
        }
        if (BoolUtils.isTrue(thenExpression2)) {
            String elseExpressionText = ParenthesesUtils.getText(tracker.markUnchanged(elseExpression2), 14);
            return ParenthesesUtils.getText(condition2, 14) + " || " + elseExpressionText;
        }
        if (BoolUtils.isFalse(thenExpression2)) {
            String elseExpressionText = ParenthesesUtils.getText(tracker.markUnchanged(elseExpression2), 13);
            return BoolUtils.getNegatedExpressionText(condition2, 13, tracker) + " && " + elseExpressionText;
        }
        if (BoolUtils.isFalse(elseExpression2)) {
            String thenExpressionText = ParenthesesUtils.getText(tracker.markUnchanged(thenExpression2), 13);
            return ParenthesesUtils.getText(condition2, 13) + " && " + thenExpressionText;
        }
        String thenExpressionText = ParenthesesUtils.getText(tracker.markUnchanged(thenExpression2), 14);
        return BoolUtils.getNegatedExpressionText(condition2, 14, tracker) + " || " + thenExpressionText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class SimplifiableConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            boolean elseConstant;
            super.visitConditionalExpression(expression2);
            PsiExpression thenExpression2 = expression2.getThenExpression();
            if (thenExpression2 == null) {
                return;
            }
            PsiExpression elseExpression2 = expression2.getElseExpression();
            if (elseExpression2 == null) {
                return;
            }
            PsiType thenType = thenExpression2.getType();
            if (!PsiType.BOOLEAN.equals((Object)thenType)) {
                return;
            }
            PsiType elseType = elseExpression2.getType();
            if (!PsiType.BOOLEAN.equals((Object)elseType)) {
                return;
            }
            boolean thenConstant = BoolUtils.isFalse(thenExpression2) || BoolUtils.isTrue(thenExpression2);
            boolean bl = elseConstant = BoolUtils.isFalse(elseExpression2) || BoolUtils.isTrue(elseExpression2);
            if (thenConstant == elseConstant) {
                if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(BoolUtils.getNegated(thenExpression2), elseExpression2) || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(thenExpression2, BoolUtils.getNegated(elseExpression2))) {
                    this.registerError((PsiElement)expression2, expression2);
                }
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }
    }

    private static class SimplifiableConditionalFix
    extends InspectionGadgetsFix {
        private SimplifiableConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                SimplifiableConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiConditionalExpression expression2 = (PsiConditionalExpression)descriptor.getPsiElement();
            CommentTracker tracker = new CommentTracker();
            String newExpression = SimplifiableConditionalExpressionInspection.calculateReplacementExpression(expression2, tracker);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression, tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SimplifiableConditionalExpressionInspection$SimplifiableConditionalFix", "getFamilyName"));
        }
    }
}

