/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.threading.NestedSynchronizedStatementInspection;
import org.jetbrains.annotations.NotNull;

public class NestedTryStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("nested.try.statement.display.name", new Object[0]);
        if (string == null) {
            NestedTryStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("nested.try.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            NestedTryStatementInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedTryStatementVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/NestedTryStatementInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NestedTryStatementVisitor
    extends BaseInspectionVisitor {
        private NestedTryStatementVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            if (statement == null) {
                NestedTryStatementVisitor.$$$reportNull$$$0(0);
            }
            super.visitTryStatement(statement);
            PsiTryStatement parentTry = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiTryStatement.class);
            if (parentTry == null) {
                return;
            }
            PsiCodeBlock tryBlock = parentTry.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)statement, (boolean)true)) {
                return;
            }
            if (NestedSynchronizedStatementInspection.isNestedStatement(statement, PsiTryStatement.class)) {
                this.registerStatementError((PsiStatement)statement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/NestedTryStatementInspection$NestedTryStatementVisitor", "visitTryStatement"));
        }
    }
}

