/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PropertyUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

class PublicMethodWithoutLoggingInspectionBase
extends BaseInspection {
    final List<String> loggerClassNames = new ArrayList<String>();
    public String loggerClassName = "java.util.logging.Logger,org.slf4j.Logger,org.apache.commons.logging.Log,org.apache.log4j.Logger";

    PublicMethodWithoutLoggingInspectionBase() {
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("public.method.without.logging.display.name", new Object[0]);
        if (string == null) {
            PublicMethodWithoutLoggingInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("public.method.without.logging.problem.descriptor", new Object[0]);
        if (string == null) {
            PublicMethodWithoutLoggingInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            PublicMethodWithoutLoggingInspectionBase.$$$reportNull$$$0(2);
        }
        super.readSettings(element);
        PublicMethodWithoutLoggingInspectionBase.parseString(this.loggerClassName, this.loggerClassNames);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            PublicMethodWithoutLoggingInspectionBase.$$$reportNull$$$0(3);
        }
        this.loggerClassName = PublicMethodWithoutLoggingInspectionBase.formatString(this.loggerClassNames);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicMethodWithoutLoggingVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/logging/PublicMethodWithoutLoggingInspectionBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/logging/PublicMethodWithoutLoggingInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ContainsLoggingCallVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsLoggingCall;

        private ContainsLoggingCallVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                ContainsLoggingCallVisitor.$$$reportNull$$$0(0);
            }
            if (this.containsLoggingCall) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                ContainsLoggingCallVisitor.$$$reportNull$$$0(1);
            }
            if (this.containsLoggingCall) {
                return;
            }
            super.visitMethodCallExpression(expression2);
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getQualifiedName();
            if (containingClassName == null) {
                return;
            }
            if (PublicMethodWithoutLoggingInspectionBase.this.loggerClassNames.contains(containingClassName)) {
                this.containsLoggingCall = true;
            }
        }

        private boolean containsLoggingCall() {
            return this.containsLoggingCall;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/logging/PublicMethodWithoutLoggingInspectionBase$ContainsLoggingCallVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class PublicMethodWithoutLoggingVisitor
    extends BaseInspectionVisitor {
        private PublicMethodWithoutLoggingVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                PublicMethodWithoutLoggingVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            PsiCodeBlock body2 = method.getBody();
            if (body2 == null) {
                return;
            }
            if (method.isConstructor()) {
                return;
            }
            if (PropertyUtil.isSimpleGetter(method) || PropertyUtil.isSimpleSetter(method)) {
                return;
            }
            if (this.containsLoggingCall(body2)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean containsLoggingCall(PsiCodeBlock block) {
            ContainsLoggingCallVisitor visitor = new ContainsLoggingCallVisitor();
            block.accept((PsiElementVisitor)visitor);
            return visitor.containsLoggingCall();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/logging/PublicMethodWithoutLoggingInspectionBase$PublicMethodWithoutLoggingVisitor", "visitMethod"));
        }
    }
}

