/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class LiteralAsArgToStringEqualsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("literal.as.arg.to.string.equals.display.name", new Object[0]);
        if (string == null) {
            LiteralAsArgToStringEqualsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String methodName = (String)infos[0];
        String string = InspectionGadgetsBundle.message("literal.as.arg.to.string.equals.problem.descriptor", methodName);
        if (string == null) {
            LiteralAsArgToStringEqualsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LiteralAsArgToEqualsVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SwapEqualsFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/LiteralAsArgToStringEqualsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class LiteralAsArgToEqualsVisitor
    extends BaseInspectionVisitor {
        private LiteralAsArgToEqualsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                LiteralAsArgToEqualsVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName) && !"equalsIgnoreCase".equals(methodName)) {
                return;
            }
            PsiExpressionList argList = expression2.getArgumentList();
            PsiExpression[] args = argList.getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiExpression argument = args[0];
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return;
            }
            if (!(argument instanceof PsiLiteralExpression)) {
                return;
            }
            if (!TypeUtils.isJavaLangString(argumentType)) {
                return;
            }
            PsiExpression target = methodExpression.getQualifierExpression();
            if (target instanceof PsiLiteralExpression) {
                return;
            }
            this.registerError((PsiElement)argument, methodName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/LiteralAsArgToStringEqualsInspection$LiteralAsArgToEqualsVisitor", "visitMethodCallExpression"));
        }
    }

    private static class SwapEqualsFix
    extends InspectionGadgetsFix {
        private SwapEqualsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("literal.as.arg.to.string.equals.flip.quickfix", new Object[0]);
            if (string == null) {
                SwapEqualsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression argument = (PsiExpression)descriptor.getPsiElement();
            PsiElement argumentList = argument.getParent();
            PsiMethodCallExpression expression2 = (PsiMethodCallExpression)argumentList.getParent();
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression target = methodExpression.getQualifierExpression();
            String methodName = methodExpression.getReferenceName();
            PsiExpression strippedTarget = ParenthesesUtils.stripParentheses(target);
            if (strippedTarget == null) {
                return;
            }
            PsiExpression strippedArg = ParenthesesUtils.stripParentheses(argument);
            if (strippedArg == null) {
                return;
            }
            String callString = ParenthesesUtils.getPrecedence(strippedArg) > 1 ? '(' + strippedArg.getText() + ")." + methodName + '(' + strippedTarget.getText() + ')' : strippedArg.getText() + '.' + methodName + '(' + strippedTarget.getText() + ')';
            CommentTracker tracker = new CommentTracker();
            tracker.markUnchanged(strippedArg);
            tracker.markUnchanged(strippedTarget);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, callString, tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LiteralAsArgToStringEqualsInspection$SwapEqualsFix", "getFamilyName"));
        }
    }
}

