/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.unicode;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementEditorPredicate;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceOctalEscapeWithUnicodeEscapeIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            ReplaceOctalEscapeWithUnicodeEscapeIntention.$$$reportNull$$$0(0);
        }
    }

    @Override
    protected void processIntention(Editor editor, @NotNull PsiElement element) {
        SelectionModel selectionModel;
        if (element == null) {
            ReplaceOctalEscapeWithUnicodeEscapeIntention.$$$reportNull$$$0(1);
        }
        if ((selectionModel = editor.getSelectionModel()).hasSelection()) {
            int index;
            Document document = editor.getDocument();
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            String text2 = document.getText(new TextRange(start, end));
            int textLength = end - start;
            StringBuilder replacement = new StringBuilder(textLength);
            int anchor = 0;
            while ((index = ReplaceOctalEscapeWithUnicodeEscapeIntention.indexOfOctalEscape(text2, anchor + 1)) >= 0) {
                replacement.append(text2.substring(anchor, index));
                anchor = ReplaceOctalEscapeWithUnicodeEscapeIntention.appendUnicodeEscape(text2, index, replacement);
            }
            replacement.append(text2.substring(anchor, textLength));
            document.replaceString(start, end, (CharSequence)replacement);
        } else if (element instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            String text3 = literalExpression.getText();
            CaretModel model = editor.getCaretModel();
            int offset = model.getOffset() - literalExpression.getTextOffset();
            StringBuilder newLiteralText = new StringBuilder();
            int index1 = ReplaceOctalEscapeWithUnicodeEscapeIntention.indexOfOctalEscape(text3, offset);
            int index2 = ReplaceOctalEscapeWithUnicodeEscapeIntention.indexOfOctalEscape(text3, offset + 1);
            int escapeStart = index2 == offset ? index2 : index1;
            newLiteralText.append(text3.substring(0, escapeStart));
            int escapeEnd = ReplaceOctalEscapeWithUnicodeEscapeIntention.appendUnicodeEscape(text3, escapeStart, newLiteralText);
            newLiteralText.append(text3.substring(escapeEnd, text3.length()));
            PsiReplacementUtil.replaceExpression((PsiExpression)literalExpression, newLiteralText.toString());
        }
    }

    private static int appendUnicodeEscape(String text2, int escapeStart, @NonNls StringBuilder out) {
        int textLength = text2.length();
        int length = 1;
        boolean zeroToThree = false;
        while (escapeStart + length < textLength) {
            char c = text2.charAt(escapeStart + length);
            if (length == 1 && (c == '0' || c == '1' || c == '2' || c == '3')) {
                zeroToThree = true;
            }
            if (c < '0' || c > '7' || length > 3 || length > 2 && !zeroToThree) {
                int ch = Integer.parseInt(text2.substring(escapeStart + 1, escapeStart + length), 8);
                out.append("\\u").append(String.format("%04x", ch));
                break;
            }
            ++length;
        }
        return escapeStart + length;
    }

    private static int indexOfOctalEscape(String text2, int offset) {
        int textLength = text2.length();
        int escapeStart = -1;
        block0: while ((escapeStart = text2.indexOf(92, escapeStart + 1)) >= 0) {
            if (escapeStart < offset - 4 || escapeStart < textLength - 1 && text2.charAt(escapeStart + 1) == '\\') continue;
            boolean isEscape = true;
            for (int previousChar = escapeStart - 1; previousChar >= 0 && text2.charAt(previousChar) == '\\'; --previousChar) {
                isEscape = !isEscape;
            }
            if (!isEscape) continue;
            int length = 1;
            boolean zeroToThree = false;
            while (escapeStart + length < textLength) {
                char c = text2.charAt(escapeStart + length);
                if (length == 1 && (c == '0' || c == '1' || c == '2' || c == '3')) {
                    zeroToThree = true;
                }
                if (c < '0' || c > '7' || length > 3 || length > 2 && !zeroToThree) {
                    if (offset > escapeStart + length || length <= 1) continue block0;
                    return escapeStart;
                }
                ++length;
            }
            return escapeStart;
        }
        return -1;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        OctalEscapePredicate octalEscapePredicate = new OctalEscapePredicate();
        if (octalEscapePredicate == null) {
            ReplaceOctalEscapeWithUnicodeEscapeIntention.$$$reportNull$$$0(2);
        }
        return octalEscapePredicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/unicode/ReplaceOctalEscapeWithUnicodeEscapeIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/unicode/ReplaceOctalEscapeWithUnicodeEscapeIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OctalEscapePredicate
    extends PsiElementEditorPredicate {
        private OctalEscapePredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element, @Nullable Editor editor) {
            if (editor == null) {
                return false;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasSelection()) {
                int start = selectionModel.getSelectionStart();
                int end = selectionModel.getSelectionEnd();
                if (start < 0 || end < 0 || start > end) {
                    return false;
                }
                String text2 = editor.getDocument().getCharsSequence().subSequence(start, end).toString();
                return ReplaceOctalEscapeWithUnicodeEscapeIntention.indexOfOctalEscape(text2, 1) >= 0;
            }
            if (element instanceof PsiLiteralExpression) {
                CaretModel model;
                int offset;
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
                String text3 = literalExpression.getText();
                int index = ReplaceOctalEscapeWithUnicodeEscapeIntention.indexOfOctalEscape(text3, offset = (model = editor.getCaretModel()).getOffset() - literalExpression.getTextOffset());
                return index >= 0 && offset >= index;
            }
            return false;
        }
    }
}

