/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.JavaCoverageOptionsProvider;
import com.intellij.coverage.PackageAnnotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.rt.coverage.instrumentation.SourceLineCounter;
import gnu.trove.TIntObjectHashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class SourceLineCounterUtil {
    public static boolean collectNonCoveredClassInfo(PackageAnnotator.ClassCoverageInfo classCoverageInfo, PackageAnnotator.PackageCoverageInfo packageCoverageInfo, byte[] content, boolean excludeLines, Condition<String> includeDescriptionCondition) {
        if (content == null) {
            return false;
        }
        ClassReader reader = new ClassReader(content, 0, content.length);
        SourceLineCounter counter = new SourceLineCounter(null, excludeLines, null);
        reader.accept((ClassVisitor)counter, 0);
        HashSet descriptions = new HashSet();
        TIntObjectHashMap lines = counter.getSourceLines();
        lines.forEachEntry((line, description) -> {
            if (includeDescriptionCondition.value((Object)((String)description))) {
                ++classCoverageInfo.totalLineCount;
                ++packageCoverageInfo.totalLineCount;
                descriptions.add(description);
            }
            return true;
        });
        classCoverageInfo.totalMethodCount += descriptions.size();
        packageCoverageInfo.totalMethodCount += descriptions.size();
        if (!counter.isInterface()) {
            ++packageCoverageInfo.totalClassCount;
        }
        return !counter.isInterface();
    }

    public static void collectSrcLinesForUntouchedFiles(List<Integer> uncoveredLines, byte[] content, boolean excludeLines, Project project) {
        ClassReader reader = new ClassReader(content);
        SourceLineCounter collector = new SourceLineCounter(null, excludeLines, null);
        reader.accept((ClassVisitor)collector, 0);
        String qualifiedName = reader.getClassName();
        Condition includeDescriptionCondition = description -> !JavaCoverageOptionsProvider.getInstance(project).isGeneratedConstructor(qualifiedName, (String)description);
        TIntObjectHashMap lines = collector.getSourceLines();
        lines.forEachEntry((line, description) -> {
            if (includeDescriptionCondition.value((Object)((String)description))) {
                uncoveredLines.add(--line);
            }
            return true;
        });
    }
}

