/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.FilePosition;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class FileNavigatable
implements Navigatable {
    private final Project myProject;
    private final NullableLazyValue<OpenFileDescriptor> myValue;
    private final FilePosition myFilePosition;

    public FileNavigatable(Project project2, FilePosition filePosition) {
        this.myProject = project2;
        this.myFilePosition = filePosition;
        this.myValue = new NullableLazyValue<OpenFileDescriptor>(){

            @Nullable
            protected OpenFileDescriptor compute() {
                return FileNavigatable.this.getDescriptor();
            }
        };
    }

    public void navigate(boolean requestFocus) {
        OpenFileDescriptor descriptor2 = (OpenFileDescriptor)this.myValue.getValue();
        if (descriptor2 != null) {
            descriptor2.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        OpenFileDescriptor descriptor2 = (OpenFileDescriptor)this.myValue.getValue();
        if (descriptor2 != null) {
            return descriptor2.canNavigate();
        }
        return false;
    }

    public boolean canNavigateToSource() {
        OpenFileDescriptor descriptor2 = (OpenFileDescriptor)this.myValue.getValue();
        if (descriptor2 != null) {
            return descriptor2.canNavigateToSource();
        }
        return false;
    }

    @Nullable
    private OpenFileDescriptor getDescriptor() {
        OpenFileDescriptor descriptor2 = null;
        VirtualFile file = VfsUtil.findFileByIoFile((File)this.myFilePosition.getFile(), (boolean)false);
        if (file != null) {
            descriptor2 = new OpenFileDescriptor(this.myProject, file, this.myFilePosition.getStartLine(), this.myFilePosition.getStartColumn());
        }
        return descriptor2;
    }
}

