/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.LanguageLightRefAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import java.util.Collection;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;

enum CompilerHierarchySearchType {
    DIRECT_INHERITOR{

        @Override
        PsiElement[] performSearchInFile(SearchId[] definitions, PsiNamedElement baseElement, PsiFileWithStubSupport file, LanguageLightRefAdapter adapter) {
            return adapter.findDirectInheritorCandidatesInFile(definitions, file);
        }

        @Override
        Class<? extends LightRef> getRequiredClass(LanguageLightRefAdapter adapter) {
            return adapter.getHierarchyObjectClass();
        }

        @Override
        SearchId[] convertToIds(Collection<LightRef> lightRef, NameEnumerator nameEnumerator) {
            return (SearchId[])lightRef.stream().map(r -> r instanceof LightRef.JavaLightAnonymousClassRef ? new SearchId(((LightRef.JavaLightAnonymousClassRef)r).getName()) : new SearchId(nameEnumerator.getName(((LightRef.LightClassHierarchyElementDef)r).getName()))).toArray(SearchId[]::new);
        }
    }
    ,
    FUNCTIONAL_EXPRESSION{

        @Override
        PsiElement[] performSearchInFile(SearchId[] definitions, PsiNamedElement baseElement, PsiFileWithStubSupport file, LanguageLightRefAdapter adapter) {
            return adapter.findFunExpressionsInFile(definitions, file);
        }

        @Override
        Class<? extends LightRef> getRequiredClass(LanguageLightRefAdapter adapter) {
            return adapter.getFunExprClass();
        }

        @Override
        SearchId[] convertToIds(Collection<LightRef> lightRef, NameEnumerator nameEnumerator) {
            return (SearchId[])lightRef.stream().map(r -> ((LightRef.LightFunExprDef)r).getId()).map(SearchId::new).toArray(SearchId[]::new);
        }
    };


    abstract PsiElement[] performSearchInFile(SearchId[] var1, PsiNamedElement var2, PsiFileWithStubSupport var3, LanguageLightRefAdapter var4);

    abstract Class<? extends LightRef> getRequiredClass(LanguageLightRefAdapter var1);

    abstract SearchId[] convertToIds(Collection<LightRef> var1, NameEnumerator var2);
}

