/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaCompletionSorting;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.backwardRefs.ReferenceIndexUnavailableException;
import com.intellij.compiler.chainsSearch.ChainSearcher;
import com.intellij.compiler.chainsSearch.MethodChainLookupRangingHelper;
import com.intellij.compiler.chainsSearch.OperationChain;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.chainsSearch.context.ChainSearchTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodChainCompletionContributor
extends CompletionContributor {
    public static final String REGISTRY_KEY = "compiler.ref.chain.search";
    private static final Logger LOG = Logger.getInstance(MethodChainCompletionContributor.class);
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();

    public MethodChainCompletionContributor() {
        ElementPattern pattern = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{MethodChainCompletionContributor.patternForMethodCallArgument(), MethodChainCompletionContributor.patternForVariableAssignment(), MethodChainCompletionContributor.patternForReturnExpression()});
        this.extend(CompletionType.SMART, pattern, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(1);
                }
                try {
                    if (!Registry.is((String)MethodChainCompletionContributor.REGISTRY_KEY)) {
                        return;
                    }
                    THashSet alreadySuggested = new THashSet();
                    CompletionResultSet finalResult = result;
                    result.runRemainingContributors(parameters, arg_0 -> 1.lambda$addCompletions$0((Set)alreadySuggested, finalResult, arg_0));
                    ChainCompletionContext completionContext = MethodChainCompletionContributor.extractContext(parameters);
                    if (completionContext == null) {
                        return;
                    }
                    result = JavaCompletionSorting.addJavaSorting((CompletionParameters)parameters, (CompletionResultSet)result);
                    List elementsFoundByMethodsChainsSearch = MethodChainCompletionContributor.searchForLookups(completionContext);
                    if (!UNIT_TEST_MODE && !alreadySuggested.isEmpty()) {
                        elementsFoundByMethodsChainsSearch = elementsFoundByMethodsChainsSearch.stream().filter(arg_0 -> 1.lambda$addCompletions$1((Set)alreadySuggested, arg_0)).collect(Collectors.toList());
                    }
                    result.addAllElements((Iterable)elementsFoundByMethodsChainsSearch);
                }
                catch (ReferenceIndexUnavailableException referenceIndexUnavailableException) {
                    // empty catch block
                }
            }

            private static /* synthetic */ boolean lambda$addCompletions$1(Set alreadySuggested, LookupElement lookupElement) {
                PsiElement psi = lookupElement.getPsiElement();
                return !(psi instanceof PsiMethod) || !alreadySuggested.contains(psi);
            }

            private static /* synthetic */ void lambda$addCompletions$0(Set alreadySuggested, CompletionResultSet finalResult, CompletionResult completionResult) {
                LookupElement lookupElement = completionResult.getLookupElement();
                PsiElement psi = lookupElement.getPsiElement();
                if (psi instanceof PsiMethod) {
                    alreadySuggested.add((PsiMethod)psi);
                }
                finalResult.passResult(completionResult);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/compiler/chainsSearch/completion/MethodChainCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static List<LookupElement> searchForLookups(ChainCompletionContext context) {
        CompilerReferenceService compilerReferenceService = CompilerReferenceService.getInstance((Project)context.getProject());
        if (compilerReferenceService == null) {
            return Collections.emptyList();
        }
        CompilerReferenceServiceEx compilerReferenceServiceEx = (CompilerReferenceServiceEx)compilerReferenceService;
        ChainSearchTarget target = context.getTarget();
        List<OperationChain> searchResult = ChainSearcher.search(4, target, 5, context, compilerReferenceServiceEx);
        int maxWeight = searchResult.stream().mapToInt(OperationChain::getChainWeight).max().orElse(0);
        return searchResult.stream().filter(ch -> ch.getChainWeight() * 10 >= maxWeight).map(ch -> MethodChainLookupRangingHelper.toLookupElement(ch, context)).collect(Collectors.toList());
    }

    @Nullable
    private static ChainCompletionContext extractContext(CompletionParameters parameters) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), (Class[])new Class[]{PsiAssignmentExpression.class, PsiLocalVariable.class, PsiMethodCallExpression.class, PsiReturnStatement.class});
        LOG.assertTrue(parent != null, (Object)"A completion position should match to a pattern");
        if (parent instanceof PsiReturnStatement) {
            return MethodChainCompletionContributor.extractContextFromReturn((PsiReturnStatement)parent, parameters);
        }
        if (parent instanceof PsiAssignmentExpression) {
            return MethodChainCompletionContributor.extractContextFromAssignment((PsiAssignmentExpression)parent, parameters);
        }
        if (parent instanceof PsiLocalVariable) {
            return MethodChainCompletionContributor.extractContextFromVariable((PsiLocalVariable)parent, parameters);
        }
        return MethodChainCompletionContributor.extractContextFromMethodCall((PsiMethodCallExpression)parent, parameters);
    }

    @Nullable
    private static ChainCompletionContext extractContextFromMethodCall(PsiMethodCallExpression parent, CompletionParameters parameters) {
        PsiParameter[] methodParameters;
        PsiMethod method = parent.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PsiExpression.class);
        PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PsiExpressionList.class);
        if (expressionList == null) {
            return null;
        }
        int exprPosition = Arrays.asList(expressionList.getExpressions()).indexOf(expression);
        if (exprPosition < (methodParameters = method.getParameterList().getParameters()).length) {
            PsiParameter methodParameter = methodParameters[exprPosition];
            return ChainCompletionContext.createContext(methodParameter.getType(), PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethodCallExpression.class), MethodChainCompletionContributor.suggestIterators(parameters));
        }
        return null;
    }

    @Nullable
    private static ChainCompletionContext extractContextFromReturn(PsiReturnStatement returnStatement, CompletionParameters parameters) {
        PsiType type = PsiTypesUtil.getMethodReturnType((PsiElement)returnStatement);
        if (type == null) {
            return null;
        }
        return ChainCompletionContext.createContext(type, (PsiElement)returnStatement, MethodChainCompletionContributor.suggestIterators(parameters));
    }

    @Nullable
    private static ChainCompletionContext extractContextFromVariable(PsiLocalVariable localVariable, CompletionParameters parameters) {
        PsiDeclarationStatement declaration = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)localVariable, PsiDeclarationStatement.class);
        return ChainCompletionContext.createContext(localVariable.getType(), (PsiElement)declaration, MethodChainCompletionContributor.suggestIterators(parameters));
    }

    @Nullable
    private static ChainCompletionContext extractContextFromAssignment(PsiAssignmentExpression assignmentExpression, CompletionParameters parameters) {
        PsiExpression lExpr = assignmentExpression.getLExpression();
        if (!(lExpr instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement resolved = ((PsiReferenceExpression)lExpr).resolve();
        return resolved instanceof PsiVariable ? ChainCompletionContext.createContext(((PsiVariable)resolved).getType(), (PsiElement)assignmentExpression, MethodChainCompletionContributor.suggestIterators(parameters)) : null;
    }

    @NotNull
    private static ElementPattern<PsiElement> patternForVariableAssignment() {
        ElementPattern patternForParent = PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("IntellijIdeaRulezzz")).afterSiblingSkipping((ElementPattern)PsiJavaPatterns.psiElement(PsiWhiteSpace.class), (ElementPattern)PsiJavaPatterns.psiElement(PsiJavaToken.class).withText("="))});
        TreeElementPattern treeElementPattern = ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent(patternForParent)).withSuperParent(2, PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiAssignmentExpression.class), PsiJavaPatterns.psiElement(PsiLocalVariable.class).inside(PsiDeclarationStatement.class)}))).inside(PsiMethod.class);
        if (treeElementPattern == null) {
            MethodChainCompletionContributor.$$$reportNull$$$0(0);
        }
        return treeElementPattern;
    }

    @NotNull
    private static ElementPattern<PsiElement> patternForMethodCallArgument() {
        TreeElementPattern treeElementPattern = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withSuperParent(3, PsiMethodCallExpression.class)).withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().with((PatternCondition)new PatternCondition<PsiReferenceExpression>("QualifierIsNull"){

            public boolean accepts(@NotNull PsiReferenceExpression referenceExpression, ProcessingContext context) {
                if (referenceExpression == null) {
                    2.$$$reportNull$$$0(0);
                }
                return referenceExpression.getQualifierExpression() == null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/compiler/chainsSearch/completion/MethodChainCompletionContributor$2", "accepts"));
            }
        }));
        if (treeElementPattern == null) {
            MethodChainCompletionContributor.$$$reportNull$$$0(1);
        }
        return treeElementPattern;
    }

    private static ElementPattern<PsiElement> patternForReturnExpression() {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceExpression.class).withText("IntellijIdeaRulezzz"))).withSuperParent(2, PsiReturnStatement.class);
    }

    private static boolean suggestIterators(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            MethodChainCompletionContributor.$$$reportNull$$$0(2);
        }
        return parameters.getInvocationCount() > 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/chainsSearch/completion/MethodChainCompletionContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "patternForVariableAssignment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "patternForMethodCallArgument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/chainsSearch/completion/MethodChainCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suggestIterators";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

