/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.inspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ChangeSuperClassFix
implements LocalQuickFix,
HighPriorityAction {
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myNewSuperClass;
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myOldSuperClass;
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myTargetClass;
    private final int myInheritorCount;
    @NotNull
    private final String myNewSuperName;
    private final boolean myImplements;

    public ChangeSuperClassFix(@NotNull PsiClass targetClass, @NotNull PsiClass newSuperClass, @NotNull PsiClass oldSuperClass, int percent, boolean isImplements) {
        if (targetClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(0);
        }
        if (newSuperClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(1);
        }
        if (oldSuperClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(2);
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)newSuperClass.getProject());
        this.myNewSuperName = (String)ObjectUtils.notNull((Object)newSuperClass.getQualifiedName());
        this.myTargetClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)targetClass);
        this.myNewSuperClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)newSuperClass);
        this.myOldSuperClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)oldSuperClass);
        this.myInheritorCount = percent;
        this.myImplements = isImplements;
    }

    @NotNull
    public PsiClass getNewSuperClass() {
        PsiClass psiClass = (PsiClass)ObjectUtils.notNull((Object)this.myNewSuperClass.getElement());
        if (psiClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(3);
        }
        return psiClass;
    }

    public int getInheritorCount() {
        return this.myInheritorCount;
    }

    @NotNull
    public String getName() {
        String string = String.format("Make " + (this.myImplements ? "implements" : "extends") + " '%s'", this.myNewSuperName);
        if (string == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroupNames.INHERITANCE_GROUP_NAME;
        if (string == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor problemDescriptor) {
        if (project2 == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(6);
        }
        if (problemDescriptor == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(7);
        }
        PsiClass oldSuperClass = (PsiClass)this.myOldSuperClass.getElement();
        PsiClass newSuperClass = (PsiClass)this.myNewSuperClass.getElement();
        if (oldSuperClass == null || newSuperClass == null) {
            return;
        }
        PsiElement element = this.myTargetClass.getElement();
        if (element == null || !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            return;
        }
        PsiClass aClass = (PsiClass)element;
        ChangeSuperClassFix.changeSuperClass(aClass, oldSuperClass, newSuperClass);
    }

    private static void changeSuperClass(@NotNull PsiClass aClass, @NotNull PsiClass oldSuperClass, @NotNull PsiClass newSuperClass) {
        if (aClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(8);
        }
        if (oldSuperClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(9);
        }
        if (newSuperClass == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(10);
        }
        PsiMethod[] ownMethods = aClass.getMethods();
        List oldOverridenMethods = Stream.of(ownMethods).map(m -> {
            if (oldSuperClass == null) {
                ChangeSuperClassFix.$$$reportNull$$$0(18);
            }
            if (m.isConstructor()) {
                return null;
            }
            Object[] supers = m.findSuperMethods(oldSuperClass);
            if (supers.length == 0) {
                return null;
            }
            return Pair.create((Object)m, (Object)ContainerUtil.set((Object[])supers));
        }).filter(Objects::nonNull).collect(Collectors.toList());
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)aClass.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        WriteAction.run(() -> {
            PsiElement ref;
            if (aClass == null) {
                ChangeSuperClassFix.$$$reportNull$$$0(15);
            }
            if (newSuperClass == null) {
                ChangeSuperClassFix.$$$reportNull$$$0(16);
            }
            if (oldSuperClass == null) {
                ChangeSuperClassFix.$$$reportNull$$$0(17);
            }
            if (aClass instanceof PsiAnonymousClass) {
                ref = ((PsiAnonymousClass)aClass).getBaseClassReference().replace((PsiElement)factory.createClassReferenceElement(newSuperClass));
            } else {
                PsiReferenceList list;
                PsiJavaCodeReferenceElement[] refElements;
                PsiReferenceList extendsList = (PsiReferenceList)ObjectUtils.notNull((Object)aClass.getExtendsList());
                for (PsiJavaCodeReferenceElement refElement : refElements = (PsiJavaCodeReferenceElement[])ArrayUtil.mergeArrays((Object[])ChangeSuperClassFix.getReferences(extendsList), (Object[])ChangeSuperClassFix.getReferences(aClass.getImplementsList()))) {
                    if (!refElement.isReferenceTo((PsiElement)oldSuperClass)) continue;
                    refElement.delete();
                }
                if (newSuperClass.isInterface() && !aClass.isInterface()) {
                    list = aClass.getImplementsList();
                } else {
                    list = extendsList;
                    PsiJavaCodeReferenceElement[] elements = list.getReferenceElements();
                    if (elements.length == 1 && elements[0].isReferenceTo((PsiElement)psiFacade.findClass("java.lang.Object", aClass.getResolveScope()))) {
                        elements[0].delete();
                    }
                }
                assert (list != null);
                ref = list.add((PsiElement)factory.createClassReferenceElement(newSuperClass));
            }
            JavaCodeStyleManager.getInstance((Project)aClass.getProject()).shortenClassReferences(ref);
        });
        List<MemberInfo> memberInfos = oldOverridenMethods.stream().filter(m -> {
            Set newSupers;
            if (newSuperClass == null) {
                ChangeSuperClassFix.$$$reportNull$$$0(14);
            }
            return !(newSupers = ContainerUtil.set((Object[])((PsiMethod)m.getFirst()).findSuperMethods(newSuperClass))).equals(m.getSecond());
        }).map(m -> (PsiMethod)m.getFirst()).map(m -> {
            MemberInfo info = new MemberInfo((PsiMember)m);
            info.setChecked(true);
            return info;
        }).collect(Collectors.toList());
        if (memberInfos.isEmpty()) {
            return;
        }
        List<PsiMethod> toDelete = ChangeSuperClassFix.getOverridenMethodsToDelete(memberInfos, newSuperClass.getName(), aClass.getProject());
        if (!toDelete.isEmpty()) {
            WriteAction.run(() -> {
                for (PsiMethod method : toDelete) {
                    method.delete();
                }
            });
        }
    }

    @NotNull
    private static PsiJavaCodeReferenceElement[] getReferences(PsiReferenceList list) {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = list == null ? PsiJavaCodeReferenceElement.EMPTY_ARRAY : list.getReferenceElements();
        if (psiJavaCodeReferenceElementArray == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(11);
        }
        return psiJavaCodeReferenceElementArray;
    }

    @NotNull
    private static List<PsiMethod> getOverridenMethodsToDelete(List<MemberInfo> candidates, String newClassName, Project project2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List<PsiMethod> list = candidates.stream().map(c -> (PsiMethod)c.getMember()).collect(Collectors.toList());
            if (list == null) {
                ChangeSuperClassFix.$$$reportNull$$$0(12);
            }
            return list;
        }
        final MemberSelectionPanel panel = new MemberSelectionPanel("<html>Choose members to delete since they are already defined in <b>" + newClassName + "</b>", candidates, null);
        DialogWrapper dlg = new DialogWrapper(project2, false){
            {
                super(arg0, arg1);
                this.setOKButtonText("Remove");
                this.setTitle("Choose Members");
                this.init();
            }

            @NotNull
            protected JComponent createCenterPanel() {
                MemberSelectionPanel memberSelectionPanel = panel;
                if (memberSelectionPanel == null) {
                    1.$$$reportNull$$$0(0);
                }
                return memberSelectionPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/inspection/ChangeSuperClassFix$1", "createCenterPanel"));
            }
        };
        List<Object> list = dlg.showAndGet() ? panel.getTable().getSelectedMemberInfos().stream().map(info -> (PsiMethod)info.getMember()).collect(Collectors.toList()) : Collections.emptyList();
        if (list == null) {
            ChangeSuperClassFix.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 1: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSuperClass";
                break;
            }
            case 2: 
            case 9: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldSuperClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/inspection/ChangeSuperClassFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/inspection/ChangeSuperClassFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewSuperClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverridenMethodsToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "changeSuperClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$changeSuperClass$2";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$changeSuperClass$1";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$changeSuperClass$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

