/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.options.ModuleTableCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public class TargetOptionsComponent
extends JPanel {
    private static final String[] KNOWN_TARGETS;
    private static final String COMPILER_DEFAULT = "Same as language level";
    private final ComboBox myCbProjectTargetLevel;
    private final JBTable myTable;
    private final Project myProject;

    public TargetOptionsComponent(Project project2) {
        super(new GridBagLayout());
        this.myProject = project2;
        this.myCbProjectTargetLevel = TargetOptionsComponent.createTargetOptionsCombo();
        this.myTable = new JBTable((TableModel)new TargetLevelTableModel());
        this.myTable.setRowHeight(22);
        this.myTable.getEmptyText().setText("All modules will be compiled with project bytecode version");
        TableColumn moduleColumn = this.myTable.getColumnModel().getColumn(0);
        moduleColumn.setHeaderValue("Module");
        moduleColumn.setCellRenderer(new ModuleTableCellRenderer());
        TableColumn targetLevelColumn = this.myTable.getColumnModel().getColumn(1);
        String columnTitle = "Target bytecode version";
        targetLevelColumn.setHeaderValue("Target bytecode version");
        targetLevelColumn.setCellEditor(new TargetLevelCellEditor());
        targetLevelColumn.setCellRenderer(new TargetLevelCellRenderer());
        int width = this.myTable.getFontMetrics(this.myTable.getFont()).stringWidth("Target bytecode version") + 10;
        targetLevelColumn.setPreferredWidth(width);
        targetLevelColumn.setMinWidth(width);
        targetLevelColumn.setMaxWidth(width);
        new TableSpeedSearch((JTable)this.myTable);
        this.add((Component)new JLabel("Project bytecode version: "), TargetOptionsComponent.constraints(0, 0, 1, 1, 0.0, 0.0, 0));
        this.add((Component)this.myCbProjectTargetLevel, TargetOptionsComponent.constraints(1, 0, 1, 1, 1.0, 0.0, 0));
        this.add((Component)new JLabel("Per-module bytecode version:"), TargetOptionsComponent.constraints(0, 1, 2, 1, 1.0, 0.0, 0));
        JPanel tableComp = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TargetOptionsComponent.this.addModules();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TargetOptionsComponent.this.removeSelectedModules();
            }
        }).createPanel();
        tableComp.setPreferredSize(new Dimension(this.myTable.getWidth(), 150));
        this.add((Component)tableComp, TargetOptionsComponent.constraints(0, 2, 2, 1, 1.0, 1.0, 1));
    }

    private void removeSelectedModules() {
        int[] rows = this.myTable.getSelectedRows();
        if (rows.length > 0) {
            TableUtil.removeSelectedItems((JTable)this.myTable);
        }
    }

    private void addModules() {
        TargetLevelTableModel model = (TargetLevelTableModel)this.myTable.getModel();
        ArrayList<Module> items = new ArrayList<Module>(Arrays.asList(ModuleManager.getInstance((Project)this.myProject).getModules()));
        HashSet<Module> alreadyAdded = new HashSet<Module>();
        for (TargetLevelTableModel.Item item : model.getItems()) {
            alreadyAdded.add(item.module);
        }
        Iterator it = items.iterator();
        while (it.hasNext()) {
            Module module2 = (Module)it.next();
            if (!alreadyAdded.contains(module2)) continue;
            it.remove();
        }
        Collections.sort(items, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        ChooseModulesDialog chooser = new ChooseModulesDialog((Component)this, items, "Choose module");
        chooser.show();
        List elements = chooser.getChosenElements();
        if (!elements.isEmpty()) {
            model.addItems(elements);
            int i = model.getModuleRow((Module)elements.get(0));
            if (i != -1) {
                TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{i});
                TableUtil.scrollSelectionToVisible((JTable)this.myTable);
            }
        }
    }

    public void setProjectBytecodeTargetLevel(String level) {
        this.myCbProjectTargetLevel.setSelectedItem((Object)(level == null ? "" : level));
    }

    @Nullable
    public String getProjectBytecodeTarget() {
        String item = ((String)this.myCbProjectTargetLevel.getSelectedItem()).trim();
        return "".equals(item) ? null : item;
    }

    public Map<String, String> getModulesBytecodeTargetMap() {
        TargetLevelTableModel model = (TargetLevelTableModel)this.myTable.getModel();
        HashMap<String, String> map = new HashMap<String, String>();
        for (TargetLevelTableModel.Item item : model.getItems()) {
            map.put(item.module.getName(), item.targetLevel);
        }
        return map;
    }

    public void setModuleTargetLevels(Map<String, String> moduleLevels) {
        Map<Module, String> map;
        if (!moduleLevels.isEmpty()) {
            map = new HashMap();
            for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                String target = moduleLevels.get(module2.getName());
                if (target == null) continue;
                map.put(module2, target);
            }
        } else {
            map = Collections.emptyMap();
        }
        ((TargetLevelTableModel)this.myTable.getModel()).setItems(map);
    }

    private static GridBagConstraints constraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int fill) {
        return new GridBagConstraints(gridx, gridy, gridwidth, gridheight, weightx, weighty, 17, fill, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0);
    }

    private static ComboBox createTargetOptionsCombo() {
        ComboBox combo = new ComboBox((ComboBoxModel)new TargetLevelComboboxModel());
        combo.setEditable(true);
        combo.setEditor((ComboBoxEditor)new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                HintTextField editor = new HintTextField(TargetOptionsComponent.COMPILER_DEFAULT, 12);
                editor.setBorder(null);
                return editor;
            }
        });
        return combo;
    }

    static {
        ArrayList<String> targets = new ArrayList<String>();
        targets.add("1.1");
        targets.add("1.2");
        for (LanguageLevel level : LanguageLevel.values()) {
            targets.add(JpsJavaSdkType.complianceOption((JavaVersion)level.toJavaVersion()));
        }
        KNOWN_TARGETS = ArrayUtil.toStringArray(targets);
    }

    static class HintTextField
    extends JTextField {
        private final char[] myHint;

        public HintTextField(String hint) {
            this(hint, 0);
        }

        public HintTextField(String hint, int columns) {
            super(hint, columns);
            this.myHint = hint.toCharArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            boolean isFocused = this.isFocusOwner();
            if (!isFocused && this.getText().isEmpty()) {
                Color oldColor = g.getColor();
                Font oldFont = g.getFont();
                try {
                    g.setColor((Color)JBColor.GRAY);
                    FontMetrics metrics = g.getFontMetrics();
                    int x = Math.abs(this.getWidth() - metrics.charsWidth(this.myHint, 0, this.myHint.length)) / 2;
                    int y = Math.abs(this.getHeight() - metrics.getHeight()) / 2 + metrics.getAscent();
                    g.drawChars(this.myHint, 0, this.myHint.length, x, y);
                }
                finally {
                    g.setColor(oldColor);
                    g.setFont(oldFont);
                }
            }
        }
    }

    private static class TargetLevelCellRenderer
    extends DefaultTableCellRenderer {
        private TargetLevelCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component instanceof JLabel) {
                JLabel comp = (JLabel)component;
                comp.setHorizontalAlignment(0);
                if ("".equals(value)) {
                    comp.setForeground((Color)JBColor.GRAY);
                    comp.setText(TargetOptionsComponent.COMPILER_DEFAULT);
                } else {
                    comp.setForeground(table.getForeground());
                }
            }
            return component;
        }
    }

    private static class TargetLevelCellEditor
    extends DefaultCellEditor {
        private TargetLevelCellEditor() {
            super((JComboBox<?>)TargetOptionsComponent.createTargetOptionsCombo());
            this.setClickCountToStart(0);
        }
    }

    private static final class TargetLevelComboboxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final List<String> myOptions = new ArrayList<String>();
        private String mySelectedItem = "";

        TargetLevelComboboxModel() {
            for (int i = KNOWN_TARGETS.length - 1; i >= 0; --i) {
                this.myOptions.add(KNOWN_TARGETS[i]);
            }
        }

        @Override
        public int getSize() {
            return this.myOptions.size();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.mySelectedItem = this.toModelItem((String)anItem);
            this.fireContentsChanged(this, 0, this.myOptions.size());
        }

        @Override
        public Object getSelectedItem() {
            return this.mySelectedItem;
        }

        @Override
        public Object getElementAt(int index) {
            return this.myOptions.get(index);
        }

        private String toModelItem(String item) {
            item = item.trim();
            for (String option : this.myOptions) {
                if (!option.equals(item)) continue;
                return option;
            }
            return item;
        }
    }

    private static final class TargetLevelTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        private final List<Item> myItems = new ArrayList<Item>();

        private TargetLevelTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.myItems.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Item item = this.myItems.get(rowIndex);
            return columnIndex == 0 ? item.module : item.targetLevel;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Item item = this.myItems.get(rowIndex);
            item.targetLevel = ((String)aValue).trim();
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public void addItems(Collection<Module> modules) {
            for (Module module2 : modules) {
                this.myItems.add(new Item(module2));
            }
            this.sorItems();
            this.fireTableDataChanged();
        }

        private void sorItems() {
            Collections.sort(this.myItems, (o1, o2) -> o1.module.getName().compareTo(o2.module.getName()));
        }

        public List<Item> getItems() {
            return this.myItems;
        }

        public void removeRow(int idx) {
            this.myItems.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }

        public void setItems(Map<Module, String> items) {
            this.myItems.clear();
            for (Map.Entry<Module, String> entry : items.entrySet()) {
                this.myItems.add(new Item(entry.getKey(), entry.getValue()));
            }
            this.sorItems();
            this.fireTableDataChanged();
        }

        public int getModuleRow(Module module2) {
            for (int i = 0; i < this.myItems.size(); ++i) {
                if (!this.myItems.get((int)i).module.equals(module2)) continue;
                return i;
            }
            return -1;
        }

        private static final class Item {
            final Module module;
            String targetLevel = "";

            Item(Module module2) {
                this.module = module2;
            }

            Item(Module module2, String targetLevel) {
                this.module = module2;
                this.targetLevel = targetLevel;
            }
        }
    }
}

