/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.engine.requests.MethodReturnValueWatcher;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.InternalException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugProcessEvents
extends DebugProcessImpl {
    private static final Logger LOG = Logger.getInstance(DebugProcessEvents.class);
    private static final String REQUEST_HANDLER = "REQUEST_HANDLER";
    private DebuggerEventThread myEventThread;
    private final AtomicBoolean myNotificationsCoolDown = new AtomicBoolean();

    public DebugProcessEvents(Project project2) {
        super(project2);
        DebuggerSettings.getInstance().addCapturePointsSettingsListener(this::createStackCapturingBreakpoints, this.myDisposable);
    }

    @Override
    protected void commitVM(VirtualMachine vm) {
        super.commitVM(vm);
        if (vm != null) {
            this.vmAttached();
            this.myEventThread = new DebuggerEventThread();
            ApplicationManager.getApplication().executeOnPooledThread((Runnable)this.myEventThread);
        }
    }

    private static void showStatusText(DebugProcessEvents debugProcess, Event event) {
        Requestor requestor = debugProcess.getRequestsManager().findRequestor(event.request());
        Breakpoint breakpoint = null;
        if (requestor instanceof Breakpoint) {
            breakpoint = (Breakpoint)requestor;
        }
        String text = debugProcess.getEventText((Pair<Breakpoint, Event>)Pair.create((Object)breakpoint, (Object)event));
        debugProcess.showStatusText(text);
    }

    public String getEventText(Pair<Breakpoint, Event> descriptor2) {
        String text = "";
        Event event = (Event)descriptor2.getSecond();
        Breakpoint breakpoint = (Breakpoint)descriptor2.getFirst();
        if (event instanceof LocatableEvent) {
            try {
                text = breakpoint != null ? breakpoint.getEventMessage((LocatableEvent)event) : DebuggerBundle.message((String)"status.generic.breakpoint.reached", (Object[])new Object[0]);
            }
            catch (InternalException e) {
                text = DebuggerBundle.message((String)"status.generic.breakpoint.reached", (Object[])new Object[0]);
            }
        } else if (event instanceof VMStartEvent) {
            text = DebuggerBundle.message((String)"status.process.started", (Object[])new Object[0]);
        } else if (event instanceof VMDeathEvent) {
            text = DebuggerBundle.message((String)"status.process.terminated", (Object[])new Object[0]);
        } else if (event instanceof VMDisconnectEvent) {
            RemoteConnection connection = this.getConnection();
            String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
            String transportName = DebuggerBundle.getTransportName((RemoteConnection)connection);
            text = DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{addressDisplayName, transportName});
        }
        return text;
    }

    private static void preprocessEvent(SuspendContextImpl suspendContext, ThreadReference thread) {
        ThreadReferenceProxyImpl oldThread = suspendContext.getThread();
        suspendContext.setThread(thread);
        if (oldThread == null) {
            suspendContext.getDebugProcess().beforeSuspend(suspendContext);
        }
    }

    private static Consumer<Event> getEventRequestHandler(Event event) {
        Object property;
        EventRequest request = event.request();
        Object object = property = request != null ? request.getProperty(REQUEST_HANDLER) : null;
        if (property instanceof Consumer) {
            return (Consumer)property;
        }
        return null;
    }

    private static void enableNonSuspendingRequest(EventRequest request, Consumer<Event> handler) {
        request.setSuspendPolicy(0);
        request.putProperty(REQUEST_HANDLER, handler);
        request.enable();
    }

    private void processVMStartEvent(SuspendContextImpl suspendContext, VMStartEvent event) {
        DebugProcessEvents.preprocessEvent(suspendContext, event.thread());
        LOG.debug("enter: processVMStartEvent()");
        DebugProcessEvents.showStatusText(this, event);
        this.getSuspendManager().voteResume(suspendContext);
    }

    private void vmAttached() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        LOG.assertTrue(!this.isAttached());
        if (this.myState.compareAndSet(DebugProcessImpl.State.INITIAL, DebugProcessImpl.State.ATTACHED)) {
            VirtualMachineProxyImpl machineProxy = this.getVirtualMachineProxy();
            EventRequestManager requestManager = machineProxy.eventRequestManager();
            if (machineProxy.canGetMethodReturnValues()) {
                this.myReturnValueWatcher = new MethodReturnValueWatcher(requestManager, this);
            }
            DebugProcessEvents.enableNonSuspendingRequest(requestManager.createThreadStartRequest(), (Consumer<Event>)((Consumer)event -> {
                ThreadReference thread = ((ThreadStartEvent)event).thread();
                this.getVirtualMachineProxy().threadStarted(thread);
                ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).threadStarted((DebugProcess)this, thread);
            }));
            DebugProcessEvents.enableNonSuspendingRequest(requestManager.createThreadDeathRequest(), (Consumer<Event>)((Consumer)event -> {
                ThreadReference thread = ((ThreadDeathEvent)event).thread();
                this.getVirtualMachineProxy().threadStopped(thread);
                ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).threadStopped((DebugProcess)this, thread);
            }));
            ((DebuggerManagerImpl)DebuggerManager.getInstance((Project)this.getProject())).getCustomPositionManagerFactories().map(factory -> (PositionManager)factory.fun((Object)this)).filter(Objects::nonNull).forEach(this::appendPositionManager);
            Stream.of(Extensions.getExtensions((ExtensionPointName)PositionManagerFactory.EP_NAME, (AreaInstance)this.getProject())).map(factory -> factory.createPositionManager((DebugProcess)this)).filter(Objects::nonNull).forEach(this::appendPositionManager);
            ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).processAttached((DebugProcess)this);
            this.createStackCapturingBreakpoints();
            ApplicationManager.getApplication().runReadAction(() -> {
                XDebugSession session = this.getSession().getXDebugSession();
                if (session != null) {
                    session.initBreakpoints();
                }
            });
            String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)this.getConnection());
            String transportName = DebuggerBundle.getTransportName((RemoteConnection)this.getConnection());
            this.showStatusText(DebuggerBundle.message((String)"status.connected", (Object[])new Object[]{addressDisplayName, transportName}));
            LOG.debug("leave: processVMStartEvent()");
        }
    }

    private void createStackCapturingBreakpoints() {
        this.getManagerThread().invoke(new DebuggerCommandImpl(){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            protected void action() {
                StackCapturingLineBreakpoint.deleteAll(DebugProcessEvents.this);
                StackCapturingLineBreakpoint.createAll(DebugProcessEvents.this);
            }
        });
    }

    private void processVMDeathEvent(SuspendContextImpl suspendContext, @Nullable Event event) {
        if (this.isAttached() && (event == null || this.getVirtualMachineProxy().getVirtualMachine() == event.virtualMachine())) {
            try {
                DebugProcessEvents.preprocessEvent(suspendContext, null);
                this.cancelRunToCursorBreakpoint();
            }
            finally {
                if (this.myEventThread != null) {
                    this.myEventThread.stopListening();
                    this.myEventThread = null;
                }
                this.closeProcess(false);
            }
        }
        if (event != null) {
            DebugProcessEvents.showStatusText(this, event);
        }
    }

    private void processClassPrepareEvent(SuspendContextImpl suspendContext, ClassPrepareEvent event) {
        DebugProcessEvents.preprocessEvent(suspendContext, event.thread());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Class prepared: " + event.referenceType().name());
        }
        suspendContext.getDebugProcess().getRequestsManager().processClassPrepared(event);
        this.getSuspendManager().voteResume(suspendContext);
    }

    private void processStepEvent(SuspendContextImpl suspendContext, StepEvent event) {
        ThreadReference thread = event.thread();
        DebugProcessEvents.preprocessEvent(suspendContext, thread);
        RequestHint hint = (RequestHint)event.request().getProperty("hint");
        this.deleteStepRequests(event.thread());
        boolean shouldResume = false;
        Project project2 = this.getProject();
        if (hint != null) {
            int nextStepDepth = hint.getNextStepDepth(suspendContext);
            if (nextStepDepth == -100) {
                this.getSession().clearSteppingThrough();
                shouldResume = true;
            } else if (nextStepDepth != 0) {
                ThreadReferenceProxyImpl threadProxy = suspendContext.getThread();
                this.doStep(suspendContext, threadProxy, hint.getSize(), nextStepDepth, hint);
                shouldResume = true;
            }
            if (!shouldResume && hint.isRestoreBreakpoints()) {
                DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager().enableBreakpoints(this);
            }
        }
        if (shouldResume) {
            this.getSuspendManager().voteResume(suspendContext);
        } else {
            this.showStatusText("");
            if (this.myReturnValueWatcher != null) {
                this.myReturnValueWatcher.disable();
            }
            this.getSuspendManager().voteSuspend(suspendContext);
            if (hint != null) {
                MethodFilter methodFilter = hint.getMethodFilter();
                if (methodFilter instanceof NamedMethodFilter && !hint.wasStepTargetMethodMatched()) {
                    String message = "Method <b>" + ((NamedMethodFilter)methodFilter).getMethodName() + "()</b> has not been called";
                    XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(message, MessageType.INFO).notify(project2);
                }
                if (hint.wasStepTargetMethodMatched() && hint.isResetIgnoreFilters()) {
                    this.checkPositionNotFiltered(suspendContext.getThread(), (Consumer<List<ClassFilter>>)((Consumer)filters -> this.mySession.resetIgnoreStepFiltersFlag()));
                }
            }
        }
    }

    private void processLocatableEvent(SuspendContextImpl suspendContext, final LocatableEvent event) {
        ThreadReference thread = event.thread();
        DebugProcessEvents.preprocessEvent(suspendContext, thread);
        this.getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((evaluatingContext = SuspendManagerUtil.getEvaluatingContext(suspendManager = DebugProcessEvents.this.getSuspendManager(), suspendContext.getThread())) != null && !DebuggerSession.enableBreakpointsDuringEvaluation()) {
                    DebugProcessEvents.access$200(DebugProcessEvents.this, event);
                    suspendManager.voteResume(suspendContext);
                    return;
                }
                requestor = (LocatableEventRequestor)DebugProcessEvents.this.getRequestsManager().findRequestor(event.request());
                resumePreferred = requestor != null && "SuspendNone".equals(requestor.getSuspendPolicy()) != false;
                requestHit = false;
                start = requestor instanceof OverheadProducer != false && requestor instanceof RunToCursorBreakpoint == false ? System.currentTimeMillis() : 0L;
                try {
                    v0 = requestHit = requestor != null && requestor.processLocatableEvent(this, event) != false;
                    ** if (start <= 0L) goto lbl-1000
                }
                catch (LocatableEventRequestor.EventProcessingException ex) {
                    try {
                        if (DebugProcessEvents.access$900().isDebugEnabled()) {
                            DebugProcessEvents.access$900().debug(ex.getMessage());
                        }
                        considerRequestHit = new boolean[]{true};
                        DebuggerInvocationUtil.invokeAndWait(DebugProcessEvents.this.getProject(), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$contextAction$0(com.intellij.debugger.engine.requests.LocatableEventRequestor com.intellij.debugger.engine.requests.LocatableEventRequestor$EventProcessingException boolean[] ), ()V)(this, (LocatableEventRequestor)requestor, (LocatableEventRequestor.EventProcessingException)ex, (boolean[])considerRequestHit), ModalityState.NON_MODAL);
                        requestHit = considerRequestHit[0];
                        v1 = resumePreferred = requestHit == false;
                        ** if (start <= 0L) goto lbl-1000
                    }
                    catch (Throwable var11_10) {
                        if (start > 0L) {
                            OverheadTimings.add(DebugProcessEvents.this, (OverheadProducer)requestor, requestHit != false || requestor instanceof StackCapturingLineBreakpoint != false ? 1L : 0L, System.currentTimeMillis() - start);
                        }
                        throw var11_10;
                    }
lbl-1000:
                    // 1 sources

                    {
                        OverheadTimings.add(DebugProcessEvents.this, (OverheadProducer)requestor, requestHit != false || requestor instanceof StackCapturingLineBreakpoint != false ? 1L : 0L, System.currentTimeMillis() - start);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
lbl-1000:
                // 1 sources

                {
                    OverheadTimings.add(DebugProcessEvents.this, (OverheadProducer)requestor, requestHit != false || requestor instanceof StackCapturingLineBreakpoint != false ? 1L : 0L, System.currentTimeMillis() - start);
                }
lbl-1000:
                // 2 sources

                {
                }
                if (requestHit && requestor instanceof Breakpoint) {
                    ApplicationManager.getApplication().runReadAction((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$contextAction$1(com.intellij.debugger.engine.requests.LocatableEventRequestor ), ()V)(this, (LocatableEventRequestor)requestor));
                }
                if (!requestHit || resumePreferred) {
                    suspendManager.voteResume(suspendContext);
                } else {
                    if (DebugProcessEvents.this.myReturnValueWatcher != null) {
                        DebugProcessEvents.this.myReturnValueWatcher.disable();
                    }
                    suspendManager.voteSuspend(suspendContext);
                    DebugProcessEvents.access$1000(DebugProcessEvents.this, event);
                }
            }

            private /* synthetic */ void lambda$contextAction$1(LocatableEventRequestor requestor) {
                XBreakpoint breakpoint;
                XDebugSession session = DebugProcessEvents.this.getSession().getXDebugSession();
                if (session != null && (breakpoint = ((Breakpoint)requestor).getXBreakpoint()) != null) {
                    ((XDebugSessionImpl)session).processDependencies(breakpoint);
                }
            }

            private /* synthetic */ void lambda$contextAction$0(LocatableEventRequestor requestor, LocatableEventRequestor.EventProcessingException ex, boolean[] considerRequestHit) {
                String displayName = requestor instanceof Breakpoint ? ((Breakpoint)requestor).getDisplayName() : requestor.getClass().getSimpleName();
                String message = DebuggerBundle.message((String)"error.evaluating.breakpoint.condition.or.action", (Object[])new Object[]{displayName, ex.getMessage()});
                considerRequestHit[0] = Messages.showYesNoDialog((Project)DebugProcessEvents.this.getProject(), (String)message, (String)ex.getTitle(), (Icon)Messages.getQuestionIcon()) == 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebugProcessEvents$2", "contextAction"));
            }
        });
    }

    private void notifySkippedBreakpoints(@Nullable LocatableEvent event) {
        if (event != null && this.myNotificationsCoolDown.compareAndSet(false, true)) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> this.myNotificationsCoolDown.set(false), 1L, TimeUnit.SECONDS);
            XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"message.breakpoint.skipped", (Object[])new Object[]{event.location()}), MessageType.WARNING).notify(this.getProject());
        }
    }

    @Nullable
    private static LocatableEvent getLocatableEvent(EventSet eventSet) {
        return StreamEx.of((Collection)eventSet).select(LocatableEvent.class).findFirst().orElse(null);
    }

    private void processDefaultEvent(SuspendContextImpl suspendContext) {
        DebugProcessEvents.preprocessEvent(suspendContext, null);
        this.getSuspendManager().voteResume(suspendContext);
    }

    static /* synthetic */ void access$1000(DebugProcessEvents x0, Event x1) {
        DebugProcessEvents.showStatusText(x0, x1);
    }

    private class DebuggerEventThread
    implements Runnable {
        private final VirtualMachineProxyImpl myVmProxy;
        private boolean myIsStopped = false;

        DebuggerEventThread() {
            this.myVmProxy = DebugProcessEvents.this.getVirtualMachineProxy();
        }

        public synchronized void stopListening() {
            this.myIsStopped = true;
        }

        private synchronized boolean isStopped() {
            return this.myIsStopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String oldThreadName = Thread.currentThread().getName();
            Thread.currentThread().setName("DebugProcessEvents");
            try {
                EventQueue eventQueue = this.myVmProxy.eventQueue();
                while (!this.isStopped()) {
                    try {
                        final EventSet eventSet = eventQueue.remove();
                        DebugProcessEvents.this.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

                            @Override
                            public PrioritizedTask.Priority getPriority() {
                                return PrioritizedTask.Priority.HIGH;
                            }

                            @Override
                            protected void action() throws Exception {
                                int processed = 0;
                                for (Object event : eventSet) {
                                    if (DebugProcessEvents.this.myReturnValueWatcher != null && DebugProcessEvents.this.myReturnValueWatcher.isTrackingEnabled() && DebugProcessEvents.this.myReturnValueWatcher.processEvent((Event)event)) {
                                        ++processed;
                                        continue;
                                    }
                                    Consumer handler = DebugProcessEvents.getEventRequestHandler((Event)event);
                                    if (handler == null) continue;
                                    handler.consume(event);
                                    ++processed;
                                }
                                if (processed == eventSet.size()) {
                                    eventSet.resume();
                                    return;
                                }
                                LocatableEvent locatableEvent = DebugProcessEvents.getLocatableEvent(eventSet);
                                if (eventSet.suspendPolicy() == 2) {
                                    for (SuspendContextImpl context : DebugProcessEvents.this.getSuspendManager().getEventContexts()) {
                                        if (context.getSuspendPolicy() != 2) continue;
                                        if (DebugProcessImpl.isResumeOnlyCurrentThread() && locatableEvent != null && !context.isEvaluating()) {
                                            DebugProcessEvents.this.getSuspendManager().resume(context);
                                            continue;
                                        }
                                        if (DebuggerSession.enableBreakpointsDuringEvaluation()) continue;
                                        DebugProcessEvents.this.notifySkippedBreakpoints(locatableEvent);
                                        eventSet.resume();
                                        return;
                                    }
                                }
                                SuspendContextImpl suspendContext = null;
                                if (DebugProcessImpl.isResumeOnlyCurrentThread() && locatableEvent != null) {
                                    for (SuspendContextImpl context : DebugProcessEvents.this.getSuspendManager().getEventContexts()) {
                                        ThreadReferenceProxyImpl threadProxy = DebugProcessEvents.this.getVirtualMachineProxy().getThreadReferenceProxy(locatableEvent.thread());
                                        if (context.getSuspendPolicy() != 2 || !context.isExplicitlyResumed(threadProxy)) continue;
                                        context.myResumedThreads.remove(threadProxy);
                                        suspendContext = context;
                                        suspendContext.myVotesToVote = eventSet.size();
                                        break;
                                    }
                                }
                                if (suspendContext == null) {
                                    suspendContext = DebugProcessEvents.this.getSuspendManager().pushSuspendContext(eventSet);
                                }
                                for (Event event : eventSet) {
                                    if (DebugProcessEvents.getEventRequestHandler(event) != null) {
                                        DebugProcessEvents.this.getSuspendManager().voteResume(suspendContext);
                                        continue;
                                    }
                                    try {
                                        if (event instanceof VMStartEvent) {
                                            DebugProcessEvents.this.processVMStartEvent(suspendContext, (VMStartEvent)event);
                                            continue;
                                        }
                                        if (event instanceof VMDeathEvent || event instanceof VMDisconnectEvent) {
                                            DebugProcessEvents.this.processVMDeathEvent(suspendContext, event);
                                            continue;
                                        }
                                        if (event instanceof ClassPrepareEvent) {
                                            DebugProcessEvents.this.processClassPrepareEvent(suspendContext, (ClassPrepareEvent)event);
                                            continue;
                                        }
                                        if (event instanceof StepEvent) {
                                            DebugProcessEvents.this.processStepEvent(suspendContext, (StepEvent)event);
                                            continue;
                                        }
                                        if (event instanceof LocatableEvent) {
                                            DebugProcessEvents.this.processLocatableEvent(suspendContext, (LocatableEvent)event);
                                            continue;
                                        }
                                        if (!(event instanceof ClassUnloadEvent)) continue;
                                        DebugProcessEvents.this.processDefaultEvent(suspendContext);
                                    }
                                    catch (VMDisconnectedException e) {
                                        LOG.debug((Throwable)e);
                                    }
                                    catch (InternalException e) {
                                        LOG.info((Throwable)e);
                                    }
                                    catch (Throwable e) {
                                        LOG.error(e);
                                    }
                                }
                            }
                        });
                    }
                    catch (InternalException e) {
                        LOG.debug((Throwable)e);
                    }
                    catch (ProcessCanceledException | VMDisconnectedException | InterruptedException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        LOG.debug(e);
                    }
                }
            }
            catch (VMDisconnectedException | InterruptedException e) {
                this.invokeVMDeathEvent();
            }
            finally {
                Thread.interrupted();
                Thread.currentThread().setName(oldThreadName);
            }
        }

        private void invokeVMDeathEvent() {
            DebugProcessEvents.this.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    SuspendContextImpl suspendContext = DebugProcessEvents.this.getSuspendManager().pushSuspendContext(0, 1);
                    DebugProcessEvents.this.processVMDeathEvent(suspendContext, null);
                }
            });
        }
    }
}

