/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerPsiEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerEvaluator
extends XDebuggerEvaluator
implements XDebuggerPsiEvaluator {
    private final DebugProcessImpl myDebugProcess;
    private final JavaStackFrame myStackFrame;

    public JavaDebuggerEvaluator(DebugProcessImpl debugProcess, JavaStackFrame stackFrame) {
        this.myDebugProcess = debugProcess;
        this.myStackFrame = stackFrame;
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(1);
        }
        this.evaluate((XExpression)XExpressionImpl.fromText((String)expression), callback, expressionPosition);
    }

    public void evaluate(final @NotNull XExpression expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(3);
        }
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext(), this.myStackFrame.getStackFrameProxy().threadProxy()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DebuggerUIUtil.isObsolete((Object)callback)) {
                    return;
                }
                JavaDebugProcess process2 = JavaDebuggerEvaluator.this.myDebugProcess.getXdebugProcess();
                if (process2 == null) {
                    callback.errorOccurred("No debug process");
                    return;
                }
                TextWithImports text = TextWithImportsImpl.fromXExpression(expression);
                NodeManagerImpl nodeManager = process2.getNodeManager();
                WatchItemDescriptor descriptor2 = nodeManager.getWatchItemDescriptor(null, text, null);
                EvaluationContextImpl evalContext = JavaDebuggerEvaluator.this.myStackFrame.getFrameDebuggerContext(this.getDebuggerContext()).createEvaluationContext();
                if (evalContext == null) {
                    callback.errorOccurred("Context is not available");
                    return;
                }
                descriptor2.setContext(evalContext);
                EvaluateException exception = descriptor2.getEvaluateException();
                if (exception != null && descriptor2.getValue() == null) {
                    callback.errorOccurred(exception.getMessage());
                    return;
                }
                callback.evaluated((XValue)JavaValue.create(null, descriptor2, evalContext, nodeManager, true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaDebuggerEvaluator$1", "threadAction"));
            }
        });
    }

    public void evaluate(final @NotNull PsiElement element, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback) {
        if (element == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(5);
        }
        this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(this.myDebugProcess.getDebuggerContext(), this.myStackFrame.getStackFrameProxy().threadProxy()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                if (suspendContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (DebuggerUIUtil.isObsolete((Object)callback)) {
                    return;
                }
                JavaDebugProcess process2 = JavaDebuggerEvaluator.this.myDebugProcess.getXdebugProcess();
                if (process2 == null) {
                    callback.errorOccurred("No debug process");
                    return;
                }
                DebuggerContextImpl debuggerContext = JavaDebuggerEvaluator.this.myStackFrame.getFrameDebuggerContext(this.getDebuggerContext());
                EvaluationContextImpl evalContext = debuggerContext.createEvaluationContext();
                if (evalContext == null) {
                    callback.errorOccurred("Context is not available");
                    return;
                }
                try {
                    ExpressionEvaluator evaluator = (ExpressionEvaluator)ReadAction.compute(() -> {
                        if (element == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        CodeFragmentFactory factory = DebuggerUtilsEx.getCodeFragmentFactory(element, null);
                        return factory.getEvaluatorBuilder().build(element, debuggerContext.getSourcePosition());
                    });
                    Value value = evaluator.evaluate((EvaluationContext)evalContext);
                    TextWithImportsImpl text = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "");
                    WatchItemDescriptor descriptor2 = new WatchItemDescriptor(JavaDebuggerEvaluator.this.myDebugProcess.getProject(), text, value, evalContext);
                    callback.evaluated((XValue)JavaValue.create(null, descriptor2, evalContext, process2.getNodeManager(), true));
                }
                catch (EvaluateException e) {
                    callback.errorOccurred(e.getMessage());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suspendContext";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/engine/JavaDebuggerEvaluator$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "threadAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$threadAction$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project2, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        if (project2 == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(6);
        }
        if (document == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(7);
        }
        return (ExpressionInfo)PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(() -> {
            if (project2 == null) {
                JavaDebuggerEvaluator.$$$reportNull$$$0(9);
            }
            if (document == null) {
                JavaDebuggerEvaluator.$$$reportNull$$$0(10);
            }
            try {
                PsiElement elementAtCursor = DebuggerUtilsEx.findElementAt(PsiDocumentManager.getInstance((Project)project2).getPsiFile(document), offset);
                if (elementAtCursor == null || !elementAtCursor.isValid()) {
                    return null;
                }
                Pair<PsiElement, TextRange> pair2 = JavaDebuggerEvaluator.findExpression(elementAtCursor, sideEffectsAllowed);
                if (pair2 != null) {
                    PsiElement element = (PsiElement)pair2.getFirst();
                    return new ExpressionInfo((TextRange)pair2.getSecond(), null, null, (PsiElement)(element instanceof PsiExpression ? element : null));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            return null;
        });
    }

    @Nullable
    private static Pair<PsiElement, TextRange> findExpression(PsiElement element, boolean allowMethodCalls) {
        EditorTextProvider textProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(element.getLanguage());
        if (textProvider != null) {
            return textProvider.findExpression(element, allowMethodCalls);
        }
        return null;
    }

    public EvaluationMode getEvaluationMode(@NotNull String text, int startOffset, int endOffset, @Nullable PsiFile psiFile) {
        if (text == null) {
            JavaDebuggerEvaluator.$$$reportNull$$$0(8);
        }
        if (psiFile != null) {
            PsiElement[] range = CodeInsightUtil.findStatementsInRange((PsiFile)psiFile, (int)startOffset, (int)endOffset);
            return range.length > 1 ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION;
        }
        return super.getEvaluationMode(text, startOffset, endOffset, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/JavaDebuggerEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpressionInfoAtOffset";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getEvaluationMode";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getExpressionInfoAtOffset$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

